<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class HrmEmployeeLoan extends Model
{
    protected $table ='hrm_employees_loans';

 
    
    protected $fillable = [
        'employ_id','type', 'loan_amount', 'date','remaning','payment_method','receipt_no','notes','instrument_no'
    ];

    public function hrmemployee() {
        return $this->belongsTo('App\HrmEmployee','employ_id');
    }
    

    public static function getData($employ_id = null)
    {
    	
        $total_calculated_advance = HrmEmployeeLoan::where('employ_id' , $employ_id)->where('type' , 'Advance')->sum('loan_amount');
    	$total_calculated_loan = HrmEmployeeLoan::where('employ_id' , $employ_id)->where('type' , 'Loan')->sum('loan_amount');

        
        $total_remaning_advance = HrmEmployeeLoan::where('employ_id' , $employ_id)->where('type' , 'Advance')->sum('remaning'); 
    	$total_remaning_loan = HrmEmployeeLoan::where('employ_id' , $employ_id)->where('type' , 'Loan')->sum('remaning');

    	$total_recived_advance = HrmEmployeeLoanAdjusment::where('employ_id' , $employ_id)->where('type' , 'Advance')->sum('adjustment_amount');
        $total_recived_loan = HrmEmployeeLoanAdjusment::where('employ_id' , $employ_id)->where('type' , 'Loan')->sum('adjustment_amount');

        $total_calculated_advance_account = HrmEmployeeLoan::where('employ_id' , $employ_id)->where('type' , 'Advance')->sum('loan_amount');
        $total_calculated_loan_account = HrmEmployeeLoan::where('employ_id' , $employ_id)->where('type' , 'Loan')->sum('loan_amount');


    	return [$total_calculated_loan , $total_remaning_loan , $total_recived_loan , $total_calculated_advance , $total_recived_advance , $total_remaning_advance , $total_calculated_advance_account , $total_calculated_loan_account];
    }
}

 