<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\AccountClass;


class AccountClassController extends Controller {

    

    //Get All the Account Class
    public function allAccountClasses() {

        $allAccountClasses = 
        AccountClass::orderBy('created_at', 'desc')->get();


        return view('account/class.index', compact('allAccountClasses'));
    }

    //show the add new Account Class form
    public function addAccountClassForm() {

        return view('account/class.add-class');
    }

    //insert new Account Class record
    public function insertAccountClass(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    'status' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/account-class/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new Account Class
        //AccountClass::create(Input::all());
        $input=$request->all();
        AccountClass::create($input);

        return redirect()
                        ->route('account-class.all')
                        ->with([
                            'message' => 'Class created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    

    //show the edit AccountClass form
    public function editAccountClassForm($id) {

        $class = AccountClass::where('id', $id)->first();

        return view('account/class.edit-class', compact('class'));
    }

    //update the Account Class
    public function updateAccountClass(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    'status' => 'required',
                    
        ]);

        if ($validator->fails()) {
            return redirect('/account-class/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Account Class
        AccountClass::where('id',$request->id)->update(['name'=>$request->name,'status'=>$request->status]);

        return redirect()
                        ->route('account-class.all')
                        ->with([
                            'message' => 'Class updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific Account Class
    public function deleteAccountClass($id) {

        AccountClass::where('id', $id)->delete();

        return redirect()->route('account-class.all')->with([
                    'message' => 'Class deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
