<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\CompanyBank;
use App\AccountTransfer;

class AccountTransferController extends Controller {


    //Get All the transfers
    public function allAccountTransfers() {

        $allAccountTransfers = AccountTransfer::orderBy('created_at', 'desc')->get();

        return view('transaction/transfer.index', compact('allAccountTransfers'));
    }

    //show the add new transfer  form
    public function addAccountTransferForm() {

        $accounts = CompanyBank::all();
        
        return view('transaction/transfer.add-transfer',compact('accounts'));
    }

    //insert new transfer record
    public function insertAccountTransfer(Request $request) {

        $validator = Validator::make($request->all(), [
                    'from_account' => 'required',
                    'to_account' => 'required',
                    'date'=>'required',
                    'amount'=>'required'
        ]);

        if ($validator->fails()) {
            return redirect('/account-transfers/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new Transfer
        //$transfer = AccountTransfer::create(Input::all());
        $input=$request->all();
        $transfer = AccountTransfer::create($input);

        return redirect()
                        ->route('account.transfer.all')
                        ->with([
                            'message' => 'Account Transfer created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    

    //show the edit bank form
    public function editAccountTransferForm($id) {

        $transfer = AccountTransfer::where('id', $id)->first();
        
        $accounts = CompanyBank::all();

        return view('transaction/transfer.edit-transfer', compact('transfer','accounts'));
    }

    //update the record
    public function updateAccountTransfer(Request $request) {

        $validator = Validator::make($request->all(), [
                    'from_account' => 'required',
                    'to_account' => 'required',
                    'date'=>'required',
                    'amount'=>'required'
                    
        ]);

        if ($validator->fails()) {
            return redirect('/account-transfers/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Bank
        AccountTransfer::where('id',$request->id)->update(Input::except('_token'));

        return redirect()
                        ->route('account.transfer.all')
                        ->with([
                            'message' => 'Account Transfer updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific bank
    public function deleteAccountTransfer($id) {

        AccountTransfer::where('id', $id)->delete();

        return redirect()->route('account.transfer.all')->with([
                    'message' => 'Account Transfer deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
