<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\AssetMaintainance;
use Illuminate\Support\Facades\Validator;
use  DB;
use App\FixedAsset;

class AssetMaintainanceController extends Controller
{
       public function __construct()
    {
               
    }

      function index()
    {
        $asset_maintainances = AssetMaintainance::with(['asset'])->orderBy('id', 'DESC')->get();
        
        return view('procurement/asset-maintainance.index' ,compact('asset_maintainances') );
    }

    
    function create()
    {
        $fixed_assets = FixedAsset::where('physical_status' , 'in_use')->where('is_sent' , 0)->orderBy('name' , 'ASC')->get();
        return view('procurement/asset-maintainance.create',compact('fixed_assets') );
    }


    function insert(Request $request)
    {


        $validator = Validator::make($request->all(), [
                        'fixed_assets' => 'required',
                        'type' => 'required',
                        'start_date' => 'required',
                        'end_date' => 'required',
                        'cost' => 'required',
            ]);


           if ($validator->fails()) 
            {
                return redirect('/asset-maintainance/create')
                ->withErrors($validator)
                ->withInput();
            }


             if(strtotime($request->end_date) < strtotime($request->start_date))
            {
            return redirect('/asset-maintainance/create')
            ->withInput()
            ->with('date_error', 'Please make Sure You Enter Correct Start And End Date.');;
            }

        DB::beginTransaction();

        try {

                AssetMaintainance::create([
                    'asset_id' => $request->fixed_assets,
                    'type' => $request->type,
                    'start_date' => $request->start_date,
                    'end_date' => $request->end_date,
                    'cost' => $request->cost,
                ]);

             
               DB::commit();

               return redirect()->route('asset.maintainance')->with('success' , 'Asset Maintainance  Added Successfully!');
          

          } 
            catch (\Exception $e) 
          {
           DB::rollback();
          return redirect()->route('asset.maintainance')->with('success' , 'Something went wrong.');
          }
    }

      public function destroy($id)
    {
        if(is_numeric($id))
        {
          AssetMaintainance::where('id',$id)->delete();
        }

        return redirect()->route('asset.maintainance')->with('success' , 'Asset Maintainance Removed Successfully!');
    }



 function edit($id= null)
    {
        $fixed_assets = FixedAsset::orderBy('id' , 'DESC')->get();
        $asset_maintainance =  AssetMaintainance::find($id);
        return view('procurement/asset-maintainance.edit',compact('fixed_assets' , 'asset_maintainance') );
    }


      function update(Request $request)
    {

       $id = $request->id;

        $validator = Validator::make($request->all(), [
                        'fixed_assets' => 'required',
                        'type' => 'required',
                        'start_date' => 'required',
                        'end_date' => 'required',
                        'cost' => 'required',
            ]);


           if ($validator->fails()) 
            {
                return redirect('/asset-maintainance/edit/' . $id)
                ->withErrors($validator)
                ->withInput();
            }

        DB::beginTransaction();

        try {

                AssetMaintainance::where('id' , $id)->update([
                    'asset_id' => $request->fixed_assets,
                    'type' => $request->type,
                    'start_date' => $request->start_date,
                    'end_date' => $request->end_date,
                    'cost' => $request->cost,
                ]);

             
               DB::commit();

               return redirect()->route('asset.maintainance')->with('success' , 'Asset Maintainance  Update Successfully!');
          

          } 
            catch (\Exception $e) 
          {
           DB::rollback();
          return redirect()->route('asset.maintainance')->with('success' , 'Something went wrong.');
          }
    }

}
