<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Traits\MultiProjectCookie;
use App\Customer;
use App\DepositorBank;
use App\CompanyBank;
use App\CustomerCancelUnitReceipt;
use App\ChartOfAccount;
use App\CustomerProperty;
use Illuminate\Support\Facades\Validator;
use App\Dealer;
use App\DealerOpenFileCancelReceipt;
use App\OpenFileDealerInfo;

class CancelUnitController extends Controller
{
    //
    use MultiProjectCookie;
    public function createCloseUnitCancelReceipt()
    {
        $customers = Customer::where('is_deleted', false)->get();
        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();

        $result = CustomerCancelUnitReceipt::where([['receipt_no', '!=', null]])
            ->orderby('receipt_no', 'desc')->first();

        if ($result) {

            $parts = explode("-", $result->receipt_no);
            $num = intval($parts[1]);
            $num++;
            $receipt_no = $parts[0] . "-" . strval($num);
        } else
            $receipt_no = 'CU-50000';





        $accounts = ChartOfAccount::orderBy('number', 'ASC')->get();




        activity('Create')->log('Cancel Unit  Receipt ');


        return view('receipt.cancel.closefile', compact('customers', 'banks',  'cBanks', 'receipt_no'));
    }
    
    public function createOpenFileCancelReceipt()
    {
        $dealers = Dealer::where('is_deleted', false)->get();
        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();

        $result = DealerOpenFileCancelReceipt::where([['receipt_no', '!=', null]])
            ->orderby('receipt_no', 'desc')->first();

        if ($result) {

            $parts = explode("-", $result->receipt_no);
            $num = intval($parts[1]);
            $num++;
            $receipt_no = $parts[0] . "-" . strval($num);
        } else
            $receipt_no = 'COF-50000';





        $accounts = ChartOfAccount::orderBy('number', 'ASC')->get();







        return view('receipt.cancel.openfile', compact('dealers', 'banks',  'cBanks', 'receipt_no'));
    }

    public function updatePropertyForm(Request $request)
    {
        $project_ids =   $this->getCookieInfoAndMultiPro($request);
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];


        //refunded
        $data['allStatementscancel'] = CustomerProperty::where('customer_id', $request->customer_id)->whereHas('cancelProperty', function ($q) {
            $q->where('status', 1);
        })
        ->doesntHave('customerCancelUnitReceipt')
        ->with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundHistory')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->orderBy('created_at', 'desc')->get();



        //decline





        return view('receipt.cancel.update-table-closefile', $data);
    }

    public function updateOpenFileForm(Request $request)
    {
        $project_ids =   $this->getCookieInfoAndMultiPro($request);
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];





        $data['allopenfile'] = OpenFileDealerInfo::where('dealer_id', $request->dealer_id)
            ->whereHas('cancelOpenFile', function ($q) {
                $q->where('status', s1);
            })
            ->doesntHave('dealerOpenFileCancelReceipt')
            ->whereHas('inventory', function ($query) use ($ids) {
                $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                    $query->whereIn('multi_project_id', $ids);
                });
            })

            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->get();

        return view('receipt.cancel.update-table-openfile', $data);
    }

    public function getCanceledUnitData(Request $request)
    {
        $allStatementsRefunded = CustomerProperty::where('id', $request->property_id)->whereHas('cancelProperty', function ($q) {
            $q->where('status', 1);
        })->with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundHistory')
            ->orderBy('created_at', 'desc')->first();


        $total_deduct = 0;
        if (!empty($allStatementsRefunded->cancelProperty)) {


            $total_deduct = $allStatementsRefunded->cancelProperty->fee;
        }

        $arr = [


            'total_deduct' => $total_deduct,
        ];

        return response()->json(['data' => $arr]);
    }

    public function getCanceledOpenfileData(Request $request)
    {
        $openfile_cancel = OpenFileDealerInfo::where('id', $request->openfile_dealer_info_id)
            ->whereHas('cancelOpenFile', function ($q) {
                $q->where('status', 1);
            })

            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->first();

        $total_deduct = 0;
        if (!empty($openfile_cancel->cancelOpenFile)) {


            $total_deduct = $openfile_cancel->cancelOpenFile->fee;
        }

        $arr = [


            'total_deduct' => $total_deduct,
        ];

        return response()->json(['data' => $arr]);
    }

    public function insertReceipt(Request $request)
    {
        $messages = [
            'bank_name.required_if' => 'Depositor Bank Name is required',
            'company_account.required_if' => 'Company Account is required',
            'cheque_number.required_if' => 'Cheque Number is required.',
            'drawn_date' => 'Drawn Date is required',
            'dealer_adjustment_unit_id' => 'Dealer Payable Rebates is required',
            'vendor_purchase_order_id' => 'Vendor Bill is required',
        ];

        $validator = Validator::make(
            $request->all(),
            [
                'amount' => 'required|regex:/^[0-9]+$/u',
                'customer_id' => 'required',
                'customer_property_id' => 'required',
                'payment_method' => 'required',

                'receipt_date' => 'required',
                'bank_name' => 'nullable|required_if:payment_method,2,3',
                'company_account' => 'nullable|required_if:payment_method,2,3',
                'drawn_date' => 'nullable|required_if:payment_method,3',
                'cheque_number' => 'nullable|required_if:payment_method,3|regex:/^[a-zA-Z\s0-9]+$/u',

                'receipt_no' => 'required|unique:customer_cancel_unit_receipts,receipt_no',
                'roll_back_properties' => 'nullable|required_if:adjustment_type,7|regex:/^[0-9]+$/u'
            ],
            $messages
        );



        if ($validator->fails()) {
            return redirect()->route('property.cancel.receipt')
                ->withErrors($validator)->withInput()
                ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error',]);
        }
 

        $allStatementsRefunded = CustomerProperty::where('id', $request->customer_property_id)
            ->whereHas('cancelProperty', function ($q) {
                $q->where('status', 1);
            })->with('unitRefundHistory', 'inventory')
            ->orderBy('created_at', 'desc')->first();

        $total_fee = 0;
        if (!empty($allStatementsRefunded->cancelProperty)) {
            $total_fee = $allStatementsRefunded->cancelProperty->fee;
        }

        $remainingAmount =  $total_fee;
        if ($request->amount > $remainingAmount) {
            return redirect()->route('property.cancel.receipt')
                ->with(['message' => 'entered amount is more then remaining amount!', 'alert-type' => 'error',]);
        }



        $multiproject_id = $allStatementsRefunded->inventory ? $allStatementsRefunded->inventory->multiproject->id : null;
        $request->merge(['multi_project_id' => $multiproject_id]);


        $input = $request->all();
        $receipt = CustomerCancelUnitReceipt::create($input);
        if (!$receipt) {
            return redirect()->route('property.cancel.receipt')->withInput()
                ->with(['message' => 'Something went wrong!', 'alert-type' => 'error',]);
        } else {

            return redirect()
                ->back()
                ->with(['message' => 'Receipt send for approval!', 'alert-type' => 'info']);
        }
    }

    public function insertOpenFileRefundReceipt(Request $request)
    {
        $messages = [
            'bank_name.required_if' => 'Depositor Bank Name is required',
            'company_account.required_if' => 'Company Account is required',
            'cheque_number.required_if' => 'Cheque Number is required.',
            'drawn_date' => 'Drawn Date is required',
            'dealer_adjustment_unit_id' => 'Dealer Payable Rebates is required',
            'vendor_purchase_order_id' => 'Vendor Bill is required',
        ];

        $validator = Validator::make(
            $request->all(),
            [
                'amount' => 'required|regex:/^[0-9]+$/u',
                'dealer_id' => 'required',
                'openfile_dealer_info_id' => 'required',
                'payment_method' => 'required',

                'receipt_date' => 'required',
                'bank_name' => 'nullable|required_if:payment_method,2,3',
                'company_account' => 'nullable|required_if:payment_method,2,3',
                'drawn_date' => 'nullable|required_if:payment_method,3',
                'cheque_number' => 'nullable|required_if:payment_method,3|regex:/^[a-zA-Z\s0-9]+$/u',

                'receipt_no' => 'required|unique:dealer_open_file_cancel_receipts,receipt_no',
                'roll_back_properties' => 'nullable|required_if:adjustment_type,7|regex:/^[0-9]+$/u'
            ],
            $messages
        );



        if ($validator->fails()) {
            return redirect()->route('property.cancel-openfile.receipt')
                ->withErrors($validator)->withInput()
                ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error',]);
        }

        // dd($request->all());
        // amount



        $openfile_refund = OpenFileDealerInfo::where('id', $request->openfile_dealer_info_id)->whereHas('cancelOpenFile', function ($q) {
            $q->where('status', 1);
        })

            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->first();

        $total_deduct = 0;
        if (!empty($openfile_refund->cancelOpenFile)) {
            $total_deduct = $openfile_refund->cancelOpenFile->fee;
        }
 
        $remainingAmount =   $total_deduct;
        if ($request->amount > $remainingAmount) {
            return redirect()->route('property.cancel-openfile.receipt')
                ->with(['message' => 'entered amount is more then total deduction amount!', 'alert-type' => 'error',]);
        }



        $multiproject_id = $openfile_refund->inventory ? $openfile_refund->inventory->multiproject->id : null;
        $request->merge(['multi_project_id' => $multiproject_id]);


        $input = $request->all();
        $receipt = DealerOpenFileCancelReceipt::create($input);
        if (!$receipt) {
            return redirect()->route('property.cancel-openfile.receipt')->withInput()
                ->with(['message' => 'Something went wrong!', 'alert-type' => 'error',]);
        } else {
            return redirect()
                ->back()
                ->with(['message' => 'Receipt send for approval!', 'alert-type' => 'info']);
        }
    }

    public function getPendingReceipts(Request $request)
    {        
        $data = array();
        $project_ids =   $this->getCookieInfoAndMultiPro($request);
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];

        $data['receipts'] = CustomerCancelUnitReceipt::with('property')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->where([['is_approved', false], ['is_deleted', false]])
            ->orderBy('receipt_date', 'asc')->get();



        $data['totalAmount'] = CustomerCancelUnitReceipt::where([['is_approved', false],
         ['is_deleted', false]])
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();


            $data['openfile_receipts'] = DealerOpenFileCancelReceipt::
            when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->where([['is_approved', false], ['is_deleted', false]])
            ->orderBy('receipt_date', 'asc')->get();



        $data['openfile_count'] = DealerOpenFileCancelReceipt::where([['is_approved', false], ['is_deleted', false]])
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();

 
            activity('View')->log('Cancel Unit Pending Receipt List');

        return view('receipt.cancel.pending', $data);
    }

    public function editReceiptForm($id)
    {
        $project_ids =   $this->getCookieInfoAndMultiPro();
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];


        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();

        $receipt = CustomerCancelUnitReceipt::where('id', $id)->with('customer', 'property')->first();

        $properties = CustomerProperty::where('customer_id', $receipt->customer_id)->whereHas('cancelProperty', function ($q) {
            $q->where('status', 1);
        })->with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundHistory')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->orderBy('created_at', 'desc')->get();






        $customers = Customer::where('is_deleted', false)->get();


        //rebate history








        return view('receipt.cancel.edit-closefile', compact('receipt', 'banks', 'cBanks', 'customers', 'properties'));
    }

    public function editOpenfileReceiptForm($id)
    {
        $project_ids =   $this->getCookieInfoAndMultiPro();
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];


        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();

        $receipt = DealerOpenFileCancelReceipt::where('id', $id)->first();

       
        $OpenFileDealerInfo_approved_refund = OpenFileDealerInfo::where('dealer_id', $receipt->dealer_id)
        ->whereHas('cancelOpenFile', function ($q) {
            $q->where('status', 1);
        })
            ->whereHas('inventory', function ($query) use ($ids) {
                $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                    $query->whereIn('multi_project_id', $ids);
                });
            })

            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->get();

       
        
            $dealers = Dealer::where('is_deleted', false)->get();




      


        return view('receipt.cancel.edit-openfile', compact('receipt', 'banks', 'cBanks', 'dealers', 'OpenFileDealerInfo_approved_refund'));
    }

    public function editUpdatePropertyForm(Request $request)
    {
        $project_ids =   $this->getCookieInfoAndMultiPro();
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];


        $receipt = CustomerCancelUnitReceipt::where('id', $request->receipt_id)->with('customer', 'property')->first();

        $allStatementscancel = CustomerProperty::where('customer_id', $receipt->customer_id)
        ->whereHas('cancelProperty', function ($q) {
            $q->where('status', 1);
        })->with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundHistory')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->orderBy('created_at', 'desc')->get();



        return view('receipt.cancel.update-table-closefile-edit', compact('receipt', 'allStatementscancel'));
    }

    public function editUpdateOpenfileForm(Request $request)
    {
        $project_ids =   $this->getCookieInfoAndMultiPro();
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];

 


            $receipt = DealerOpenFileCancelReceipt::where('id', $request->receipt_id)->first();

        $allopenfile = OpenFileDealerInfo::where('dealer_id', $receipt->dealer_id)
        ->whereHas('cancelOpenFile', function ($q) {
            $q->where('status', 1);
        })
            ->whereHas('inventory', function ($query) use ($ids) {
                $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                    $query->whereIn('multi_project_id', $ids);
                });
            })

            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->get();

       
        



        return view('receipt.cancel.update-table-openfile-edit', compact('receipt', 'allopenfile'));
    }
    
    public function updateReceipt(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'amount' => 'required|regex:/^[0-9]+$/u',
            'receipt_date' => 'required',
            'customer_id' => 'required',
            'customer_property_id' => 'required',
            'payment_method' => 'required',
            'cheque_number' => 'nullable|regex:/^[a-zA-Z\s0-9]+$/u',
            'receipt_no' => 'required',
        ]);


        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)->withInput()
                ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error',]);
        }

        $allStatementsRefunded = CustomerProperty::where('id', $request->customer_property_id)
        ->whereHas('cancelProperty', function ($q) {
            $q->where('status', 1);
        })->with('unitRefundHistory', 'inventory')
        ->orderBy('created_at', 'desc')->first();

        $total_fee = 0;
        if (!empty($allStatementsRefunded->cancelProperty)) {
            $total_fee = $allStatementsRefunded->cancelProperty->fee;
        }

        $remainingAmount =  $total_fee;
        if ($request->amount > $remainingAmount) {
            return redirect()->back()
                ->with(['message' => 'entered amount is more then remaining amount!', 'alert-type' => 'error',]);
        }

        $multiproject_id = $allStatementsRefunded->inventory ? $allStatementsRefunded->inventory->multiproject->id : null;
        $request->merge(['multi_project_id' => $multiproject_id]);   
        
        $receipt =      CustomerCancelUnitReceipt::where('id', $request->id)->update($request->except(['_token', 'permission', 'receipt_id', 'type', 'total_deduction']));

        if (!$receipt) 
        { 
            return redirect()->back()->withInput()
                ->with(['message' => 'Something went wrong!', 'alert-type' => 'error',]);
        } 
        else 
        {
            return redirect()
                ->back()
                ->with(['message' => 'Receipt send for approval!', 'alert-type' => 'info']);
        }
    }

    public function updateOpenFileReceipt(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'amount' => 'required|regex:/^[0-9]+$/u',
            'receipt_date' => 'required',
            'dealer_id' => 'required',
                'openfile_dealer_info_id' => 'required',
            'payment_method' => 'required',


            'cheque_number' => 'nullable|regex:/^[a-zA-Z\s0-9]+$/u',
            'receipt_no' => 'required',
        ]);


        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)->withInput()
                ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error',]);
        }


        $openfile_refund = OpenFileDealerInfo::where('id', $request->openfile_dealer_info_id)->whereHas('cancelOpenFile', function ($q) {
            $q->where('status', 1);
        })

            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->first();

        $total_deduct = 0;
        if (!empty($openfile_refund->cancelOpenFile)) {
            $total_deduct = $openfile_refund->cancelOpenFile->fee;
        }
 
        $remainingAmount =   $total_deduct;
        if ($request->amount > $remainingAmount) {
            return redirect()->back()
                ->with(['message' => 'entered amount is more then total deduction amount!', 'alert-type' => 'error',]);
        }



        $multiproject_id = $openfile_refund->inventory ? $openfile_refund->inventory->multiproject->id : null;
        $request->merge(['multi_project_id' => $multiproject_id]);

 
       
         $receipt =    DealerOpenFileCancelReceipt::where('id', $request->id)->update($request->except(['_token', 'permission', 'receipt_id', 'type', 'total_deduction']));

        if (!$receipt) {
            return redirect()->back()->withInput()
                ->with(['message' => 'Something went wrong!', 'alert-type' => 'error',]);
        } else {
            return redirect()
                ->back()
                ->with(['message' => 'Receipt Updated Successfully!', 'alert-type' => 'info']);
        }













       


       


       



 
    }

    public function detailReceipt($id)
    {

        $data = array();

        $banks = DepositorBank::orderBy('name', 'ASC')->get();
        $cBanks = CompanyBank::all();

        $data['banks'] = $banks;
        $data['cBanks'] = $cBanks;

        $data['receipt'] = CustomerCancelUnitReceipt::where('id', $id)->first();

        $data['property'] = CustomerProperty::where('id', $data['receipt']->customer_property_id)
            ->whereHas('cancelProperty', function ($q) {
                $q->where('status', 1);
            })
            ->with('inventory', 'customer', 'unitRefundHistory')
            ->first();

       
        // $data['property']->unitRefundHistory->total_refund
        // $data['property']->unitRefundHistory->total_deduct; 
        $data['balance'] =   $data['property']->cancelProperty->fee;

        $digit = new \NumberFormatter("en", \NumberFormatter::SPELLOUT);

        if ($data['receipt']->tax_paid_by == \App\CustomerRefundUnitReceipt::company)
            $data['words'] = $digit->format($data['receipt']->amount + $data['receipt']->tax_amount);
        else
            $data['words'] = $digit->format($data['receipt']->amount);

        
        activity('View')
            ->log('View Unit Cancel Close unit  Receipt record ' . $data['receipt']->receipt_no);

        return view('receipt.cancel.detail-closeunit', $data);
    }

    public function detailOpenFileReceipt($id)
    {

        $data = array();

        $banks = DepositorBank::orderBy('name', 'ASC')->get();
        $cBanks = CompanyBank::all();

        $data['banks'] = $banks;
        $data['cBanks'] = $cBanks;

        $data['receipt'] = DealerOpenFileCancelReceipt::where('id', $id)->first();
        $data['openfile_refund'] = OpenFileDealerInfo::where('id',  $data['receipt']->openfile_dealer_info_id)->whereHas('cancelOpenFile', function ($q) {
            $q->where('status', 1);
        })
             
            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->first();
       

       
         
        $data['balance'] =   $data['openfile_refund']->cancelOpenFile->fee;

        $digit = new \NumberFormatter("en", \NumberFormatter::SPELLOUT);

        if ($data['receipt']->tax_paid_by == DealerOpenFileCancelReceipt::company)
            $data['words'] = $digit->format($data['receipt']->amount + $data['receipt']->tax_amount);
        else
            $data['words'] = $digit->format($data['receipt']->amount);

     
        activity('View')
            ->log('View Open File cancel  Receipt record ' . $data['receipt']->receipt_no);

        return view('receipt.cancel.detail-openunit', $data);
    }

    function uploadReceiptDocument(Request $request)
    {

        $receipt_id = $request->input('receipt_id');

        $supported_image = array(
            'gif',
            'jpg',
            'JPG',
            'jpeg',
            'png',
            'PNG',
            'docx',
            'pdf',
        );

        DB::beginTransaction();

        try {

            if ($request->file('files')) {
                foreach ($request->file('files') as $file) {

                    $imagePath = $file;
                    $imageExtension = $imagePath->getClientOriginalExtension();

                    if (!in_array($imageExtension, $supported_image)) {
                        echo json_encode(array('response' => 'invalid_document', 'message' => 'Only jpg|png|JPG|PNG|jpeg|gif|pdf|docx  Aceptable.'));

                        DB::rollback();
                        exit();
                    }

                    if (in_array($imageExtension, array('docx', 'pdf'))) {
                        $imageName = time() . '.' . $imagePath->getClientOriginalName();
                    } else {
                        $imageName = md5(time() . '.' . $imagePath->getClientOriginalName());
                    }

                    $path = $imagePath->storeAs('receipt_documents', $imageName, 'public');

                    $unit_type = $request->input('unit_type');
                    if($unit_type == CancelReceiptDocument::open_file){
                    CancelReceiptDocument::create([
                        'cancel_receipt_id' => $receipt_id,
                        'document_path' => $imageName,
                        'openfile' => 1
                        
                    ]);
                }
                elseif($unit_type == CancelReceiptDocument::close_unit){
                    CancelReceiptDocument::create([
                        'cancel_receipt_id' => $receipt_id,
                        'document_path' => $imageName,
                        'close_unit' => 1
                        
                    ]);
                }
            }

                DB::commit();

                echo json_encode(array('response' => 'yes'));
            } else {
                echo json_encode(array('response' => 'invalid_document', 'message' => 'Please Select files to upload.'));
                DB::rollback();
                exit();
            }
        } catch (\Exception $e) {
            // d($e);
            DB::rollback();
            echo json_encode(array('response' => 'invalid_document', 'message' => 'Something went wrong. Please Refresh the page.'));
        }
    }

    public function deleteDocument($id = null)
    {

        $receipt_document = CancelReceiptDocument::where('id',$id)->where('close_unit',1)->first();

        if (\File::exists(public_path('storage/receipt_documents/' . $receipt_document->document_path))) {
            \File::delete(public_path('storage/receipt_documents/' . $receipt_document->document_path));
        }

        $receipt_document->delete();

        return redirect()->back();
    }

    public function deleteReceipt($id)
    {
        $receipt = CustomerCancelUnitReceipt::where('id', $id)->first();

        CustomerCancelUnitReceipt::where('id', $id)->update(['is_deleted' => true]);

        $amount = CustomerCancelUnitReceipt::where([['customer_id', $receipt->customer_id], ['is_deleted', false]])->sum('amount');

        // Customer::where('id', $receipt->customer_id)->update(['total_paid_amount' => $amount]);

        activity('Delete')->log('Delete Cancel Unit Receipt info ' . $receipt->receipt_no);

        return redirect()
            ->back()
            ->with([
                'message' => 'Receipt deleted successfully!',
                'alert-type' => 'info'
            ]);
    }

    public function deleteOpenFileReceipt($id)
    {      
        $receipt = DealerOpenFileCancelReceipt::where('id', $id)->first();
        DealerOpenFileCancelReceipt::where('id', $id)->update(['is_deleted' => true]);

        // $amount = CustomerRefundUnitReceipt::where([['customer_id', $receipt->customer_id], ['is_deleted', false]])->sum('amount');

        // Customer::where('id', $receipt->customer_id)->update(['total_paid_amount' => $amount]);

        activity('Delete')->log('Delete Cancel Unit Receipt info ' . $receipt->receipt_no);

        return redirect()
            ->back()
            ->with([
                'message' => 'Receipt deleted successfully!',
                'alert-type' => 'info'
            ]);
    }

    public function approvedReceipt($id)
    {
        $current_receipt = CustomerCancelUnitReceipt::find($id);

        $isLessDateReceipt = CustomerCancelUnitReceipt::where('receipt_date', '<', $current_receipt->receipt_date)->where('customer_property_id', $current_receipt->customer_property_id)->where('is_approved', false)->where('is_deleted', false)->first();


        // customer_property_id
        // $properties = CustomerProperty
        if (!empty($isLessDateReceipt)) {
            return redirect()
                ->back()
                ->withInput()
                ->with([
                    'message' => 'Error ! First approve lower date receipt.',
                    'alert-type' => 'error',
                ]);
        }

        $receipt_n = CustomerCancelUnitReceipt::where('id', $id)->first();





        $receipt =     CustomerCancelUnitReceipt::where('id', $id)->update(['is_approved' => true]);




        if (!$receipt) {
            return redirect()
                ->back()
                ->withInput()
                ->with([
                    'message' => 'Something went wrong!',
                    'alert-type' => 'error',
                ]);
        }


        activity('Approved')->log('Cancel Close Unit Receipt Approved ' . $receipt_n->receipt_no);

        return redirect()
            ->back()
            ->with([
                'message' => 'Receipt Approved successfully!',
                'alert-type' => 'info'
            ]);
    }
     
    public function approvedOpenfileReceipt($id)
    {

        $current_receipt = DealerOpenFileCancelReceipt::find($id);

        $isLessDateReceipt = DealerOpenFileCancelReceipt::where('receipt_date', '<', $current_receipt->receipt_date)->where('openfile_dealer_info_id', $current_receipt->openfile_dealer_info_id)->where('is_approved', false)->where('is_deleted', false)->first();


        // customer_property_id
        // $properties = CustomerProperty
        if (!empty($isLessDateReceipt)) {
            return redirect()
                ->back()
                ->withInput()
                ->with([
                    'message' => 'Error ! First approve lower date receipt.',
                    'alert-type' => 'error',
                ]);
        }

        $receipt_n = DealerOpenFileCancelReceipt::where('id', $id)->first();
        $receipt =     DealerOpenFileCancelReceipt::where('id', $id)->update(['is_approved' => true]);
        if (!$receipt) {
            return redirect()
                ->back()
                ->withInput()
                ->with([
                    'message' => 'Something went wrong!',
                    'alert-type' => 'error',
                ]);
        }
        activity('Approved')->log('Open Unit Cancel Unit Receipt Approved ' . $receipt_n->receipt_no);
        return redirect()
            ->back()
            ->with([
                'message' => 'Receipt Approved successfully!',
                'alert-type' => 'info'
            ]);
    }

    public function receiptList()
    {
        $data = array();
        $project_ids =   $this->getCookieInfoAndMultiPro();
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];

        $data['receipts'] = CustomerCancelUnitReceipt::with('property')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->where('is_deleted', false)
            ->orderBy('receipt_date', 'asc')->get();
        $data['totalAmount'] = CustomerCancelUnitReceipt::where('is_deleted', false)
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();
            $data['openfile_receipts'] = DealerOpenFileCancelReceipt::
            when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->where('is_deleted', false)
            ->orderBy('receipt_date', 'asc')->get();
        $data['openfile_count'] = DealerOpenFileCancelReceipt::where(
         'is_deleted', false)
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count(); 
            activity('View')->log('Cancel Unit Pending Receipt List');
        return view('receipt.cancel.list',$data);
        
    }
}
