<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\ChartOfAccount;
use App\AccountType;
use App\GeneralJournalEntry;
use App\MultiProject;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class ChartOfAccountController extends Controller
{
    

    public function allAccounts() { 

        $data['accounts'] = ChartOfAccount::orderBy('number','ASC')->paginate(100);

        $data['all_accounts'] = ChartOfAccount::select('id','number','name')->orderBy('number','ASC')->get();

        $data['types'] = AccountType::all();

        
        $leafAccount = array();

        foreach ($data['accounts'] as $acc) {
            $leafAccount[$acc->id] = ChartOfAccount::where('sub_account_id',[$acc->id])->count()  == 0 ?  true : false;
        }
        
        $data['leafAccount'] = $leafAccount;

     
        return view('account.index',$data);
    }

    public function updateTable(Request $request) {

        if($request->name != 0 && $request->type != 0) {

        $data['accounts'] = ChartOfAccount::where([['id',$request->name],['account_type_id',$request->type]])->orderBy('number','ASC')->get();

        }
        elseif($request->name != 0 ) {
            $data['accounts'] = ChartOfAccount::where([['id',$request->name]])->orderBy('number','ASC')->get();

        }
        elseif($request->type != 0) {
            $data['accounts'] = ChartOfAccount::where([['account_type_id',$request->type]])->orderBy('number','ASC')->get();

        }
        else 
        {
            $data['accounts'] = ChartOfAccount::orderBy('number','ASC')->get();

        }

        
        $leafAccount = array();

        foreach ($data['accounts'] as $acc) {
            $leafAccount[$acc->id] = ChartOfAccount::where('sub_account_id',[$acc->id])->count()  == 0 ?  true : false;

        }

        $data['leafAccount'] = $leafAccount;

        return view('account.update-table',$data);
    }

    public function addAccountForm() {

        $data['types'] = AccountType::all();



        $data['accounts'] = ChartOfAccount::orderBy('number','ASC')->get();

        return view('account.add-account',$data);
    }
    public function getChartOfAccountNo(Request $request)
    {
      $account_type=  AccountType::where('id', $request->id)->first();
        if (!empty($account_type)) {
            $chart_number=  ChartOfAccount::where('account_type_id',$request->id)->latest('id')->first();
        if(!empty($chart_number))
        {
            $array = explode("-", $chart_number ? $chart_number->number: 1);
 
           
            $lastIndex = count($array) - 1;
            $val=     $array[$lastIndex] + 1;
                if ($val <= 9) {
                     
                    $incrementedValue = sprintf('%02d', $array[$lastIndex] + 1);
                    return $account_type->number.'-'.$incrementedValue;
                }
           else{
            return $account_type->number.'-'.$val;
           }
            ;
        }

        else
        {
            return $account_type->number.'-01';
        }
        }
      


        
    }
    public function getSubChartOfAccountNo(Request $request)
    {
        
        $chart_number = ChartOfAccount::where('id', $request->id)->first();
       
        if (!empty($chart_number)) {
            $latest_sub_account = ChartOfAccount::where('sub_account_id', $chart_number->id)->latest('id')->first();

           $account= AccountType::where('id',$chart_number->account_type_id)->first();
            if (!empty($latest_sub_account)) {
                $array = explode("-", $latest_sub_account->number);
               $array_size= count($array);
                // dd($array_size, $array);
               
                if ($array_size >= 4) {

                    $lastIndex =  $array_size - 1;
                    $val = $array[$lastIndex] + 1;
                   
                    if ($val <= 9999) {
                        
                        $incrementedValue = sprintf('%04d', $array[$lastIndex] + 1);
                        $array[$lastIndex] = $incrementedValue;
                        $string = implode('-', $array);
                        $data = [
                            'account_type' => $account->id,
                            'number' => $string,
                        ];
                        return $data;

                    }
                    else{
                        $incrementedValue =  $array[$lastIndex] + 1;
                        $array[$lastIndex] = $incrementedValue;
                        $string = implode('-', $array);
                        $data = [
                            'account_type' => $account->id,
                            'number' => $string,
                        ];
                        return $data;
                    }
                     
                     
                } else {
                    $lastIndex =  $array_size - 1;
                    $val = $array[$lastIndex] + 1;
                    
                    if ($val <= 9) {
                        
                        $incrementedValue = sprintf('%02d', $array[$lastIndex] + 1);
                        $array[$lastIndex] = $incrementedValue;
                        $string = implode('-', $array);
                        $data = [
                            'account_type' => $account->id,
                            'number' => $string,
                        ];
                        return $data;

                    }
                }
            }
            else{
                
                $array = explode("-", $chart_number->number);
                $array_size= count($array);
              
                 if ($array_size >= 3) {
                    $string = implode('-', $array);
                    $data = [
                        'account_type' => $account->id,
                        'number' => $string.'-0001',
                    ];
                    return $data;
                 } else {
                      
                         $string = implode('-', $array);
                         $data = [
                             'account_type' => $account->id,
                             'number' => $string.'-01',
                         ];
                         return $data;
 
                     
                 }


            }
        }
    }
    //insert new Chart of Account record
    public function insertAccount(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    'number' => 'required',
                    'account_type_id' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/chart-of-accounts/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }
        $account = ChartOfAccount::create($request->all());

        activity('Create')->log('New Chart of account [ ' . $account->name . '] create. ');

        return redirect()
                        ->route('chart-of-account.all')
                        ->with([
                            'message' => 'Account created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    public function editAccountForm($id) {

        $data['types'] = AccountType::all();
        $data['accounts'] = ChartOfAccount::orderBy('number','ASC')->get();

        $data['account'] = ChartOfAccount::find($id);

        return view('account.edit-account',$data);

    }

    //insert new Chart of Account record
    public function updateAccount(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    'number' => 'required',
                    'account_type_id' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/chart-of-accounts/edit/'.$request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }
        // ChartOfAccount::where('id',$request->id)->update(Input::except('_token'));
        // ChartOfAccount::where('id',$request->id)->update($request->all());
        ChartOfAccount::where('id', $request->id)->update(request()->except(['_token', 'permission']));
        $account = ChartOfAccount::find($request->id);

        activity('Create')->log('Update Chart of account [ ' . $account->name . '] create. ');

        return redirect()
                        ->route('chart-of-account.all')
                        ->with([
                            'message' => 'Account updated successfully!',
                            'alert-type' => 'info'
        ]);
    }


    public function getAccountDescription(Request $request) {

        $type = AccountType::find($request->id);

        return  $type->description;
    }

    public function detailAccount($account_id) {

    $from = date(date('Y') . '-' . ChartOfAccount::FISCAL_YEAR_START . '-01');
    $to  = date((date('Y') + 1) . '-' . ChartOfAccount::FISCAL_YEAR_END . '-30');

    $data['openingBalance'] = GeneralJournalEntry::where('date','<',$from)->where([['is_post',true],['account_id',$account_id]])->sum('amount');

    $data['entries'] = GeneralJournalEntry::whereBetween('date',[$from,$to])->where([['is_post',true],['account_id',$account_id]])->orderBy('date','ASC')->get();

    $data['from'] = $from;
    $data['to'] = $to;

    $data['account'] = ChartOfAccount::find($account_id);

    return view('account.detail-account',$data);

    }

    public function updateDetailAccount(Request $request) {

        $date=explode('-',$request->date_range);
        $from=Carbon::parse($date[0])->startOfDay();
        $to=Carbon::parse($date[1])->endOfDay();

         

    $data['openingBalance'] = GeneralJournalEntry::where('date','<',$from)->where([['is_post',true],['account_id',$request->account_id]])->sum('amount');;

    $data['entries'] = GeneralJournalEntry::whereBetween('date',[$from,$to])->where([['is_post',true],['account_id',$request->account_id]])->orderBy('date','ASC')->get();

    $data['from'] = $from;
    $data['to'] = $to;

    $data['account'] = ChartOfAccount::find($request->account_id);

    return view('account.update-detail-account',$data);

    }

    public function deleteAccount($id) {

        ChartOfAccount::where('id',$id)->delete();

        return redirect()->back()->with([
                            'message' => 'Account deleted successfully!',
                            'alert-type' => 'info'
        ]);
    }

    public function dashboard(Request $request) {
       
        try{

            $data =  array();
            if($request->has('multipro_id')){
                
                if($request->multipro_id == 'all'){
                    $data['multipro_id'] =$request->multipro_id;
                }else if(!empty($request->multipro_id)){
                $data['multipro_id'] =  decrypt($request->multipro_id);
                }
            }
            $project_id = request()->cookie('current_project_id');
            $user = Auth::user();
            $data['multi_projects'] = [];
            if (!empty($project_id)) {
                $p_id = decrypt($project_id);
                $multi = MultiProject::where('id', $p_id)->first();
                $multiProjectId = $multi->id;
                if ($multi->name == "Super Admin") {
                    $roles = $user
                        ->roles()
                        ->where('name', 'like', 'admin')
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->first();
                        
                    if (!empty($roles)) {
                        $data['multi_projects']  = MultiProject::where('name', 'NOT like', 'Super Admin')->get();
                        $data['project'] = $multi->name;
                        $data['role'] = 'admin';
                        $data['project_ids'] =  'all';
                        if(isset( $data['multipro_id'])){
                            $data['project_ids'] = $data['multipro_id'];
                            
                        }
                      
                         return  $this->getDashboardData($data);
                        
    
                    } else {
                        $project_ids = $user->roles()
                        ->with(
                        
                        [
                            'projects' => function($query) {
                                // add conditions to the roles query here
                                $query->where('name', 'NOT like', 'Super Admin');
                            },
                            
                        ])
                         // Eager load the related 'projects' models
                        ->get()
                        ->pluck('projects.*.id') // Pluck the 'id' column from the related 'projects' models
                        ->flatten() // Flatten the collection of IDs into a single array
                        ->unique() // Filter out duplicates
                        ->toArray(); // Reset the array keys // Reset the array keys
    
                        ;
                        $data['multi_projects'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get();
                    
                        $data['project'] = $multi->name;
                        $data['role'] = 'other';
                        $data['project_ids'] =  $project_ids;
                        if(isset( $data['multipro_id'])){
                            if($data['multipro_id'] != 'all'){
                            $data['project_ids'] = $data['multipro_id'];
                            }
                         
                        }
                        return  $this->getDashboardData($data);
                    }
                }
                else{

                    $roles = $user
                        ->roles()
                        
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->first(); 
                        if (!empty($roles)) {
                            $data['multi_projects']  = [];
                            $data['project'] = $multi->name;
                            $data['role'] = 'other';
                            $data['project_ids'] =  $multi->id ;
                            if(isset( $data['multipro_id'])){
                                if($data['multipro_id'] != 'all'){
                                    $data['project_ids'] = $data['multipro_id'];
                                    }
                            }
                             return  $this->getDashboardData($data);
                            
        
                        }
                }
            }




        }
        catch(\Exception $e){
            return redirect()

            ->back()
            ->with([
                'message' => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }
       


    }
    
     public function getDashboardData($data){
        $id=[];
       
 if(is_array($data['project_ids'])){
    $id=    $data['project_ids'];
   }
   else
   {
    $id[]=    $data['project_ids'];
   }


        $data['banks'] = ChartOfAccount::whereHas('type',function($query){
            $query->where('name','Bank');
        })->get();

        $bankBalance = array();
        $totalBankBalance = 0;

        foreach($data['banks'] as $b) {
            $bankBalance[$b->id] = GeneralJournalEntry::where([['account_id',$b->id],['is_post',true]])
            ->when($id[0] !== 'all', function ($query) use ($id) {
               $query->whereIn('multi_project_id', $id);
                                })
            ->sum('amount');

            $totalBankBalance += $bankBalance[$b->id];
        }

        $data['bankBalance'] = $bankBalance;
        $data['totalBankBalance'] = $totalBankBalance;

        $data['accountPayable'] = $this->getAccountChildSum('Accounts Payable',date('Y-m-d'),$id);

        $data['accountReceivable'] = $this->getAccountChildSum('Accounts Receivable',date('Y-m-d'),$id);

       

        $data['allEntries'] = GeneralJournalEntry::where([['is_post',false]])
        ->when($id[0] !== 'all', function ($query) use ($id) {
           $query->whereIn('multi_project_id', $id);
                            })
        ->orderBy('entry_no','DESC')->groupBy('entry_no')->get();

        $totalAmount = array();

        foreach ($data['allEntries'] as $entries) {
            $totalAmount[$entries->entry_no] = GeneralJournalEntry::where([['entry_no', $entries->entry_no], ['amount', '>', 0]])
            ->when($id[0] !== 'all', function ($query) use ($id) {
               $query->whereIn('multi_project_id', $id);
                                })
            ->sum('amount');
        }

        $data['totalAmount'] = $totalAmount;

        if(isset($data['multipro_id'])){
            //  dd($data);
            return view('account.dashboard-update',$data);
        }
        else{
            
            return view('account.dashboard',$data);
        }

      


     }
    public function getClosingReport(Request $request) {

        
        $validator = Validator::make($request->all(), [
            'date_range'=>'required',
            'multipro_id' =>'required'

        ]);
       

         if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
       
        $permissions= $request->permission;
        try{
            $id = $request->multipro_id;
            if($id != 'all'){
             $id=   decrypt($request->multipro_id);
            }

            $project_id = request()->cookie('current_project_id');
            $user = Auth::user();
            if (!empty($project_id)) {
                $p_id = decrypt($project_id);
                $multi = MultiProject::where('id', $p_id)->first();
                $multiProjectId = $multi->id;
                if ($multi->name == "Super Admin") {
                    $roles = $user
                        ->roles()
                        ->where('name', 'like', 'admin')
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->first();
                    if (!empty($roles)) {
                        // $data['multi_projects']  = MultiProject::where('name', 'NOT like', 'Super Admin')->get();
                        $data['project'] = $multi->name;
                        $data['role'] = 'admin';
                        $data['project_ids'] =  $id;
                        
                      
                        return   $this->callGetClosingReport($request,$data);
                        
    
                    } else {
                        $project_ids = $user->roles()
                        ->with(
                        
                        [
                            'projects' => function($query) {
                                // add conditions to the roles query here
                                $query->where('name', 'NOT like', 'Super Admin');
                            },
                            
                        ])
                         // Eager load the related 'projects' models
                        ->get()
                        ->pluck('projects.*.id') // Pluck the 'id' column from the related 'projects' models
                        ->flatten() // Flatten the collection of IDs into a single array
                        ->unique() // Filter out duplicates
                        ->toArray(); // Reset the array keys
                         
                        
    
   
                        $data['project'] = $multi->name;
                        $data['role'] = 'other';
                        $data['project_ids'] =  $project_ids;
                        
                            if($id != 'all'){
                            $data['project_ids'] = $id;
                            }
                         
                         
                         return   $this->callGetClosingReport($request,$data);
                    }
                }
                else{
                    // $roles = $user
                    //     ->roles()
                        
                    //     ->whereHas('projects', function ($query) use ($multiProjectId) {
                    //         $query->where('multi_project_id', $multiProjectId);
                    //     })
                    //     ->first(); 

                        $roles = $user->roles()
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->get()
                        ->filter(function ($r) use ($permissions) {
                            return $r->hasPermission($permissions);
                        })
                        ->first();
                      
                     
                        if (!empty($roles) ) {
                            $data['multi_projects']  = [];
                            $data['project'] = $multi->name;
                            $data['role'] = 'other';
                            $data['project_ids'] =  $multi->id ;
                            
                                if($data['multipro_id'] != 'all'){
                                    $data['project_ids'] =$id;
                                    }
                             
                            return  $this->callGetClosingReport($request,$data);
                            
        
                        }
                }
            }


      

        
    }
    catch(\Exception $e){
        return redirect()

        ->back()
        ->with([
            'message' => 'Invalid Inputs!',
            'alert-type' => 'error',
        ]);

    }
    }
    public function callGetClosingReport($request,$data){
        $id=[];
        // $id[]=    $data['project_ids'];
        if(is_array($data['project_ids'])){
            $id=    $data['project_ids'];
           }
           else
           {
            $id[]=    $data['project_ids'];
           }

        $date=explode('-',$request->date_range);
        $from=Carbon::parse($date[0])->startOfDay();
        $to=Carbon::parse($date[1])->endOfDay();
      
        $data['leafAccount'] = ChartOfAccount::where('sub_account_id',$request->bank_id)->count()  == 0 ?  true : false;

        if($data['leafAccount']) {

             $data['transactions'] = GeneralJournalEntry::where([['account_id',$request->bank_id],['is_post',true]])
             ->when($id[0] !== 'all', function ($query) use ($id) {
               $query->whereIn('multi_project_id', $id);
                                })
             ->whereBetween('date',[$from,$to])->get();

            $entryNos = GeneralJournalEntry::where([['account_id',$request->bank_id],['is_post',true]])
            ->when($id[0] !== 'all', function ($query) use ($id) {
               $query->whereIn('multi_project_id', $id);
                                })
            ->pluck('entry_no');

            $entryData = array();
            foreach($entryNos as $entry) {
                $entryData[$entry] = GeneralJournalEntry::where([['entry_no',$entry],['account_id','!=',$request->bank_id]])
                ->when($id[0] !== 'all', function ($query) use ($id) {
                   $query->whereIn('multi_project_id', $id);
                                    })
                ->get();
            }
            $data['accountHit'] = $entryData;

            $data['account'] = ChartOfAccount::find($request->bank_id);

            $data['pre_balance'] = GeneralJournalEntry::where([['account_id',$request->bank_id],['is_post',true],['date','<',$from]])
            ->when($id[0] !== 'all', function ($query) use ($id) {
               $query->whereIn('multi_project_id', $id);
                                })
            ->sum('amount');
            
            $data['level'] = 3;
        }

        else {
            
            $data['account'] = ChartOfAccount::find($request->bank_id);
            
            //check the account is parent account or child account
            if(!($data['account']->sub_account_id)) {
                
                $data['childAccounts'] = ChartOfAccount::where('sub_account_id',$request->bank_id)->get();
                
                $subChild = array();
                $transaction = array();
                $preBalance = array();
                
                foreach($data['childAccounts'] as $cA) {
                    
                    $subChild[$cA->id] = ChartOfAccount::where('sub_account_id',$cA->id)->get();
                    
                    foreach($subChild[$cA->id] as $sCA) {
                        $transaction[$sCA->id] = GeneralJournalEntry::where([['account_id',$sCA->id],['is_post',true]])
                        ->when($id[0] !== 'all', function ($query) use ($id) {
                           $query->whereIn('multi_project_id', $id);
                                            })
                        ->whereBetween('date',[$from,$to])->get();
                        $preBalance[$sCA->id] = GeneralJournalEntry::where([['account_id',$sCA->id],['is_post',true],['date','<',$from]])
                        ->when($id[0] !== 'all', function ($query) use ($id) {
                           $query->whereIn('multi_project_id', $id);
                                            })
                        ->sum('amount');
                    }
                }
                
                $data['level'] = 1;
                $data['subChild'] = $subChild;
                $data['transactions'] = $transaction;
                $data['preBalance'] = $preBalance;
                
            }
            
            else {
                
                $data['childAccounts'] = ChartOfAccount::where('sub_account_id',$request->bank_id)->get();
                
               
                $transaction = array();
                $preBalance = array();
                
                foreach($data['childAccounts'] as $cA) {
                
                        $transaction[$cA->id] = GeneralJournalEntry::where([['account_id',$cA->id],['is_post',true]])
                        ->when($id[0] !== 'all', function ($query) use ($id) {
                           $query->whereIn('multi_project_id', $id);
                                            })
                        ->whereBetween('date',[$from,$to])->get();
                        $preBalance[$cA->id] = GeneralJournalEntry::where([['account_id',$cA->id],['is_post',true],['date','<',$from]])
                        ->when($id[0] !== 'all', function ($query) use ($id) {
                           $query->whereIn('multi_project_id', $id);
                                            })
                        ->sum('amount');
                    
                }
                $data['level'] = 2;
                $data['transactions'] = $transaction;
                $data['preBalance'] = $preBalance;
            }

            
            
            

            // $dayBalance = array();
            // $preBalance = array();

            // foreach($data['childAccounts'] as $cA) {
            //     $id = $cA->id;
            //     if(!$data['account']->sub_account_id) {
            //         $dayBalance[$cA->id] = GeneralJournalEntry::where([['is_post',true],['date',$request->date]])->whereHas('account',function($query) use($id){
            //                 $query->where('sub_account_id', $id); 
            //             })->sum('amount');
            //         $preBalance[$cA->id] = GeneralJournalEntry::where([['is_post',true],['date','<',$request->date]])->whereHas('account',function($query) use($id){
            //                 $query->where('sub_account_id', $id); 
            //             })->sum('amount');
            //     }
            //     else {
            //         $dayBalance[$cA->id] = GeneralJournalEntry::where([['is_post',true],['date',$request->date]])->whereHas('account',function($query) use($id){
            //                 $query->where('id', $id); 
            //             })->sum('amount');
            //         $preBalance[$cA->id] = GeneralJournalEntry::where([['is_post',true],['date','<',$request->date]])->whereHas('account',function($query) use($id){
            //                 $query->where('id', $id); 
            //             })->sum('amount');

            //     }


            // }

            // $data['dayBalance'] = $dayBalance;
            // $data['preBalance'] = $preBalance;

        }

            $data['from'] = $from;
            $data['to'] = $to;

        return view('account.closing-report',$data);
    }
    //get  the sum of accounts of specific type
    public static function getAccountChildSum($accountName,$date,$id='all') {

        $sum = 0;
        $result = ChartOfAccount::whereHas('type',function($query) use($accountName) {
            $query->where('name',$accountName);
        })->get();
        foreach($result as $r) {
            $result = GeneralJournalEntry::where([['is_post',true],['date','<=',$date],['account_id',$r->id]])
            ->when($id[0] !== 'all', function ($query) use ($id) {
               $query->whereIn('multi_project_id', $id);
                                })
            ->sum('amount');
            $sum += $result;
        }

        return $sum;

    }
}
