<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\CompanyBank;
use App\DepositorBank;
use App\ExpensePayment;
use App\AccountTransfer;
use App\DealerPaidRebate;
use App\Receipt;

class CompanyBankController extends Controller {

    protected $bank;

    public function __construct() {
        $this->bank = new CompanyBank();
    }

    //Get All the accounts
    public function allBanks() {

        $allBanks = CompanyBank::orderBy('created_at', 'desc')->get();

        return view('transaction/bank.index', compact('allBanks'));
    }

    //show the add new account  form
    public function addBankForm() {

        $banks = DepositorBank::all();
        
        return view('transaction/bank.add-bank',compact('banks'));
    }

    //insert new account record
    public function insertBank(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    'account_title' => 'required',
                    'account_number'=>'required',
                    'opening_balance'=>'required'
        ]);

        if ($validator->fails()) {
            return redirect('/bank-account/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new Bank
        //$bank = CompanyBank::create(Input::all());
        $input=$request->all();
        $bank = CompanyBank::create($input);

        return redirect()
                        ->route('bank.detail',['id'=>$bank->id])
                        ->with([
                            'message' => 'Account created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the Account
    public function detailBank($id) {

        $data['bank'] = CompanyBank::where('id', $id)->first();
    
        $sales = Receipt::where([['company_account',$id],['is_deleted',false]])->get();

        $records = array();

        foreach ($sales as $s) {
            $newRecord = ['date'=>$s->receipt_date,'amount'=>$s->amount,'category'=>'Sale Receipt','memo'=>'Receipt # '.$s->receipt_no,'type'=>'credit'];

            array_push($records,$newRecord);
        }

        $data['records']  = collect($records)->sortBy('date')->all();

        return view('transaction/bank.detail-bank', $data);
    }

    //show the edit bank form
    public function editBankForm($id) {

        $bank = CompanyBank::where('id', $id)->first();
        
        $banks = DepositorBank::all();

        return view('transaction/bank.edit-bank', compact('bank','banks'));
    }

    //update the Expense record
    public function updateBank(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    'account_title' => 'required',
                    'account_number'=>'required',
                    'opening_balance'=>'required'
                    
        ]);

        if ($validator->fails()) {
            return redirect('/bank-account/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Bank
        CompanyBank::where('id',$request->id)->update($request->except(['_token']));

        return redirect()
                        ->route('bank.detail',['id'=>$request->id])
                        ->with([
                            'message' => 'Account updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific bank
    public function deleteBank($id) {

        CompanyBank::where('id', $id)->delete();

        return redirect()->route('bank.all')->with([
                    'message' => 'Account deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
