<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\Customer;
use App\CustomerStatement;
use App\CustomerProperty;
use DB;
use App\Country;
use App\City;
use Carbon\Carbon;
use App\Receipt;
use App\CustomerDocument;
use App\PropertyChatHistory;
use App\DNFBP;
use App\CustomerPropertyTax;
use App\TaxReceipt;
use App\DepositorBank;
use App\TransferProperty;
use App\DealerTransaction;
use App\PaymentHeadPriority;
use App\CompanyBank;
use App\MultiProject;
use App\SurchargeReceipt;
use App\TransferPropertyHistory;
// use App\CustomersFingerprint;
use Illuminate\Support\Facades\Auth;
use App\Traits\MultiProjectCookie;
  

class CustomerController extends Controller {

    use MultiProjectCookie;
    protected $customer;

    public function __construct() {
        $this->customer = new Customer();
    }
   
    //Get All the customer
    public function allCustomers() {

       
        $data = array();
        $request = app(Request::class);

        $data =
        $this->getCookieInfoAndMultiPro($request);
 
        if($data['status'] == 'error'){
            return redirect()

            ->back()
            ->with([
                'message' => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }
        
        $ids=[];
        if(is_array($data['project_ids'])){
            $ids= $data['project_ids']; 
        }
        else{
          
            //  if(sizeof($data['multi_projects']) > 0){
                $ids[]= $data['project_ids'];
            //  }else{
                // $ids[] = 'all';
            //  }

        }
         
       
        // dd($ids, sizeof($data['multi_projects']));

        $data['allCustomers'] = Customer::orderBy('created_at', 'desc')->where('is_deleted',false)->paginate(25);
        $data['customerCount'] = Customer::where([['is_deleted',false]])->count();

        
        $data['customerNames'] = Customer::where('is_deleted',false)->select('name','id')->orderBy('name','asc')->get();

        $data['referenceNumbers'] = CustomerProperty::where([['is_deleted',false],['membership_no','!=',null]])
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
                            })
        ->get();

        activity('View')->log('Customer list.');

        return view('customer.index', $data);
    }

    //show the add new customer form
    public function addCustomerForm() {

        $countries = Country::all();
        $depositer_banks = DepositorBank::all();
        // $fingerplace = CustomersFingerprint::all(); 
        
        

        return view('customer.add-customer',compact('countries','depositer_banks'));
    }

    //insert new customer record
    public function insertCustomer(Request $request) {

    //    dd($request->all());

    if($request->type == 1)
    {
        $messages = [
        'account_title.required_if' => 'The account title field is required when payment method is bank or cheaque.',
        'depositer_bank.required_if' => 'The depositer bank field is required when payment method is bank or cheaque.',
        'iban_number.required_if' => 'The iban number field is required when payment method is bank or cheaque.',
        'cnic.required' => 'Incorportion number required.'
        ];
    }
    else
    {
        $messages = [
        'account_title.required_if' => 'The account title field is required when payment method is bank or cheaque.',
        'depositer_bank.required_if' => 'The depositer bank field is required when payment method is bank or cheaque.',
        'iban_number.required_if' => 'The iban number field is required when payment method is bank or cheaque.',
        'cnic.required' => 'Cnic number required.'
        ];
    }



        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s,.-]+$/u',
                    'father_name' => 'required|regex:/^[a-zA-Z\s,-.]+$/u',
                    'cnic' => 'unique:customers,cnic|required',
                    'mailing_address' => 'required',
                   // 'payment_method' => 'required',
                    // 'dob' => 'required',
                    'mobile_number' => 'required',
                    'nominee_name' => 'required|regex:/^[a-zA-Z\s,.-]+$/u',
                    'nominee_so_do_wo' => 'required|regex:/^[a-zA-Z\s,-.]+$/u',
                    'nominee_relation' => 'required',
                    // 'file' => 'required',
                    'nominee_cnic' => 'required',
                    'nominee_address' => 'required',
                    'type' => 'required',

                    'account_title'=>'nullable|required_if:payment_method,1,2',
                    'depositer_bank'=>'nullable|required_if:payment_method,1,2',
                    'iban_number'=>'nullable|required_if:payment_method,1,2',
                    

        ],$messages);

        //............for validate user cnic from dnfbp...................//

      
        $dnfbp_check_point_customer = DNFBP::where('cnic' , $request->cnic)->first();

              if ($dnfbp_check_point_customer == true) 
            {
                return redirect('/add/customer')
                ->withInput()
                ->with([
                    'message' => 'This Member cnic is found in list of DNFBP. You cant add this customer record.',
                    'alert-type' => 'error',
                ]);
            }
     

         if ($request->nominee_cnic) 
        {
             $dnfbp_check_point_nominee = DNFBP::where('cnic' , $request->nominee_cnic)->first();

                if ($dnfbp_check_point_nominee == true) 
            {
                return redirect('/add/customer')
                ->withInput()
                ->with([
                    'message' => 'This Member cnic is found in list of DNFBP. You cant add this nominee record.',
                    'alert-type' => 'error',
                ]);
            }
        }

       //.............end...........................................//

        if ($validator->fails()) {
            return redirect('/add/customer')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

       


        //create new customer
        $customer = $this->customer->insertNewCustomer($request);
        
        // $fingerplace = CustomersFingerprint::all();
        // $fingerplace = CustomersFingerprint::where('id',$request->customers_fingerprint_id)->first();


        

        activity('Create')->log('customer ' . $customer->name);

        return redirect()
                        ->route('customer.detail', ['id' => $customer->id])
                        ->with([
                            'message' => 'Customer created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the customer
    public function detailCustomer($id) {

        $customer = Customer::with('receipts','properties','nominee')->where('id', $id)->first();

        // $fingerplace = CustomersFingerprint::all();

        $cancel_properties = CustomerProperty::where('customer_id',$id)->where('status' , CustomerProperty::cancel)->pluck('id');

        $received = CustomerStatement::where([['customer_id',$id],['is_deleted',false]])->whereNotIn('customer_property_id' , $cancel_properties)->sum('received');  

        $dueAmount = CustomerStatement::where([['customer_id',$id],['due_date','<',date('y-m-d')]])->whereNotIn('customer_property_id' , $cancel_properties)->value(DB::raw("SUM(balance)"));

        $outstandingAmt = CustomerProperty::where('customer_id',$id)->whereNotIn('id' , $cancel_properties)->sum('net_pay') - $received;
        $transferproperty=  TransferProperty::where('owner_id',$id)->get();
        
        $followUps = PropertyChatHistory::with('property')->whereHas('property',function($query) use($id) {
            $query->where('customer_id',$id);
        })->get();

        activity('View')->log('See the customer Detail '.$customer->name);

        return view('customer.detail-customer', compact('transferproperty','customer','dueAmount','received','outstandingAmt','followUps'));
    }

    //show the edit customer form
    public function editCustomerForm($id) {

        $customer = Customer::where('id', $id)->first();
        $depositer_banks = DepositorBank::all();

        return view('customer.edit-customer', compact('customer','depositer_banks'));
    }

    //update the customer record
    public function updateCustomer(Request $request) {

  if($request->type == 1)
        {
            $messages = [
                 'account_title.required_if' => 'The account title field is required when payment method is bank or cheaque.',
            'depositer_bank.required_if' => 'The depositer bank field is required when payment method is bank or cheaque.',
            'iban_number.required_if' => 'The iban number field is required when payment method is bank or cheaque.',
                    'cnic.required' => 'Incorportion number required.'
                    ];
        }
        else
        {
             $messages = [
                  'account_title.required_if' => 'The account title field is required when payment method is bank or cheaque.',
            'depositer_bank.required_if' => 'The depositer bank field is required when payment method is bank or cheaque.',
            'iban_number.required_if' => 'The iban number field is required when payment method is bank or cheaque.',
                    'cnic.required' => 'Cnic number required.'
                    ];
        }



        $validator = Validator::make($request->all(), [
                   'name' => 'required|regex:/^[a-zA-Z\s,.-]+$/u',
                    'father_name'=>'required|regex:/^[a-zA-Z\s,-.]+$/u',
                    'cnic'=>'required',
                    'nominee_address' => 'required',
                    'mailing_address' => 'required',
                    //  'payment_method' => 'required',

                    // 'dob' => 'required',
                    'mobile_number'=>'required',
                    'nominee_name' => 'required|regex:/^[a-zA-Z\s,.-]+$/u',
                    'nominee_so_do_wo' => 'required|regex:/^[a-zA-Z\s,-.]+$/u',
                    'nominee_relation' => 'required',

                     'account_title'=>'nullable|required_if:payment_method,1,2',
                    'depositer_bank'=>'nullable|required_if:payment_method,1,2',
                    'iban_number'=>'nullable|required_if:payment_method,1,2',

        ],$messages);


         //............for validate user cnic from dnfbp...................//

      
        $dnfbp_check_point_customer = DNFBP::where('cnic' , $request->cnic)->first();

              if ($dnfbp_check_point_customer == true) 
            {
                return redirect('/customer/edit/' . $request->id)
                ->withInput()
                ->with([
                    'message' => 'This Member cnic is found in list of DNFBP. You cant add this customer record.',
                    'alert-type' => 'error',
                ]);
            }
     

         if ($request->nominee_cnic) 
        {
             $dnfbp_check_point_nominee = DNFBP::where('cnic' , $request->nominee_cnic)->first();

                if ($dnfbp_check_point_nominee == true) 
            {
                return redirect('/customer/edit/' . $request->id)
                ->withInput()
                ->with([
                    'message' => 'This Member cnic is found in list of DNFBP. You cant add this nominee record.',
                    'alert-type' => 'error',
                ]);
            }
        }

       //.............end...........................................//

        if ($validator->fails()) {
            return redirect('/customer/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update customer
        $this->customer->updateCustomer($request);

        $cus = Customer::where('id',$request->id)->first();

        activity('Update')->log('Edit the Customer info '.$cus->name);

        return redirect()
                        ->route('customer.detail', ['id' => $request->id])
                        ->with([
                            'message' => 'Customer updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific customer
    public function deleteCustomer($id) {

       // $this->customer->deleteCustomer($id);

        $cus = Customer::where('id',$id)->first();

        activity('Delete')->log('delete the Customer info '.$cus->name);

        Customer::where('id',$id)->update(['is_deleted'=>true]);

        CustomerProperty::where('customer_id',$id)->update(['is_deleted'=>true]);

        Receipt::where('customer_id',$id)->update(['is_deleted'=>true]);

        $amount = Receipt::where('customer_id',$id)->sum('amount');

        Customer::where('id',$id)->update(['total_paid_amount'=>$amount]);


        return redirect()->route('customer.all')->with([
                    'message' => 'Customer deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function getCitiesByCountry(Request $request) {
        return City::where('country_id',$request->country_id)->get();
    }

    public function downloadData($id) {

        $result = CustomerProperty::where('id',$id)->with('customer','inventory')->first();
        


        //membership

    
        $data['statement'] = CustomerProperty::where('id',$id)->with('inventory','customer')->first();

        $data['receivedAmt'] = CustomerStatement::where('customer_property_id',$data['statement']->id)->sum('received');
        $data['receipt'] = Receipt::where([['customer_property_id',$data['statement']->id],['payment_head',Receipt::down_payment]])->first();



        //Statement
        

        $data['property'] = CustomerProperty::where('id',$id)->with('inventory','customer','statement')->first();
        $data['amount'] = CustomerStatement::where('customer_property_id',$id)->sum('received');
        $data['receivedAmtPer'] = $data['amount'] * 100 / $data['property']->net_pay;

        $pdf = \PDF::loadView('customer.download-data',$data);

        $name = $data['property']->customer->name;

        

            activity('Download')->log('Download customer complete data ' . $name);


        return $pdf->download($name . '-property.pdf');

    }

    public function updateTable(Request $request) {

        if($request->ref != 0 && $request->cus != 0) {
            $ref = $request->ref;
            $data['allCustomers'] = Customer::where([['is_deleted',false],['id',$request->cus]])->whereHas('properties', function($query) use ($ref) {
                    $query->where('id',$ref);
                })->get();
        }
        else if($request->ref != 0) {
            $ref = $request->ref;
            $data['allCustomers'] = Customer::where([['is_deleted',false]])->whereHas('properties', function($query) use ($ref) {
                    
                        $query->where('id', $ref);
                    
                })->get();
        }
        else if($request->cus != 0) {
            $data['allCustomers'] = Customer::where([['is_deleted',false],['id',$request->cus]])->get();
        }

        return view('customer.update-table',$data);
    }

    public function deleteCustomerDocument($id) {

        $customer = CustomerDocument::where('id',$id)->with('customer')->first();

        CustomerDocument::where('id',$id)->delete();

        if($customer){
            activity('Delete')->log('Customer document delete ' . $customer->customer->name);
        }

        return redirect()->back()->with([
                            'message' => 'Customer document deleted successfully!',
                            'alert-type' => 'info'
        ]);
    }

    public function addCustomerDocument(Request $request) {

        $customer = Customer::where('id',$request->customer_id)->first();

        if ($request->hasfile('file')) {

             $file = $request->file('file');
             $name = $request->customer_id . '-' . $file->getClientOriginalName();

             $file->move(public_path() . '/uploads/', $name);

             CustomerDocument::create(['customer_id'=>$request->customer_id,'url'=>$name,'name'=>$request->name]);
           
         }

        

        if($customer){
            activity('Delete')->log('Customer document addedd' . $customer->name);
        }

        return redirect()->back()->with([
                            'message' => 'Customer document added successfully!',
                            'alert-type' => 'info'
        ]);
    }

    public function renameDocumentModal(Request $request) {


        $data['document'] = CustomerDocument::find($request->document_id);

        return view('customer.rename-document-modal',$data);
    }

    public function renameCustomerDocument(Request $request) {

        $doc = CustomerDocument::find($request->document_id);
            

        $customer = Customer::where('id',$doc->customer_id)->first();


        CustomerDocument::where('id',$request->document_id)->update(['name'=>$request->name]);


        if($customer){
            activity('Delete')->log('Customer document Rename' . $customer->name);
        }

        return redirect()->back()->with([
                            'message' => 'Customer document rename successfully!',
                            'alert-type' => 'info'
        ]);
    }

    public function taxPaid(Request $request) {

      
        if ($request->hasfile('file')) {

             $file = $request->file('file');
             $name = $request->tax_id . '-' . $file->getClientOriginalName();

             $file->move(public_path() . '/uploads/', $name);

             CustomerPropertyTax::where('id',$request->tax_id)->update(['reference'=>$request->reference,'cpr'=>$name,'status'=>true]);
           
         }


        return redirect()->back()->with([
                            'message' => 'Tax paid successfully!',
                            'alert-type' => 'info'
        ]);
    }


 public function taxAmountPaid(Request $request) {


  DB::beginTransaction();

    try {

        $dataArray = ['tax_id' => $request->tax_receipt_id , 'receipt_no' => $request->receipt_no ,'receipt_date' => $request->tax_receipt_date , 'receipt_amount' => $request->tax_amount ,'payment_method' => $request->payment_method , 'note' => $request->description ];


        if ($request->payment_method == TaxReceipt::bank || $request->payment_method == TaxReceipt::cheque) 
        {
            $dataArray['depositer_bank_id'] = $request->bank_name;
            $dataArray['company_bank_id'] = $request->company_account;
            $dataArray['drawn_date'] = $request->drawn_date;
            $dataArray['instrument_no'] = $request->cheque_number;
            $dataArray['inst_no'] = $request->inst_no;
            $dataArray['payment_head'] = $request->payment_head;
        }


          $tax_receipt =   TaxReceipt::create($dataArray);

            CustomerPropertyTax::where('id',$request->tax_receipt_id)->update(['tax_payment_received'=>CustomerPropertyTax::paid ]);

            Receipt::where('receipt_no' , $request->receipt_no)->update(['tax_payment_received'=>CustomerPropertyTax::paid]);

    
          DB::commit();

            return redirect()->route('receipt.tax.detail' , [ $tax_receipt->id])->with([
            'message' => 'Tax paid successfully!',
            'alert-type' => 'info'
            ]);
      } 
        
        catch (\Exception $e) 
      {
       DB::rollback();
        
         return redirect()->back()->with([
                            'message' => 'Something went wrong!',
                            'alert-type' => 'error'
        ]);

      }


    }


    public function deleteCustomerReceipt($cust_receipt_id = null)
    {
        
        $tax_receipt =   TaxReceipt::find($cust_receipt_id);

          DB::beginTransaction();

    try {

            CustomerPropertyTax::where('id',$tax_receipt->tax_id)->update(['tax_payment_received'=>CustomerPropertyTax::unpaid ]);

            Receipt::where('receipt_no' , $tax_receipt->receipt_no)->update(['tax_payment_received'=>CustomerPropertyTax::unpaid]);


            $tax_receipt->delete();

    
            DB::commit();

            return redirect()->back()->with([
            'message' => 'Tax deleted  successfully!',
            'alert-type' => 'info'
            ]);
      } 
        
        catch (\Exception $e) 
      {
       DB::rollback();
        
         return redirect()->back()->with([
                            'message' => 'Something went wrong!',
                            'alert-type' => 'error'
        ]);

      }


    }


    public function customerTransferStatementHistory($id){

        $transferproperty= TransferProperty::where('id',$id)->first();
    //     dd($transferproperty->transferhistory);
        $property = CustomerProperty::where('id', $transferproperty->property_id)->with('inventory','customer','statement','propertyTax')->first();
        $amount = TransferPropertyHistory::where('transfer_prop_id',$id)->sum('received');
        $data = unserialize($transferproperty->unit_detail);
         
        $receivedAmtPer = $amount * 100 /  $data['net_amt'];
        $outstandingAmt = ( $data['net_amt'] - $amount);
        $outstandingAmtPer = $outstandingAmt * 100 / $data['net_amt'];

        $dealers = DealerTransaction::where('product_id',$id)->get();
        $periorities = PaymentHeadPriority::orderby('priority' , 'ASC')->get(['payment_head' , 'priority']);
        $pdc_receipt= Receipt::where('customer_property_id',$transferproperty->property_id)->where('payment_method',Receipt::cheque)->where('cheaque_status' , Receipt::pending)->sum('amount');
        
        $pdcReceiptPer = $pdc_receipt * 100 /  $data['net_amt'];
        $allotment = false; $provisional = false;

        if($receivedAmtPer >= 10) 
        {
            $allotment = true;
        }
        if($receivedAmtPer >= 25) 
        {
            $provisional = true;
        }
        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();
        $waiveOff = SurchargeReceipt::where('customer_property_id', $transferproperty->property_id)->where('customer_id' , $transferproperty->owner_id)->where('amount' , 0)->sum('total_surcharge');
        $paidSurcharge = SurchargeReceipt::where('customer_property_id', $transferproperty->property_id)->where('customer_id' , $transferproperty->owner_id)->sum('amount');  
        $taxs = CustomerPropertyTax::where('customer_id',$transferproperty->owner_id)->where('property_id',$transferproperty->property_id)->get();
       
        activity('View')->log('View the tranfer history detail '. $transferproperty->property->inventory->unit_number . $transferproperty->property->customer->name);
        


        return view('customer.transfer-history',compact('taxs','data','transferproperty','paidSurcharge','waiveOff','property','allotment','provisional','amount','receivedAmtPer','outstandingAmtPer','outstandingAmt','dealers','banks','cBanks','periorities','pdc_receipt','pdcReceiptPer'));

    }

    public function getCookieInfoAndMultiProold($request){
        $data =  array();
        try{
           
          
            if($request->has('multipro_id')){
                
                if($request->multipro_id == 'all'){
                    $data['multipro_id'] =$request->multipro_id;
                }else if(!empty($request->multipro_id)){
                $data['multipro_id'] =  decrypt($request->multipro_id);
                }
            }
            
            
            $project_id = request()->cookie('current_project_id');
            
            $user = Auth::user();
            $data['multi_projects'] = [];
            if (!empty($project_id)) {
                $p_id = decrypt($project_id);
                $multi = MultiProject::where('id', $p_id)->first();
                $multiProjectId = $multi->id;
                if ($multi->name == "Super Admin") {
                    $roles = $user
                        ->roles()
                        ->where('name', 'like', 'admin')
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->first();
                    if (!empty($roles)) {
                        $data['multi_projects']  = MultiProject::where('name', 'NOT like', 'Super Admin')->get()->pluck('id')->toArray();
                        $data['project'] = $multi->name;
                        $data['role'] = 'admin';
                        $data['project_ids'] =  'all';
                        if(isset( $data['multipro_id'])){
                            $data['project_ids'] = $data['multipro_id'];
                            
                        }
                        $data['status'] = 'success';
                        return  $data;
                        
    
                    } else {
                        
 $permission=decrypt($request->permission);
 $project_ids=       $user->roles()
//  ->where('name', 'NOT like', 'admin')
->whereHas('projects', function ($query)   {
$query->where('name', 'NOT like', 'Super Admin');
})
->get()
->filter(function ($r) use ($permission) {
return $r->hasPermission($permission);
})
->pluck('projects.*.id')  
->flatten() 
->unique()
->toArray()
;



                        // $project_ids = $user->roles()
                        // ->with(
                        
                        // [
                        //     'projects' => function($query) {
                        //         // add conditions to the roles query here
                        //         $query->where('name', 'NOT like', 'Super Admin');
                        //     },
                            
                        // ])
                        //  // Eager load the related 'projects' models
                        // ->get()
                        // ->pluck('projects.*.id') // Pluck the 'id' column from the related 'projects' models
                        // ->flatten() // Flatten the collection of IDs into a single array
                        // ->unique() // Filter out duplicates
                        // ->toArray(); // Reset the array keys// Reset the array keys
                      if(sizeof($project_ids) == 0)
                      {
                        $data['status'] = 'error';
                        return $data;
                      }
                        
                        $data['multi_projects'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get();
                        $data['project'] = $multi->name;
                        $data['role'] = 'other';
                        $data['project_ids'] =  $project_ids;
                        if(isset( $data['multipro_id'])){
                            if($data['multipro_id'] != 'all'){
                            $data['project_ids'] = $data['multipro_id'];
                            }
                         
                        }
                        $data['status'] = 'success';
                        return $data;
                    }
                }
                else{
                    $roles = $user
                        ->roles()
                        
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->first(); 
                      
                    
                        if (!empty($roles)) {
                            $data['multi_projects']  = [];
                            $data['project'] = $multi->name;
                            $data['role'] = 'other';
                            $data['project_ids'] =  $multi->id ;
                            if(isset( $data['multipro_id'])){
                                if($data['multipro_id'] != 'all'){
                                    $data['project_ids'] = $data['multipro_id'];
                                    }
                            }
                            $data['status'] = 'success';
                            return  $data;
                            
        
                        }
                }
            }
            else
            {
                $data['status'] = 'error';
                return  $data; 
            }
        }
        catch(\Exception $e){
            $data['status'] = 'error';
            return  $data;
    
        }
    }
}
