<?php

namespace App\Http\Controllers;

use App\CustomerProperty;
use Illuminate\Http\Request;
use App\CustomerRequest;
use App\UnitSize;
use App\UnitFloor;
use App\Customer;

class CustomerRequestController extends Controller
{
    

    public function index() {

    	$data['requests'] = CustomerRequest::orderBy('created_at','desc')->get();

    	return view('customer-request.index',$data);
    }

    public function addForm() {

    	$data['sizes'] = UnitSize::orderBy('name','asc')->get();
    	$data['floors'] = UnitFloor::orderBy('name','asc')->get();

    	return view('customer-request.create',$data);
    }

    public function smsForm(Request $request) {

        $data = array();

        $data['customer'] = Customer::where('id',$request->customer_id)->first();

        return view('customer-request.sms-modal',$data);

    }
}
