<?php

namespace App\Http\Controllers;


use App\DealerPaidRebate;
use App\DealerTransaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\Dealer;
use App\DealerType;
use App\Country;
use App\City;
use App\CustomerProperty;
use App\CustomerStatement;
use App\Receipt;
use App\DepositorBank;
use App\CompanyBank;
use App\DealerReceivedAmount;
use DB;
use Carbon\Carbon;
use App\DNFBP;
use App\DealerPackage;
use App\DealerPackageReceipt;
use App\Inventory;
use DataTables;

class DealerController extends Controller {

    protected $dealer;

    public function __construct() {
        $this->dealer = new Dealer();
    }

    //Get All the Dealer
    public function allDealers(Request $request) {

        $allDealers = Dealer::with('dealerType')->where([['is_deleted',false]])->orderBy('created_at', 'desc')->get();

        activity('View')->log('Dealer List.');

        return view('Dealer.index', compact('allDealers'));
    }

    //show the add new Dealer form
    public function addDealerForm() {

         $countries = Country::all();
         $types = DealerType::where([['status',true]])->get();
         $dealers = Dealer::where([['status',true]])->with('dealerType')->orderby('name','asc')->select('dealer_type_id','id','name')->get()->groupBy('dealer_type_id');
         $dealerTypes = DealerType::where([['status',true]])->pluck('name','id');

         return view('Dealer.add-dealer',compact('countries','types','dealers','dealerTypes'));
    }

    //insert new Dealer record
    public function insertDealer(Request $request) {
        $this->validate($request,[
                    
            'incentive_type'=>'required|integer',
            
         ]);
        $validator = Validator::make($request->all(), [
                    'name' => 'required',
                  
                    'percentage' => 'required|numeric',
                    'phone_number'=>'nullable',
                    'country_id'=>'required',
                  
                    'city_id'=>'required',
                    'code'=>'required',
                    
        ]);


        
            //............for validate dealer cnic from dnfbp...................//
            $dealerTypes = DealerType::where([['id',$request->incentive_type]])->first();
            if ($dealerTypes->name == 'company' || $dealerTypes->name == 'Company') {
                $this->validate($request,[
                    
                    'reg_no'=>'required|unique:dealers,reg_no',
                    
                 ]);
            } else {
                $this->validate($request,[
                    
                    'cnic'=>'required|unique:dealers,cnic',
                   
                    
                 ]);
            }
      if ($request->cnic) {
          // code...
   
           $dnfbp_check_point_dealer= DNFBP::where('cnic' , str_replace('-', '', $request->cnic))->first();

              if ($dnfbp_check_point_dealer == true) 
            {
                return redirect('/add/dealer')
                ->withInput()
                ->with([
                    'message' => 'This Dealer cnic is found in list of DNFBP. You cant add this Dealer record.',
                    'alert-type' => 'error',
                ]);
            }
        }
       //.............end...........................................//


        if ($validator->fails()) {
            return redirect('/add/dealer')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }
       
       
        //create new Dealer
        $dealer = $this->dealer->insertNewDealer($request);

        activity('Create')->log('New Dealer Added '. $request->name);

        return redirect()
                        ->route('dealer.detail',['id'=>$dealer->id])
                        ->with([
                            'message' => 'Incentive created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the Dealer
    public function detailDealer($id) {

        $dealer = Dealer::with('dealerType','dealerTransaction','dealerRebate')->where('id', $id)->first();
        $cancel_properties = CustomerProperty::where('status' , CustomerProperty::cancel)->pluck('id');
        
        $properties = CustomerProperty::whereHas('dealerTransaction' , function($query) use($id){
            $query->where('dealer_id',$id);
        })->with('inventory')->get();

        $total_sales = CustomerProperty::whereNotIn('id' , $cancel_properties)->whereHas('dealerTransaction' , function($query) use($id){
            $query->where('dealer_id',$id);
        })->sum('net_pay');
        
        $total_rebates = DealerTransaction::where('dealer_id',$id)->sum('amount');
        $total_paid_rebates = DealerPaidRebate::where('dealer_id',$id)->sum('amount');

        $receivedAmount = array();
        $lastDate = array();
        $remainingAmount = array();
        $color = array();
        $dueAmt = array();
        $dueMonth = array();

        if($properties) {
            foreach($properties as $property) {
                $receivedAmount[$property->id] = Receipt::where('customer_property_id' , $property->id)->where('is_approved' , 1)->where('is_deleted',false)->sum('amount');

                $lastDate[$property->id] = Receipt::where('customer_property_id',$property->id)->orderBy('receipt_date','desc')->where('is_approved' , 1)->where('is_deleted',false)->first();
                $remainingAmount[$property->id] = $property->net_pay - $receivedAmount[$property->id];
                $remainingInstallments = CustomerStatement::where([['due_date','<=',Carbon::today()],['customer_property_id',$property->id],['balance','>',0]])->count();
                $dueAmt[$property->id] = CustomerStatement::where('customer_property_id',$property->id)->where('due_date','<=',Carbon::today())->value(DB::raw("SUM(balance)"));
                $dueMonth[$property->id] = CustomerStatement::where([['due_date','<=',Carbon::today()],['customer_property_id',$property->id],['balance','>',0]])->get();
            if($remainingInstallments)
            {
                if($remainingInstallments >= 3 )
                {
                    $color[$property->id] = 'red';
                }
                elseif($remainingInstallments = 2 ) {
                    $color[$property->id] = 'orange';
                }
                else
                    $color[$property->id] = 'black';

            }
            else
                $color[$property->id] = 'black';
            }
        }

        $dealerReceivedAmount = DealerReceivedAmount::where('dealer_id',$id)->with('property')->get();

        // inventory rebate history
        $transactions = DealerTransaction::where([['dealer_id',$id],['product_id','!=',null]])->with('property')->get();
        $paid_rebate = array();
        $received_amount = array();
        $released_amount = array();
        foreach ($transactions as $t) {
            $released_amount[$t->id] = 0;
            if($t->property) {
                $paid_rebate[$t->id] = DealerPaidRebate::where([['dealer_id',$id],['property_id',$t->property->id],['is_deleted',false]])->sum('amount');
                $received_amount[$t->id] = Receipt::where([['customer_property_id',$t->property->id],['is_deleted',false],['is_approved' , 1]])->sum('amount');
                
            }
        }


         // package rebate history
         $package_transactions = DealerTransaction::where([['dealer_id',$id],['dealer_package_id','!=',null]])->with('dealerPackage')->get();
         $package_paid_rebate = array();
         $package_received_amount = array();
         $package_released_amount = array();
         foreach ($package_transactions as $package_t) {
             $package_released_amount[$package_t->id] = 0;
             if($package_t->dealerPackage) {
                 $package_paid_rebate[$package_t->id] = DealerPaidRebate::where([['dealer_id',$id],['dealer_package_id',$package_t->dealerPackage->id],['is_deleted',false]])->sum('amount');
                 $package_received_amount[$package_t->id] = DealerPackageReceipt::where([['dealerpackage_id',$package_t->dealerPackage->id],['is_deleted',false],['is_approved' , 1]])->sum('amount');
                 
             }
         }
 
         
 
 
 











        $dealer_openfile_package = DealerPackage::where('dealer_id',$dealer->id)->get();
        $inventory_rebate=   $dealer->dealerRebate->where('property_id' ,'!=',null);
        $package_rebate=   $dealer->dealerRebate->where('dealer_package_id' ,'!=',null);
                                       
        

        activity('View')->log('Dealer detail '. $dealer->name);

        return view('Dealer.detail-dealer', compact('package_transactions','package_paid_rebate','package_received_amount','package_released_amount'
        ,'package_rebate','inventory_rebate','dealer_openfile_package','dealer','properties','receivedAmount','lastDate','remainingAmount','dealerReceivedAmount','transactions','paid_rebate','received_amount','released_amount','color','dueMonth','dueAmt','total_sales','total_rebates','total_paid_rebates'));
    }


    //show the edit Dealer form
    public function editDealerForm($id) {

        $dealer = Dealer::with('dealerType')->where('id', $id)->with('city')->first();
        $countries = Country::all();
        $types = DealerType::where([['status',true]])->get();
        if($dealer->city){
        $cities = City::where('country_id',$dealer->city->country_id)->get();}
        else {
            $cities = array();
        }
        $dealers = Dealer::where([['status',true],['id','!=',$id]])->with('dealerType')->orderby('name','asc')->select('dealer_type_id','id','name')->get()->groupBy('dealer_type_id');
         $dealerTypes = DealerType::where([['status',true]])->pluck('name','id');

        return view('Dealer.edit-dealer', compact('dealer','countries','cities','types','dealerTypes','dealers'));
    }

    //update the Dealer record
    public function updateDealer(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    // 'cnic'=>'required',
                    'percentage' => 'required|numeric',
                    'phone_number'=>'nullable',
                    // 'email'=>'email',
                    'country_id'=>'required',
                    'incentive_type'=>'required',
                    'city_id'=>'required',
                    'code'=>'required'
        ]);


            //............for validate dealer cnic from dnfbp...................//

  if ($request->cnic) {

               $dnfbp_check_point_dealer = DNFBP::where('cnic' , str_replace('-', '', $request->cnic))->first();

                  if ($dnfbp_check_point_dealer == true) 
                {
                    return redirect('/dealer/edit/' . $request->id)
                    ->withInput()
                    ->with([
                        'message' => 'This Dealer cnic is found in list of DNFBP. You cant update this Dealer record.',
                        'alert-type' => 'error',
                    ]);
                }
}
            //.............end...........................................//


        if ($validator->fails()) {
            return redirect('/dealer/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Dealer
       $this->dealer->updateDealer($request);

       activity('Update')->log('Edit Dealer info '. $request->name);

        return redirect()
                        ->route('dealer.all')
                        ->with([
                            'message' => 'Incentive updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific Dealer
    public function deleteDealer($id) {

        $dealer = Dealer::where('id',$id)->first();

        Dealer::where('id', $id)->update(['is_deleted'=>true]);



        activity('Delete')->log('Delete dealer info '. $dealer->name);

        return redirect()->route('dealer.all')->with([
                    'message' => 'Incentive deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    public function getDealerInfo(Request $request) {

        return Dealer::where('id',$request->id)->first();
    }

    public function addDealerPayment() {

        $data['dealers'] = Dealer::where('is_deleted',false)->get();
        $data['banks'] = DepositorBank::all();
        $data['cBanks'] = CompanyBank::all();

        return view('Dealer.dealer_payment',$data);
    }

    public function createDealerPayment(Request $request) {

        $validator = Validator::make($request->all(), [
                    'amount' => 'required|regex:/^[0-9]+$/u',
                    'dealer_id'=>'required',
                    'customer_property_id'=>'required',
                    'payment_mode' => 'required',
                    'date' => 'required',
                    'cheque_number'=>'nullable|regex:/^[a-zA-Z\s0-9]+$/u',
        ]);

        if ($validator->fails()) {
            return redirect('/dealer/payment/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        $result = $this->dealer->createDealerPayment($request);

        if(!$result) {
            return redirect('/dealer/payment/add')
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        $dealer = Dealer::where('id',$result->dealer_id)->first();

        activity('Create')->log('New Dealer Payment Added '. $dealer->name);

        return redirect()
                        ->route('dealer.detail',['id'=>$dealer->id])
                        ->with([
                            'message' => 'Payment added successfully!',
                            'alert-type' => 'info'
        ]);

    }


    public function getDealerProperties(Request $request) {

        $properties = CustomerProperty::where('dealer_id',$request->dealer_id)->with('inventory')->get();

        $receivedAmount = array();
        $lastDate = array();
        $remainingAmount = array();

        foreach($properties as $property) {
            $receivedAmount[$property->id] = Receipt::where('customer_property_id',$property->id)->sum('amount');
             $lastDate[$property->id] = Receipt::where('customer_property_id',$property->id)->orderBy('receipt_date','desc')->first();
            $remainingAmount[$property->id] = $property->net_pay - $receivedAmount[$property->id];

        }

        return view('Dealer.update_property',compact('properties','receivedAmount','lastDate','remainingAmount'));
    }

    public function deleteDealerPayment($id) {

        $dealer = DealerReceivedAmount::where('id',$id)->first();

        DealerReceivedAmount::where('id',$id)->delete();

        activity('Delete')->log('Dealer Received Payment Deleted '. $dealer->amount);

        return redirect()
                        ->route('dealer.detail',['id'=>$dealer->dealer_id])
                        ->with([
                            'message' => 'Payment deleted successfully!',
                            'alert-type' => 'info'
        ]);
    }


    public function dealerTransferForm(Request $request) {

        $data['property_id'] = $request->property_id;

        $data['dealer_id'] = $request->dealer_id;

        $data['dealers'] = Dealer::where([['id','!=',$request->dealer_id]]) ->get();
        $data['rebate'] = DealerTransaction::where([['product_id',$request->property_id],['dealer_id',$request->dealer_id]])->first()->amount;


        return view('Dealer.update-dealer-modal',$data);
    }

    public function transferDealer(Request $request) {


        //update the property dealer
        CustomerProperty::where('id',$request->property_id)->update(['dealer_id'=>$request->new_dealer_id]);

        //update the rebate transaction
        DealerTransaction::where([['product_id',$request->property_id],['dealer_id',$request->dealer_id]])->update(['dealer_id'=>$request->new_dealer_id,'amount'=>$request->rebate]);

        //update the paid rebate record
        DealerPaidRebate::where([['property_id',$request->property_id],['dealer_id',$request->dealer_id]])->update(['dealer_id'=>$request->new_dealer_id]);

        ///Now update the stats of previous dealer

        $total_sale = CustomerProperty::where('dealer_id',$request->dealer_id)->sum('net_pay');

        $total_rebate = DealerTransaction::where('dealer_id',$request->dealer_id)->sum('amount');

        $paid_rebate = DealerPaidRebate::where('dealer_id',$request->dealer_id)->sum('amount');

        Dealer::where('id',$request->dealer_id)->update(['total_sale'=>$total_sale,'total_paid_amount'=>$paid_rebate,'total_rebate'=>$total_rebate]);

        ///Now update the stats of new dealer

        $total_sale = CustomerProperty::where('dealer_id',$request->new_dealer_id)->sum('net_pay');

        $total_rebate = DealerTransaction::where('dealer_id',$request->new_dealer_id)->sum('amount');

        $paid_rebate = DealerPaidRebate::where('dealer_id',$request->new_dealer_id)->sum('amount');

        Dealer::where('id',$request->new_dealer_id)->update(['total_sale'=>$total_sale,'total_paid_amount'=>$paid_rebate,'total_rebate'=>$total_rebate]);

        return redirect()
                        ->back()
                        ->with([
                            'message' => 'Property Dealer Transfer successfully!',
                            'alert-type' => 'info'
        ]);


    }




    public function getDealerPackageDetail($dealer_package_id)
    {
         

     $dealer_package =   DealerPackage::where('id', $dealer_package_id)->first();


       $paid_amount= $dealer_package->dealerPackagePaymentReceipt->where('is_approved', 1)->sum('amount');
 
       
        
      
                 $package_paid_rebate = DealerPaidRebate::where([['dealer_id',$dealer_package->dealer_id],['dealer_package_id',$dealer_package->id],['is_deleted',false]])->sum('amount');
                 
                 
            
         
       
       $sold_inventory = DealerPackage::join('open_file_dealer_infos', 'dealer_packages.id', '=', 'open_file_dealer_infos.dealer_package_id')
        ->join('inventories', 'open_file_dealer_infos.invertory_id', '=', 'inventories.id')
        ->where('inventories.status',Inventory::sold)
        ->where('dealer_packages.id',$dealer_package_id)
        ->get();
        
        return view('Dealer.dealer-package-detail', compact('package_paid_rebate','paid_amount','dealer_package','sold_inventory'));
        
    }


    public function getDealerPackageRebate(Request $request)
    {


        


        $transactions = DealerTransaction::where([['dealer_id',$request->id],['dealer_package_id','!=',null]])->with('dealerPackage')->get();
        $paid_rebate = array();
        $received_amount = array();
        $released_amount = array();
        foreach ($transactions as $t) {
            $released_amount[$t->id] = 0;
            if($t->dealerPackage) {
                $paid_rebate[$t->id] = DealerPaidRebate::where([['dealer_id',$request->id],['dealer_package_id',$t->dealerPackage->id],['is_deleted',false]])->sum('amount');
                $received_amount[$t->id] = DealerPackageReceipt::where([['dealerpackage_id',$t->dealerPackage->id],['is_deleted',false],['is_approved' , 1]])->sum('amount');
                
            }
        }
        $data = [
            'transactions' => $transactions,
            'received_amount' => $received_amount,
            'paid_rebate' => $paid_rebate,
            'released_amount' => $released_amount


        ];
        return response()->json($data);



    }
}
