<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\DealerPaidRebate;
use App\Dealer;
use App\DealerTransaction;
use App\Receipt;
use App\CustomerStatement;
use App\CompanyBank;
use App\ChartOfAccount;
use App\CustomerProperty;
use App\DealerPackage;
use App\DealerPackageReceipt;
use App\DepositorBank;
use App\Traits\MultiProjectCookie;

class DealerPaidRebateController extends Controller {

    use MultiProjectCookie;
    protected $rebate;

    public function __construct() {
        $this->rebate = new DealerPaidRebate();
    }

    //Get All the rebates
    public function allRebates(Request $request) {

        $data =array();
      
        $data =  $this->getCookieInfoAndMultiPro($request);
        if ($data['status'] == 'error') {
            return redirect()
                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($data['project_ids'])) {
            $ids =    $data['project_ids'];
        } else {
            $ids[] =    $data['project_ids'];
        }


        $allRebates = DealerPaidRebate::where('is_deleted',false)
       
        ->whereHas('property', function ($query) use($ids){
            $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            });
        })
        ->with('dealer')->orderBy('created_at', 'desc')->get();
        
        $totalPaidRebate =  DealerPaidRebate::
       whereHas('property', function ($query) use($ids){
            $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            });
        })
        ->sum('amount');

        activity('View')->log('Dealer Rebate List.');

        return view('transaction/rebate.index', compact('allRebates','totalPaidRebate'));
    }


    public function allPackageRebates(Request $request) {
        $data =array();
      
        $data =  $this->getCookieInfoAndMultiPro($request);
        if ($data['status'] == 'error') {
            return redirect()
                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($data['project_ids'])) {
            $ids =    $data['project_ids'];
        } else {
            $ids[] =    $data['project_ids'];
        }


        $allRebates = DealerPaidRebate::where([['is_deleted',false],['dealer_package_id','!=',null]])
        // ->whereHas('dealerPackage')
        ->whereHas('dealerPackage', function ($query) use($ids){
            $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            });
        })
        ->with('dealer')->orderBy('created_at', 'desc')->get();
        
        $totalPaidRebate =  DealerPaidRebate::where([['is_deleted',false],['dealer_package_id','!=',null]])
        ->whereHas('dealerPackage', function ($query) use($ids){
            $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            });
        })
        ->sum('amount');

        activity('View')->log('Dealer Package Rebate List.');

        return view('transaction/package_rebate.index', compact('allRebates','totalPaidRebate'));
    }

    //show the add new rebate  form
    public function addRebateForm() {

       
        $banks = DepositorBank::orderBy('name', 'ASC')->get();
        $cBanks = CompanyBank::all();

        $data['banks'] = $banks;
        $data['cBanks'] = $cBanks;
        $data['dealers'] = Dealer::where('status', true)->orderBy('name', 'asc')
            ->get();
        $data['accounts'] = ChartOfAccount::orderBy('number', 'ASC')->get();

        return view('transaction/rebate.add-rebate', $data);
    }
    public function addPackageRebateForm() {

       
        $banks = DepositorBank::orderBy('name', 'ASC')->get();
        $cBanks = CompanyBank::all();

        $data['banks'] = $banks;
        $data['cBanks'] = $cBanks;
        $data['dealers'] = Dealer::where('status', true)->orderBy('name', 'asc')
            ->get();
        $data['accounts'] = ChartOfAccount::orderBy('number', 'ASC')->get();

        return view('transaction/package_rebate.add-rebate', $data);
    }
    
    public function updateDealerAmount(Request $request) {
        
        $data =array();
      
        $data =  $this->getCookieInfoAndMultiPro($request);
        if ($data['status'] == 'error') {
            return redirect()
                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($data['project_ids'])) {
            $ids =    $data['project_ids'];
        } else {
            $ids[] =    $data['project_ids'];
        }


    $dealer = Dealer::where('id',$request->dealer_id)->first();

    $transactions = DealerTransaction::where('dealer_id',$request->dealer_id)
    ->when($ids[0] !== 'all', function ($query) use ($ids) {
        $query->whereHas('property', function ($q) use ($ids) {
            $q->whereIn('multi_project_id', $ids);
        });
    })
    ->with('property')->get();

    $paid_rebate = array();
    $received_amount = array();
    $released_amount = array();

    foreach ($transactions as $t) 
    {
        $released_amount[$t->id] = 0;
        if($t->property && $t->property->status != CustomerProperty::cancel) 
        {
            $paid_rebate[$t->id] = DealerPaidRebate::where([['property_id',$t->property->id],['is_deleted',false],['dealer_id',$dealer->id]])->sum('amount');
            $received_amount[$t->id] = Receipt::where([['customer_property_id',$t->property->id],['is_deleted',false]])->sum('amount');
        }
    }

        
        return view('transaction/rebate.update-amount',compact('dealer','transactions','paid_rebate','received_amount','released_amount'));
    }


    public function updateDealerPackageAmount(Request $request) {
        
        $data =array();
      
        $data =  $this->getCookieInfoAndMultiPro($request);
        if ($data['status'] == 'error') {
            return redirect()
                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($data['project_ids'])) {
            $ids =    $data['project_ids'];
        } else {
            $ids[] =    $data['project_ids'];
        }


        $dealer = Dealer::where('id',$request->dealer_id)->first();
    
        $transactions = DealerTransaction::where([['dealer_id',$request->dealer_id],['dealer_package_id','!=',null]])
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereHas('dealerPackage', function ($q) use ($ids) {
                $q->whereIn('multi_project_id', $ids);
            });
        })
        ->with('dealerPackage')->get();

        
        $paid_rebate = array();
        $received_amount = array();
        $released_amount = array();
    
        foreach ($transactions as $t) 
        {
            $released_amount[$t->id] = 0;
            if($t->dealerPackage && $t->dealerPackage->payment_status == DealerPackage::completed) 
            {
                $paid_rebate[$t->id] = DealerPaidRebate::where([['dealer_package_id',$t->dealerPackage->id],['is_deleted',false],['dealer_id',$dealer->id]])->sum('amount');
                $received_amount[$t->id] = DealerPackageReceipt::where([['dealerpackage_id',$t->dealerPackage->id],['is_deleted',false],['dealer_id',$dealer->id]])->sum('amount');
            }
        }
    
            
            return view('transaction/package_rebate.update-amount',compact('dealer','transactions','paid_rebate','received_amount','released_amount'));
        }

      //insert new rebate record
    public function insertRebate(Request $request)
    { 

        $messages = [
            'bank_name.required_if' => 'Depositor Bank Name is required',
            'company_account.required_if' => 'Company Account is required',
            'cheque_number.required_if' => 'Cheque Number is required.', 
            'drawn_date' => 'Drawn Date is required',
            'dealer_adjustment_unit_id' => 'Dealer Payable Rebates is required'
        ];

        $validator = Validator::make($request->all() , [
            'dealer_id' => 'required', 
            'date' => 'required', 
            'amount' => 'required|numeric|min:1', 
            'property_id' => 'required',
            'bank_name' => 'nullable|required_if:payment_method,2,3',
            'company_account' => 'nullable|required_if:payment_method,2,3',
            'drawn_date' => 'nullable|required_if:payment_method,3',
            'cheque_number' => 'nullable|required_if:payment_method,3|regex:/^[a-zA-Z\s0-9]+$/u'
        ], $messages);

        if ($validator->fails())
        {
            return redirect('/dealer-rebate/add')
                ->withErrors($validator)->withInput()
                ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error', ]);
        }

         if($request->w_h_tax == 1){
            $rebate = DealerPaidRebate::create([
                'dealer_id' => $request->dealer_id, 
                'property_id' => $request->property_id, 
                'amount' => $request->amount, 
                'date' => $request->date, 
                'account_id' => $request->account_id, 
                'description' => $request->notes, 
                'payment_method' => $request->payment_method,
                'bank_name' => $request->bank_name,
                'company_account' => $request->company_account,
                'drawn_date' => $request->drawn_date,
                'cheque_number' => $request->cheque_number,
                'tax_amount' => $request->tax_amount
            ]);
         }
         else{
            $rebate = DealerPaidRebate::create([
                'dealer_id' => $request->dealer_id, 
                'property_id' => $request->property_id, 
                'amount' => $request->amount, 
                'date' => $request->date, 
                'account_id' => $request->account_id, 
                'description' => $request->notes, 
                'payment_method' => $request->payment_method,
                'bank_name' => $request->bank_name,
                'company_account' => $request->company_account,
                'drawn_date' => $request->drawn_date,
                'cheque_number' => $request->cheque_number,
                
            ]);
         }
        //create new rebate
     

        $dealer = Dealer::where('id', $request->dealer_id)
            ->first();

        Dealer::where('id', $request->dealer_id)
            ->update(['total_paid_amount' => $dealer->total_paid_amount + $rebate->amount]);

        //$property = CustomerProperty::find($request->property_id);
        

        activity('Create')
            ->log('Dealer Rebate Paid ' . $dealer->name);

        return redirect()
            ->route('rebate.detail', ['id' => $rebate
            ->id])
            ->with(['message' => 'Rebate paid successfully!', 'alert-type' => 'info']);
    }

    public function insertPackageRebate(Request $request)
    {

        
        $messages = [
            'bank_name.required_if' => 'Depositor Bank Name is required',
            'company_account.required_if' => 'Company Account is required',
            'cheque_number.required_if' => 'Cheque Number is required.', 
            'drawn_date' => 'Drawn Date is required',
            'dealer_adjustment_unit_id' => 'Dealer Payable Rebates is required'
        ];

        $validator = Validator::make($request->all() , [
            'dealer_id' => 'required', 
            'date' => 'required', 
            'amount' => 'required|numeric|min:1', 
            'dealerpackage_id' => 'required',
            'bank_name' => 'nullable|required_if:payment_method,2,3',
            'company_account' => 'nullable|required_if:payment_method,2,3',
            'drawn_date' => 'nullable|required_if:payment_method,3',
            'cheque_number' => 'nullable|required_if:payment_method,3|regex:/^[a-zA-Z\s0-9]+$/u'
        ], $messages);

        if ($validator->fails())
        {
            return redirect('/dealer-package-rebate/add')
                ->withErrors($validator)->withInput()
                ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error', ]);
        }

        if ($request->w_h_tax == '1') {
            //create new rebate
            $rebate = DealerPaidRebate::create([
                'dealer_id' => $request->dealer_id,

                'amount' => $request->amount,
                'date' => $request->date,
                'account_id' => $request->account_id,
                'description' => $request->notes,
                'payment_method' => $request->payment_method,
                'bank_name' => $request->bank_name,
                'company_account' => $request->company_account,
                'drawn_date' => $request->drawn_date,
                'cheque_number' => $request->cheque_number,
                'tax_amount' => $request->tax_amount,
                'dealer_package_id' => $request->dealerpackage_id
            ]);
        } else {
            $rebate = DealerPaidRebate::create([
                'dealer_id' => $request->dealer_id,

                'amount' => $request->amount,
                'date' => $request->date,
                'account_id' => $request->account_id,
                'description' => $request->notes,
                'payment_method' => $request->payment_method,
                'bank_name' => $request->bank_name,
                'company_account' => $request->company_account,
                'drawn_date' => $request->drawn_date,
                'cheque_number' => $request->cheque_number,
               
                'dealer_package_id' => $request->dealerpackage_id
            ]);
        }

        $dealer = Dealer::where('id', $request->dealer_id)
            ->first();

        Dealer::where('id', $request->dealer_id)
            ->update(['total_paid_amount' => $dealer->total_paid_amount + $rebate->amount]);

        //$property = CustomerProperty::find($request->property_id);
        

        activity('Create')
            ->log('Dealer Package Rebate Paid ' . $dealer->name);

        return redirect()
            ->route('rebate.package.detail', ['id' => $rebate
            ->id])
            ->with(['message' => 'Rebate paid successfully!', 'alert-type' => 'info']);
    }
    

    //show the edit rebate form
    public function editRebateForm($id) {

        $rebate = DealerPaidRebate::with('dealer')->where('id', $id)->first();
        
        $dealers = Dealer::where('status',true)->orderBy('name','asc')->get();

        return view('transaction/rebate.edit-rebate', compact('rebate','dealers'));
    }

    //update the Rebate record
    public function updateRebate(Request $request) {

        $validator = Validator::make($request->all(), [
                    'dealer_id' =>'required',
                    'date'=>'required',
                    'amount'=>'required|numeric|min:1',
                    
        ]);

        if ($validator->fails()) {
            return redirect('/dealer-rebate/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }
        $rebate = DealerPaidRebate::where('id',$request->id)->first();

        //update Purchase
       // DealerPaidRebate::where('id',$request->id)->update(Input::except('_token'));

        DealerPaidRebate::where('id',$request->id)->update(['dealer_id'=>$request->dealer_id,'property_id'=>$request->property_id,'amount'=>$request->amount,'date'=>$request->date,'account_id'=>$request->account_id,'description'=>$request->description,'payment_method'=>$request->payment_method]);
        
        $dealer = Dealer::where('id',$request->dealer_id)->first();
        
        Dealer::where('id',$request->dealer_id)->update(['total_paid_amount'=>$dealer->total_paid_amount - $rebate->amount]);
  
        $dealer = Dealer::where('id',$request->dealer_id)->first();
         
        Dealer::where('id',$request->dealer_id)->update(['total_paid_amount'=>$dealer->total_paid_amount + $request->amount]);

        activity('Update')->log('Edit Dealer Rebate Paid '. $dealer->name);

        return redirect()
                        ->route('rebate.all')
                        ->with([
                            'message' => 'Rebate updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific rebate
    public function deleteRebate($id) {

         $rebate = DealerPaidRebate::where('id',$id)->first();
        
         $dealer = Dealer::where('id',$rebate->dealer_id)->first();
         
        // Dealer::where('id',$rebate->dealer_id)->update(['total_paid_amount'=>$dealer->total_paid_amount - $rebate->amount]);

        // DealerPaidRebate::where('id', $id)->delete();

        DealerPaidRebate::where('id',$id)->update(['is_deleted'=>true]);

        activity('Delete')->log('Delete Dealer Rebate '. $dealer->name);

        return redirect()->route('rebate.all')->with([
                    'message' => 'Rebate deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    //show the dealer rebate receipt
    public function detailRebate($id) {

         $cBanks = CompanyBank::all();
        $banks = DepositorBank::orderBy('name', 'ASC')->get();
        
        $rebate = DealerPaidRebate::with('dealer')->where('id', $id)->first();
        return view('Dealer/dealer-receipt', compact('cBanks', 'banks', 'rebate'));
    }
    public function detailPackageRebate($id) {

        $cBanks = CompanyBank::all();
       $banks = DepositorBank::orderBy('name', 'ASC')->get();
       
       $rebate = DealerPaidRebate::with('dealer')->where('id', $id)->first();
       return view('transaction/package_rebate.dealer-receipt', compact('cBanks', 'banks', 'rebate'));
   }
}
