<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\DealerType;

class DealerTypeController extends Controller {

    protected $dealerType;

    public function __construct() {
        $this->dealerType = new DealerType();
    }

    //Get All the Dealer Type
    public function allDealerTypes() {

        $allDealerTypes = DealerType::orderBy('created_at', 'desc')->get();

        return view('Setting/dealerType.index', compact('allDealerTypes'));
    }

    //show the add new DealerType  form
    public function addDealerTypeForm() {

        return view('Setting/dealerType.add-type');
    }

    //insert new DealerType record
    public function insertDealerType(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|unique:dealer_types,name',
                    'status' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/dealer-type/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new DealerType
        $input=$request->all();
        DealerType::create($input);

        return redirect()
                        ->route('dealer.type.all')
                        ->with([
                            'message' => 'DealerType created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the DealerType
    public function detailDealerType($id) {

        $type = DealerType::where('id', $id)->first();

        return view('Setting/dealerType.detail-type', compact('type'));
    }

    //show the edit  DealerType form
    public function editDealerTypeForm($id) {

        $type = DealerType::where('id', $id)->first();

        return view('Setting/dealerType.edit-type', compact('type'));
    }

    //update the DealerType record
    public function updateDealerType(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required',
                    'status' => 'required',

        ]);

        if ($validator->fails()) {
            return redirect('/dealer-type/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update DealerType
        DealerType::where('id',$request->id)->update(['name'=>$request->name,'status'=>$request->status]);

        return redirect()
                        ->route('dealer.type.all')
                        ->with([
                            'message' => 'DealerType updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific DealerType
    public function deleteDealerType($id) {

        DealerType::where('id', $id)->delete();

        return redirect()->route('dealer.type.all')->with([
                    'message' => 'DealerType deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
