<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Validator;
use App\Department;
use DB;
use Session;
use App\PurchaseRequest;
use Illuminate\Validation\Rule;
use Carbon\Carbon;
use App\PurchaseOrder;
use App\Role;
use App\DepartmentRole;
use Illuminate\Support\Facades\Auth;
use App\User;
class DepartmentController extends Controller
{
   
    public function __construct()
{
           
}

function index()
{
      $DepartmentList = Department::orderBy('id', 'DESC')->get();
      
      return view('procurement/department.index' ,compact('DepartmentList') );
}


function create()
{
    
      $roles = Role::orderBy('id', 'DESC')->get();

      return view('procurement/department.addDepartment' ,compact('roles') );
}


function store(Request $request)
{

$validator = Validator::make($request->all(), [
                    'name' => 'required|unique:departments,department_name',
                    'role_name' => 'required',
        ]);


       if ($validator->fails()) {
            return redirect('/departments/add-department')
                            ->withErrors($validator)
                            ->withInput();
        }

DB::beginTransaction();

   try {

         $department = Department::create([
                    'department_name' => $request->name,
                     'role_id' => $request->role_name
                     
          ]);

         
        
           DB::commit();
           return redirect()->route('department.list')->with('success' , 'Department Added Successfully!');
      

      } 
        catch (\Exception $e) 
      {
       DB::rollback();
      return redirect()->route('department.list')->with('success' , 'Something went wrong.');
      }

}

function destroy($id)
{
  
    if(is_numeric($id))
    {
         Department::where('id',$id)->delete();
    }
 
  return redirect()->route('department.list')->with('success' , 'Department Removed Successfully!');
}

function edit($id)
{
 
   if(is_numeric($id))
    {
          $finddepartment = Department::where('id', $id)->first();
          $roles = Role::orderBy('id', 'DESC')->get();
           return view('procurement/department.editDepartment' ,compact('finddepartment' , 'roles') );
    }

}

function update(Request $request)
{

 $id = $request->input('id');
 if(is_numeric($id))
 {
  $validator = Validator::make($request->all(), [
                    'name' => 'required|unique:departments,department_name,'.$id,
                    'role_name' => 'required',

        ]);


       if ($validator->fails()) {
            return redirect('/departments/edit-department/'.$id)
                            ->withErrors($validator)
                            ->withInput();
        }

 



  DB::beginTransaction();

        try {


           Department::where('id', '=', $id)->update(
            array( 'department_name' => $request->name , 'role_id' => $request->role_name));

         DB::commit();
   
      } 
        catch (\Exception $e) 
      {
        DB::rollback();
      }

}

  return redirect()->route('department.list')->with('success' , 'Department Updated Successfully!');
}


public function dashboard($department_id = null)
{

 $total_purchase = 0;
 $total_pay_purchase = 0;
 $total_monthly_purchase = 0;
 $user = User::with('role')->find(Auth::user()->id);
 $role_id = $user->role->role_id; 
 
  //........................Sum of Total Purchase........................


    PurchaseRequest::where('department_id', $department_id )->each(function($p, $k) use (&$total_purchase , &$total_pay_purchase , &$total_monthly_purchase) 
    {
    $total_purchase += $p->receipts()->sum('total_amount');
    $total_pay_purchase += $p->receipts()->sum('total_pay_amount');
    $total_monthly_purchase += $p->receipts()->whereYear('receipt_date', Carbon::now()->year)->whereMonth('receipt_date', Carbon::now()->month)
    ->sum('total_amount');
    });

  //........................GET  PRs.................................

        $purchase_requests = PurchaseRequest::withAndWhereHas('approvalStatus', function($query) use ($role_id)
        {
        $query->where('role_id',$role_id);
        $query->where('approvel_status', 0);
        })
        ->orderBy('id', 'DESC')->get();


        //........................GET  Latest Five Pr's.........................

        $data['purchase_request_latest'] = PurchaseRequest::where('department_id', $department_id )->take(5)
        ->orderBy('id', 'DESC')
        ->get();

        $data['total_purchase_orders']   = PurchaseRequest::withAndWhereHas('PurchaseOrders', function($query) 
        {
        $query->where('status', '>' , 0);
        })
        ->where('department_id' , $department_id)
        ->get();

        $data['total_purchase_orders'] = json_decode(json_encode($data['total_purchase_orders'] ));



  return view('procurement/department.dashboard' ,compact('department_id' , 'total_purchase' , 'total_pay_purchase' , 'total_monthly_purchase' , 'purchase_requests', 'data' , 'role_id') );
}

}