<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\Designation;

class DesignationController extends Controller {

    protected $designation;

    public function __construct() {
        $this->designation = new Designation();
    }

    //Get All the Designation
    public function allDesignations() {

        $allDesignations = Designation::orderBy('created_at', 'desc')->get();

        return view('Setting/designation.index', compact('allDesignations'));
    }

    //show the add new Designation  form
    public function addDesignationForm() {

        return view('Setting/designation.add-designation');
    }

    //insert new Designation record
    public function insertDesignation(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'status' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/designation/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new Designation
        //Designation::create(Input::all());
        $input=$request->all();
        Designation::create($input);

        return redirect()
                        ->route('designation.all')
                        ->with([
                            'message' => 'Designation created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the Designation
    public function detailDesignation($id) {

        $designation = Designation::where('id', $id)->first();

        return view('Setting/designation.detail-designation', compact('designation'));
    }

    //show the edit Designation form
    public function editDesignationForm($id) {

        $designation = Designation::where('id', $id)->first();

        return view('Setting/designation.edit-designation', compact('designation'));
    }

    //update the Designation record
    public function updateDesignation(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'status' => 'required',
                    
        ]);

        if ($validator->fails()) {
            return redirect('/designation/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Designation
        Designation::where('id',$request->id)->update(['name'=>$request->name,'status'=>$request->status]);

        return redirect()
                        ->route('designation.all')
                        ->with([
                            'message' => 'Designation updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific Designation
    public function deleteDesignation($id) {

        Designation::where('id', $id)->delete();

        return redirect()->route('designation.all')->with([
                    'message' => 'Designation deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
