<?php

namespace App\Http\Controllers;

use App\DirectBallotingMapDetail;
use Illuminate\Http\Request;
use App\DirectBallotingMapFile;
use App\Imports\ImportDirectMapFileData;
use App\Rules\DirectExcelMapFileRule;
use Maatwebsite\Excel\Facades\Excel;

class DirectBallotingController extends Controller
{
    
    public function directBalloting()
    {
        $balloting_files = DirectBallotingMapFile::get();
        return view('balloting.direct.index', compact('balloting_files'));
       
    }
    public function  directSettingAddFile()
    {


        return view('balloting.direct.add');
    }
    public function downloadDirectBallotingFormate()
    {
        $filename =  'directexample.xlsx';
        $path = 'excel/' . 'directexample.xlsx';

        return response()->download(storage_path('app/' . $path), $filename, [
            'Content-Type' => 'application/vnd.ms-excel',
        ]);
    }
    public function storeDirectMapFile(Request $request)
    {


        $this->validate($request, [

            'name' => 'required',
            'description' => 'nullable|min:3|max:1000',
            'mapfile' => ['required', 'file', new DirectExcelMapFileRule],
        ]);

        $file = $request->file('mapfile');

        $filename = time() . '_' . $file->getClientOriginalName();

        // $path = $file->storeAs('excel', $filename, 'public');
        $path = $file->storeAs('excel', $filename, 'local');

        $balloting_file = new DirectBallotingMapFile;
        $balloting_file->name = $request->name;
        $balloting_file->description = $request->description;
        $balloting_file->status = 0;
        $balloting_file->path = $path;
        $balloting_file->file_name = $filename;
        $balloting_file->save();
        return redirect()
            ->route('balloting.direct.index')
            ->with([
                'message' => 'Data Added Successfully!',
                'alert-type' => 'success'
            ]);
    }
    public function directBallotingPublishMap($id)
    {
        $balloting_file = DirectBallotingMapFile::where('id', $id)->first();
        
        return view('balloting.direct.publish', compact('balloting_file'));
    }
    public function importDirectBallotingMapFileData(Request $request)
    {
          try {
            $balloting_file = DirectBallotingMapFile::where('id', $request->map_id)->first();


            $data = Excel::toArray([], storage_path('app/' . $balloting_file->path))[0];
            $total_row = sizeof($data);
            $path = storage_path('app/' . $balloting_file->path);
           
            Excel::import(new ImportDirectMapFileData($balloting_file->id, $total_row), storage_path('app/' . $balloting_file->path));

            $balloting_file = DirectBallotingMapFile::where('id', $request->map_id)->first();

            $balloting_file->publish = 1;
            $balloting_file->save();
           
            session(['progress' => 100]);
            return response()->json([
                'success' => true,
                'message' => 'Data Published Successfully'
            ]);
        } catch (\Exception $e) {

            return response()->json([
                'error' => true,
                'message' => 'Something went wrong'
            ], 500);
        }
    }
    public function viewMapFile($id)
    {
        $file =    DirectBallotingMapFile::where('id', $id)->first();
        $filename =  $file->file_name;
        $path = 'excel/' . $filename;
        $data = Excel::toArray([], storage_path('app/' . $path))[0];
        return view('balloting.setting.view', compact('data'));
    }
    public function startBalloting($id)
    {
    
        $balloting_file =    DirectBallotingMapFile::where('id', $id)->first();
    
        return view('balloting.direct.start', compact('balloting_file'));
    }
    public function startBallotingMap(Request $request)
    {
         
        
        
        $b = new DirectBallotingMapDetail;
        $val = $b->startBallotingInventory($request);
        if ($val['status'] == true) {
            return response()->json([
                'success' => true,
                'message' => 'Data Published Successfully',
                'id' => $val['id']
            ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'SomeThing went wrong'
            ]);
        }
    }
    public function  publishMapInventory($id)
    {
        $balloting_file = DirectBallotingMapFile::where('id', $id)->first();
        
        return view('balloting.direct.view', compact('balloting_file'));
    }
    public function downloadFileFormate2($id)
    {
        $file =    DirectBallotingMapFile::where('id', $id)->first();
        $filename =  $file->file_name;
        $path = 'excel/' . $filename;

        return response()->download(storage_path('app/' . $path), $filename, [
            'Content-Type' => 'application/vnd.ms-excel',
        ]);
    }

    //
}
