<?php

namespace App\Http\Controllers;

use App\Customer;
use App\EmailLog;
use App\EmailSms;
use App\EmailSmsType;
use App\SmtpSetting;
use Illuminate\Http\Request;

class EmailLogController extends Controller
{
    //
    protected $email_log;

    public function __construct()
    {

        $this->email_log = new EmailLog();
    }
    public function index()
    {
      $email_sms_type=  EmailSmsType::all();
     $customer_email= Customer::where('email','!=',null)->get();
       $email_log= EmailLog::paginate(25);
        return view('Setting.emailLog.index',compact('email_log','email_sms_type','customer_email'));

    }

    public function resendMail(Request $request){

       
       
      $email_log=  EmailLog::where('id',$request->value)->first();
      
          
                    $smtp = SmtpSetting::where('status', 1)->first();
                   
                    $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
                        ->setUsername($smtp->smtp_username)
                        ->setPassword($smtp->smtp_password);
                    $mailer = new \Swift_Mailer($transport);
               $class_name=     str_replace('new ', '', $email_log->mailable_class);
                    $mailable_class = 'App\Mail\\' .   $class_name;
                    
                    $email = (new $mailable_class($email_log->content,$email_log->project_name))
                        ->subject($email_log->title)
                        ->from($smtp->from_email, $smtp->from_name)
                        ->to($email_log->receiver_email)
                        ->view($email_log->mail_view);



                   
                    $email_message = $email->render();
                    $swiftMessage = (new \Swift_Message())
                        ->setSubject($email_log->title)
                        ->setFrom($smtp->from_email, $smtp->from_name)
                        ->setTo($email_log->receiver_email)
                        ->setBody($email_message, 'text/html');
                    $response = $mailer->send($swiftMessage);

                    
                   
                    if ($response) {

                        $email_log->status = 1;
                        $email_log->save();
                        return redirect()
                        ->back()
                        ->with([
                            'message' => 'Email Send Successfully!',
                            'alert-type' => 'success'
                        ]);
                    } else {
                        $email_log->status = 0;
                        $email_log->save();
                        return redirect()
                        ->back()
                        ->with([
                            'message' => 'Unable To send email!',
                            'alert-type' => 'error'
                        ]);
                    }
                   
                    return redirect()
                    ->back()
                    ->with([
                        'message' => 'SomeThing went wrong!',
                        'alert-type' => 'error'
                    ]);

                   
                    
               
          

    }
    public function updateTable(Request $request)
    {  
        $filters = array();
        if ($request->title != 0)
            $filters['title'] = $request->title;
        if ($request->email != 0)
            $filters['email'] = $request->email;
        if ($request->status != 0)
            $filters['status'] = $request->status;
       
       $data = $this->email_log->updateTable($filters);
       return view('Setting.emailLog.update-table', $data);
    }
}
