<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\ExpenseCategory;
use App\Expense;
use App\ExpensePayment;

class ExpenseCategoryController extends Controller {


    //Get All the Expense Category
    public function allExpenseCategories() {

        $data['allExpenseCategories'] = ExpenseCategory::orderBy('created_at', 'desc')->get();

        $billAmount = array();
        $paidAmount = array();

        foreach($data['allExpenseCategories'] as $c) {
            $billAmount[$c->id] = Expense::where('category_id',$c->id)->sum('amount');
            $catId = $c->id;
            $paidAmount[$c->id] = ExpensePayment::whereHas('bill',function($query) use($catId) {
                $query->where('category_id',$catId);
            })->sum('amount');

        }

        $data['billAmount'] = $billAmount;
        $data['paidAmount'] = $paidAmount;


        return view('expense/category.index', $data);
    }

    //show the add new Category  form
    public function addExpenseCategoryForm() {

        return view('expense/category.add-category');
    }

    //insert new Category record
    public function insertExpenseCategory(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'status' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/expense-category/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new Category
        //ExpenseCategory::create(Input::all());
        $input=$request->all();
        ExpenseCategory::create($input);

        return redirect()
                        ->route('expense.category.all')
                        ->with([
                            'message' => 'Category created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the edit Category form
    public function editExpenseCategoryForm($id) {

        $expenseCategory = ExpenseCategory::where('id', $id)->first();

        return view('expense/category.edit-category', compact('expenseCategory'));
    }

    //update the Category
    public function updateExpenseCategory(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'status' => 'required',
                    
        ]);

        if ($validator->fails()) {
            return redirect('/expense-category/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Category
        ExpenseCategory::where('id',$request->id)->update(['name'=>$request->name,'status'=>$request->status]);

        return redirect()
                        ->route('expense.category.all')
                        ->with([
                            'message' => 'Category updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific Category
    public function deleteExpenseCategory($id) {

        ExpenseCategory::where('id', $id)->delete();

        return redirect()->route('expense.category.all')->with([
                    'message' => 'Category deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
