<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\FixedAssetType;
use Illuminate\Support\Facades\Validator;
use  DB;

class FixedAssetTypeController extends Controller
{
         public function __construct()
    {
               
    }

      function index()
    {
       $fixed_asset_types = FixedAssetType::orderBy('id', 'DESC')->get();
      
      return view('procurement/fixed-asset-type.index' ,compact('fixed_asset_types') );
    }

    
    function create()
    {
        return view('procurement/fixed-asset-type.create' );
    }

    function insert(Request $request)
    {
        $validator = Validator::make($request->all(), [
                        'name' => 'required|unique:fixed_asset_types,name',
                        'depreciation_policy' => 'required',
                        'depreciation_rate' => 'required',
            ]);


           if ($validator->fails()) {
                return redirect('/fixed-assets/create')
                                ->withErrors($validator)
                                ->withInput();
            }

        DB::beginTransaction();

        try {

             $department = FixedAssetType::create([
                        'name' => $request->name,
                        'depreciation_policy' => $request->depreciation_policy,
                        'depreciation_rate' => $request->depreciation_rate,
              ]);

             
               DB::commit();
               return redirect()->route('fixed.asset.type')->with('success' , 'Asset type  Added Successfully!');
          

          } 
            catch (\Exception $e) 
          {
           DB::rollback();
          return redirect()->route('fixed.asset.type')->with('success' , 'Something went wrong.');
          }
    }

    public function destroy($id)
    {
        if(is_numeric($id))
        {
          FixedAssetType::where('id',$id)->delete();
        }

        return redirect()->route('fixed.asset.type')->with('success' , 'Asset Type Removed Successfully!');
    }


    function edit($id)
{
   if(is_numeric($id))
    {
          $fixed_asset_type = FixedAssetType::where('id', $id)->first();
           return view('procurement/fixed-asset-type.edit' ,compact('fixed_asset_type') );
    }
}

public function update(Request $request) 
{

 $id = $request->input('id');
 
 if(is_numeric($id))
 {
        $validator = Validator::make($request->all(), [
                    'name' => 'required|unique:fixed_asset_types,name,'.$id,
                    'depreciation_policy' => 'required',
                    'depreciation_rate' => 'required',
        ]);

       if ($validator->fails()) {
            return redirect('/fixed-assets/edit/'.$id)
                            ->withErrors($validator)
                            ->withInput();
        }

       DB::beginTransaction();

        try {

        FixedAssetType::where('id', '=', $id)->update(
        array( 'name' => $request->name , 'depreciation_policy' => $request->depreciation_policy,
                    'depreciation_rate' => $request->depreciation_rate ));

        DB::commit();

        return redirect()->route('fixed.asset.type')->with('success' , 'Asste Type Updated Successfully!');
   
      } 
        catch (\Exception $e) 
      {
        DB::rollback();
          return redirect()->route('fixed.asset.type')->with('success' , 'Asset Type Not Updated!');
      }
}

}


}
