<?php

namespace App\Http\Controllers;

use DB;
use Auth;
use App\Vendor;
use App\Expense;
use App\Receipt;
use App\Voucher;
use App\Customer;
use Carbon\Carbon;
use App\HrmEmployee;
use App\CompanyBank;
use App\AccountClass;
use App\CancelOpenFile;
use App\CancelProperty;
use App\ChartOfAccount;
use App\ControlAccount;
use App\ExpensePayment;
use App\PurchaseRequest;
use App\CustomerProperty;
use App\CustomerRefundUnitReceipt;
use App\DealerPaidRebate;
use App\DealerTransaction;
use App\GeneralJournalEntry;
use Illuminate\Http\Request;
use App\PurchaseOrderReceipt;
use App\PurchaseRequestVendor;
use App\HrmEmployeeMonthlyEarningDeduction;
use App\FixedAssetAccount;
use App\HrmEmployeeBenevolentFound;
use App\HrmEmployeeLoanAdjusment;
use App\HrmEmployeeLoan;
use App\SchedulePlan;
use App\TaxReceipt;
use  App\VendorCertificate;
use App\DealerPackagePaidAmount;
use App\DealerPackageReceipt;
use App\DealerRefundOpenFileUnitReceipt;
use App\MultiProject;
use Illuminate\Support\Facades\Validator;
 
use App\ProjectType;
use App\CustomerCancelUnitReceipt;
use App\DealerOpenFileCancelReceipt;

class GeneralJournalEntryController extends Controller
{



    public function getAllEntries(Request $request)
    {

$data=        $this->getCookieInfoAndMultiPro($request);

if($data['status'] == 'error'){
    return redirect()

    ->back()
    ->with([
        'message' => 'Invalid Inputs!',
        'alert-type' => 'error',
    ]);

}
$id=[];
if(is_array($data['project_ids'])){
    $id=    $data['project_ids'];
   }
   else
   {
    $id[]=    $data['project_ids'];
   }
 

        // if($request->has('multipro_id')){
           
        //     $id= $request->multipro_id;
            
        // }
        //   $data['multi_projects'] = MultiProject::all();
        //   dd(  $data['multi_projects']);
       
        $data['allEntries'] = GeneralJournalEntry::with('voucher','receipt')
        ->when($id[0] !== 'all', function ($query) use ($id) {
             $query->whereIn('multi_project_id', $id);
                            })
        ->orderBy('entry_no', 'DESC')->groupBy('entry_no')->paginate(30);
        $data['accounts'] = ChartOfAccount::orderBy('number', 'ASC')->get();
        $data['customers'] = Customer::orderBy('name', 'ASC')->get();
        $data['vendors'] = Vendor::orderBy('name', 'ASC')->get();

        $data['classes'] = AccountClass::all();

        $last_entry = GeneralJournalEntry::orderBy('entry_no', 'DESC')
        ->when($id[0] !== 'all', function ($query) use ($id) {
             $query->whereIn('multi_project_id', $id);
                            })
        ->first();

        if ($last_entry)
            $data['latest_entry_no'] = ++$last_entry->entry_no;
        else
            $data['latest_entry_no'] = 1;

        $totalAmount = array();

        foreach ($data['allEntries'] as $entries) {
            $totalAmount[$entries->entry_no] = GeneralJournalEntry::where([['entry_no', $entries->entry_no], ['amount', '>', 0]])
            ->when($id[0] !== 'all', function ($query) use ($id) {
                 $query->whereIn('multi_project_id', $id);
                                })
            ->sum('amount');
        }

        $data['totalAmount'] = $totalAmount;


       
        if(isset($data['multipro_id'])){
           
            return view('general-entry.index-update', $data);
        }
        else{
            
            return view('general-entry.index', $data);
        }
    }
    public function getCookieInfoAndMultiPro($request=null){
        $data =  array();
        try{
           
            if($request != null){
                    if($request->has('multipro_id')){
                
                if($request->multipro_id == 'all'){
                    $data['multipro_id'] =$request->multipro_id;
                }else if(!empty($request->multipro_id)){
                $data['multipro_id'] =  decrypt($request->multipro_id);
                }
            }
        }
            
            
            $project_id = request()->cookie('current_project_id');
           
            $user = Auth::user();
            $data['multi_projects'] = [];
            if (!empty($project_id)) {
                $p_id = decrypt($project_id);
                $multi = MultiProject::where('id', $p_id)->first();
                $multiProjectId = $multi->id;
                if ($multi->name == "Super Admin") {

                    $roles = $user
                        ->roles()
                        ->where('name', 'like', 'admin')
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->first();
                    if (!empty($roles)) {
                        $data['multi_projects']  = MultiProject::where('name', 'NOT like', 'Super Admin')->get();
                        $data['project'] = $multi->name;
                        $data['role'] = 'admin';
                        $data['project_ids'] =  'all';
                        if(isset( $data['multipro_id'])){
                            $data['project_ids'] = $data['multipro_id'];
                            
                        }
                        $data['status'] = 'success';
                        return  $data;
                        
    
                    } else {
                        // $request = app(Request::class);
               
                    $permission=decrypt($request->permission);
                    // dd($permission);
                    
                    $project_ids=       $user->roles()
                    // ->where('name', 'NOT like', 'admin')
                   ->whereHas('projects', function ($query)   {
                   $query->where('name', 'NOT like', 'Super Admin');
                   })
                   ->get()
                   ->filter(function ($r) use ($permission) {
                   return $r->hasPermission($permission);
                   })
                   ->pluck('projects.*.id') // Pluck the 'id' column from the remaining 'projects' models
                   ->flatten() // Flatten the collection of IDs into a single array
                   ->unique()
                   ->toArray()
                   ;
                //    dd( $project_ids);
                   if(sizeof($project_ids) == 0)
                   {
                       $data['status'] = 'error';
                       return  $data; 
                   }
                         
                        $data['multi_projects'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get();
                        $data['project'] = $multi->name;
                        $data['role'] = 'other';
                        $data['project_ids'] =  $project_ids;
                        if(isset( $data['multipro_id'])){
                            if($data['multipro_id'] != 'all'){
                            $data['project_ids'] = $data['multipro_id'];
                            }
                         
                        }
                        $data['status'] = 'success';
                        return $data;
                    }
                }
                else{
                    $roles = $user
                        ->roles()
                        
                        ->whereHas('projects', function ($query) use ($multiProjectId) {
                            $query->where('multi_project_id', $multiProjectId);
                        })
                        ->first(); 
                       
                    
                        if (!empty($roles)) {
                            $data['multi_projects']  = [];
                            $data['project'] = $multi->name;
                            $data['role'] = 'other';
                            $data['project_ids'] =  $multi->id ;
                            if(isset( $data['multipro_id'])){
                                if($data['multipro_id'] != 'all'){
                                    $data['project_ids'] = $data['multipro_id'];
                                    }
                            }
                            $data['status'] = 'success';
                            return  $data;
                            
        
                        }
                }
            }
            else
            {
                $data['status'] = 'error';
                return  $data; 
            }
        }
        catch(\Exception $e){
            $data['status'] = 'error';
            return  $data;
    
        }
    }

// public function getCookieInfoAndMultiPro($request){
//     $data =  array();
//     try{
       
      
//         if($request->has('multipro_id')){
            
//             if($request->multipro_id == 'all'){
//                 $data['multipro_id'] =$request->multipro_id;
//             }else if(!empty($request->multipro_id)){
//             $data['multipro_id'] =  decrypt($request->multipro_id);
//             }
//         }
        
        
//         $project_id = request()->cookie('current_project_id');
       
//         $user = Auth::user();
//         $data['multi_projects'] = [];
//         if (!empty($project_id)) {
//             $p_id = decrypt($project_id);
//             $multi = MultiProject::where('id', $p_id)->first();
//             $multiProjectId = $multi->id;
//             if ($multi->name == "Super Admin") {
//                 $roles = $user
//                     ->roles()
//                     ->where('name', 'like', 'admin')
//                     ->whereHas('projects', function ($query) use ($multiProjectId) {
//                         $query->where('multi_project_id', $multiProjectId);
//                     })
//                     ->first();
//                 if (!empty($roles)) {
//                     $data['multi_projects']  = MultiProject::where('name', 'NOT like', 'Super Admin')->get();
//                     $data['project'] = $multi->name;
//                     $data['role'] = 'admin';
//                     $data['project_ids'] =  'all';
//                     if(isset( $data['multipro_id'])){
//                         $data['project_ids'] = $data['multipro_id'];
                        
//                     }
//                     $data['status'] = 'success';
//                     return  $data;
                    

//                 } else {
//                     $project_ids = $user->roles()
//                     ->where('name', 'NOT like', 'admin')
//                     // ->with(
                    
//                     // [
//                     //     'projects' => function($query) {
//                     //         // add conditions to the roles query here
//                     //         $query->where('name', 'NOT like', 'Super Admin');
//                     //     },
                        
//                     // ])
//                      // Eager load the related 'projects' models
//                     ->get()
//                     ->pluck('projects.*.id') // Pluck the 'id' column from the related 'projects' models
//                     ->flatten() // Flatten the collection of IDs into a single array
//                     ->unique() // Filter out duplicates
//                     ->toArray(); // Res // Reset the array keys
                     
//                     $data['multi_projects'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get();
//                     $data['project'] = $multi->name;
//                     $data['role'] = 'other';
//                     $data['project_ids'] =  $project_ids;
//                     if(isset( $data['multipro_id'])){
//                         if($data['multipro_id'] != 'all'){
//                         $data['project_ids'] = $data['multipro_id'];
//                         }
                     
//                     }
//                     $data['status'] = 'success';
//                     return $data;
//                 }
//             }
//             else{
//                 $roles = $user
//                     ->roles()
                    
//                     ->whereHas('projects', function ($query) use ($multiProjectId) {
//                         $query->where('multi_project_id', $multiProjectId);
//                     })
//                     ->first(); 
                
//                     if (!empty($roles)) {
//                         $data['multi_projects']  = [];
//                         $data['project'] = $multi->name;
//                         $data['role'] = 'other';
//                         $data['project_ids'] =  $multi->id ;
//                         if(isset( $data['multipro_id'])){
//                             if($data['multipro_id'] != 'all'){
//                                 $data['project_ids'] = $data['multipro_id'];
//                                 }
//                         }
//                         $data['status'] = 'success';
//                         return  $data;
                        
    
//                     }
//             }
//         }
//         else
//         {
//             $data['status'] = 'error';
//             return  $data; 
//         }
//     }
//     catch(\Exception $e){
//         $data['status'] = 'error';
//         return  $data;

//     }
// }
    public function updateQuery(Request $request)
    {

        $query = $request->input('query');

        $arr = array(
        "CRV",
        "BRV" ,
        "CPV" ,
        "BPV",
        "JV",

        "crv",
        "brv" ,
        "cpv" ,
        "bpv",
        "jv",
        );

        $type = explode('-', $query);

        $voucher_type = null;
        if( in_array($type[0], $arr ))
        {
            if ($type[0] == 'cpv' || $type[0] == 'CPV') 
            {
                  $voucher_type  = GeneralJournalEntry::CPV;
            }
            elseif($type[0] == 'crv' || $type[0] == 'CRV')
            {
                  $voucher_type  = GeneralJournalEntry::CRV;
            }
             elseif($type[0] == 'brv' || $type[0] == 'BRV')
            {
                  $voucher_type  = GeneralJournalEntry::BRV;
            }
             elseif($type[0] == 'bpv' || $type[0] == 'BPV')
            {
                  $voucher_type  = GeneralJournalEntry::BPV;
            }
             elseif($type[0] == 'jv' || $type[0] == 'JV')
            {
                  $voucher_type  = GeneralJournalEntry::JV;
            }
          
        }


       $arr_replace = array(
        "CRV-" => '',
        "BRV-" => '',
        "CPV-" => '',
        "BPV-"=> '',
        "JV-"=> '',

        "crv-"=> '',
        "brv-" => '',
        "cpv-" => '',
        "bpv-"=> '',
        "jv-"=> '',
        );


        $query =  strtr( $query , $arr_replace);



        $allEntries = GeneralJournalEntry::with('voucher');


        if (!empty($voucher_type)) 
        {
              $allEntries =  $allEntries->where('voucher_type' , $voucher_type);
        }
        
        if (!empty($query) && is_numeric($query)) 
        {
            $allEntries =  $allEntries->where('amount', $query);
        }


        if (!empty($query) && !is_numeric($query)) 
        {
            $allEntries =  $allEntries->where('voucher_no','like',  '%'. $query .'%')->orWhere('entry_no','like',  '%'. $query .'%');
        }
        
        


       $allEntries =  $allEntries->orderBy('entry_no', 'DESC')->groupBy('entry_no')->get();
       
      
        
        $totalAmount = array();
        
        $entriesArray = array();

        foreach ($allEntries as $entries) 
        {
            
                 $totalAmount[$entries->entry_no] = GeneralJournalEntry::where([['entry_no', $entries->entry_no], ['amount', '>', 0]])->sum('amount');
                 
                  if ((!empty($query) && is_numeric($query)) && ($totalAmount[$entries->entry_no]  === $query)) 
                  {
                          $entriesArray[] = $entries;
                          $totalAmount[$entries->entry_no] = GeneralJournalEntry::where([['entry_no', $entries->entry_no], ['amount', '>', 0]])->sum('amount');
                  }
            
        }
        
        
             if (!empty($query) && is_numeric($query)) 
              {
                   $data['allEntries'] = $entriesArray;
              }
              else
              {
                 $data['allEntries'] = $allEntries;  
              }
        
         
          

        $data['totalAmount'] = $totalAmount;

          return view('general-entry.update-entries-table', $data);
        }

     public function updateEntries(Request $request)
    {
      $data=  $this->getCookieInfoAndMultiPro($request);
      
        if($data['status'] == 'error'){
            return redirect()

            ->back()
            ->with([
                'message' => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }
        
        $id=[];
        if(is_array($data['project_ids'])){
            $id=    $data['project_ids'];
           }
           else
           {
            $id[]=    $data['project_ids'];
           }

        $date=explode('-',$request->date_range);
        // dd( $request->all());
        $from=Carbon::parse($date[0])->startOfDay();
        $to=Carbon::parse($date[1])->endOfDay();
        
        
        $allEntries = GeneralJournalEntry::
        when($id[0] !== 'all', function ($query) use ($id) {
             $query->whereIn('multi_project_id', $id);
                            })->
        whereBetween('date',[$from,$to]);
       
        
        if($request->account > 0 )
        {
            $allEntries =  $allEntries->where('account_id',$request->account);
        }
        
        $allEntries =  $allEntries->with('voucher')->orderBy('entry_no', 'DESC')->groupBy('entry_no')->get();
        
        $data['allEntries'] = $allEntries;
        
        $totalAmount = array();

        foreach ($data['allEntries'] as $entries) {
            $totalAmount[$entries->entry_no] = GeneralJournalEntry::where([['entry_no', $entries->entry_no], ['amount', '>', 0]])
            ->when($id[0] !== 'all', function ($query) use ($id) {
                 $query->whereIn('multi_project_id', $id);
                                })
            ->sum('amount');
        }

        $data['totalAmount'] = $totalAmount;


        return view('general-entry.update-entries-table', $data);
    }
    public  function getCookieInfomation(){
        $data = array();
        $project_id = request()->cookie('current_project_id');
        $user = Auth::user();
        if (!empty($project_id)) {
            $p_id = decrypt($project_id);
            $multi = MultiProject::where('id', $p_id)->first();
            $multiProjectId = $multi->id;
            if ($multi->name == "Super Admin") {
                $roles = $user
                    ->roles()
                    ->where('name', 'like', 'admin')
                    ->whereHas('projects', function ($query) use ($multiProjectId) {
                        $query->where('multi_project_id', $multiProjectId);
                    })
                    ->first();
                if (!empty($roles)) {
                    $data['multi_projects']  = MultiProject::where('name', 'NOT like', 'Super Admin')->get()->pluck('id')->toArray() // Flatten the collection of IDs into a single array
                    ;
                    return   $data;
                } else {
                    $project_ids = $user->roles()
                        ->with('projects') // Eager load the related 'projects' models
                        ->get()
                        ->pluck('projects.*.id') // Pluck the 'id' column from the related 'projects' models
                        ->flatten() // Flatten the collection of IDs into a single array
                        ->unique() // Filter out duplicates
                        ->values(); // Reset the array keys
    
                    ;
                    $data['multi_projects'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get()->pluck('id')
                    ->toArray();
                    
                     return   $data;
                }
            }
            else{
                $roles = $user
                    ->roles()
                    
                    ->whereHas('projects', function ($query) use ($multiProjectId) {
                        $query->where('multi_project_id', $multiProjectId);
                    })
                    ->first(); 
    
                    if (!empty($roles)) {
                        $data['multi_projects']  = $multi->id;
                        
                        return   $data;
                        
    
                    }
            }
        }
    }
    public function getCustomerVouchers()
    {
        
        $project_ids=   $this->getCookieInfomation();
       
        $ids=[];
        if(is_array($project_ids['multi_projects'])){
            $ids= $project_ids['multi_projects']; 
        }
        else
        $ids[]= $project_ids['multi_projects'];

        $data['receipts'] = Receipt::where([['is_book',false],['is_approved',true]])
        ->whereIn('multi_project_id', $ids)
        ->orderBy('created_at','DESC')->get();
        
        $data['customer_tax_receipts'] = TaxReceipt::where([['is_book',false]])
        ->whereIn('multi_project_id', $ids)
        ->orderBy('created_at','DESC')->get();

        // $data['refund_properties'] = CancelProperty::
        // where([['after_cancellation_status', 'refunded'], ['voucher_generated', false]])
        // ->whereHas('customerProperty', function($query) use($ids) {
        //     // add constraints on the related model here
        //     $query->whereIn('multi_project_id', $ids);
        // })
        // ->get();
       
        $data['refund_properties'] = CustomerRefundUnitReceipt::
        with('property')->
        where([['is_approved', true], ['is_book', false]])
        ->whereIn('multi_project_id', $ids)
        
        ->get();
       
        // $data['allStatementsRefunded'] = CustomerProperty::whereHas('cancelProperty', function($q)
        // {
        //     $q->where('after_cancellation_status','refunded');
        
        // })->with('inventory','customer','dealer','cancelProperty','unitRefundHistory')
        // ->when($ids[0] !== 'all', function ($query) use ($ids) {
        //     $query->whereIn('multi_project_id', $ids);
        // })
        // ->orderBy('created_at', 'desc')->paginate(25);
     
      
        $data['allStatements'] = CustomerProperty::where([['is_book',false],['status',CustomerProperty::approved]])
        ->whereIn('multi_project_id', $ids)
        ->orderBy('created_at','DESC')->get();
 
        $data['allEntries'] = GeneralJournalEntry::whereIn('transaction_type',[GeneralJournalEntry::booking,GeneralJournalEntry::receipt])
        ->whereIn('multi_project_id', $ids)
        ->orderBy('entry_no','DESC')->groupBy('entry_no')->get();

          
        $data['list'] = ControlAccount::where([['type',ControlAccount::CUSTOMER]])->get();


        $balance = array();

        foreach ($data['list'] as $l) {
            $balance[$l->id] = GeneralJournalEntry::where([['name', $l->id], ['is_post', true]])
            ->whereIn('multi_project_id', $ids)->sum('amount');
        }

        $totalAmount = array();

        foreach ($data['allEntries'] as $entries) {
            $totalAmount[$entries->entry_no] = GeneralJournalEntry::where([['entry_no', $entries->entry_no], ['amount', '>', 0]])
            ->whereIn('multi_project_id', $ids)
            ->sum('amount');
        }

        $data['totalAmount'] = $totalAmount;

        $data['balance'] = $balance;

        $data['cancel_receipts'] = CustomerCancelUnitReceipt::with('property')
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
        })
        ->where('is_deleted', false)
        ->orderBy('receipt_date', 'asc')->get();

        return view('general-entry.customer', $data);
    }

    public function getVendorVouchers()
    {
        
         // $total_receipts = PurchaseRequest::with('receipts')->get();
         
        $total_receipts = PurchaseRequest::WithAndWhereHas('receipts', function ($query) {
          
            $query->where('is_book', '=', false);
        })
         ->get();
        //echo '<pre>';
         $data['total_receipts'] = json_decode(json_encode($total_receipts));

         
         // print_r($data['total_receipts'] );
         // exit;
        $data['allExpenses'] = Expense::where([['is_book',true]])->orderBy('created_at','DESC')->get();
        
        $data['vendorCertificates'] = VendorCertificate::orderBy('created_at','DESC')->get();

        $data['allEntries'] = GeneralJournalEntry::whereHas('controlAccount',function($query){
            $query->where('type',ControlAccount::VENDOR);
        })->orderBy('entry_no','DESC')->groupBy('entry_no')->get();

        $data['list'] = ControlAccount::where([['type',ControlAccount::VENDOR]])->get();


        $balance = array();

        foreach ($data['list'] as $l) {
            $balance[$l->id] = GeneralJournalEntry::where([['name', $l->id], ['is_post', true]])->sum('amount');
        }

        $totalAmount = array();

        foreach ($data['allEntries'] as $entries) {
            $totalAmount[$entries->entry_no] = GeneralJournalEntry::where([['entry_no', $entries->entry_no], ['amount', '>', 0]])->sum('amount');
        }

        $data['totalAmount'] = $totalAmount;

        $data['balance'] = $balance;



        return view('general-entry.vendors', $data);
    }

    public function getDealerVouchers(Request $request)
    {

        $data=  $this->getCookieInfoAndMultiPro($request);
      
        if($data['status'] == 'error'){
            return redirect()

            ->back()
            ->with([
                'message' => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }
        
        $id=[];
        if(is_array($data['project_ids'])){
            $id=    $data['project_ids'];
           }
           else
           {
            $id[]=    $data['project_ids'];
           }

        $data['allEntries'] = GeneralJournalEntry::whereHas('controlAccount',function($query){
            $query->where('type',ControlAccount::DEALER);
        })
        ->when($id[0] !== 'all', function ($query) use ($id) {
            $query->whereIn('multi_project_id', $id);
                           })
        ->orderBy('entry_no','DESC')->groupBy('entry_no')->get();

        $data['list'] = ControlAccount::where([['type',ControlAccount::DEALER]])->get();

        $data['allRebates'] = DealerPaidRebate::where([['is_deleted',false],['is_book',false]])
        ->whereHas('property', function ($query) use($id){
            $query->when($id[0] !== 'all', function ($query) use ($id) {
                $query->whereIn('multi_project_id', $id);
            });
        })
        ->with('dealer')->orderBy('created_at', 'desc')->get();

        $data['pendingRebateBookings'] = DealerTransaction::where([['is_book',false]])
       ->whereHas('dealerPackage', function ($query) use($id){
        $query->when($id[0] !== 'all', function ($query) use ($id) {
            $query->whereIn('multi_project_id', $id);
        });
    })
        ->with('dealer')->orderBy('created_at', 'desc')->get();

        // dd( $data['pendingRebateBookings']);

        $data['pendingopenfilepackage'] = DealerPackageReceipt::where('is_book',0)
        ->when($id[0] !== 'all', function ($query) use ($id) {
            $query->whereIn('multi_project_id', $id);
                           })
        ->where('is_approved',1)->get();
        // dd( $data['pendingopenfilepackage']);
 
         $data['openfile_receipts'] = DealerRefundOpenFileUnitReceipt::where([['is_approved', true], ['is_book', false]])
         ->when($id[0] !== 'all', function ($query) use ($id) {
            $query->whereIn('multi_project_id', $id);
                           })
         ->get();
        //  dd(  $data['refund_openfiles']);
        //  CancelOpenFile::where([['after_cancellation_status', 'refunded'], ['voucher_generated', false]])
        
        // ->get();
       
        // dd( $data['pendingopenfilepackage']);
        // echo "<pre>";
        // print_r($data['pendingRebateBookings']);
        // exit;

        $balance = array();

        foreach ($data['list'] as $l) {
            $balance[$l->id] = GeneralJournalEntry::where([['name', $l->id], ['is_post', true]])->sum('amount');
        }

        $totalAmount = array();

        foreach ($data['allEntries'] as $entries) {
            $totalAmount[$entries->entry_no] = GeneralJournalEntry::where([['entry_no', $entries->entry_no], ['amount', '>', 0]])->sum('amount');
        }

        $data['totalAmount'] = $totalAmount;

        $data['balance'] = $balance;
        $data['cancel_openfile_receipts'] = DealerOpenFileCancelReceipt::
            when($id[0] !== 'all', function ($query) use ($id) {
                $query->whereIn('multi_project_id', $id);
            })
            ->where('is_deleted', false)
            ->orderBy('receipt_date', 'asc')->get();

           
        return view('general-entry.dealer', $data);
    }

    public function getEmployeeVouchers()
    {
       $data['allEntries'] = GeneralJournalEntry::whereHas('controlAccount',function($query){
            $query->where('type',ControlAccount::EMPLOYEE);
        })->orderBy('entry_no','DESC')->groupBy('entry_no')->get();

        $data['list'] = ControlAccount::where([['type',ControlAccount::EMPLOYEE]])->get();

        $balance = array();

        foreach ($data['list'] as $l) {
            $balance[$l->id] = GeneralJournalEntry::where([['name', $l->id], ['is_post', true]])->sum('amount');
        }

        $totalAmount = array();

        foreach ($data['allEntries'] as $entries) {
            $totalAmount[$entries->entry_no] = GeneralJournalEntry::where([['entry_no', $entries->entry_no], ['amount', '>', 0]])->sum('amount');
        }

        $data['totalAmount'] = $totalAmount;

        $data['balance'] = $balance;


            $month = Carbon::now()->month;
            $year = Carbon::now()->year;


            $totalArray = array();

            $total_records = HrmEmployeeMonthlyEarningDeduction::where('is_sent' , 1)->where('is_book' , 0)->where('is_approved',1)->groupBy(['month' , 'year'])->get();

            $total_pending_payroll = $total_records->count();

            $data['total_pending_payroll'] = $total_pending_payroll;

             $total_pending_payroll = HrmEmployeeMonthlyEarningDeduction::where('is_sent' , 1)->where('is_approved',1)->groupBy(['month' , 'year'])->count();

            $total_count = 0;
               
            foreach ($total_records as $key => $value)
            {
                $total_monthly_earning = HrmEmployeeMonthlyEarningDeduction::where('month', $value->month)->where('year', $value->year)->where('type', 1)->where('is_sent' , 1)->where('is_book' , 0)->where('is_approved',1)->sum('amount');
               
               

                $total_monthly_deduction = HrmEmployeeMonthlyEarningDeduction::where('month', $value->month)->where('year', $value->year)->where('type', 0)->where('is_sent' , 1)->where('is_book' , 0)->where('is_approved',1)->sum('amount');

                //dd($total_monthly_deduction);

                $total_monthly_tax =  HrmEmployeeMonthlyEarningDeduction::where('month', $value->month)->where('year', $value->year)->where('is_sent' , 1)->where('is_book' , 0)->where('is_approved',1)->sum('tax');

                $employee_benevolent_found = HrmEmployeeBenevolentFound::where('month',$value->month)->where('year', $value->year)->where('is_approved',1)->sum('bf_fund');

               // dd($employee_benevolent_found);

                $HrmEmployeeAdvance = HrmEmployeeLoanAdjusment::whereMonth('date' , $value->month)->whereYear('date', $value->year)->where('type' , 'Advance')->where('is_approved',1)->sum('adjustment_amount');
               
               

                $HrmEmployeeLoan = HrmEmployeeLoanAdjusment::whereMonth('date' , $value->month)->whereYear('date', $value->year)->where('type' , 'Loan')->where('is_approved',1)->sum('adjustment_amount');

                $total_monthly_advance = HrmEmployeeLoan::whereMonth('date', $value->month)->whereYear('date', $value->year)->where('type' , 'Advance')->where('is_sent' , 1)->where('is_book' , 0)->where('is_approved',1)->sum('loan_amount');

                //dd($total_monthly_advance);

                $total_monthly_loan = HrmEmployeeLoan::whereMonth('date', $value->month)->whereYear('date', $value->year)->where('type' , 'Loan')->where('is_sent' , 1)->where('is_book' , 0)->sum('loan_amount');

                $total_pending_advance_loan = HrmEmployeeLoan::whereMonth('date', $value->month)->whereYear('date', $value->year)->where('is_sent' , 1)->where('is_book' , 0)->count();


        if ($total_pending_advance_loan > 0 ) {
            $total_count ++;

            }
           
                $totalArray[] = array('month' => $value->month , 'year' => $value->year , 'total_monthly_earning' => $total_monthly_earning , 'total_monthly_deduction' => $total_monthly_deduction , 'total_monthly_tax' =>$total_monthly_tax , 'employee_benevolent_found' => $employee_benevolent_found , 'HrmEmployeeLoan' =>$HrmEmployeeLoan , 'HrmEmployeeAdvance' => $HrmEmployeeAdvance, 'total_monthly_loan' => $total_monthly_loan , 'total_monthly_advance' => $total_monthly_advance, 'total_net_salary' => ($total_monthly_earning - ($total_monthly_deduction + $total_monthly_tax + $employee_benevolent_found + $HrmEmployeeLoan + $HrmEmployeeAdvance)));

            }
           
            $data['total_count'] = $total_count;


            $data['totalArray'] = $totalArray;

            $HrmEmployees = array();

            $HrmEmployees = HrmEmployee::with('companyDetail','accountDetail','employeeEarningDeduction','benevolentFund')->orderBy('id','DESC')->get();
            $HrmEmployees =json_decode(json_encode($HrmEmployees));

            $company_account_no = array();
           
            $company_account_no = CompanyBank::get();
            $data['company_account_no'] = $company_account_no;
            $data['HrmEmployees'] = $HrmEmployees;
            $data['month'] = $month;
            $data['year'] = $year;

             $data['employees'] = HrmEmployee::with(['loan'])->orderby('id','DESC')->get();

             $data['employees'] =json_decode(json_encode($data['employees']));

             $data['total_pending_loan_advance'] = HrmEmployeeLoan::where('is_approved',1)->count('is_approved');

           activity('Voucher')->log('Employees Voucher');
            return view('general-entry.employee', $data);
           
    }

    public function getReceiptDetail($id)
    {

        $data = array();
        $data['receipt'] = Receipt::where('id',$id)->first();


        $data['property'] = CustomerProperty::where('id', $data['receipt']->customer_property_id)->with('inventory', 'customer')->first();

        return view('general-entry.receipt-detail', $data);
    }

    public function getBillDetail($id)
    {

        $data['expense'] = Expense::where('id', $id)->first();

        return view('general-entry.bill-detail', $data);
    }

    public function getProcurementBillDetail($id)
    {


        $data['receipt'] = PurchaseOrderReceipt::find($id);

        return view('general-entry.pro-bill-detail', $data);
    }


    public function createVoucherFormold(Request $request) {

      
        $data['accounts'] = ChartOfAccount::orderBy('number','ASC')->get();
        $leafAccount = array();
        foreach ($data['accounts'] as $acc) {
            $leafAccount[$acc->id] = ChartOfAccount::where('sub_account_id', [$acc->id])->count()  == 0 ?  true : false;
        }
        $data['leafAccount'] = $leafAccount;
        $data['names'] = ControlAccount::get();
        $data['classes'] = AccountClass::all();

        $data['transaction_id'] = $request->id;

         if( !empty($request->receipt_type ) )
        {
            $data['transaction_type'] = $request->receipt_type;
        }
        else
        {
           $data['transaction_type'] = $request->type; 
        }
        

         //receipt info

        if($request->type == GeneralJournalEntry::receipt && empty($request->receipt_type ))
            $data['receipt'] = Receipt::where('id',$request->id)->first();

        else
            $data['receipt'] = null;
            
            
        //customer tax receipt info

        if($request->type == GeneralJournalEntry::receipt && !empty($request->receipt_type ))
            $data['customer_tax_receipt'] = TaxReceipt::where('id',$request->id)->first();

        else
            $data['customer_tax_receipt'] = null;

        //statement info
        if ($request->type == GeneralJournalEntry::booking)
            $data['property'] = CustomerProperty::where('id', $request->id)->with('inventory', 'customer')->first();
        else
            $data['property'] = null;

        //rebate info
        if ($request->type == GeneralJournalEntry::rebate)
            $data['rebate'] = DealerPaidRebate::where('id', $request->id)->with('dealer')->first();
        else
            $data['rebate'] = null;

        //pendind rebate
        if($request->type == GeneralJournalEntry::dealer_receipt)
            $data['pending_rebate'] = DealerTransaction::where('id',$request->id)->with('dealer')->first();
        else
            $data['pending_rebate'] = null;



            
 
        return view('general-entry.create-voucher', $data);
    }

    public function createVoucherForm(Request $request) 
    {
    
     $data=   $this->getCookieInfoAndMultiPro($request);

    // $data['multi_projects']= MultiProject::all();
         
        $data['accounts'] = ChartOfAccount::orderBy('number','ASC')->get();


        $leafAccount = array();

        foreach ($data['accounts'] as $acc) {
            $leafAccount[$acc->id] = ChartOfAccount::where('sub_account_id', [$acc->id])->count()  == 0 ?  true : false;
        }
        $data['leafAccount'] = $leafAccount;



        $data['names'] = ControlAccount::get();
        $data['classes'] = AccountClass::all();

        

        $data['transaction_id'] = $request->id;
        
        
        if( !empty($request->receipt_type ) )
        {
            $data['transaction_type'] = $request->receipt_type;
        }
        else
        {
           $data['transaction_type'] = $request->type; 
        }
        

        //receipt info

        if($request->type == GeneralJournalEntry::receipt && empty($request->receipt_type ))
            $data['receipt'] = Receipt::where('id',$request->id)->first();

        else
            $data['receipt'] = null;
            
            
        //customer tax receipt info

        if($request->type == GeneralJournalEntry::receipt && !empty($request->receipt_type ))
            $data['customer_tax_receipt'] = TaxReceipt::where('id',$request->id)->first();

        else
            $data['customer_tax_receipt'] = null;


        //statement info
        if ($request->type == GeneralJournalEntry::booking)
            $data['property'] = CustomerProperty::where('id', $request->id)->with('inventory', 'customer')->first();
        else
            $data['property'] = null;

        //rebate info
        if ($request->type == GeneralJournalEntry::rebate)
            $data['rebate'] = DealerPaidRebate::where('id', $request->id)->with('dealer')->first();
        else
            $data['rebate'] = null;

        //pendind rebate
        if($request->type == GeneralJournalEntry::dealer_receipt)
            $data['pending_rebate'] = DealerTransaction::where('id',$request->id)->with('dealer')->first();
        else
            $data['pending_rebate'] = null;

        // dealer open file package
        if($request->type == GeneralJournalEntry::dealer_open_file_package)
        $data['pending_open_file_package'] = DealerPackageReceipt::where('id',$request->id)->first();

    else
        $data['pending_open_file_package'] = null;

             //refund info
        if ($request->type == GeneralJournalEntry::customer_refund_unit)
        $data['pending_refund'] = CustomerRefundUnitReceipt::where('id', $request->id)->first();
    else
        $data['pending_refund'] = null;

        if($request->type == GeneralJournalEntry::dealer_refunded_open_file){
            $data['pending_refund_openfile'] = DealerRefundOpenFileUnitReceipt::
            where('id',$request->id)
            ->first();
        }   
        else
            $data['pending_refund_openfile'] = null;

            if($request->type == GeneralJournalEntry::customer_cancel_unit){
                $data['pending_cancel_closeunit'] = CustomerCancelUnitReceipt::
                where('id',$request->id)
                ->first();
            }   
            else
                $data['pending_cancel_closeunit'] = null;

                if($request->type == GeneralJournalEntry::dealer_cancel_open_unit){
                    $data['pending_cancel_openfile'] = DealerOpenFileCancelReceipt::
                    where('id',$request->id)
                    ->first();
                }   
                else
                    $data['pending_cancel_openfile'] = null;
 
    
        return view('general-entry.create-voucher', $data);
    }
  
    public function voucherEdit(Request $request, $id)
    {

        $data['accounts'] = ChartOfAccount::orderBy('number', 'ASC')->get();
        $account_info = GeneralJournalEntry::with('voucher')->where([ ['entry_no', '=', $id]])->orderBy('id', 'ASC')->get();

        $transaction_type   = $account_info[0]->transaction_type;
        $transaction_id     = $account_info[0]->transaction_id;
        $data['voucher_type']           = $account_info[0]->voucher_type;
        $data['account_info'] = $account_info;

        $leafAccount = array();

        foreach ($data['accounts'] as $acc) {
            $leafAccount[$acc->id] = ChartOfAccount::where('sub_account_id', [$acc->id])->count()  == 0 ?  true : false;
        }
        $data['leafAccount'] = $leafAccount;


        $data['names'] = ControlAccount::get();
        $data['classes'] = AccountClass::all();

        $last_entry = GeneralJournalEntry::orderBy('entry_no', 'DESC')->first();

        if ($last_entry)
            $data['latest_entry_no'] = ++$last_entry->entry_no;
        else
            $data['latest_entry_no'] = 1;

        $data['transaction_id'] = $transaction_id;

        $data['transaction_type'] = $transaction_type;

        $data['count'] = $account_info->count();

        return view('general-entry.update-voucher', $data);
    }


    public function UpdateVoucher(Request $request)
    {
        
        $voucher_valid_after = SchedulePlan::first()->voucher_valid_after;

        if ($request->date <= $voucher_valid_after) 
        {
            return 'date_error';
            exit();
        }
        
        DB::beginTransaction();
        try {

            $entry_info = GeneralJournalEntry::where([['entry_no',$request->entry_no]])->first();
           
            GeneralJournalEntry::where([['entry_no',$request->entry_no]])->delete();

            Voucher::where([['entry_no',$request->entry_no]])->update(['narration'=>$request->memo]);
            for ($i = 0; $i < count($request->account); $i++) {

                $amount = $request->debit[$i] != 0 ? $request->debit[$i] : $request->credit[$i] * -1;
                $line_narration = '';
                if($request->line_narration[$i])
                    $line_narration = $request->line_narration[$i];
                 $gId = GeneralJournalEntry::create(['date' => $request->date, 'entry_no' => $request->entry_no, 'adjusting_entry' => $request->adjusting_entry, 'account_id' => $request->account[$i], 'amount' => $amount, 'memo' => $line_narration, 'name' => $request->name[$i], 'voucher_type' => $request->voucher_type, 'transaction_id' => $request->transaction_id, 'transaction_type' => $request->transaction_type, 'prepare_by' => Auth::user()->id, 'voucher_no' => $entry_info->voucher_no, 'bank_name' => $request->bank_name, 'cheaque_no' => $request->cheaque_no,'is_check'=> $entry_info->is_check,'is_post'=> $entry_info->is_post,'check_by'=> $entry_info->check_by,'post_by'=> $entry_info->post_by]);


                if ($request->voucher_type == GeneralJournalEntry::BPV || $request->voucher_type == GeneralJournalEntry::BRV)
                    GeneralJournalEntry::where('id', $gId->id)->update(['is_cleared' => false]);
            }
        } catch (\Exception $e) {
            DB::rollback();
            return false;
        }
        DB::commit();



        //return 1;

           return $entry_info;


    }

    public function createReversalVoucherForm($id)
    {
        $data=   $this->getCookieInfoAndMultiPro();

        $data['entries'] = GeneralJournalEntry::where('entry_no', $id)->get();

        $data['accounts'] = ChartOfAccount::orderBy('number', 'ASC')->get();

        $leafAccount = array();

        foreach ($data['accounts'] as $acc) {
            $leafAccount[$acc->id] = ChartOfAccount::where('sub_account_id', [$acc->id])->count()  == 0 ?  true : false;
        }
        $data['leafAccount'] = $leafAccount;


        $data['names'] = ControlAccount::orderBy('id','DESC')->get();
        $data['classes'] = AccountClass::all();


        $data['transaction_id'] = null;

        $data['transaction_type'] = null;



        return view('general-entry.create-reversal-voucher', $data);
    }

    public function createVoucher(Request $request)
    {
        

        $voucher_valid_after = SchedulePlan::first()->voucher_valid_after;

        if ($request->date <= $voucher_valid_after) 
        {
            return 'date_error';
            exit();
        }
        
       
       
        DB::beginTransaction();
         try { 
     
        //  $voucherNo = GeneralJournalEntry::where([['voucher_type',$request->voucher_type]])->groupBy('entry_no')->get();
        
        //   if(count($voucherNo) > 0 )
        // {
        //     $voucherNo = json_decode($voucherNo);
        //     $voucher_no = array();
        //     foreach ($voucherNo as $key => $row)
        //     {
        //         $voucher_number = explode('-' , $row->voucher_no);
        //         $voucher_no[$key] = $voucher_number[0];
        //     }
        //     array_multisort($voucher_no, SORT_DESC, $voucherNo);

        //     $break_voucher_no = explode('-' , $voucherNo[0]->voucher_no);
        
        //     $voucherNo = $break_voucher_no[0] + 1 .'-' . date('m') . date('y');
        // }
        // else
        // {
        //     $voucherNo = count($voucherNo) + 1 .'-' . date('m') . date('y');
        // }
     
        $pro_id =  $request->cookie('current_project_id');
        if (empty($pro_id)) {
            return redirect()

            ->back()
            ->with([
                'message' => 'Something went wrong!',
                'alert-type' => 'error',
            ]);
        }

        $pro_id =decrypt($pro_id);
        $multi_pro = MultiProject::whereRaw("id = IF(name='Super Admin', $pro_id, -1)")->first();

      if(!empty($multi_pro)){
        $validator = Validator::make($request->all(), [
            'multipro_id' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => "Please Select Project first",
            ]);
        }
       
            $request->merge(['multipro_id' =>  decrypt($request->multipro_id)]);
           
      }
      else{
                $request->merge(['multipro_id' =>  $pro_id]);
      }

    
        
        
        // dd($request->multipro_id);
        $month = date('m' , strtotime($request->date));
            $year = date('Y' , strtotime($request->date));


        $voucherNo = GeneralJournalEntry::where([['voucher_type',$request->voucher_type]])->groupBy('entry_no')->get();
       
// dd($voucherNo);
        if(count($voucherNo) > 0 )
        {
            $voucherNo = json_decode($voucherNo);
            $voucher_no = array();
            foreach ($voucherNo as $key => $row)
            {
                if(  (date('m' , strtotime($row->date)) == $month) &&  (date('Y' ,strtotime($row->date)) == $year)  )
                {
                    // $voucher_number = explode('-' , $row->voucher_no);
                    $voucher_no[$key] = $row->voucher_no;
                }
            }

            
            if(count($voucher_no) > 0 )
            {
                $voucher_nobrs = array_intersect($voucher_no , array_column($voucherNo , 'voucher_no'));
                $voucher_nobrs =array_values($voucher_nobrs);
                
                usort($voucher_nobrs, function ($item1, $item2) {
                $item1 = explode('-' , $item1);
                $item2 = explode('-' , $item2);
                
                if($item1[0]==$item2[0]) return 0;
                return $item1[0] < $item2[0]?1:-1;
                
                });
                
                $break_voucher_no = explode('-' , $voucher_nobrs[0]);
                
                $voucherNo = $break_voucher_no[0] + 1;
            }
            else
            {
                $voucherNo =  1;
            }

            
        }
        else
        {
            $voucherNo =  1;
        }
      
        
        if($voucherNo < 10)
        {
            $voucherNo = '0'.$voucherNo;
        }

        $voucherNo = $voucherNo.'-' . $month . $year;
               

       


        // dd(  $voucherNo);
        $last_entry = GeneralJournalEntry::orderBy('entry_no','DESC')->first();

        if ($last_entry)
            $latest_entry_no = ++$last_entry->entry_no;
        else
            $latest_entry_no = 1;
            // 
         Voucher::create(['entry_no'=>$latest_entry_no,'narration'=>$request->memo]);
           
            for ($i = 0; $i < count($request->account); $i++) {

                $amount = $request->debit[$i] != 0 ? $request->debit[$i] : $request->credit[$i] * -1;


                
                $line_narration ='';
                if(!empty($request->line_narration[$i]))
                {
                    $line_narration = $request->line_narration[$i];
                }
                if ($request->transaction_type == GeneralJournalEntry::dealer_open_file_package) {
                    $gId = GeneralJournalEntry::create(['date' => $request->date, 'entry_no' => $latest_entry_no, 'adjusting_entry' => $request->adjusting_entry, 'account_id' => $request->account[$i], 'amount' => $amount, 'memo' => $line_narration, 'name' => $request->name[$i], 'voucher_type' => $request->voucher_type, 'transaction_id' => $request->transaction_id, 'transaction_type' => $request->transaction_type, 'prepare_by' => Auth::user()->id, 'voucher_no' => $voucherNo, 'bank_name' => $request->bank_name, 'cheaque_no' => $request->cheaque_no,'dealer_package_voucher'=>1,'multi_project_id'=>$request->multipro_id]);
                } 
                elseif($request->transaction_type == GeneralJournalEntry::customer_refund_unit){
                    $gId = GeneralJournalEntry::create(['date' => $request->date, 'entry_no' => $latest_entry_no, 'adjusting_entry' => $request->adjusting_entry, 'account_id' => $request->account[$i], 'amount' => $amount, 'memo' => $line_narration, 'name' => $request->name[$i], 'voucher_type' => $request->voucher_type, 'transaction_id' => $request->transaction_id, 'transaction_type' => $request->transaction_type, 'prepare_by' => Auth::user()->id, 'voucher_no' => $voucherNo, 'bank_name' => $request->bank_name, 'cheaque_no' => $request->cheaque_no,'customer_refund_unit'=>1,'multi_project_id'=>$request->multipro_id]);

                }
                elseif($request->transaction_type == GeneralJournalEntry::dealer_refunded_open_file){
                    $gId = GeneralJournalEntry::create(['date' => $request->date, 'entry_no' => $latest_entry_no, 'adjusting_entry' => $request->adjusting_entry, 'account_id' => $request->account[$i], 'amount' => $amount, 'memo' => $line_narration, 'name' => $request->name[$i], 'voucher_type' => $request->voucher_type, 'transaction_id' => $request->transaction_id, 'transaction_type' => $request->transaction_type, 'prepare_by' => Auth::user()->id, 'voucher_no' => $voucherNo, 'bank_name' => $request->bank_name, 'cheaque_no' => $request->cheaque_no,'dealer_refund_openfile'=>1,'multi_project_id'=>$request->multipro_id]);

                }
                elseif($request->transaction_type == GeneralJournalEntry::customer_cancel_unit){
                    $gId = GeneralJournalEntry::create(['date' => $request->date, 'entry_no' => $latest_entry_no, 'adjusting_entry' => $request->adjusting_entry, 'account_id' => $request->account[$i], 'amount' => $amount, 'memo' => $line_narration, 'name' => $request->name[$i], 'voucher_type' => $request->voucher_type, 'transaction_id' => $request->transaction_id, 'transaction_type' => $request->transaction_type, 'prepare_by' => Auth::user()->id, 'voucher_no' => $voucherNo, 'bank_name' => $request->bank_name, 'cheaque_no' => $request->cheaque_no,'cancel_close_unit'=>1,'multi_project_id'=>$request->multipro_id]);

                }
                elseif($request->transaction_type == GeneralJournalEntry::dealer_cancel_open_unit){
                    $gId = GeneralJournalEntry::create(['date' => $request->date, 'entry_no' => $latest_entry_no, 'adjusting_entry' => $request->adjusting_entry, 'account_id' => $request->account[$i], 'amount' => $amount, 'memo' => $line_narration, 'name' => $request->name[$i], 'voucher_type' => $request->voucher_type, 'transaction_id' => $request->transaction_id, 'transaction_type' => $request->transaction_type, 'prepare_by' => Auth::user()->id, 'voucher_no' => $voucherNo, 'bank_name' => $request->bank_name, 'cheaque_no' => $request->cheaque_no,'cancel_open_unit'=>1,'multi_project_id'=>$request->multipro_id]);

                }
                else {
                    $gId = GeneralJournalEntry::create(['date' => $request->date, 'entry_no' => $latest_entry_no, 'adjusting_entry' => $request->adjusting_entry, 'account_id' => $request->account[$i], 'amount' => $amount, 'memo' => $line_narration, 'name' => $request->name[$i], 'voucher_type' => $request->voucher_type, 'transaction_id' => $request->transaction_id, 'transaction_type' => $request->transaction_type, 'prepare_by' => Auth::user()->id, 'voucher_no' => $voucherNo, 'bank_name' => $request->bank_name, 'cheaque_no' => $request->cheaque_no,'multi_project_id'=>$request->multipro_id]);
                }

                if ($request->voucher_type == GeneralJournalEntry::BPV || $request->voucher_type == GeneralJournalEntry::BRV)
                    GeneralJournalEntry::where('id', $gId->id)->update(['is_cleared' => false]);
            }
 
     
            $lastEntry = GeneralJournalEntry::orderBy('id', 'DESC')->first();

            if ($request->transaction_type == GeneralJournalEntry::booking)
                CustomerProperty::where('id', $request->transaction_id)->update(['is_book' => true]);

            elseif ($request->transaction_type == GeneralJournalEntry::receipt)
                Receipt::where('id', $request->transaction_id)->update(['is_book' => true]);
                
            elseif ($request->transaction_type == GeneralJournalEntry::customer_tax_receipt)
                TaxReceipt::where('id', $request->transaction_id)->update(['is_book' => true]);

            elseif ($request->transaction_type == GeneralJournalEntry::rebate)
                DealerPaidRebate::where('id', $request->transaction_id)->update(['is_book' => true]);

            elseif ($request->transaction_type == GeneralJournalEntry::procurment_receipt)
                PurchaseOrderReceipt::where('id', $request->transaction_id)->update(['is_book' => true, 'status' => 1]);

            elseif ($request->transaction_type == GeneralJournalEntry::payment) {

               
            }

            elseif($request->transaction_type == GeneralJournalEntry::dealer_receipt)
                DealerTransaction::where('id',$request->transaction_id)->update(['is_book' => true]);
            elseif($request->transaction_type == GeneralJournalEntry::customer_refund_unit)
                CustomerRefundUnitReceipt::where('id',$request->transaction_id)->update(['is_book' => true]);
            elseif($request->transaction_type == GeneralJournalEntry::dealer_open_file_package)
                DealerPackageReceipt::where('id',$request->transaction_id)->update(['is_book' => 1]);
                elseif($request->transaction_type == GeneralJournalEntry::dealer_refunded_open_file)
                DealerRefundOpenFileUnitReceipt::where('id',$request->transaction_id)->update(['is_book' => true]);
                elseif($request->transaction_type == GeneralJournalEntry::customer_cancel_unit)
                CustomerCancelUnitReceipt::where('id',$request->transaction_id)->update(['is_book' => true]);
                elseif($request->transaction_type == GeneralJournalEntry::dealer_cancel_open_unit){
                    DealerOpenFileCancelReceipt::where('id',$request->transaction_id)->update(['is_book' => true]);
                }
                elseif ($request->transaction_type == GeneralJournalEntry::massPayment) {
                $bill = explode(',', $request->transaction_id);
                foreach ($bill as $key => $val) {
                    Expense::where('id', $val)->update(['status' => Expense::PAID]);
                    Expense::where('id', $val)->update(['entry_no' => $lastEntry->entry_no]);
                }
            }
        } catch (\Exception $e) { 
           
            DB::rollback();
            return false;
        }
        DB::commit();



        return $lastEntry;

         //  return redirect()->route('voucher-detail',['id'=>$last_entry]);


    }
    
    
      public function getCustomerTaxReceiptDetail($id = null)
    {
        $data = array();

        $digit = new \NumberFormatter("en", \NumberFormatter::SPELLOUT);

        $data['receipt'] = TaxReceipt::where('id' , $id)->first();

        $data['words'] = $digit->format($data['receipt']->receipt_amount);

        return view('receipt.customer_tax_detail_pending',$data);
    }
    

    public function voucherDetail($id)
{ 
        $data['entries'] = GeneralJournalEntry::where([['entry_no',$id]])->get();


        $data['entry'] = GeneralJournalEntry::with('bills','voucher')->where('entry_no', $id)->first();

        $firstEntry = GeneralJournalEntry::orderBy('entry_no', 'ASC')->first()->entry_no;

        $lastEntry = GeneralJournalEntry::orderBy('entry_no', 'DESC')->first()->entry_no;

        $data['next'] = $data['previous'] = false;

       
        if ($lastEntry != $data['entry']->entry_no)
            $data['next'] = true;
        if ($firstEntry != $data['entry']->entry_no)
            $data['previous'] = true;

        $data['balance'] = GeneralJournalEntry::where([['account_id', $data['entry']->account_id], ['is_post', true], ['entry_no', '<=', $data['entry']->entry_no]])->sum('amount');

        $data['previousBalance'] = GeneralJournalEntry::where([['account_id', $data['entry']->account_id], ['entry_no', '!=', $id]])->sum('amount');

        $data['voucherAmount'] = GeneralJournalEntry::where([['entry_no', $id], ['amount', '>', 0]])->sum('amount');

  


 

        return view('general-entry.detail-voucher', $data);
    }

    public function voucherChecked($id)
    {
 
      GeneralJournalEntry::where('entry_no', $id)->update(['is_check' => true, 'check_by' => Auth::user()->id]);
 
        return redirect()->back()->with([
            'message' => 'Voucher checked successfully!',
            'alert-type' => 'info'
        ]);
    }

    public function voucherPosted($id)
    {

      
        GeneralJournalEntry::where('entry_no', $id)->update(['is_post' => true, 'post_by' => Auth::user()->id]);
      
        $allEntries = GeneralJournalEntry::where('entry_no',$id)->get();

        foreach($allEntries as $aE){
            $account = ChartOfAccount::where('id',$aE->account_id)->first();
            ChartOfAccount::where('id',$aE->account_id)->update(['closing_balance'=>$account->closing_balance + $aE->amount]);
        }
 
        return redirect()->back()->with([
            'message' => 'Posted checked successfully!',
            'alert-type' => 'info'
        ]);
    }

    public function addBillForm()
    {

        $data['accounts'] = ChartOfAccount::orderBy('number','ASC')->get();


        $leafAccount = array();

        foreach ($data['accounts'] as $acc) {
            $leafAccount[$acc->id] = ChartOfAccount::where('sub_account_id', [$acc->id])->count()  == 0 ?  true : false;
        }
        $data['leafAccount'] = $leafAccount;


        $data['customers'] = array();
        $data['vendors'] = ControlAccount::where('type', ControlAccount::VENDOR)->get();
        $data['classes'] = AccountClass::all();

        $data['transaction_id'] = null;

        $data['transaction_type'] = GeneralJournalEntry::bill;



        return view('general-entry.add-bill', $data);
    }
    public function createBill(Request $request)
    {

        DB::beginTransaction();
        try {

            $debitB = explode(',', $request->debitB);
            $creditB = explode(',', $request->creditB);


            $amount = $debitB[0] != 0 ? $debitB[0] : $creditB[0];
            //create bill
            $expense = Expense::create(['vendor_id' => $request->name1[0], 'category_id' => $request->account[0], 'amount' => $amount, 'billed_at' => $request->billed_at, 'due_at' => $request->due_at, 'status' => $request->status, 'notes' => $request->notes, 'project_id' => $request->project_id, 'expense_type' => $request->expense_type, 'is_book' => true]);

            if ($request->hasfile('image')) {
                $file = $request->file('image');;
                $name = $expense->id . '-' . $file->getClientOriginalName();
                $file->move(public_path() . '/uploads/', $name);

                Expense::where('id', $expense->id)->update(['image_url' => $name]);
            }

            //create Voucher

            $last_entry = GeneralJournalEntry::orderBy('entry_no', 'DESC')->first();

            $voucherNo = GeneralJournalEntry::where('voucher_type', $request->voucher_type)->groupBy('entry_no')->count();
            $voucherNo = $voucherNo + 1;

            if ($last_entry)
                $latestEntryNo = ++$last_entry->entry_no;
            else
                $latestEntryNo = 1;

            for ($i = 0; $i < count($request->account); $i++) {
                if ($request->account[$i] != 0) {



                    $amount = $debitB[$i] != 0 ? $debitB[$i] : $creditB[$i] * -1;

                    $gId = GeneralJournalEntry::create(['date' => $request->billed_at, 'entry_no' => $latestEntryNo, 'adjusting_entry' => 0, 'account_id' => $request->account[$i], 'amount' => $amount, 'memo' => $request->notes, 'name' => $request->name1[$i], 'voucher_type' => $request->voucher_type, 'transaction_id' => $expense->id, 'transaction_type' => GeneralJournalEntry::bill, 'prepare_by' => Auth::user()->id, 'voucher_no' => $voucherNo, 'bank_name' => $request->bank_name, 'cheaque_no' => $request->cheaque_no]);

                    if ($request->voucher_type == GeneralJournalEntry::BPV || $request->voucher_type == GeneralJournalEntry::BRV)
                        GeneralJournalEntry::where('id', $gId->id)->update(['is_cleared' => false]);
                }
            }

            if ($request->voucher_type == GeneralJournalEntry::CPV || $request->voucher_type == GeneralJournalEntry::BPV) {

                $amount = $debitB[0] != 0 ? $debitB[0] : $creditB[0];



                $payment = ExpensePayment::create(['bill_id' => $expense->id, 'amount' => $amount, 'date' => $expense->billed_at, 'account_id' => $request->account[1], 'payment_method' => $request->voucher_type == GeneralJournalEntry::CPV ? ExpensePayment::CASH : ExpensePayment::BANK_TRANSFER, 'notes' => $request->notes]);

                //check cash or bank transaction
                if ($request->voucher_type == GeneralJournalEntry::BPV)
                    ExpensePayment::where('id', $payment->id)->update(['is_reconciled' => false]);

                $bill = Expense::where('id', $expense->id)->first();

                $paid_amount = ExpensePayment::where('bill_id', $expense->id)->sum('amount');

                if ($paid_amount  == $bill->amount) {
                    Expense::where('id', $expense->id)->update(['status' => \App\Expense::PAID]);
                } else {
                    Expense::where('id', $expense->id)->update(['status' => \App\Expense::PARTIALLY]);
                }
            }
        } catch (\Exception $e) {
            DB::rollback();
            return false;
        }
        DB::commit();


        return redirect()->route('voucher-detail', ['id' => $latestEntryNo]);
    }
    public function voucherDelete($id)
    {
         DB::beginTransaction();
        try 
        {
            $entryNo = GeneralJournalEntry::where('entry_no', $id)->first();
            
            $chart_of_account =  ChartOfAccount::find($entryNo->account_id);
            
            ChartOfAccount::where('id' , $entryNo->account_id)->update( ['closing_balance'=>($chart_of_account->closing_balance - $entryNo->amount)]);
            
            GeneralJournalEntry::where('entry_no', $id)->delete();
            
            Voucher::where('entry_no' , $id)->delete();

            DB::commit();
            
            return redirect()->back()->with([
            'message' => 'Voucher deleted successfully!',
            'alert-type' => 'info'
            ]);
         } 
         catch (\Exception $e) 
         {
            DB::rollback();
            
            return redirect()->back()->with([
            'message' => 'Voucher Not deleted!',
            'alert-type' => 'error'
            ]);
        }
    }
    public function sentToAccounts()
    {
       $fixed_asset_depreciations =  FixedAssetAccount::where('is_book' , 0)->where('type' , 'depreciation')->with(['asset_type'])->get();
       $fixed_asset_depreciations = json_decode(json_encode($fixed_asset_depreciations));
       $fixed_asset_solds =  FixedAssetAccount::where('is_book' , 0)->where('type' , 'sold')->with(['asset_type'])->get();
        $fixed_asset_solds = json_decode(json_encode($fixed_asset_solds));

        return view('general-entry.fixed-asset', compact('fixed_asset_depreciations' , 'fixed_asset_solds' ));
    }
}
