<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Receipt;
use App\CustomerProperty;
use App\Expense;
use App\Payroll;
use App\Employee;
use App\Purchase;
use Carbon\Carbon;
use App\DealerPaidRebate;
use App\CustomerStatement;
use App\Dealer;
use DB;
use Illuminate\Support\Facades\Auth;
use App\User;
use Illuminate\Support\Facades\Validator;
use App\Inventory;
use App\UnitFloor;
use App\CustomerAdjustment;
use Mail;
use App\Sms;
use App\SmsClient;
use App\Customer;
use App\Role;
use App\RoleUser;
use Spatie\Activitylog\Models\Activity;
use Artisan;
use App\PropertyChatHistory;
use App\Department;
use App\DNFBP;
use App\MultiProject;
use App\SchedulePlan;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Gate;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    protected $inventory;
    protected $statement;

    public function __construct()
    {
        $this->middleware('auth');
        $this->inventory = new Inventory();
        $this->statement = new CustomerStatement();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

   

    public function index(Request $request)
    { 
    
       
      $data = [];
       
      $data =
      $this->getCookieInfoAndMultiPro($request);
       
     
      if($data['status'] == 'error'){
        return redirect()
            ->route('projectswitch.index')
         
        ;
    } 
    $ids=[];
    if(is_array($data['project_ids'])){
        $ids=    $data['project_ids'];
       }
       else
       {
        $ids[]=    $data['project_ids'];
       }
    //  dd($ids);

        $user = User::find(Auth::user()->id);
        $role = Role::find($user->role->role_id);

        if (Gate::allows('has-permission', 'manage-procurement-dashboard'))  
     {
  //     return redirect()
  //     ->route('projectswitch.index')
   
  // ;
        return redirect()->route('dashboard1',['id' => $user->role->role_id]);
    }
    // elseif($user->can('manage-department-dashboard'))
    elseif (Gate::allows('has-permission', 'manage-department-dashboard'))  
     {
  //     return redirect()
  //     ->route('projectswitch.index')
   
  // ;
        $user = User::with('role')->find(Auth::user()->id);
         $department = Department::where([['role_id',$user->role->role_id]])->orderBy('id', 'DESC')->first();

         if($department)
            return redirect()->route('department.dashboard',['id' => $department->id]);
        else
            return redirect()->route('dashboard1',['id' => $user->role->role_id]);

    }
    // elseif(!$user->can('manage-procurement-dashboard') && !$user->can('manage-department-dashboard') && $role->name != 'admin' && $user->can('store-keeper'))
    
    
    elseif(!Gate::allows('has-permission', 'manage-procurement-dashboard') && !Gate::allows('has-permission', 'manage-department-dashboard') &&  !Gate::allows('has-role', 'admin') && Gate::allows('has-permission', 'store-keeper'))
    {
  //     return redirect()
  //     ->route('projectswitch.index')
   
  // ;
         return redirect()->route('manage.store.keeper.dashboard');
      
    }
    else {

      // dd($ids);
      
        $data['stats'] = $this->statement->getDashboardStats($ids);
        //current month due amounts
         
        $data['due'] = $this->statement->getDueAmount(null,$ids);

        $data['unitNumbers'] = Inventory::where([['is_deleted',false],
        ['status','!=',Inventory::open]])
        ->whereIn('multi_project_id', $ids)
        ->select('id','unit_number')->orderBy('unit_number','asc')->get();
        $data['customers'] = Customer::where('is_deleted',false)->select('id','name')->orderBy('name','asc')->get();
        $data['dealers'] = Dealer::where('is_deleted',false)->select('id','name','code')->orderBy('name','asc')->get();
        
      
        $data['statementCount'] = Customerproperty::where('is_deleted',false)
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
          $query->whereIn('multi_project_id', $ids);
                          })
        ->count();

        activity('View')->log('dashboard');

      
       
        if(isset($data['multipro_id'])){
          
          return view('home-update', $data);
      }
      else{
        // dd('1',$data);
        return view('home',$data);
      }
    }

    }

    public function getCookieInfoAndMultiPro($request){
      $data =  array();
      try{
         
        
          if($request->has('multipro_id')){
              
              if($request->multipro_id == 'all'){
                  $data['multipro_id'] =$request->multipro_id;
              }else if(!empty($request->multipro_id)){
              $data['multipro_id'] =  decrypt($request->multipro_id);
              }
          }
          
          
          $project_id = request()->cookie('current_project_id');
         
          $user = Auth::user();
          $data['multi_projects'] = [];
          if (!empty($project_id)) {
              $p_id = decrypt($project_id);
              $multi = MultiProject::where('id', $p_id)->first();
              $multiProjectId = $multi->id;
              if ($multi->name == "Super Admin") {
                
                  $roles = $user
                      ->roles()
                      ->where('name', 'like', 'admin')
                      ->whereHas('projects', function ($query) use ($multiProjectId) {
                          $query->where('multi_project_id', $multiProjectId);
                      })
                      ->first();
                       
                  if (!empty($roles)) {
                      $data['multi_projects']  = MultiProject::where('name', 'NOT like', 'Super Admin')->get();
                      $data['project'] = $multi->name;
                      $data['role'] = 'admin';
                      $data['project_ids'] =  'all';
                      $data['project_names'] = MultiProject::where('name', 'NOT like', 'Super Admin')->get()->pluck('name')->toArray();
                      if(isset( $data['multipro_id'])){
                          $data['project_ids'] = $data['multipro_id'];
                          if( $data['project_ids'] != 'all'){
                            $data['project_names'] = MultiProject::where('id',$data['project_ids'])->first('name')->toArray();
                       
                          
                        }
                          
                      }
                      $data['status'] = 'success';
                      return  $data;
                      
  
                  } else {
                      $request = app(Request::class);
                      if(!isset($request->permission)){
                       
                        $project_ids = $user->roles()
                        ->with(
                        
                        [
                            'projects' => function($query) {
                                // add conditions to the roles query here
                                $query->where('name', 'NOT like', 'Super Admin');
                            },
                            
                        ])
                         // Eager load the related 'projects' models
                        ->get()
                        ->pluck('projects.*.id') // Pluck the 'id' column from the related 'projects' models
                        ->flatten() // Flatten the collection of IDs into a single array
                        ->unique() // Filter out duplicates
                        ->toArray(); // Reset the array keys// Reset the array keys
                         
                      }
                      else{
               
                     $permission=decrypt($request->permission);
                      
                     $project_ids=       $user->roles()
                     ->whereHas('projects', function ($query)   {
                     $query->where('name', 'NOT like', 'Super Admin');
                     })
                     ->get()
                     ->filter(function ($r) use ($permission) {
                     return $r->hasPermission($permission);
                     })
                     ->pluck('projects.*.id') // Pluck the 'id' column from the remaining 'projects' models
                     ->flatten() // Flatten the collection of IDs into a single array
                     ->unique()
                     ->toArray()
                     ;
                     
                     if(sizeof($project_ids) == 0)
                     {
                         $data['status'] = 'error';
                         return  $data; 
                     }
                    }
                     
                      $data['multi_projects'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get();
                      $data['project'] = $multi->name;
                      $data['role'] = 'other';
                      $data['project_ids'] =  $project_ids;
                      $data['project_names'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get()->pluck('name')->toArray();
                      if(isset( $data['multipro_id'])){
                          if($data['multipro_id'] != 'all'){
                          $data['project_ids'] = $data['multipro_id'];
                          $data['project_names'] = MultiProject::where('id',$data['project_ids'])->first('name')->toArray();
                        
                          }
                       
                      }
                      $data['status'] = 'success';
                      return $data;
                  }
              }
              else{
               
                  $roles = $user
                      ->roles()
                      
                      ->whereHas('projects', function ($query) use ($multiProjectId) {
                          $query->where('multi_project_id', $multiProjectId);
                      })
                      ->first(); 
                  
                     
                      if(!empty($roles)) {
                          $data['multi_projects']  = [];
                          $data['project'] = $multi->name;
                          $data['role'] = 'other';
                          $data['project_ids'] =  $multi->id ;
                          $data['project_names'] = MultiProject::where('id',$data['project_ids'])->first('name')->toArray();
                           
                          if(isset( $data['multipro_id'])){
                              if($data['multipro_id'] != 'all'){
                                  $data['project_ids'] = $data['multipro_id'];
                                  }
                          }
                          $data['status'] = 'success';
                          return  $data;
                          
      
                      }
                      else{
                        $data['status'] = 'error';
                        return  $data;
                      }
              }
          }
          else
          {
              $data['status'] = 'error';
              return  $data; 
          }
      }
      catch(\Exception $e){
          $data['status'] = 'error';
          return  $data;
  
      }
  }
     public function getRecoveryDue(Request $request) 
     {
        //current month due amounts

      //   $request->merge([
      //     'multipro_id' =>'all',
           
      // ]);
      $data =
      $this->getCookieInfoAndMultiPro($request);
      if($data['status'] == 'error'){
        return redirect()

        ->back()
        ->with([
            'message' => 'Invalid Inputs!',
            'alert-type' => 'error',
        ]);
    }
      $ids=[];
      if(is_array($data['project_ids'])){
          $ids=    $data['project_ids'];
         }
         else
         {
          $ids[]=    $data['project_ids'];
         }
      
          

         $due_data=array();
      
        $due_data = $this->statement->getDueAmount(null,$ids);

       
        $total = 0;
        // dd($due_data);

        if(!empty($due_data['total']))
        {
            $total =  max($due_data['total']);
        }
        $data['max_due'] =  $total;
      // dd($due_data);
        activity('View')->log('Recovery due report');

        if(isset($data['multipro_id'])){
   
          return view('report.recovery-due-update',$data,$due_data);
      }
      else{
         
        return view('report.recovery-due',$data,$due_data);
      }
      
     }



    public function dnfbp()
    {
        $list_of_members = DNFBP::get();
        return view('dnfbp',compact('list_of_members'));
    }

   
    public function backup()
    {
      $DB_DATABASE= env('DB_DATABASE');
      $DB_USERNAME=env('DB_USERNAME');
      $DB_PASSWORD=env('DB_PASSWORD');
      $password="whoKnows?@usman";
      $string1=openssl_encrypt($DB_DATABASE,"AES-128-ECB",$password);
      $string2=openssl_encrypt($DB_USERNAME,"AES-128-ECB",$password);
      $string3=openssl_encrypt($DB_PASSWORD,"AES-128-ECB",$password);
      return Redirect::to(url('/backup.php?key1='.$string1.'&key2='.$string2.'&key3='.$string3.'')); 
    }

    function dnfbpValidateCnic(Request $request)
    {
        $cnic = $request->cnic;
        $dnfbp_check_point = DNFBP::where('cnic' , $cnic)->first();
        if ($dnfbp_check_point == true) 
        {
           echo json_encode(array('response' => 'invalid' ));
        }
    }
    

    public function adminProfile()
    {
        $admin = Auth::user();

        activity('View')->log('admin profile');

        return view('profile',compact('admin'));
    }

    public function editAdminProfile($id)
    {
        $admin = User::where('id',$id)->first();

        activity('Edit')->log('admin profile');

        return view('edit-profile',compact('admin'));
    }

    public function updateAdminProfile(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'string|max:255',
            'email' => 'required|string|email|max:255',
            'password' => 'nullable|string|min:6',
        ]);

         if ($validator->fails()) {
            return redirect('/admin/profile/'.$request->id.'/edit')
                        ->withErrors($validator)
                        ->withInput()
                   ->with([
                'message'    => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }

        User::where('id',$request->id)->update(['name'=>$request->name,
            'email'=>$request->email]);

        if($request->password !== null)
        {
            User::where('id',$request->id)->update(['password'=> bcrypt($request->password)]);

        }


        activity('Update')->log('profile updated');

        return redirect()
            ->route('admin.profile')
            ->with([
                'message'    => 'Profile updated Successfully!',
                'alert-type' => 'success',
            ]);
    }

    public function getInfoByFloor(Request $request) {
        return $this->inventory->getFloorInfo($request->floor);
    }

    public function allAccounts() {

        $allUsers = User::get();

        return view('Setting/account.index',compact('allUsers'));
    }

    public function addAccountForm() {

      $roles = Role::get();

        return view('Setting/account.add-account',compact('roles'));
    }

    public function insertAccount(Request $request) {

       $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'phone_number' => 'required|max:11|min:11|unique:users',
            'password' => 'required|string|min:6',
            'role' =>'required'
        ]);

       if ($validator->fails()) {
            return redirect('/account/add')
                        ->withErrors($validator)
                        ->withInput()
                   ->with([
                'message'    => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }

        $user = new User();

        $user->name = $request->name;
        $user->email = $request->email;
        $user->password = bcrypt($request->password);
        $user->phone_number = $request->phone_number;
        $user->save();


        foreach($request->role as $role) {
          $roleobj = Role::find($role);
          $user->roles()->attach($roleobj);
        }

        return redirect()
            ->route('account.all');
    }

    public function editAccountForm($id) {

      $roles = Role::get();

      $user = User::where('id',$id)->with('roles')->first();

      $selected_roles =array();
        foreach($user->roles as $r)
        {
            array_push($selected_roles, $r->id);
        }


      return view('Setting/account.edit-account',compact('roles','user','selected_roles'));
    }

    public function updateAccount(Request $request) {

       $validator = Validator::make($request->all(), [
           'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
            'phone_number' => 'required|max:11|min:11',
            //'password' => 'required|string|min:6',
            'role' =>'required'
        ]);

       if ($validator->fails()) {
            return redirect('/account/edit/'.$request->id)
                        ->withErrors($validator)
                        ->withInput()
                   ->with([
                'message'    => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }

       $input = $request->only('name', 'email', 'phone_number');

        $user = User::find($request->id);
        $user->update($input); //update the user info

        if($request->password !== null)
        {
            User::where('id',$request->id)->update(['password'=> bcrypt($request->password)]);

        }

        //delete all roles currently linked to this user
        DB::table('role_user')->where('user_id',$request->id)->delete();

        //attach the new roles to the user
        foreach ($request->input('role') as $key => $value) {
            $user->attachRole($value);
        }

        return redirect()
            ->route('account.all');
    }

    public function deleteAccount($id) {

      $user = User::where('id',$id)->first();

      User::where('id',$id)->delete();

      activity('Delete')->log('Account of ' . $user->name);

      return redirect()->back();
    }


    public function sendMessageForm() {
        
      $clients = Customer::select('id','name')->get();

      return view('customer.new-sms',compact('clients'));
    }

    public function sendMessage(Request $request) {

      //store sms in db and get id
      $message = Sms::create(['message'=>$request->message]);

      //store sms with clients id
      for($i = 0;$i < count($request->ids) ; $i++) {
            SmsClient::create(['message_id'=>$message->id,'client_id'=>$request->ids[$i]]);
      }

      //send sms to client on primary number
      $clients = Customer::whereIn('id',$request->ids)->get();
      
      foreach($clients as $c){
          if(strpos( $c->mobile_number, '0092' ) !== false ) {
                $number=$c->mobile_number;
            }
          else{
                $number="92".substr($c->mobile_number,1);
            }
            
          SmsController::sendSMS($number,$message->message);
          // $ch = curl_init("http://brandedsms.net//api/sms-api.php?username=omer&password=omer&phone=".$number."&sender=Step&message=".$message);
            // $result= curl_exec($ch);
      }

      activity('Send')->log('SMS to clients');

      return '1';
    }

    public function smsHistory() {

      $allMessages = Sms::orderBy('created_at','desc')->get();

      activity('view')->log('SMS History');

      return view('customer.sms-history',compact('allMessages'));
    }

    public function getActivityLog() {

      $data = array();
      
      $data['activity'] = Activity::with('user')->orderBy('created_at','desc')->paginate(50);
      $data['users'] = User::orderBy('name' , 'ASC')->get();
      return view('activity',$data);
    }

    public function getUserActivityLog(Request $request)
    {
      $user = $request->user;
      $from = $request->from;
      $to = $request->to;

      $data['activity'] = Activity::orderBy('created_at','desc')->where('causer_id' , $user)->whereDate('created_at', '>=', $from)->whereDate('created_at', '<=', $to)->paginate(50);

       $data['users'] = User::orderBy('name' , 'ASC')->get();

      return view('activity',$data);

    }

    public function getDownloadActivityLog() {

      $data = array();
      
      $data['activity'] = Activity::where('log_name','Download')->with('user')->orderBy('created_at','desc')->paginate(50);

      return view('download-activity',$data);
    }

    

    public function getBackup() {

      Artisan::call('backup:run',array('--only-files'=>true));

      $output = Artisan::output();

      dd($output);

      return redirect('/')->with([
                'message'    => 'Backup created Successfully!',
                'alert-type' => 'success',
            ]);
    }

    public function generateSchedule(Request $request) {

      
      if($request->unit_number_app)
        $data['inventory'] = Inventory::find($request->unit_number_app);

      $data['payment_schedule'] = $request;
// print_r($request->all());die;

      return view('schedule',$data);
    }

   public function getUpComingFollowUp() {
       
        $user = User::find(Auth::user()->id);
       
        $role = Role::find($user->role->role_id);
       
        if($role->name == 'admin')
        {

        $data['followUps'] = PropertyChatHistory::with(['property','user'])->whereHas('property.statement', function($q){
        $q->where([['due_date','<=',Carbon::now()->endOfMonth()],['balance','>',0]]);
        })->select("*")
        ->whereDate('next_follow_up', '>=', date('Y-m-d'))
        ->orderBy('created_at', 'desc')
        ->get()
        ->unique('property_id');
       
        }
        else
        {
          $data['followUps'] = PropertyChatHistory::with(['property','user','user_asign'])->whereHas('property.statement', function($q){
          $q->where([['due_date','<=',Carbon::now()->endOfMonth()],['balance','>',0]]);
          })->select("*")
          ->whereHas('user_asign', function($q){ $q->where('user_assign', '=', Auth::user()->id);
                })
          ->whereDate('next_follow_up', '>=', date('Y-m-d'))
          ->orderBy('created_at', 'desc')
          ->get()
          ->unique('property_id');
        }

        $data['followUps'] = $data['followUps']->sortBy('next_follow_up');

     
      return view('followup.upcoming',$data);
    }

      public function getExpiredFollowUp() {
       
        $user = User::find(Auth::user()->id);
       
        $role = Role::find($user->role->role_id);
       
        if($role->name == 'admin')
        {


        $data['followUps'] = PropertyChatHistory::with(['property','user','user_asign'])->select("*")
                            ->whereDate('next_follow_up', '<', date('Y-m-d'))
                            ->orderBy('created_at', 'desc')
                            ->get()
                            ->unique('property_id');
        }
       
        else
        {
           
        $data['followUps'] = PropertyChatHistory::with(['property','user','user_asign'])->select("*")
                            ->whereDate('next_follow_up', '<', date('Y-m-d'))
                            ->whereHas('user_asign', function($q){
                            $q->where('user_assign', '=', Auth::user()->id);
                            })
                            ->orderBy('created_at', 'desc')
                            ->get()
                            ->unique('property_id');
        }                        
       

        $data['followUps'] = $data['followUps']->sortBy('next_follow_up',true);

      return view('followup.expired',$data);
    }
   public function showFollowUpHistory(Request $request) {

        $data = array();
       
        $data['users'] = User::orderBy('id', 'desc')->get();
       
        $data['property'] = CustomerProperty::with('chatHistory')->where('id',$request->property_id)->first();

        return view('followup.chat-history-modal',$data);

    }

      public function deleteFollowUp(Request $request) {
       
        $data = array();
       
        $followup = PropertyChatHistory::where('id',$request->id)->first();
       
        PropertyChatHistory::where('id',$request->id)->delete();
       
       
        $data['users'] = User::orderBy('id', 'desc')->get();
       
        $data['property'] = CustomerProperty::with('chatHistory')->where('id',$followup->property_id)->first();

        return view('followup.chat-history-modal',$data);
    }

        public function todayFollowUp() {

        $user = User::find(Auth::user()->id);
       
        $role = Role::find($user->role->role_id);
       
        if($role->name == 'admin')
        {
            $data['today_followUps'] = PropertyChatHistory::with(['property','user','user_asign'])->select("*")
                            ->whereDate('next_follow_up', '=', date('Y-m-d'))
                            ->orderBy('created_at', 'desc')
                            ->get()
                            ->unique('property_id');
        }
        else
        {
           $data['today_followUps'] = PropertyChatHistory::with(['property','user','user_asign'])->whereHas('user_asign', function($q){
                            $q->where('user_assign', '=', Auth::user()->id);
                            })->select("*") ->whereDate('next_follow_up', '=', date('Y-m-d'))
                            ->orderBy('created_at', 'desc')
                            ->get()
                            ->unique('property_id');
        }
                   
       
        $data['today_followUps'] = $data['today_followUps']->sortBy('next_follow_up');

     
      return view('followup.today',$data);
    }
    
}
