<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\HrmEmployee;
use App\HrmCompanyDetail;
use App\HrmSetting;
use App\HrmAttendance;
use App\HrmEmployeeAttendanceSchedual;
use App\Imports\ImportAttendance;
use Illuminate\Support\Facades\Validator;
use Excel;
use Auth;
use DB;
use Carbon\Carbon;
class HrmAttendanceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $HrmEmployees =HrmEmployee::with(['companyDetail','accountDetail','docunmentDetail'])->orderBy('id','ASC')->get();

        $HrmEmployees =json_decode(json_encode($HrmEmployees));

        // echo "<pre>";

        // print_r($HrmEmployees);

        // die;
        activity('List')->log('Employee Attendance List');

 
        return view('hrm.add-attendances', compact('HrmEmployees'));
             
    }

    public function hrmSampleDownload()
    {
        $HrmEmployees =HrmEmployee::with('companyDetail')->where('status',1)->get();


        header("Content-type: text/csv");
        header("Content-Disposition: attachment; filename=result_file.csv");
        header("Pragma: no-cache");
        header("Expires: 0");
        ob_clean();


        $emply = array();
        $emply[] = array('name' , 'employ_code' , 'status' , 'date' , 'checkin' , 'checkout' , 'leave_type' );
        foreach ($HrmEmployees as $key => $value) 
        {
        $emply[] = array($value->name , $value->companyDetail->employee_code  );
        }

        $data = $emply;



        $this->outputCSV($data);

    }



function outputCSV($data) {
    $output = fopen("php://output", "w+");
    foreach ($data as $row) {
        fputcsv($output, $row);
    }
    fclose($output);
}

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    public function createinitialhrmsetting(Request $request)
    {
       
        
        $request->validate([
       'checkin' => 'required',
       'checkout' => 'required | after:checkin',
       'late_fine'=>'required',
        ]);

       
        $hrm_setting = new HrmSetting;
        
        $hrm_setting->checkin = $request->checkin;
        $hrm_setting->checkout = $request->checkout;
        $hrm_setting->late_fine = $request->late_fine;
        $hrm_setting->weekend_day =implode(',' , $request->day);
        $hrm_setting->save();

        activity('Create')->log('Hrm Attendance Setting');
        return redirect()->back()->with('success', 'Hrm Attendance Setting Success');
       // return view('hrm.hrm-setting', compact('hrm_setting'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

       
        $data = $request->all();

        $employee_id =  $data['employee_id'];

        $lims_hrm_setting_data = HrmSetting::latest()->first();
       
        $checkin = $lims_hrm_setting_data->checkin;

       
        DB::beginTransaction();

        try
        {


            foreach($employee_id as $id)
            {

                $date_of_joing = HrmCompanyDetail::where('employ_id',$id)->first()->date_of_joining;

                 if(  $data['date']  < $date_of_joing)
                 {

                    DB::rollback();
                    return redirect()->back()->with('success', 'Can not mark atendance because  Employee date of joining is Less then Attendance date .');
                   
                 }

               
                    $data['date'] = date('Y-m-d', strtotime(str_replace('/', '-', $data['date'])));
                    $data['user_id'] = Auth::id();
                    $data['present_absent'] = $data['status'];
                    $data['leave_type'] = $data['leave_type'];

                    $lims_attendance_data = HrmAttendance::whereDate('date', $data['date'])->where('employ_id', $id)->first();

                    if(!$lims_attendance_data)
                    {
                        $data['employ_id'] = $id;
                        $diff = strtotime($checkin) - strtotime($data['checkin']);
                        if($diff >= 0)
                        $data['status'] = 1;
                        else
                        $data['status'] = 0;


                    if( $data['present_absent']  == 0 || $data['present_absent']  == 2)
                    {
                        $data['checkin'] = null;
                        $data['checkout'] = null;
                    }

                    if( $data['present_absent']  == 0 || $data['present_absent']  == 1)
                    {
                        $data['leave_type'] = null;
                    }

                         HrmAttendance::create($data);
                    }
            }
             
              activity('Add')->log('Add Employee Attendance');

             DB::commit();
             return redirect()->back()->with('message', 'Attendance created successfully');

            }
             catch(\Exception $e)
            {
             DB::rollback();
             return redirect()->back()->with('success', 'Something went wrong.');
            }

    }


    /*Details of Employee Attendance */
   
    public function DetailofEmployeeAttendance(Request $request , $id = null)
    {

        $HrmEmployees =HrmEmployee::where('id',$id)->first();

        $month = Carbon::now()->month;
        $year = Carbon::now()->year;

        if ($request->month)
        {
            $month = $request->month;
        }

          if ($request->employee_id)
        {
              $id = $request->employee_id;
        }

          if ($request->year)
        {
             $year = $request->year;
        }

        $num_of_days=cal_days_in_month(CAL_GREGORIAN, $month, $year);
               

        $employee_attendance = HrmAttendance::where('employ_id',$id)->whereYear('date', $year)->whereMonth('date', $month)->orderBy('date' , 'ASC')->get();
       
        $presents = HrmAttendance::where('employ_id',$id)->where('present_absent' , 1)->whereYear('date', $year)->whereMonth('date', $month)->count();

        $leaves = HrmAttendance::where('employ_id',$id)->where('present_absent' , 2)->whereYear('date', $year)->whereMonth('date', $month)->count();

        $absents = HrmAttendance::where('employ_id',$id)->where('present_absent' , 0)->whereYear('date', $year)->whereMonth('date', $month)->count();

        $ontime = HrmAttendance::where('employ_id',$id)->where('status' , 1)->where('present_absent' , 1)->whereYear('date', $year)->whereMonth('date', $month)->count();

        $late = HrmAttendance::where('employ_id',$id)->where('status' , 0)->where('present_absent' , 1)->whereYear('date', $year)->whereMonth('date', $month)->count();

        $medical_leave = HrmAttendance::where('employ_id',$id)->where('leave_type' , 0)->whereYear('date', $year)->count();    

        $anual_leave = HrmAttendance::where('employ_id',$id)->where('leave_type' , 1)->whereYear('date', $year)->count();


        $other_leave = HrmAttendance::where('employ_id',$id)->where('leave_type' , 2)->whereYear('date', $year)->count();

        $special_leave = HrmAttendance::where('employ_id',$id)->where('leave_type' , 3)->whereYear('date', $year)->count();

        $weekend_leave = HrmAttendance::where('employ_id',$id)->where('leave_type' , 4)->whereYear('date', $year)->count();

       
        $year_ = date('Y' , strtotime($year));

        $leave_type = HrmEmployeeAttendanceSchedual::latest()->first();

        $employee_medical_leaves = $leave_type->medical_leave;
        $employee_anual_leaves = $leave_type->anual_leave;
        $employee_other_leaves = $leave_type->other_leave;
        $employee_special_leaves = $leave_type->special_leave;
        $employee_weekend_leaves = $leave_type->weekend;

        $lims_hrm_setting = HrmSetting::latest()->first();

        $offday = explode(',', $lims_hrm_setting->weekend_day);

        activity('Details')->log('Details Employee Attendance');
       
           return view('hrm.details-employee-attendance', compact('employee_attendance','HrmEmployees' , 'month' , 'year_' , 'presents' , 'leaves' , 'absents','ontime','late','employee_medical_leaves','employee_anual_leaves','employee_other_leaves','employee_special_leaves','employee_weekend_leaves','medical_leave','anual_leave','other_leave','special_leave','weekend_leave', 'num_of_days','offday'));
    }



    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {

       //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edithrmsetting()
    {     
       $hrm_setting = HrmSetting::latest()->first();
    
       activity('Edit')->log('Hrm Attendance Setting');
        return view('hrm.hrm-setting', compact('hrm_setting'));
       
       
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function updatehrmsetting(Request $request, $id)
    {
        //dd($request->all());
        $hrm_setting =HrmSetting::find($id);

       // dd($hrm_setting);
       
       
        $hrm_setting->checkin = $request->checkin;
        $hrm_setting->checkout = $request->checkout;
        $hrm_setting->late_fine = $request->late_fine;
        $hrm_setting->weekend_day =implode(',' , $request->day);
        $hrm_setting= $hrm_setting->save();

        if($hrm_setting){

                activity('Update')->log('Update Hrm Attendance Setting');
                return redirect()->back()->with('success' , 'Hrm Setting Updated Successfully!');
             }
             else{
                Session::flash('error','something wrong');
                return redirect()->back();
             }
    }

    /**
     * import attendance file.
     *
     * @param
     * @return \Illuminate\Http\Response
     */
    public function attendanceFileImport(Request $request)
    {

     // Excel::import(new ImportAttendance,request()->file('file'));
        $file = request()->file('file');

        if($file)
        {
                $employeeArr = $this->csvToArray($file);
                $newEmployeeArray = array();
                $lims_hrm_setting_data = HrmSetting::latest()->first();
                $checkin = $lims_hrm_setting_data->checkin;

                foreach ($employeeArr as $key => $value) 
                {   
                    $employe = HrmCompanyDetail::where('employee_code' ,  $value['employ_code'])->first();

                    if(  date('Y-m-d' , strtotime($value['date']))  < $employe->date_of_joing)
                    {

                        return   redirect()->back()
                        ->with(['message' => 'Can not mark atendance because  Employee date of joining is Less then Attendance date .',
                        'alert-type' => 'error']); 
                    }


                    /////////Status///////////////////////////
                    
                    if($value['status'] == 'absent')
                    {
                       $status = 0; 
                    }
                    elseif($value['status'] == 'leave')
                    {
                       $status = 2;  
                    }
                    else
                    {
                        $status = 1;
                    }

                    /////////Leave Type///////////////////////////


                    if($value['leave_type'] == 'medical')
                    {
                       $type = 0; 
                    }
                    elseif($value['leave_type'] == 'anual')
                    {
                       $type = 1;  
                    }
                    elseif($value['leave_type'] == 'special')
                    {
                       $type = 3;  
                    }
                    elseif($value['leave_type'] == 'weekend')
                    {
                       $type = 4;  
                    }
                     elseif($value['leave_type'] == 'other')
                    {
                       $type = 2;  
                    }
                    else
                    {
                        $type = null;
                    }



                    $lims_attendance_data = HrmAttendance::whereDate('date', date('Y-m-d' , strtotime($value['date'])))->where('employ_id', $employe->employ_id)->first();

                    if(!$lims_attendance_data)
                    {
                        
                        $diff = strtotime($checkin) - strtotime($value['checkin']);
                        if($diff >= 0)
                        $checkin_status = 1;
                        else
                        $checkin_status = 0;

                        $data = array('employ_id' =>$employe->employ_id , 'present_absent' => $status , 'user_id' => Auth::id(), 'date' =>  date('Y-m-d' , strtotime($value['date'])) , 'checkin' => $value['checkin'] , 'checkout' => $value['checkout'] , 'leave_type' =>  $type , 'status' => $checkin_status);


                         HrmAttendance::create($data);
                    }

                }


               
               return redirect()
                ->back()
                ->with(['message' => 'Employee Attendance added successfully!',
                'alert-type' => 'info']); 
        }

        else
        {
            return redirect()
                ->back()
                ->with(['message' => 'Please Upload File',
                'alert-type' => 'error']); 
        }
        
    }


    function csvToArray($filename = '', $delimiter = ',')
{
    if (!file_exists($filename) || !is_readable($filename))
        return false;

    $header = null;
    $data = array();
    if (($handle = fopen($filename, 'r')) !== false)
    {
        while (($row = fgetcsv($handle, 1000, $delimiter)) !== false)
        {
            if (!$header)
                $header = $row;
            else
                $data[] = array_combine($header, $row);
        }
        fclose($handle);
    }

    return $data;
}



    /*/////edit earning////////////*/
        public function attendanceEdit(Request $request)
        {      
         $id = $request->id;

         $HrmEmployeesAttendance = HrmAttendance::find($id);

         if ($HrmEmployeesAttendance == true)
            {

             $present_absent = $HrmEmployeesAttendance->present_absent;
             $date = $HrmEmployeesAttendance->date;
             $checkin = $HrmEmployeesAttendance->checkin;
             $checkout = $HrmEmployeesAttendance->checkout;
             $leave_type = $HrmEmployeesAttendance->leave_type;
             $atte_id = $HrmEmployeesAttendance->id;

             echo json_encode(array(

                'present_absent' => $present_absent,
                'date' => $date,
                'checkin' => $checkin,
                'checkout' => $checkout,
                'id' => $atte_id,
                'response' => 'yes',
                'leave_type' => $leave_type
             ));

            }

          activity('Attendance Edit')->log('Employee Attendance Edit');
        }


    // attendance update

    public function attendanceUpdate(Request $request)
    {  

      DB::beginTransaction();

        try
        {        
            $lims_hrm_setting_data = HrmSetting::latest()->first();

                $checkin = $lims_hrm_setting_data->checkin;

                $req_checkin = $request->checkin;

                $diff = strtotime($checkin) - strtotime($request->checkin);

                if($diff >= 0)
                $status = 1;
                else
                $status = 0;

            if( $request->status  == 1 )
            {
                HrmAttendance::where('id', $request->record_id)->update([
                'date' => $request->date, 'present_absent' => $request->status,
                'checkin' => $request->checkin, 'checkout' => $request->checkout,
                'status' => $status,          

                ]);                        
            }

            if( $request->status  == 0 )
            {  
                HrmAttendance::where('id', $request->record_id)->update([

                'date' => $request->date, 'present_absent' => $request->status,
                'checkin' => null, 'checkout' => null,
                'status' => null, 'leave_type' => null,

                ]);
             }          

              if( $request->status  == 2 )  
              {

                if($request->leave_type == 'null')

                    $leave_type = null ;

                 else

                    $leave_type = $request->leave_type ;
                 
                    HrmAttendance::where('id', $request->record_id)->update([

                    'date' => $request->date, 'present_absent' => $request->status,
                    'checkin' => null, 'checkout' => null,
                    'status' => null, 'leave_type' => $leave_type,

                 ]);
              }        


            activity('Update')->log('Update Employee Attendance');

            DB::commit();
            return redirect()
                 ->back()
                 ->with('success', 'Employee Attendance Update Successfully!');

        }
            catch(\Exception $e)
            {

            DB::rollback();
            return redirect()
                 ->back()
                 ->with('success', 'Something went wrong.');
            }
     }


        /*attendance delete*/

        public function attendanceDelete($id)
        {
          $attendance = HrmAttendance::find($id);

          $attendance->delete();

          activity('Delete')->log('Delete Employee Attendance');

          return redirect()->back()->with('message' , 'Employee Attendance Removed Successfully!');
        }

}
