<?php

namespace App\Http\Controllers;

use DB;
use Session;
use storage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\HrmEmployeeAttendanceSchedual;
use Illuminate\Support\Facades\Validator;

class HrmEmployeeAttendanceSchedualController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
         $att_shedual_plan_lists = HrmEmployeeAttendanceSchedual::orderBy('id', 'DESC')->first();

         activity('List')->log('Attendance Scheduale List');

         return view('hrm.attendance-schedual-plan-list', compact('att_shedual_plan_lists'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        activity('Create')->log('Create Attendance Scheduale'); 
        return view('hrm.attandance-schedual-plan');
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

       
         $validator = Validator::make($request->all(), [

            'medical_leave' => 'required',
            'anual_leave'   => 'required',
            'special_leave' => 'required',
            'other_leave'   => 'required',
            'weekend_leave' => 'required'
                   
        ]);
 

       if ($validator->fails()) {
            return redirect()->back()
                            ->withErrors($validator)
                            ->withInput();
        }

DB::beginTransaction();

   try {        

         $HrmEmployeeAttendanceSchedual = HrmEmployeeAttendanceSchedual::create([
                     'medical_leave' => $request->medical_leave,
                     'anual_leave' => $request->anual_leave,
                     'other_leave' => $request->other_leave,
                     'special_leave' => $request->special_leave,
                     'weekend' => $request->weekend_leave
                     
          ]);
  
           activity('Store')->log('Store Attendance Scheduale');

           DB::commit();
           return redirect()->route('schedual-plan.list')->with('success' , 'Schedual Plan Added Successfully!');
      

      } 
        catch (\Exception $e) 
      {
       DB::rollback();
      return redirect()->route('/itemsunit/add-itemsunit')->with('success' , 'Something went wrong.');
      }

    }



    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

       $att_shedual_plan_list = HrmEmployeeAttendanceSchedual::orderBy('id', 'DESC')->first();

       activity('Edit')->log('Edit Attendance Scheduale');  
         
         return view('hrm.edit-attendance-schedual-plan', compact('att_shedual_plan_list'));  
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $HrmEmployeeAttendanceSchedual =HrmEmployeeAttendanceSchedual::findorFail($id);
        
        $HrmEmployeeAttendanceSchedual->medical_leave = $request->medical_leave;
        $HrmEmployeeAttendanceSchedual->anual_leave = $request->anual_leave;
        $HrmEmployeeAttendanceSchedual->other_leave = $request->other_leave;
        $HrmEmployeeAttendanceSchedual->special_leave = $request->special_leave;
        $HrmEmployeeAttendanceSchedual->weekend = $request->weekend_leave;
       

        $HrmEmployeeAttendanceSchedual= $HrmEmployeeAttendanceSchedual->save();
        if($HrmEmployeeAttendanceSchedual){

               activity('Update')->log('Update Attendance Scheduale');
                return redirect()->route('schedual-plan.list')->with('success' , 'Schedual Plan Updated Successfully!');
             }
             else{
                Session::flash('error','something wrong');
                return redirect()->back();
             }

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
