<?php
namespace App\Http\Controllers;

use DB;
use Session;
use storage;
use App\User;
use App\Role;
use App\City;
use App\Country;
use Carbon\Carbon;
use App\Department;
use App\HrmSetting;
use App\HrmEmployee;
use App\HrmAttendance;
use App\HrmCompanyDetail;
use App\HrmEmployeeSalary;
use Illuminate\Http\Request;
use App\HrmEmployeeDocument;
use App\HrmBankAccountDetail;
use App\HrmEmployeeDeduction;
use App\HrmEmployeeTotalSalary;
use App\HrmEmployeeDesignation;
use App\HrmEmployeeEarningDeduction;
use Illuminate\Support\Facades\Auth;
use App\HrmEmployeeAttendanceSchedual;
use Illuminate\Support\Facades\Validator;
use App\HrmEmployeeMonthlyEarningDeduction;
use App\AllowanceTittle;
use App\DeductionTittle;
use App\HrmEmployeeLoan;
class HrmEmployeeController extends Controller
{

    public $HrmEmployeesDocuments;
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     
    public function index()
    {

        $HrmEmployees = HrmEmployee::with(['companyDetail', 'accountDetail', 'docunmentDetail'])
            ->orderBy('id', 'DESC')
            ->get();

        $HrmEmployees = json_decode(json_encode($HrmEmployees));

        activity('View')->log('View Employees List');

        return view('hrm.employee-sheet', compact('HrmEmployees'));
    }

    /*Hrm Deshboard*/
    public function getHrmDashboard()
    {

        $all_employees = HrmEmployee::count('name');

        $latest_employees = HrmEmployee::orderBy('id', 'desc')->take(3)
            ->get();

        $total_departments = Department::count('department_name');
        $all_departments = Department::orderBy('id', 'desc')->take(3)
            ->get();

        $month = Carbon::now()->month;
        $year = Carbon::now()->year;

        $total_earning = HrmEmployeeMonthlyEarningDeduction::where('type', 1)->sum('amount');

        $total_deduction = HrmEmployeeMonthlyEarningDeduction::where('type', 0)->sum('amount');

        $total_salries = 0;

        $total_salries = $total_earning - $total_deduction;

        $current_month_employees = HrmCompanyDetail::whereMonth('date_of_joining', $month)->count('employ_id');

        $total_monthly_salaries = HrmEmployeeMonthlyEarningDeduction::whereMonth('created_at', $month)->where('type', 1)
            ->sum('amount');

        $HrmEmployees = HrmEmployee::with(['companyDetail', 'accountDetail'])->orderBy('id', 'DESC')
            ->get();

        $HrmEmployees = json_decode(json_encode($HrmEmployees));

        activity('Hrm Dashbord')->log('View Hrm Dashbord');

        return view('hrm.hrm-dashboard', compact('all_employees', 'total_departments', 'all_departments', 'latest_employees', 'current_month_employees', 'month', 'total_monthly_salaries', 'total_salries', 'HrmEmployees'));
    }

    public function updateStatus(Request $request)
    {
        $id = $request->id;

        $employee_status = HrmEmployee::where('id', $id)->update(['status' => $request->status

        ]);

        activity('Update')
            ->log('Update Employee Status');

        return redirect()
            ->route('employee.sheet')
            ->with('success', 'Employee updated Successfully!');

    }

    /*get AppointmentLetter*/
    public function getAppointmentLetter()
    {

        activity('AppointmentLetter')
            ->log('Employee Appointment Letter');

        return view('hrm.employee-appointment-letter');

    }
    /*get transperLetter*/
    public function gettransperLetter(Request $request)
    {
        $month = Carbon::now()->month;
        $year = Carbon::now()->year;
        $amount = $request->total_amount;
        $check_no = $request->check_no;
        $account_no = $request->account_no;
;

        activity('Transper Letter')
            ->log('Employee Transper Letter');

        return view('hrm.transper-letter', compact('month', 'year', 'amount', 'check_no', 'account_no'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    /*show Department && country && City*/

    public function create()
    {
        
        $DepartmentLists = Department::orderBy('id', 'DESC')->get();

        $DesignationLists = HrmEmployeeDesignation::orderBy('id', 'DESC')->get();

        $roles = Role::orderBy('id', 'DESC')->get();

        $country = Country::orderBy('id', 'DESC')->get();
        
        $city = City::orderBy('id', 'DESC')->get();
        
        $employee_code = HrmCompanyDetail::orderBy('employee_code', 'DESC')->take(1)->pluck('employee_code');
        
        if(isset($employee_code[0])) {
            $last_employee_code = $employee_code[0] + 1;
        }else {
            $last_employee_code = 100;
        }
        
        activity('Create')
            ->log('Create Employee');

        return view('hrm.add-employee', compact('DepartmentLists', 'roles', 'country', 'city', 'DesignationLists', 'last_employee_code'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $validator = Validator::make($request->all() , [
            'name' => 'required|regex:/^[a-zA-Z\s,.-]+$/u', 
            'cnic' => 'unique:hrm_employees,cnic|required', 
            'gender' => 'required', 
            'dob' => 'required', 
            'phone_number' => 'required|unique:hrm_employees,phone_no', 
            'Resi_address' => 'required', 
            'per_address' => 'required', 
            'role_name' => 'required', 
            'email' => 'required|unique:hrm_employees,email',
            //'password' => 'required',
            'department' => 'required', 
            'salary_method' => 'required', 
            'salary' => 'required', 
            'designation' => 'required',
            'cnic' => 'unique:hrm_employees'
        ]);

        if ($validator->fails())
        {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }

        DB::beginTransaction();

        try
        {

            $HrmEmployee = HrmEmployee::create(['name' => $request->name, 'cnic' => $request->cnic, 'gender' => $request->gender, 'dob' => $request->dob, 'phone_no' => $request->phone_number, 'residential_address' => $request->Resi_address, 'pemanent_address' => $request->per_address, 'email' => $request->email, 'password' => $request->password, 'user_id' => $request->role_name

            ]);

            if ($HrmEmployee->id > 0)
            {
                if (!empty($request->employee_id))
                {

                    $HrmCompanyDetail = HrmCompanyDetail::create(['employee_code' => $request->employee_id, 'department' => $request->department, 'country' => $request->country, 'city' => $request->city, 'employ_id' => $HrmEmployee->id, 'date_of_joining' => $request->date_of_joing, 'monthly_salary' => $request->salary, 'salary_method' => $request->salary_method, 'designation' => $request->designation, 'contract_type' => $request->contract_type

                    ]);

                }
                if (!empty($request->account_no))
                {
                    $HrmBankAccountDetail = HrmBankAccountDetail::create(['account_holder_name' => $request->holder_name, 'bank_name' => $request->bank_name, 'branch_location' => $request->location, 'employ_id' => $HrmEmployee->id, 'account_no' => $request->account_no, 'bank_code' => $request->bank_code

                    ]);

                }

                if ($HrmEmployee->id > 0)
                {

                    $docs = array();

                    if ($request->file('file_certificate'))

                    {

                        /*print_r($request->file('file_certificate'));
                        
                            die();*/
                        $image = [];

                        $file = $request->file('file_certificate');

                        $image['name'] = str_replace(" ", "-", time() . pathinfo($file->getClientOriginalName() , PATHINFO_FILENAME));

                        $image['extension'] = $file->getClientOriginalExtension();
                        $image['name'] = $image['name'] . '.' . $image['extension'];

                        $certificate = $file->storeAs('certificates', $image['name'], 'public');

                        $docs['certificate'] = $certificate;

                    }

                    if ($request->file('file_resume'))

                    {

                        /*print_r($request->file('file_certificate'));
                        die();*/
                        
                        $image = [];

                        $file = $request->file('file_resume');

                        $image['name'] = str_replace(" ", "-", time() . pathinfo($file->getClientOriginalName() , PATHINFO_FILENAME));

                        $image['extension'] = $file->getClientOriginalExtension();
                        $image['name'] = $image['name'] . '.' . $image['extension'];

                        $resume = $file->storeAs('resumes', $image['name'], 'public');

                        $docs['resume'] = $resume;

                    }

                    if ($request->file('file_photo'))

                    {

                        $image = [];

                        $file = $request->file('file_photo');

                        $image['name'] = str_replace(" ", "-", time() . pathinfo($file->getClientOriginalName() , PATHINFO_FILENAME));

                        $image['extension'] = $file->getClientOriginalExtension();
                        $image['name'] = $image['name'] . '.' . $image['extension'];

                        $photo = $file->storeAs('photo', $image['name'], 'public');

                        $docs['photo'] = $photo;

                    }

                    $HrmEmployees = HrmEmployeeDocument::where('employ_id', $HrmEmployee->id)
                        ->first();

                    if ($HrmEmployees == true)
                    {
                        $HrmEmployees = HrmEmployeeDocument::where('employ_id', $HrmEmployee->id)
                            ->update($docs);
                    }
                    else
                    {
                        $docs['employ_id'] = $HrmEmployee->id;
                        $HrmEmployees = HrmEmployeeDocument::create($docs);
                    }

                }

            }
            else
            {

                return redirect()->route('employee.add')
                    ->with('error', 'Something went wrong!');

            }

            activity('Store')
                ->log('Store Employee');

            DB::commit();
            return redirect()
                ->route('employee.sheet')
                ->with('success', 'Employee Added Successfully!');

        }
        catch(\Exception $e)

        {

            DB::rollback();
            return redirect()->route('employee.add')
                ->with('success', 'Something went wrong.');
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
        
    }
    /*Hrm Employee Details*/
    public function detailhrmemployee(Request $request, $id = null)

    {

        $month = Carbon::now()->month;
        $year = Carbon::now()->year;

        if ($request->month)
        {
            $month = $request->month;
        }

        if ($request->employee_id)
        {
            $id = $request->employee_id;
        }

        if ($request->year)
        {
            $year = $request->year;
        }

        $HrmEmployees = HrmEmployee::with(['companyDetail', 'accountDetail', 'docunmentDetail'])->where('id', $id)->first();

        $HrmEmployeeDesignation = null;

        if (!empty($HrmEmployees->companyDetail))
        {

            $HrmEmployeeDesignation = HrmCompanyDetail::with(['designation'])->find($HrmEmployees
                ->companyDetail
                ->id);

            $HrmEmployeeDesignation = json_decode(json_encode($HrmEmployeeDesignation));

        }
        $HrmEmployeeDepartment = null;

        if (!empty($HrmEmployees->companyDetail))
        {
            $HrmEmployeeDepartment = HrmCompanyDetail::with(['department'])->find($HrmEmployees
                ->companyDetail
                ->id);
            $HrmEmployeeDepartment = json_decode(json_encode($HrmEmployeeDepartment));
        }

        $employee_document = HrmEmployeeDocument::where('employ_id', $id)->get();

        $HrmEmployeesallownces = HrmEmployeeSalary::where('employ_id', $id)->get();

        $HrmEmployeesdeductions = HrmEmployeeDeduction::where('employ_id', $id)->get();

        $total_calculated_monthly_earning = HrmEmployeeMonthlyEarningDeduction::where('employ_id', $id)->where('month', $month)->where('type', 1)
            ->sum('amount');

        $total_calculated_monthly_tax = HrmEmployeeMonthlyEarningDeduction::where('employ_id', $id)->where('month', $month)->sum('tax');

        $total_monthly_deduction = HrmEmployeeMonthlyEarningDeduction::where('employ_id', $id)->where('month', $month)->where('type', 0)
            ->sum('amount');

        $medical_leave = HrmAttendance::where('employ_id', $id)->where('leave_type', 0)
            ->count();

        $anual_leave = HrmAttendance::where('employ_id', $id)->where('leave_type', 1)
            ->count();

        $other_leave = HrmAttendance::where('employ_id', $id)->where('leave_type', 2)
            ->count();

        $special_leave = HrmAttendance::where('employ_id', $id)->where('leave_type', 3)
            ->count();

        $HrmEmployees = HrmEmployee::where('id', $id)->first();

        $num_of_days = cal_days_in_month(CAL_GREGORIAN, $month, $year);

        $employee_attendance = HrmAttendance::where('employ_id', $id)->whereYear('date', $year)->whereMonth('date', $month)->get();

        $lims_hrm_setting = HrmSetting::latest()->first();

        $offday = $lims_hrm_setting->weekend_day;
        $offday = explode(',', $offday);

        $presents = HrmAttendance::where('employ_id', $id)->where('present_absent', 1)
            ->whereYear('date', $year)->whereMonth('date', $month)->count();

        $leaves = HrmAttendance::where('employ_id', $id)->where('present_absent', 2)
            ->whereYear('date', $year)->whereMonth('date', $month)->count();

        $absents = HrmAttendance::where('employ_id', $id)->where('present_absent', 0)
            ->whereYear('date', $year)->whereMonth('date', $month)->count();

        $ontime = HrmAttendance::where('employ_id', $id)->where('status', 1)
            ->where('present_absent', 1)
            ->whereYear('date', $year)->whereMonth('date', $month)->count();

        $late = HrmAttendance::where('employ_id', $id)->where('status', 0)
            ->where('present_absent', 1)
            ->whereYear('date', $year)->whereMonth('date', $month)->count();

        $medical_leave = HrmAttendance::where('employ_id', $id)->where('leave_type', 0)
            ->whereYear('date', $year)->count();

        $anual_leave = HrmAttendance::where('employ_id', $id)->where('leave_type', 1)
            ->whereYear('date', $year)->count();

        $other_leave = HrmAttendance::where('employ_id', $id)->where('leave_type', 2)
            ->whereYear('date', $year)->count();

        $special_leave = HrmAttendance::where('employ_id', $id)->where('leave_type', 3)
            ->whereYear('date', $year)->count();

        $year_ = date('Y', strtotime($year));

        $leave_type = HrmEmployeeAttendanceSchedual::latest()->first();

        $employee_medical_leaves = $leave_type->medical_leave;
        $employee_anual_leaves = $leave_type->anual_leave;
        $employee_other_leaves = $leave_type->other_leave;
        $employee_special_leaves = $leave_type->special_leave;

        $already_exist = 0;

        $find = HrmEmployeeMonthlyEarningDeduction::where('employ_id', $id)->where('year', $year)->where('month', $month)->count();

        if ($find == 0)
        {
            $already_exist = 1;
        }

        activity('View')->log('View Employee Details');

        return view('hrm.details-employee', compact('HrmEmployees', 'HrmEmployeeDepartment', 'HrmEmployeeDesignation', 'employee_document', 'HrmEmployeesallownces', 'HrmEmployeesdeductions', 'employee_attendance', 'HrmEmployees', 'month', 'year_', 'presents', 'leaves', 'absents', 'ontime', 'late', 'employee_medical_leaves', 'employee_anual_leaves', 'employee_other_leaves', 'employee_special_leaves', 'medical_leave', 'anual_leave', 'other_leave', 'special_leave', 'num_of_days', 'offday', 'total_calculated_monthly_earning', 'total_monthly_deduction', 'total_calculated_monthly_tax', 'already_exist'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        
        $HrmEmployees = HrmEmployee::with(['companyDetail', 'accountDetail', 'earningDeduction'])->where('id', $id)->first();

        $HrmEmployeeDepartment = null;
        $HrmEmployeeCountry = null;
        $HrmEmployeeCity = null;

        $DesignationLists = HrmEmployeeDesignation::orderBy('id', 'DESC')->get();

        $HrmEmployeeDesignation = "";

        if (!empty($HrmEmployees->companyDetail))
        {

            $HrmEmployeeDesignation = HrmCompanyDetail::with(['designation'])->find($HrmEmployees
                ->companyDetail
                ->id);

            $HrmEmployeeDesignation = json_decode(json_encode($HrmEmployeeDesignation));

        }

        $DepartmentLists = Department::orderBy('id', 'DESC')->get();

        if (!empty($HrmEmployees->companyDetail))
        {

            $HrmEmployeeDepartment = HrmCompanyDetail::with(['department'])->find($HrmEmployees
                ->companyDetail
                ->id);

            $HrmEmployeeDepartment = json_decode(json_encode($HrmEmployeeDepartment));

        }

        $country = Country::orderBy('id', 'DESC')->get();

        if (!empty($HrmEmployees->companyDetail))
        {
            $HrmEmployeeCountry = HrmCompanyDetail::with(['country'])->find($HrmEmployees->companyDetail->id);

            $HrmEmployeeCountry = json_decode(json_encode($HrmEmployeeCountry));
        }

        $city = City::orderBy('id', 'DESC')->get();

        if (!empty($HrmEmployees->companyDetail))
        {
            $HrmEmployeeCity = HrmCompanyDetail::with(['city'])->find($HrmEmployees->companyDetail->id);

            $HrmEmployeeCity = json_decode(json_encode($HrmEmployeeCity));
        }

        $roles = Role::orderBy('id', 'DESC')->get();
        
        $HrmEmployeeRole = HrmEmployee::with(['role'])->find($HrmEmployees->id);

        $HrmEmployeeRole = json_decode(json_encode($HrmEmployeeRole));
        
        $employee_code = HrmCompanyDetail::orderBy('employee_code', 'DESC')->take(1)->pluck('employee_code');
        
        /*echo "<pre>";
        print_r($employee_code);
        exit;*/
        
        if($employee_code[0]) {
            $last_employee_code = $employee_code[0] + 1;
        }else {
            $last_employee_code = 100;
        }

        activity('Edit')->log('Edit Employee');
        
        return view('hrm.edit-employee', compact('HrmEmployees', 'HrmEmployeeDepartment', 'DepartmentLists', 'country', 'HrmEmployeeCountry', 'city', 'HrmEmployeeCity', 'roles', 'HrmEmployeeRole', 'DesignationLists', 'HrmEmployeeDesignation', 'last_employee_code'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $HrmEmployees = HrmEmployee::with(['companyDetail', 'accountDetail'])->where('id', $id)->first();

        $validator = Validator::make($request->all() , ['name' => 'required', 'cnic' => 'unique:hrm_employees,cnic,' . $id, 'gender' => 'required', 'dob' => 'required', 'phone_number' => 'required|unique:hrm_employees,phone_no,' . $id, 'Resi_address' => 'required', 'per_address' => 'required', 'role_name' => 'required', 'email' => 'required|unique:hrm_employees,email,' . $id,
        //'password' => 'required',
        

        ]);

        if ($validator->fails())
        {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }

        DB::beginTransaction();

        try
        {

            $HrmEmployee = HrmEmployee::where('id', $id)->update(['name' => $request->name, 'cnic' => $request->cnic, 'gender' => $request->gender, 'dob' => $request->dob, 'phone_no' => $request->phone_number, 'residential_address' => $request->Resi_address, 'pemanent_address' => $request->per_address, 'email' => $request->email, 'password' => $request->password, 'user_id' => $request->role_name

            ]);

            if ($id > 0)
            {
                if (!empty($request->employee_id))
                {
                    
                    $validator = Validator::make($request->all() , [
                        'department' => 'required', 
                        'salary_method' => 'required', 
                        
                    ]);

                    if ($validator->fails())
                    {
                        return redirect()
                            ->back()
                            ->withErrors($validator)->withInput();
                    }

                    $HrmCompanyDetail = HrmCompanyDetail::where('employ_id', $id)->first();
                    
                    
                    
                    if ($HrmCompanyDetail)
                    {
                        $HrmCompanyDetail = HrmCompanyDetail::where('employ_id', $id)->update(['employee_code' => $request->employee_id, 'department' => $request->department, 'country' => $request->country, 'city' => $request->city, 'date_of_joining' => $request->date_of_joing, 'monthly_salary' => $request->salary, 'salary_method' => $request->salary_method, 'designation' => $request->designation, 'contract_type' => $request->contract_type

                        ]);
                    }
                    else
                    {
                        
                        $HrmCompanyDetail = HrmCompanyDetail::create(['employee_code' => $request->employee_id, 'department' => $request->department, 'country' => $request->country, 'city' => $request->city, 'employ_id' => $id, 'date_of_joining' => $request->date_of_joing, 'monthly_salary' => $request->salary, 'designation' => $request->designation, 'contract_type' => $request->contract_type

                        ]);
                    }

                }
                if (!empty($request->account_no))
                {

                    $HrmBankAccountDetail = HrmBankAccountDetail::where('employ_id', $id)->first();

                    if ($HrmBankAccountDetail == true)
                    {
                        $HrmBankAccountDetail = HrmBankAccountDetail::where('employ_id', $id)->update(['account_holder_name' => $request->holder_name, 'bank_name' => $request->bank_name, 'branch_location' => $request->location, 'account_no' => $request->account_no, 'bank_code' => $request->bank_code

                        ]);
                    }
                    else
                    {
                        $HrmBankAccountDetail = HrmBankAccountDetail::create(['account_holder_name' => $request->holder_name, 'bank_name' => $request->bank_name, 'branch_location' => $request->location, 'employ_id' => $id, 'account_no' => $request->account_no, 'bank_code' => $request->bank_code]);
                    }
                }

                $docs = array();

                if ($id > 0)
                {

                    if ($request->file('file_certificate'))

                    {

                        $image = [];

                        $file = $request->file('file_certificate');

                        $image['name'] = str_replace(" ", "-", time() . pathinfo($file->getClientOriginalName() , PATHINFO_FILENAME));

                        $image['extension'] = $file->getClientOriginalExtension();
                        $image['name'] = $image['name'] . '.' . $image['extension'];

                        $certificate = $file->storeAs('certificates', $image['name'], 'public');

                        $docs['certificate'] = $certificate;

                    }

                    if ($request->file('file_resume'))

                    {

                        $image = [];

                        $file = $request->file('file_resume');

                        $image['name'] = str_replace(" ", "-", time() . pathinfo($file->getClientOriginalName() , PATHINFO_FILENAME));

                        $image['extension'] = $file->getClientOriginalExtension();
                        $image['name'] = $image['name'] . '.' . $image['extension'];

                        $resume = $file->storeAs('resumes', $image['name'], 'public');

                        $docs['resume'] = $resume;

                    }

                    if ($request->file('file_photo'))

                    {

                        $image = [];

                        $file = $request->file('file_photo');

                        $image['name'] = str_replace(" ", "-", time() . pathinfo($file->getClientOriginalName() , PATHINFO_FILENAME));

                        $image['extension'] = $file->getClientOriginalExtension();
                        $image['name'] = $image['name'] . '.' . $image['extension'];

                        $photo = $file->storeAs('photo', $image['name'], 'public');

                        $docs['photo'] = $photo;

                    }

                    $HrmEmployees = HrmEmployeeDocument::where('employ_id', $id)->first();

                    if ($HrmEmployees == true)
                    {
                        $HrmEmployees = HrmEmployeeDocument::where('employ_id', $id)->update($docs);
                    }
                    else
                    {
                        $docs['employ_id'] = $id;
                        $HrmEmployees = HrmEmployeeDocument::create($docs);
                    }

                }

            }
            else
            {

                return 'first you need to insert basic information';

            }

            activity('Update')->log('Update Employee');

            DB::commit();
            return redirect()
                ->route('employee.sheet')
                ->with('success', 'Employee updated  Successfully!');

        }
        catch(\Exception $e)

        {
            //dd($e);
            DB::rollback();
            return redirect()->route('employee.add')
                ->with('success', 'Something went wrong.');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $employee = HrmEmployee::findOrFail($id);

        $employeecompany = HrmCompanyDetail::where('employ_id', $id)->delete();

        $employeeaccount = HrmBankAccountDetail::where('employ_id', $id)->delete();
        $employee->delete();

        activity('Delete')
            ->log('Delete Employee');

        return redirect()
            ->route('employee.sheet')
            ->with('success', 'Employee Removed Successfully!');

    }

    public function deleteEmployeeDocument($id)
    {

        $employeeDocument = HrmEmployeeDocument::find($id);

        $employeeDocument->delete();

        activity('Delete')
            ->log('Delete Employee Document');

        return redirect()
            ->back()
            ->with('message', 'Employee Document Removed Successfully!');

    }

    public function documentInsert(Request $request)
    {
        $employeeDocument = HrmEmployeeDocument::where('id', $request->employee_id)
            ->first();

        if ($request->hasfile('file'))
        {

            $file = $request->file('file');
            $name = $request->employee_id . '-' . time() . '-' . $file->getClientOriginalName();

            $file->move(public_path() . '/storage/', $name);

            HrmEmployeeDocument::create(['employ_id' => $request->employee_id, 'certificate' => $name]);

        }

        if ($employeeDocument)
        {

            activity('Add')->log('employee document addedd' . $employeeDocument->name);
        }

        return redirect()
            ->back()
            ->with(['message' => 'employee document added successfully!', 'alert-type' => 'info']);
    }

    public function earningDeductionGetByAjax(Request $request)
    {
        if ($request->type == 'earning')
        {
            $titles = AllowanceTittle::orderBy('name', 'ASC')->get();
        }

        if ($request->type == 'deduction')
        {
            $titles = DeductionTittle::orderBy('name', 'ASC')->get();
        }

        if ($titles->count() > 0)
        {
            echo json_encode(array(
                'response' => 'yes',
                'output' => $titles
            ));
        }
    }

}

