<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use DB;
use Session;
use storage;
use App\HrmEmployee;
use App\HrmEmployeeLoan;
use App\HrmEmployeeLoanAdjusment;
use App\HrmEmployeeLoanAdvanceDocument;

class HrmLoanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

      $employees = HrmEmployee::orderby('id','DESC')->get();
   
       activity('View')->log('View Employees Loan List');

     return view('hrm.Loan.list', compact('employees'));


    }


    /*loan and advance Request Letter*/

    public function requestLetter(Request $request)
    {

      $employee_name =  $request->name; 
      $type =  $request->type; 
      $amount =  $request->amount; 

      $employees = HrmEmployee::orderby('id','DESC')->get();

      $employee_cnic = HrmEmployee::where('name', $employee_name)->first()->cnic;

         
      return view('hrm.Loan.letter',compact('employees','employee_name','employee_cnic','type','amount'));
    }


    public function documentInsert(Request $request)
    {   
          
        $employeeloanAdvanceDocument = HrmEmployeeLoanAdvanceDocument::where('id',$request->employee_id)->first();

        if ($request->hasfile('file')) 
        {

             $file = $request->file('file');
 
             $name = $request->employee_id .'-' .time(). '-' . $file->getClientOriginalName();

             $file->move(public_path() . '/storage/loanAdvanceDocument/', $name);

             HrmEmployeeLoanAdvanceDocument::create(['employ_id'=>$request->employee_id,'document_url'=>$name]);
           
         }

        if($employeeloanAdvanceDocument){

            activity('Add')->log('employee Loan and Advance document addedd' . $employeeloanAdvanceDocument->name);
        }

        return redirect()->back()->with([
                            'message' => 'employee Loan and Advance document added successfully!',
                            'alert-type' => 'info'
        ]);
    }


    /*delete loan and advance document*/

     public function deleteDocument($id)
    {

      $employeeDocument = HrmEmployeeLoanAdvanceDocument::find($id);
      
      $employeeDocument->delete();

      activity('Delete')->log('Delete Employee Loan & Advance Document');

      return redirect()->back()->with('message' , 'Employee Loan & Advance Document Removed Successfully!');
   
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {   
        $employees = HrmEmployee::orderby('name' , 'ASC')->get();
        activity('View')->log('View Loan Form');
        return view('hrm.Loan.add', compact('employees'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        
         $validator = Validator::make($request->all(), [
         'name' => 'required',
         'type' => 'required',
         'loan' => 'required',
         'date' => 'required',
         'payment_method' => 'required',
         'receipt_no' => 'required',
        //  'instrument_no' => 'required',

        ]);
        if($request->payment_method == 'Cheque' || $request->payment_method == 'Bank'){
            $validator = Validator::make($request->all(), [
             'instrument_no' => 'required',
               ]);
         }
     
       

        if ($validator->fails()) {
        return redirect()->back()
        ->withErrors($validator)
        ->withInput();
        }

        DB::beginTransaction();

        try {

         $total_loan = 0;
         
         $date1 = date('Y-m' , strtotime($request->date));

         $month = date('m' , strtotime($request->date));

         $year = date('Y' , strtotime($request->date));

         

         $data =   HrmEmployeeLoan::where('employ_id' , $request->name)->whereMonth('date' , $month)->whereYear('date' , $year)->where('type' , $request->type )->first();

         
         if($data)

         {
            $date = date('Y-m' , strtotime($data->date));

            $loan = $data->loan_amount;

            $type = $data->type;

            $total_loan = $loan + $request->loan;

            $remaning = $data->remaning;

            $total_remaning = $total_loan - $remaning; 

             

            if($date == $date1 && $type == $request->type)
            {

            $loan = HrmEmployeeLoan::where('employ_id' , $request->name)->whereMonth('date' , $month)->whereYear('date' , $year)->where('type' , $type )->update([
      
                'loan_amount' => $data->loan_amount + $request->loan, 
                'remaning' => $data->remaning +  $request->loan,          


        ]);
            } 

            else{

                $loan = HrmEmployeeLoan::create([
                 'employ_id' => $request->name,      
                 'type' => $request->type,      
                 'loan_amount' => $request->loan,      
                 'date' => $request->date,      
                 'remaning' => $request->loan,      
                 'payment_method' => $request->payment_method,      
                 'receipt_no' => $request->receipt_no,      
                 'notes' => $request->notes,      
                 'instrument_no' => $request->instrument_no,      

        ]);
            }   

         }

         else{

            $loan = HrmEmployeeLoan::create([
                 'employ_id' => $request->name,      
                 'type' => $request->type,      
                 'loan_amount' => $request->loan,      
                 'date' => $request->date,      
                 'remaning' => $request->loan,
                 'payment_method' => $request->payment_method,      
                 'receipt_no' => $request->receipt_no,      
                 'notes' => $request->notes, 
                 'instrument_no' => $request->instrument_no, 

                 ]);
             


         }


        activity('Store')->log('Store Employee Loan');

        DB::commit();
        return redirect()->route('list.loan')->with('success' , 'Loan Added Successfully!');


        } 
        catch (\Exception $e) 
        {
        DB::rollback();

        dd($e);
        return redirect()->route('add.loan')->with('success' , 'Something went wrong.');
        }
    

    }

    public function detailsLoan($id)
    {

       $employee_id = $id;

       $loan = HrmEmployeeLoan::where('employ_id', $id)->get();

       $employee_document = HrmEmployeeLoanAdvanceDocument::where('employ_id',$id)->get();

       activity('View')->log('Details Employee Loan');
       
       return view('hrm.Loan.details-loan', compact('loan' ,'employee_id','employee_document'));

    }

     public function detailsLoanAdvance($id,$employee_id)
     {
        

       $employee_name = HrmEmployee::where('id', $employee_id)->first()->name;


       $loan = HrmEmployeeLoan::where('id', $id)->first();

       


       activity('View')->log('Details Employee Loan & Advance');
       
       return view('hrm.Loan.details-loan-advance', compact('loan','employee_name'));

    }


    public function adjustmentLoan($id)
    {   
        $employees = HrmEmployee::orderby('name' , 'ASC')->get();

        $loan = HrmEmployeeLoan::where('id', $id)->first();


        activity('Adjustment')->log('Adjustment Employee Loan');

        return view('hrm.Loan.adjustment', compact('loan','employees'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {   

        $employees = HrmEmployee::orderby('name' , 'ASC')->get();

        $loan = HrmEmployeeLoan::where('id', $id)->first();


        activity('Edit')->log('Edit Employee Loan Tittle');

        return view('hrm.Loan.edit', compact('loan','employees'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
         'name' => 'required',
         'type' => 'required',
         'loan' => 'required',
         'date' => 'required',
         'payment_method' => 'required',      
         'receipt_no' => 'required',      
        
        ]);


        if ($validator->fails()) {
        return redirect('edit.loan.advance')
        ->withErrors($validator)
        ->withInput();
        }

        DB::beginTransaction();

        try {

        $loan = HrmEmployeeLoan::where('id',$id)->update([
        
         'employ_id' => $request->name,      
         'type' => $request->type,      
         'loan_amount' => $request->loan,      
         'date' => $request->date,      
         'remaning' => $request->loan,
         'payment_method' => $request->payment_method,      
         'receipt_no' => $request->receipt_no,      
         'notes' => $request->notes,      

        ]);




        activity('Update')->log('Update Employee Loan'.$request->type);

        DB::commit();
        return redirect()->route('detail.loan',[$request->name])->with('success' , 'Update'.$request->type .'Successfully!');


        } 
        catch (\Exception $e) 
        {
        DB::rollback();

        return redirect()->route('edit.loan.advance')->with('success' , 'Something went wrong.');
        }
    
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $loan = HrmEmployeeLoan::find($id);

        $loan->delete();

        activity('Delete')->log('Delete Employee Loan');

      return redirect()->route('list.loan')->with('message' , 'Employee Loan Removed Successfully!');
    }


    public function adjustmentLoanInsert(Request $request)
    {
        
        // return $request->all();
         $validator = Validator::make($request->all(), [
         'employee_id' => 'required',
         'date' => 'required',
         'loan_id' => 'required',
         'adjustment' => 'required',

        ]);
     

        if ($validator->fails()) {
         return redirect('adjustment.loan',['id'=>$request->employee_id])
        ->withErrors($validator)
        ->withInput();
        }

        DB::beginTransaction();

        try {

        $loan_adjustment = HrmEmployeeLoanAdjusment::create([
        'employ_id' => $request->employee_id,
        'date' => $request->date,            
        'loan_id' => $request->loan_id,         
        'adjustment_amount' => $request->adjustment,      

        ]);


        $loan = HrmEmployeeLoan::where('employ_id' , $request->employee_id)->first()->remaning;
         
         $remaning = $loan - $request->adjustment;

        $remaning_loan = HrmEmployeeLoan::where('id',$request->loan_id)->update([
        'remaning' => $remaning,     

        ]);

     
        activity('Store')->log('Store Employee Adjustment');

        DB::commit();
        return redirect()->route('detail.loan',['id'=>$request->employee_id])->with('success' , 'Adjustment Added Successfully!');


        } 
        catch (\Exception $e) 
        {
            //dd($e);
        DB::rollback();
        return redirect()->route('adjustment.loan',['id'=>$request->employee_id])->with('success' , 'Something went wrong.');
        }
    

    }

    public function loanReport()
    {
       $employees = HrmEmployee::orderby('name','DESC')->get();
   
       activity('Report')->log('Employees Loan Report');

     return view('report.hrm-loan-report', compact('employees')); 
    }


    /*get receipt*/

    public function getReceipt(Request $request ,$id)
    {
       
       $employee_id = $request->employ_id;

       $receipt_id = $request->id;


       $employee = HrmEmployee::where('id', $employee_id)->first();

       $receipt = HrmEmployeeLoan::where('id', $receipt_id)->first();

       activity('Receipt')->log('Details Employee Receipt');

      return view('hrm.Loan.receipt',compact('employee','receipt'));  
    }

    /*get reamining loan and advance*/
    public function remaningLoanAdvance(Request $request)
    {

        $employee_id = $request->employee_id;
        

        $type = $request->type;

        $remaning = HrmEmployeeLoan::where('employ_id', $employee_id)->where('type',$type)->sum('remaning');

        return $remaning;
    }

    public function loanAdvanceApproved(Request $request)
    {
        $id = $request->id;
        $loan_advance_approve = $request->is_approved;

        $employee_payroll = HrmEmployeeLoan::where('id',$id)->update(['is_approved' => $loan_advance_approve]);

        activity('approve')->log('Loan || Advance approved');

        return redirect()->route('detail.loan',['id'=>$request->employ_id])->with('success' , 'Loan || Advance approved!');


    }
}