<?php

namespace App\Http\Controllers;

use DB;
use Session;
use storage;
use App\User;
use App\Role;
use App\City;
use App\Country;
use App\Department;
use App\HrmSetting;
use App\HrmEmployee;
use App\HrmAttendance;
use App\HrmEmployeeLoan;
use App\HrmCompanyDetail;
use App\HrmEmployeeSalary;
use App\HrmEmployeeOvertime;
use App\HrmEmployeeDocument;
use Illuminate\Http\Request;
use App\HrmEmployeeDeduction;
use App\HrmBankAccountDetail;
use\App\HrmEmployeeCommission;
use App\HrmEmployeeTotalSalary;
use Illuminate\Support\Facades\Auth;
use App\HrmEmployeeEarningDeduction;
use Illuminate\Support\Facades\Validator;
use App\HrmEmployeeMonthlyEarningDeduction;


class HrmPayslipController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       $HrmEmployees =HrmEmployee::with(['companyDetail','accountDetail','earningDeduction'])->get();
     

        return view('hrm.employee-payslip', compact('HrmEmployees'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }
    

    public function payslipDetail(Request $request)
    {     

        $employee_id = $request->employe;
        $year = $request->year;
        $month = $request->month;


        $HrmEmployees=HrmEmployee::with(['companyDetail','accountDetail','docunmentDetail'])->where('id',$employee_id)->first();



        $HrmEmployee = HrmCompanyDetail::with(['department' , 'city'])->find($HrmEmployees->companyDetail->id);



        

         $from = HrmAttendance::where('employ_id',$employee_id)->whereYear('date', $year)->whereMonth('date', $month)->oldest('date')->first();

         if ($from == true) 
         {
             $from = $from->date;
         }

         $end = HrmAttendance::where('employ_id',$employee_id)->whereYear('date', $year)->whereMonth('date', $month)->latest('date')->first();

         if ($end == true) 
         {
             $end =$end->date;

         }


        $startTimeStamp = strtotime( $from);
        $endTimeStamp = strtotime($end);

        $timeDiff = abs($endTimeStamp - $startTimeStamp);

        $numberDays = $timeDiff/86400;  // 86400 seconds in one day

        // and you might want to convert to integer
        $numberDays = intval($numberDays);

      

        $absents = HrmAttendance::where('employ_id',$employee_id)->where('present_absent' , 0)->whereBetween('date' , [ $from,$end])->whereYear('date', $year)->whereMonth('date', $month)->count();

        $workingDay = ($numberDays  -  $absents);



        
        $HrmEmployeeDepartmentAndCity = json_decode(json_encode($HrmEmployee));

        $hrm_employee_deduction = HrmEmployeeDeduction::where([['employ_id' ,   $employee_id ]  ])->get();

        $hrm_employee_earning = HrmEmployeeSalary::where([['employ_id' ,   $employee_id ] ] )->get();

        $lates = HrmAttendance::where('employ_id',$employee_id)->where('status' , 0)->where('present_absent' , 1)->whereYear('date', $year)->whereMonth('date', $month)->count();

           $d=30; 


        $present_days = HrmAttendance::where('employ_id',$employee_id)->where('present_absent' , 1)->whereYear('date', $year)->whereMonth('date', $month)->count();

        $perday_salary = round($HrmEmployee->monthly_salary /  $d);

        $total_absent_fine = $perday_salary * $absents;


        $total_basic_salary = $perday_salary * $workingDay;




        $hrm_attandance_setting = HrmSetting::latest()->first();
       
        $late_fine = $hrm_attandance_setting->late_fine * $lates;


      $find = HrmEmployeeMonthlyEarningDeduction::where('employ_id',$employee_id)->where('year', $year)->where('month', $month)->count();
        if ($find == 0){

        $employee_deduction = new HrmEmployeeMonthlyEarningDeduction;
         $employee_deduction->employ_id = $employee_id;
         $employee_deduction->month= $month;
         $employee_deduction->year= $year;
         $employee_deduction->title='absent fine';
         $employee_deduction->amount= $total_absent_fine;
         $employee_deduction->type= 0;

         $employee_deduction->save();

        $employee_deduction = new HrmEmployeeMonthlyEarningDeduction;
         
         $employee_deduction->employ_id = $employee_id;
         $employee_deduction->month= $month;
         $employee_deduction->year= $year;
         $employee_deduction->title='late fine';
         $employee_deduction->amount=$late_fine;
         $employee_deduction->type= 0;

         $employee_deduction->save();

        foreach ($hrm_employee_earning as  $earning) {


        $employee_earning = new HrmEmployeeMonthlyEarningDeduction;

         $employee_earning->employ_id = $earning->employ_id;
         $employee_earning->month= $month;
         $employee_earning->year= $year;
         $employee_earning->basic_salary= $total_basic_salary;
         $employee_earning->title=$earning->allownace_title;
         $employee_earning->amount=$earning->allownace_amount;
         $employee_earning->type= 1;

         $employee_earning->save();

            
        }

        
        foreach ($hrm_employee_deduction as  $list) {


        $employee_deduction = new HrmEmployeeMonthlyEarningDeduction;

         $employee_deduction->employ_id = $list->employ_id;
         $employee_deduction->month= $month;
         $employee_deduction->year= $year;
         $employee_deduction->basic_salary= $total_basic_salary;
         $employee_deduction->title=$list->deduction_title;
         $employee_deduction->amount=$list->deduction_amount;
         $employee_deduction->type= 0;

         $employee_deduction->save();
            
            
        }
    }


    
          return view('hrm.payslip', 
            compact('HrmEmployees','HrmEmployeeDepartmentAndCity' , 'hrm_employee_deduction' , 'hrm_employee_earning' , 'month' , 'year' , 'total_absent_fine' , 'lates','absents' , 'late_fine','present_days','total_basic_salary'));

         }

       
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */


    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
