<?php
namespace App\Http\Controllers;

use DB;
use Session;
use storage;
use App\User;
use App\Role;
use App\City;
use App\Country;
use Carbon\Carbon;
use App\HrmSetting;
use App\Department;
use App\HrmEmployee;
use App\HrmTexcition;
use App\HrmAttendance;
use App\AllowanceTittle;
use App\DeductionTittle;
use App\HrmEmployeeLoan;
use App\HrmCompanyDetail;
use App\HrmEmployeeSalary;
use Illuminate\Http\Request;
use App\HrmEmployeeDocument;
use App\HrmEmployeeDeduction;
use App\HrmBankAccountDetail;
use App\HrmEmployeeTotalSalary;
use App\HrmEmployeeBenevolentFound;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\HrmEmployeeMonthlyEarningDeduction;
use App\HrmEmployeeBenevolentFoundsetting;
use App\HrmEmployeeLoanAdjusment;

class HrmSetsalaryController extends Controller
{
		
		/**
		 * Display a listing of the resource.
		 *
		 * @return \Illuminate\Http\Response
		 */
		
		public function index()
		{
		
		  $HrmEmployees = HrmEmployee::with(['companyDetail', 'accountDetail'])->get();


          activity('Salary')->log('Employees Salary List');

		  return view('hrm.employee-salary', compact('HrmEmployees' , 'employee_loans' ));
		
		}

		/**
		 * Show the form for creating a new resource.
		 *
		 * @return \Illuminate\Http\Response
		 */
		public function create()
		{
				//
		}

		public function sethrmemployeesalary($id)
		{
				
		 $HrmEmployees = HrmEmployee::with(['companyDetail', 'accountDetail', 'docunmentDetail'])->where('id', $id)->first();

         activity('Salary')->log('Set Employees Salary');

		 return view('hrm.setsalary', compact('HrmEmployees'));
		
		}

		/**
		 * Store a newly created resource in storage.
		 *
		 * @param  \Illuminate\Http\Request  $request
		 * @return \Illuminate\Http\Response
		 */

		public function employeesalary(Request $request)
		{

			
				$validator = Validator::make($request->all() , [

				'title' => 'required', 'amount' => 'required'

				]);
				if ($validator->fails())
				{
						return redirect()
								->back()
								->withErrors($validator)->withInput();
				}

				DB::beginTransaction();

				try
				{

						for ($i = 0;$i < count($request->title);$i++)
						{
							HrmEmployeeSalary::create(['employ_id' => $request->employee_id,

								'allownace_title' => $request->title[$i], 'allownace_amount' => $request->amount[$i],

							]);
						}
                        
                        activity('Add')->log('Add Employee Earning');
                        
						DB::commit();
						return redirect()->back()
								->with('success', 'Employee Earning Added Successfully!');

				}
				catch(\Exception $e)
				{
						DB::rollback();
						return redirect()->back()
								->with('success', 'Something went wrong.');
				}

		}

		/*Show All Employee Salary*/
		public function getAllEmployeesSalary(Request $request)

		{
				$month = Carbon::now()->month;
				$year = Carbon::now()->year;
				$employee = $request->employee_id;


				$arrayTotal = array();


				if ($request->month)
				{
						$month = $request->month;
				}

				if ($request->year)
				{
						$year = $request->year;
				}

			

				$total_monthly_earning = HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->where('type', 1);
					

				$total_monthly_deduction = HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->where('type', 0);

				$total_monthly_tax =  HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->sum('tax');
				

				$hrmemployees_salaries = HrmEmployee::with(['companyDetail']);


				$curent_year = $year;
				

				if (!empty($employee))
				{
					$total_monthly_earning = $total_monthly_earning->where('employ_id' , $employee);
					$total_monthly_deduction = $total_monthly_deduction->where('employ_id' , $employee);
					// $hrmemployees_salaries = $hrmemployees_salaries->where('id' , $employee);
				}

          $total_monthly_earning = $total_monthly_earning->sum('amount');


		  $total_monthly_deduction = $total_monthly_deduction->sum('amount');
           $hrmemployees_salaries =$hrmemployees_salaries->get();
          $hrmemployees_salaries =json_decode(json_encode($hrmemployees_salaries));
			$departments = Department::orderBy('department_name', 'ASC')->get();

			

			$dataList = array();

			foreach ($departments as $key => $department) 
			{
				$deprt = null;
		        $depart_id  = null;
			  foreach($hrmemployees_salaries as $employees_salary ) 
			  {
				if(!empty($employees_salary->company_detail->department)){
			  	 if ($employees_salary->company_detail->department->id == $department->id) 
			  	 {
			  	 	$deprt = $department->department_name;

			  	 	$depart_id = $department->id;

			  	 	$dataList[] = $employees_salary;

			  	 }
				}
			  }
                 
			  $arrayTotal[]  = array('department' => $deprt , 'deprt_id' => $depart_id , 'dataArray' => $dataList );

			}
			  
			$employees_salary_approved = HrmEmployeeMonthlyEarningDeduction::where([['month', $month],['year', $year],['is_approved', 1]])->groupBy(['employ_id','month' , 'year'])->get();

                activity('Salary List')->log('Employees Salary List');

				return view('hrm.all-employees-salary-list', compact('arrayTotal', 'month', 'curent_year', 'total_monthly_earning', 'total_monthly_deduction','total_monthly_tax','hrmemployees_salaries','department','employees_salary_approved'));

		}

		/*/////edit earning////////////*/
		public function earningEdit(Request $request)
		{
				$id = $request->id;
				$HrmEmployeesEarning = HrmEmployeeSalary::find($id);

				if ($HrmEmployeesEarning == true)
				{
						$title = $HrmEmployeesEarning->allownace_title;
						$amount = $HrmEmployeesEarning->allownace_amount;
						echo json_encode(array(
								'title' => $title,
								'id' => $HrmEmployeesEarning->id,
								'response' => 'yes',
								'amount' => $amount
						));
				}

          activity('Earning Edit')->log('Employee Earning Edit');
		}

		/*/////edit earning////////////*/
		public function deductionEdit(Request $request)
		{
				$id = $request->id;
				$HrmEmployeesDeduction = HrmEmployeeDeduction::find($id);

				if ($HrmEmployeesDeduction == true)
				{
						$title = $HrmEmployeesDeduction->deduction_title;
						$amount = $HrmEmployeesDeduction->deduction_amount;
						echo json_encode(array(
								'title' => $title,
								'id' => $HrmEmployeesDeduction->id,
								'response' => 'yes',
								'amount' => $amount
						));
				}

				activity('Deduction Edit')->log('Employee Deduction Edit');

		}
         /*Allownce Delete*/
		public function allowncedelete($id)
		{

				$HrmEmployeesallownce = HrmEmployeeSalary::findOrFail($id);

				$HrmEmployeesallownce->delete();

				activity('Delete')->log('Employee Allownce Delete');

				return redirect()
						->back()
						->with('success', 'Employee Removed Successfully!');
		}

		/*employee Deduction add*/

		public function employeededuction(Request $request)
		{

				$validator = Validator::make($request->all() , [

				'title' => 'required', 'amount' => 'required',

				]);
				if ($validator->fails())
				{
						return redirect()
								->back()
								->withErrors($validator)->withInput();
				}

				DB::beginTransaction();

				try
				{

						for ($i = 0;$i < count($request->title);$i++)
						{
								HrmEmployeeDeduction::create(['employ_id' => $request->employee_id, 'deduction_title' => $request->title[$i], 'deduction_amount' => $request->amount[$i],

								]);
						}
                       
                       activity('Add Deduction')->log('Employee Add Deduction');

						DB::commit();
						return redirect()->back()
								->with('success', 'Employee Deduction Added Successfully!');

				}
				catch(\Exception $e)
				{
						DB::rollback();
						return redirect()->back()
								->with('success', 'Something went wrong.');
				}
		}
        
        /*Employee Deduction Update*/
		public function employeeDeductionUpdate(Request $request)
		{

				$validator = Validator::make($request->all() , [

				'title' => 'required', 'amount' => 'required',

				]);

				if ($validator->fails())
				{
						return redirect()
								->back()
								->withErrors($validator)->withInput();
				}

				DB::beginTransaction();

				try
				{

						HrmEmployeeDeduction::where('id', $request->record_deduction_id)
								->update([

						'deduction_title' => $request->title, 'deduction_amount' => $request->amount,

						]);

                         activity('Update')->log('Update Employee Deduction');

						DB::commit();
						return redirect()
								->back()
								->with('success', 'Employee Deduction Update Successfully!');

				}
				catch(\Exception $e)
				{

						return redirect()->back()
								->with('success', 'Something went wrong.');
				}
		}
         
         /*Employee Earning Update*/
		public function employeeEarningUpdate(Request $request)
		{

				$validator = Validator::make($request->all() , [

				'title' => 'required', 'amount' => 'required',

				]);

				if ($validator->fails())
				{
				 return redirect()
				 ->back()
				 ->withErrors($validator)->withInput();
				}

				DB::beginTransaction();

				try
				{

						HrmEmployeeSalary::where('id', $request->record_id)
								->update([

						'allownace_title' => $request->title, 'allownace_amount' => $request->amount,

						]);

                        activity('Update')->log('Update Employee Earning');

						DB::commit();
						return redirect()
								->back()
								->with('success', 'Employee Earning Update Successfully!');

				}
				catch(\Exception $e)
				{

						DB::rollback();
						return redirect()->back()
								->with('success', 'Something went wrong.');
				}
		}

		/*show hrm employee deduction*/

		public function showemployeededuction($id)
		{

			$HrmEmployees = HrmEmployee::with(['companyDetail', 'accountDetail', 'docunmentDetail'])->where('id', $id)->first();

			$HrmEmployeesallownces = HrmEmployeeSalary::where('employ_id', $id)->get();

			$HrmEmployeesdeductions = HrmEmployeeDeduction::where('employ_id', $id)->get();
			
			activity('Show')->log('Show Employee Allowance & Deduction'); 

			return view('hrm.setsalary', compact('HrmEmployees', 'HrmEmployeesallownces', 'HrmEmployeesdeductions'));

		}

		/*hrm employee deduction delete*/

		public function deductiondelete($id)
		{

				$HrmEmployeededuction = HrmEmployeeDeduction::findOrFail($id);

				$HrmEmployeededuction->delete();

				activity('Delete')->log('Delete Employee Deduction');

				return redirect()
				    ->back()
					->with('success', 'Employee Deduction Removed Successfully!');
		}

		public function showemployeeovertime($id)
		{

				$HrmEmployees = HrmEmployee::with(['companyDetail', 'accountDetail', 'docunmentDetail'])->where('id', $id)->first();

				$HrmEmployees =json_decode(json_encode($HrmEmployees));

				$HrmEmployeesallownces = HrmEmployeeSalary::where('employ_id', $id)->get();

				$HrmEmployeesdeductions = HrmEmployeeDeduction::where('employ_id', $id)->get();

				$hrmAllowncesTitle = AllowanceTittle::orderBy('name' , 'ASC')->get();

				$hrmDeductionTitle = DeductionTittle::orderBy('name' , 'ASC')->get();				 
				activity('Set Salary')->log('Set Employees Salary');

				return view('hrm.setsalary', compact('HrmEmployees', 'HrmEmployeesallownces', 'HrmEmployeesdeductions' , 'hrmAllowncesTitle' , 'hrmDeductionTitle'));

		}

		/*Earning Deduction*/

		public function earningDeduction(Request $request)
		{

				$employee_id = $request->employee_id;
				$employee_year = $request->payslip_year;
				$employee_month = $request->payslip_month;
				$type = $request->loan_type;

				$HrmEmployee_monthly_salary = HrmCompanyDetail::where('employ_id', $employee_id)->get();

				$from = HrmAttendance::where('employ_id', $employee_id)->whereYear('date', $employee_year)->whereMonth('date', $employee_month)->oldest('date')->first();


				if ($from == true) 
				{
					$from = $from->date;
				}

				$end = HrmAttendance::where('employ_id',$employee_id)->whereYear('date', $employee_year)->whereMonth('date', $employee_month)->latest('date')->first();

       if ($end == true) 
       {
           $end =$end->date;

       }

        $startTimeStamp = strtotime( $from);
        
        $endTimeStamp = strtotime($end);

        $timeDiff = abs($endTimeStamp - $startTimeStamp);

        $numberDays = $timeDiff/86400;  // 86400 seconds in one day

        // and you might want to convert to integer
        $numberDays = intval($numberDays);

        $absents = HrmAttendance::where('employ_id',$employee_id)->where('present_absent' , 0)->whereBetween('date' , [ $from,$end])->whereYear('date', $employee_year)->whereMonth('date', $employee_month)->count();



        //$workingDay = ($numberDays  -  $absents);

        $workingDay = $numberDays;

         $d=30; 

        $present_days = HrmAttendance::where('employ_id',$employee_id)->where('present_absent' , 1)->whereYear('date', $employee_year)->whereMonth('date', $employee_month)->count();

        $lates = HrmAttendance::where('employ_id',$employee_id)->where('status' , 0)->where('present_absent' , 1)->whereYear('date', $employee_year)->whereMonth('date', $employee_month)->count();

        foreach ($HrmEmployee_monthly_salary as  $employee_salary) {
        	
        }


        $perday_salary = round($employee_salary->monthly_salary /  $d);



        $absent_fine = $absents * $perday_salary;

        $total_absent_fine = $perday_salary * $absents;

        $total_basic_salary = $perday_salary * $workingDay;


        $hrm_attandance_setting = HrmSetting::latest()->first();
       	

        $late_fine = $hrm_attandance_setting->late_fine * $lates;

        $tax =  HrmEmployeeMonthlyEarningDeduction::where('employ_id' , $employee_id)->where('month', $employee_month)->where('year', $employee_year)->sum('tax');

   	 

       if($type == 'Loan | Advance'){
       $remaning_loan = HrmEmployeeLoan::where('employ_id' , $employee_id)->sum('remaning');

       }else{
       	       $remaning_loan = HrmEmployeeLoan::where('employ_id' , $employee_id)->where('type' , $type )->sum('remaning');
       }

     

        //////////////////////////////////////////////////

        $earningArray = null;
				$deductionArray = null;

				$earning = HrmEmployeeSalary::where('employ_id', $employee_id)->get();

				$deduction = HrmEmployeeDeduction::where('employ_id', $employee_id)->get();

				if ($earning->count() > 0 ) 
				{
          $earningArray  = $earning;
				}

				if ($deduction->count() > 0 ) 
				{
          $deductionArray = $deduction;
				}


				echo json_encode(array(
					'response' => 'yes',
					'earning' => $earningArray,
					'deduction' => $deductionArray,
					'monthly_salary' => $total_basic_salary,
					'late_fine' => $late_fine,
					'absent_fine' => $absent_fine,
					'tax' => $tax,
					'remaning_loan' => $remaning_loan
				));
          
          activity('Earning Deduction')->log('Earning Deduction');
		}

		/*Update employee Earning and Deduction*/

		public function earningDeductionUpdate(Request $request)
		{   

			if(!empty($request->employee_id))
            {
                $employee_id = $request->employee_id;
            }
            else
            {
              $employee_id = $request->name;  
            }
            
			$year = $request->year;
			$month = $request->month;
			$already_exist = 0;

			

			    $HrmEmployees=HrmEmployee::with(['companyDetail','accountDetail','docunmentDetail'])->where('id',$employee_id)->first();



			    $HrmEmployees =json_decode(json_encode($HrmEmployees));

			    




        $HrmEmployee = HrmCompanyDetail::with(['department' , 'city'])->find($HrmEmployees->company_detail->id);

       



         $from = HrmAttendance::where('employ_id',$employee_id)->whereYear('date', $year)->whereMonth('date', $month)->oldest('date')->first();

         if ($from == true) 
         {
             $from = $from->date;
         }

         $end = HrmAttendance::where('employ_id',$employee_id)->whereYear('date', $year)->whereMonth('date', $month)->latest('date')->first();

         if ($end == true) 
         {
             $end =$end->date;

         }

        $startTimeStamp = strtotime( $from);
        $endTimeStamp = strtotime($end);

        $timeDiff = abs($endTimeStamp - $startTimeStamp);

        $numberDays = $timeDiff/86400;  // 86400 seconds in one day

        // and you might want to convert to integer
        $numberDays = intval($numberDays);

        $absents = HrmAttendance::where('employ_id',$employee_id)->where('present_absent' , 0)->whereBetween('date' , [ $from,$end])->whereYear('date', $year)->whereMonth('date', $month)->count();

       // $workingDay = ($numberDays  -  $absents);

        $workingDay = $numberDays;

       
        $HrmEmployeeDepartmentAndCity = json_decode(json_encode($HrmEmployee));

     
        $lates = HrmAttendance::where('employ_id',$employee_id)->where('status' , 0)->where('present_absent' , 1)->whereYear('date', $year)->whereMonth('date', $month)->count();

           $d=30; 


        $present_days = HrmAttendance::where('employ_id',$employee_id)->where('present_absent' , 1)->whereYear('date', $year)->whereMonth('date', $month)->count();

        $perday_salary = round($HrmEmployee->monthly_salary /  $d);

       
        $total_absent_fine = $perday_salary * $absents;


        $total_basic_salary = $perday_salary * $workingDay;

         
        $hrm_attandance_setting = HrmSetting::latest()->first();
       
        $late_fine = $hrm_attandance_setting->late_fine * $lates;


      $find = HrmEmployeeMonthlyEarningDeduction::where('employ_id',$employee_id)->where('year', $year)->where('month', $month)->count();


        if ($find == 0)
        {
        $already_exist = 1;	


        foreach ($request->earning_title as $key => $earning)
         {

         	HrmEmployeeMonthlyEarningDeduction::create([
							'employ_id' => $employee_id,
							'month'=> $month,
							'year'=> $year,
							/*'basic_salary'=> $total_basic_salary,*/
							'title'=> $earning,
							'amount'=> $request->earning_amount[$key],
							'type' => 1,
         	]);
        }


        foreach ($request->deduction_title as $key => $deduction)
         {

         		HrmEmployeeMonthlyEarningDeduction::create([
							'employ_id' => $employee_id,
							'month'=> $month,
							'year'=> $year,
							'title'=>$deduction,
							'amount'=>$request->deduction_amount[$key],
							'type' => 0,
         	]);

        }

    }

 

		$hrm_employee_deduction = HrmEmployeeMonthlyEarningDeduction::where([['employ_id' ,   $employee_id ] , ['type' , 0] , ['year' ,   $year] , ['month' , $month] ])->get();


		$hrm_employee_earning = HrmEmployeeMonthlyEarningDeduction::where([['employ_id' ,   $employee_id ] , ['type' , 1] ,['year' ,   $year ] , ['month' , $month] ] )->get();

		$texcition = HrmTexcition::get();


		$totalfind = HrmEmployeeMonthlyEarningDeduction::where('employ_id',$employee_id)->distinct()->count(['month' , 'year']);




		 $total_earning = 0;
             
        
          foreach($hrm_employee_earning as $list){
                 
             $total_earning += $list->amount; 
          
           }
         
		 $total_anual_salary = 0;
         $total_earning = $total_earning;
         $anual_salary = $total_earning * 12;
         $total_tax_amount = 0;
         $tax_slab = 0;

        foreach ($texcition as $key => $value) 
        {
          if ($anual_salary > $value->minimum  && $anual_salary < $value->maximum ) 
          {
              if ($value->deduct_percentage > 0) 
              {

                if ($value->no > 2 ) 
                {
                    $total_tax_amount = ($anual_salary - $value->minimum) * ($value->deduct_percentage / 100);

                    if ($value->deduct_amount > 0) 
                    {
                       $total_tax_amount = $total_tax_amount + $value->deduct_amount;
                    }
                }

                if ($value->no == 2 ) 
                {
                    $total_tax_amount = ($anual_salary - $value->minimum) * ($value->deduct_percentage / 100);
                }
               
                 $tax_slab = $value->no;
              }
          }
        }

        $total_tax_amount = $total_tax_amount/12;
        
        $benevolent_found = HrmEmployeeBenevolentFoundsetting::latest()->first();

        $bf = $benevolent_found->bf_fund;

        $employee_benevolent_found = ( $total_earning / 100 ) * $bf;


        // $employee_benevolent_found = $total_earning - $benevolent_found->bf_fund;

        // $bf = $benevolent_found->bf_fund;

         $search = HrmEmployeeBenevolentFound::where('employ_id',$employee_id)->where('year', $year)->where('month', $month)->whereNotNull('bf_fund')->count();



        if ($search == 0)
        {
         
         /*store employee Bf*/ 
        HrmEmployeeBenevolentFound::create([
							'employ_id' => $employee_id,
							'month'=> $month,
							'year'=> $year,
							'bf_fund'=>$employee_benevolent_found,
							'bf_fund_company_con'=>$employee_benevolent_found,
         	]);
        
          }

          $total_benevolent_found = HrmEmployeeBenevolentFound::where('employ_id',$employee_id)->sum('bf_fund');
          


        // dd($total_benevolent_found);
        // die();

        
         $search = HrmEmployeeMonthlyEarningDeduction::where('employ_id',$employee_id)->where('year', $year)->where('month', $month)->whereNotNull('tax')->count();

        
          $loan = $request->loan;
          $type = $request->type;



          
          $employee_id;

        if ($search == 0)
        {
          
        HrmEmployeeMonthlyEarningDeduction::create([
							'employ_id' => $employee_id,
							'month'=> $month,
							'year'=> $year,
							'tax'=>$total_tax_amount,
							'type' => 2,
         	]);
        
          

         
          while($loan > 0){
          	if ($type == 'Loan | Advance') {
          		$HrmEmployeeLoan = HrmEmployeeLoan::where([['employ_id',$employee_id],['remaning','>',0]])->first();

          	}else{
          		$HrmEmployeeLoan = HrmEmployeeLoan::where([['employ_id',$employee_id],['type',$type],['remaning','>',0]])->first();

          	}
          	$loan_id = $HrmEmployeeLoan->id;
          	$adj_type = $HrmEmployeeLoan->type;
          	$remaning = $HrmEmployeeLoan->remaning;
          	$loan = $loan - $remaning;
          	if($loan >= 0){
          		$HrmEmployeeLoan->remaning = 0;
          		$HrmEmployeeLoan->save();
          		$loan_adjustment = HrmEmployeeLoanAdjusment::create([

			      'employ_id' => $employee_id,
			      'date' => date('Y-m-d'),                    
			      'type' => $adj_type,                    
			      'adjustment_amount' => $remaning,      
			      'loan_id' => $loan_id,      

              ]);

          	}else{
          		$HrmEmployeeLoan->remaning = -$loan;
          		$HrmEmployeeLoan->save();
          		$loan_adjustment = HrmEmployeeLoanAdjusment::create([

			      'employ_id' => $employee_id,
			      'date' => date('Y-m-d'),
			      'type' => $adj_type,                    
			      'adjustment_amount' => $remaning + $loan,      
			      'loan_id' => $loan_id,      

              ]);

          	}

          }    

       }

       $HrmEmployeeLoan = HrmEmployeeLoanAdjusment::where('employ_id',$employee_id)->whereMonth('date' , $month)->whereYear('date' , $year)->sum('adjustment_amount');


       
       activity('Generate')->log('Generate Payslip');

	    return view('hrm.payslip', 
	            compact('HrmEmployees','HrmEmployeeDepartmentAndCity' , 'hrm_employee_deduction' , 'hrm_employee_earning' , 'month' , 'year' , 'total_absent_fine' , 'lates','absents' , 'late_fine','present_days','already_exist','total_basic_salary','texcition' , 'totalfind','total_tax_amount','tax_slab','employee_benevolent_found','total_benevolent_found','type','HrmEmployeeLoan'));
       
        
        
		}
 
        /*View Employee PaySlip*/       
		public function viewPaySlip(Request $request)
		{


		$employee_id = $request->employe;
		$year = $request->year;
		$month = $request->month;
		$already_exist = 1;
		$total_earning = 0;


		$HrmEmployees=HrmEmployee::with(['companyDetail','accountDetail','docunmentDetail'])->where('id',$employee_id)->first();

        $HrmEmployee = HrmCompanyDetail::with(['department' , 'city'])->find($HrmEmployees->companyDetail->id);

         $from = HrmAttendance::where('employ_id',$employee_id)->whereYear('date', $year)->whereMonth('date', $month)->oldest('date')->first();

         if ($from == true) 
         {
             $from = $from->date;
         }

         $end = HrmAttendance::where('employ_id',$employee_id)->whereYear('date', $year)->whereMonth('date', $month)->latest('date')->first();

         if ($end == true) 
         {
             $end =$end->date;

         }


        $startTimeStamp = strtotime( $from);
        $endTimeStamp = strtotime($end);

        $timeDiff = abs($endTimeStamp - $startTimeStamp);

        $numberDays = $timeDiff/86400;  // 86400 seconds in one day

        // and you might want to convert to integer
        $numberDays = intval($numberDays);

        $absents = HrmAttendance::where('employ_id',$employee_id)->where('present_absent' , 0)->whereBetween('date' , [ $from,$end])->whereYear('date', $year)->whereMonth('date', $month)->count();

        $workingDay = ($numberDays  -  $absents);
        
        $HrmEmployeeDepartmentAndCity = json_decode(json_encode($HrmEmployee));

        $lates = HrmAttendance::where('employ_id',$employee_id)->where('status' , 0)->where('present_absent' , 1)->whereYear('date', $year)->whereMonth('date', $month)->count();

        $d=30; 

        $present_days = HrmAttendance::where('employ_id',$employee_id)->where('present_absent' , 1)->whereYear('date', $year)->whereMonth('date', $month)->count();

        $perday_salary = round($HrmEmployee->monthly_salary /  $d);

        $total_absent_fine = $perday_salary * $absents;


        $total_basic_salary = $perday_salary * $workingDay;

        $hrm_attandance_setting = HrmSetting::latest()->first();
       
        $late_fine = $hrm_attandance_setting->late_fine * $lates;


      $hrm_employee_deduction = HrmEmployeeMonthlyEarningDeduction::where([['employ_id' ,   $employee_id ] , ['type' , 0] , ['year' ,   $year] , ['month' , $month] ])->get();

        $hrm_employee_earning = HrmEmployeeMonthlyEarningDeduction::where([['employ_id' ,   $employee_id ] , ['type' , 1] ,['year' ,   $year ] , ['month' , $month] ] )->get();

      activity('View')->log('View Payslip');

      return view('hrm.payslip', 
            compact('HrmEmployees','HrmEmployeeDepartmentAndCity' , 'hrm_employee_deduction' , 'hrm_employee_earning' , 'month' , 'year' , 'total_absent_fine' , 'lates','absents' , 'late_fine','present_days' , 'already_exist','total_basic_salary'));
       
        
        
		}
        
        /*Add Texcition*/

        public function addTaxcition()
		{
            activity('Add')->log('Add Taxcition');

			return view('hrm.add-texcition');	
		}
		
       
        /*store Texcition*/

		public function storeTaxcition(Request $request)
		{
			$validator = Validator::make($request->all(), [
			'slab_no' => 'required',
			'min_amount' => 'required',
			'max_amount' => 'required',
			'deduct_amount' => 'required',
			'deduct_per' => 'required'
			]);


			if ($validator->fails()) {
			return redirect()->back()
			->withErrors($validator)
			->withInput();
			}

			DB::beginTransaction();

			try {

			$itemsunit = HrmTexcition::create([
			'minimum' => $request->min_amount,
			'no' => $request->slab_no,
			'maximum' => $request->max_amount,
			'deduct_amount' => $request->deduct_amount,
			'deduct_percentage' => $request->deduct_per

			]);

             activity('Store')->log('Store Taxcition');

			DB::commit();
			return redirect()->route('show.texcition')->with('success' , 'Texcition  Added Successfully!');


			} 
			catch (\Exception $e) 
			{
			DB::rollback();
			return redirect()->route('add.texcition')->with('success' , 'Something went wrong.');
			}

				
		}

		/*Show Texcition list*/

		public function showTaxcition()
		{
			$texcition =HrmTexcition::orderBy('id','ASC')->get();
			
			activity('List')->log('List Taxcition');
        
            return view('hrm.texcition_schedual_list', compact('texcition'));
		}
         

         /*Edit Teacition*/


         public function editTaxcition($id)
          {
            
            $taxcition =HrmTexcition::find($id);

            activity('Edit')->log('Edit Taxcition');

            return view('hrm.edit-taxcition' ,compact('taxcition') );

           }

          /*Update Taxcition*/

          public function updateTaxcition(Request $request, $id)
          {


			$validator = Validator::make($request->all(), [
			        'slab_no' => 'required',
			        'min_amount' => 'required',
			        'max_amount' => 'required',
			        'deduct_amount' => 'required',
			        'deduct_per' => 'required'
			]);
 

			if ($validator->fails()) {
			return redirect()->back()
			                ->withErrors($validator)
			                ->withInput();
			}

			DB::beginTransaction();

			try {

			 $taxcition = HrmTexcition::where('id',$id)->update([
			            'minimum' => $request->min_amount,
			             'no' => $request->slab_no,
			             'maximum' => $request->max_amount,
			             'deduct_amount' => $request->deduct_amount,
			             'deduct_percentage' => $request->deduct_per
			             
			  ]);

             activity('Update')->log('Update Taxcition');
        
			DB::commit();
			return redirect()->route('show.texcition')->with('success' , 'Texcition  updated Successfully!');


			} 
			catch (\Exception $e) 
			{

			DB::rollback();
			return redirect()->route('edit.texcition')->with('success' , 'Something went wrong.');
			}


    }

        /*Delete taxtcition*/

        public function deleteTaxcition($id)
        {
           $taxt = HrmTexcition::find($id);

           $taxt->delete();

           activity('Delete')->log('Delete Taxcition');

           return redirect()->route('show.texcition')->with('success' , 'Taxt Removed Successfully!');

        }
        
//////////////////////////////////////////////////////////////////////////////////////////////
        /*Get Employee Payroll*/

        public function getEmployeePayroll()
        {
        	$month = Carbon::now()->month;
			$year = Carbon::now()->year;

			$hrmEmployees = HrmEmployee::with(['companyDetail', 'employeeEarningDeduction'])->get();

			$hrmEmployees =json_decode(json_encode($hrmEmployees));

			$total_monthly_earning = HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->where('type', 1);
					

				$total_monthly_deduction = HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->where('type', 0);

				$total_monthly_tax =  HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->sum('tax');
				


				$curent_year = $year;
				


				if (!empty($employee))
				{
					$total_monthly_earning = $total_monthly_earning->where('employ_id' , $employee);
					$total_monthly_deduction = $total_monthly_deduction->where('employ_id' , $employee);
				}

          $total_monthly_earning = $total_monthly_earning->sum('amount');
		  $total_monthly_deduction = $total_monthly_deduction->sum('amount');

			/*echo "<pre>";

			print_r($hrmEmployees);
			die;*/

        	return view('hrm.employee-payroll', compact('hrmEmployees','month','year','total_monthly_earning','total_monthly_deduction','total_monthly_tax'));
        }

      
		/**
		 * Update the specified resource in storage.
		 *
		 * @param  \Illuminate\Http\Request  $request
		 * @param  int  $id
		 * @return \Illuminate\Http\Response
		 */

		/*Employee Monthly Salary Update*/
		public function update(Request $request, $id)
		{
				
			$validator = Validator::make($request->all() , ['salary' => 'required',

			]);
			if ($validator->fails())
			{
					return redirect()
							->back()
							->withErrors($validator)->withInput();
			}

			DB::beginTransaction();

			try
			{

				$HrmCompanyDetail = HrmCompanyDetail::findOrFail($id)->update([

				'monthly_salary' => $request->salary

				]);


				activity('Update')->log('Update Employees Salary');

				DB::commit();
				return redirect()
				->back()
				->with('success', 'Employee Salary updated Successfully!');

			}
			catch(\Exception $e)
			{
				DB::rollback();
				return redirect()->back()
				->with('success', 'Something went wrong.');
			}

		}

		// show allowances Tittle Form

		public function showForm()
		{
           
			return view('hrm.Allowance.Addallowance');
		}

		// insert allowances Tittle Form

		public function insertAllowanceTittle(Request $request)
		{
			$validator = Validator::make($request->all(), [
			'title' => 'required',

			]);


			if ($validator->fails()) {
			return redirect('add.Allowance.title')
			->withErrors($validator)
			->withInput();
			}

			DB::beginTransaction();

			try {

			     $At = AllowanceTittle::create([
			           'name' => $request->title,      

			]);


			activity('Store')->log('Store Allowance Title');

			DB::commit();
			return redirect()->route('list.Allowance.title')->with('success' , 'Allowance Title Added Successfully!');


			} 
			catch (\Exception $e) 
			{
			DB::rollback();
			return redirect()->route('add.Allowance.title')->with('success' , 'Something went wrong.');
			}
		}

		
		
        // show Allowance Tittle  List

		public function getAllowanceTittle()
		{
          $Allowance_Tittles = AllowanceTittle::orderBy('name','DESC')->get();

          activity('View')->log('View Allowance Tittle  List '); 

		  return view('hrm.Allowance.allowance-list' , compact('Allowance_Tittles'));
		}

        // Edit Allowance Tittle  List
		public function edittAllowanceTittle($id)
		{
		 $allowance_tittle = AllowanceTittle::where('id', $id)->first();

		 activity('Edit')->log('Edit Allowance Tittle');

		 return view('hrm.allowance.allowance-edit', compact('allowance_tittle'));
		}



        // Update Allowance Title
		public function updatetAllowanceTittle(Request $request, $id)
		{  

			$validator = Validator::make($request->all(), [
			'title' => 'required',

			]);


			if ($validator->fails()) {
			return redirect('edit.Allowance.title')
			->withErrors($validator)
			->withInput();
			}

			DB::beginTransaction();

			try {

			$At = AllowanceTittle::where('id',$id)->update([
			'name' => $request->title,      

			]);


			activity('Update')->log('Update Allowance Title');

			DB::commit();
			return redirect()->route('list.Allowance.title')->with('success' , 'Allowance Title Update Successfully!');


			} 
			catch (\Exception $e) 
			{
			DB::rollback();
			return redirect()->route('add.Allowance.title')->with('success' , 'Something went wrong.');
			}
		}
        // Delete Allowance Title
		public function deleteAllowanceTittle($id)
		{
			$At =AllowanceTittle::find($id);

			$At->delete();

			activity('Delete')->log('Delete Allowance Title');

		    return redirect()->route('list.Allowance.title')->with('success' , 'Allowance title Removed Successfully!');
		}
        //View Deduction Title Form 
		public function showDeductionTittleForm()
		{
         activity('View')->log('View Deduction Title Form'); 
		 return view('hrm.Deduction.Add-deduction-tittle');
		}

        // View Deduction Tittle  List
		public function getDeductionTittle()
		{

            $Deduction_Tittles = DeductionTittle::orderBy('name','DESC')->get();

            activity('View')->log('View Deduction Tittle  List '); 

			return view('hrm.Deduction.list-deduction-tittle',compact('Deduction_Tittles'));
		}

    
        // insert Deduction Tittle  List
		public function insertDeductionTittle(Request $request)
		{
		 $validator = Validator::make($request->all(), [
		 'title' => 'required',

		]);


		if ($validator->fails()) {
		return redirect('add.deduction.title')
		->withErrors($validator)
		->withInput();
		}

		DB::beginTransaction();

		try {

		$D = DeductionTittle::create([
		'name' => $request->title,      

		]);


		activity('Store')->log('Store Deduction Title');

		DB::commit();
		return redirect()->route('list.deduction.title')->with('success' , 'Deduction Title Added Successfully!');


		} 
		catch (\Exception $e) 
		{
		DB::rollback();
		return redirect()->route('add.deduction.title')->with('success' , 'Something went wrong.');
		}
		}


		
        // Edit Deduction Tittle
		public function edittDeductionTittle($id)
		{
		$deduction_tittle = DeductionTittle::where('id', $id)->first();

		activity('Edit')->log('Edit Deduction Tittle');

		return view('hrm.Deduction.edit-deduction-tittle', compact('deduction_tittle'));
		}

        // Update Deduction Title
		public function updatetDeductionTittle(Request $request, $id)
		{
		 $validator = Validator::make($request->all(), [
		 'title' => 'required',

		]);


		if ($validator->fails()) {
		return redirect('edit.deduction.title')
		->withErrors($validator)
		->withInput();
		}

		DB::beginTransaction();

		try {

		  $D = DeductionTittle::where('id',$id)->update([
		  'name' => $request->title,      

		]);


		activity('Update')->log('Update Deduction Title');

		DB::commit();
		return redirect()->route('list.deduction.title')->with('success' , 'Deduction Title Update Successfully!');


		} 
		catch (\Exception $e) 
		{
		DB::rollback();
		return redirect()->route('edit.deduction.title')->with('success' , 'Something went wrong.');
		}
		}

		// Delete Deduction Title
		public function deleteDeductionTittle($id)
		{
		 $D =DeductionTittle::find($id);

		 $D->delete();

		 activity('Delete')->log('Delete Deduction Title');

		 return redirect()->route('list.deduction.title')->with('success' , 'Deduction title Removed Successfully!');
		}


	/*Pending payroll */
	
	public function salaryApprove(Request $request)
    {
      
        $month = Carbon::now()->month;
        $year = Carbon::now()->year;
        $employee = $request->employee_id;

     
        if ($request->month)
        {
         $month = $request->month;
        }

        if ($request->year)
        {
         $year = $request->year;
        }

         $all_employee_salary = HrmEmployeeMonthlyEarningDeduction::where([['month', $month],['year', $year],['is_approved', 0]])->groupBy(['employ_id','month' , 'year'])->get();


        $total_monthly_earning = HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->where('type', 1);


        $total_monthly_deduction = HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->where('type', 0);

        $total_monthly_tax =  HrmEmployeeMonthlyEarningDeduction::where('month', $month)->where('year', $year)->sum('tax');


        $hrmemployees_salaries = HrmEmployee::with(['employeeEarningDeduction', 'companyDetail']);

        $curent_year = $year;


        if (!empty($employee))
        {
        $total_monthly_earning = $total_monthly_earning->where('employ_id' , $employee);
        $total_monthly_deduction = $total_monthly_deduction->where('employ_id' , $employee);
        $hrmemployees_salaries = $hrmemployees_salaries->where('id' , $employee);
        }

        $total_monthly_earning = $total_monthly_earning->sum('amount');
        $total_monthly_deduction = $total_monthly_deduction->sum('amount');
        $hrmemployees_salaries =$hrmemployees_salaries->get();

 // echo "<pre>";

 //        print_r(json_decode(json_encode($hrmemployees_salaries)));

 //        die;
        //dd($total_monthly_earning);

      // $pending_payrolls = HrmEmployeeMonthlyEarningDeduction::where('is_approved' , 0)->groupBy(['month' , 'year','employ_id'])->get();

      // $total_pending_payrolls = $pending_payrolls->count();


        activity('Pending Payroll')->log('Employees Pending Payroll Details');

        return view('hrm.pending-payroll', compact('hrmemployees_salaries', 'month', 'curent_year', 'total_monthly_earning', 'total_monthly_deduction','total_monthly_tax','all_employee_salary'));
    }


    /*Pending payroll edit*/

    public function pendingPayrollEdit($year, $month , $id)
    {

     $year = $year;
     $month = $month;
     $employee_id = $id;

	$earnings = HrmEmployeeMonthlyEarningDeduction::where('employ_id' , $employee_id)->where('month', $month)->where('year', $year)->where('type', 1)->get(['id','title' , 'amount']);

	$loans = HrmEmployeeLoanAdjusment::where('employ_id' , $employee_id)->whereMonth('date', $month)->whereYear('date', $year)->first(['id','type','adjustment_amount']);


	$loan_advance_id = HrmEmployeeLoan::where('employ_id',$employee_id)->first();

     if ($loan_advance_id) {

     	$lon_adv_id = HrmEmployeeLoan::whereNotNull('employ_id')->where('employ_id' , $employee_id)->whereMonth('date', $month)->whereYear('date', $year)->first()->id;
     }

     else{
             $lon_adv_id = null;

     }
	

	

	$bf = HrmEmployeeBenevolentFound::where('employ_id' , $employee_id)->where('month', $month)->where('year', $year)->first(['id','bf_fund']);

	$deductions = HrmEmployeeMonthlyEarningDeduction::where('employ_id' , $employee_id)->where('month', $month)->where('year', $year)->where('type', 0)->get(['id','title' , 'amount']);




       activity('Edit Payroll')->log('Edit Employees Pending Payroll ');

        return view('hrm.edit-pending-payroll',compact('earnings','loans','deductions','bf','year','month','employee_id','lon_adv_id'));

    }


    public function pendingPayrollUpdate(Request $request , $employee_id)
    {
       	$month = $request->month;
       	$year = $request->year;

		foreach ($request->earning_title as $key => $earning)
		{

			$earning = HrmEmployeeMonthlyEarningDeduction::where('id', $request->id[$key])->update([
					'title' => $earning,
					'amount'=> $request->earning_amount[$key]
			]);

		}
	


         foreach ($request->deduction_title as $key => $deduction)
         {

         	$deduction = HrmEmployeeMonthlyEarningDeduction::where('id', $request->deduction_id[$key])->update([
							'title'=>$deduction,
							'amount'=>$request->deduction_amount[$key]
         	]);

        }

         $bf = HrmEmployeeBenevolentFound::where('id', $request->bf_id)->update([
         	
					'bf_fund'=>$request->bf,
					'bf_fund_company_con'=>$request->bf,
         	]);


         $loan = HrmEmployeeLoanAdjusment::where('id', $request->loan_id)->update([
         	
					'adjustment_amount'=>$request->adjustment_amount,
					
         	]);

         $lon_adv_amount = HrmEmployeeLoan::where('id' , $request->lon_adv_id)->where('employ_id',$employee_id)->whereMonth('date', $month)->whereYear('date', $year)->first()->loan_amount;

         $remaning = $lon_adv_amount - $request->adjustment_amount;

          $loan = HrmEmployeeLoan::where('id', $request->lon_adv_id)->update([
         	
					'remaning'=> $remaning,
					
         	]);
         	

 
       
			activity('Update ')->log('Update Pending Payroll Details');

			return redirect()->route('employee.salary.approve')->with('success' , 'Earning Deduction Update Successfully!');

    }


     public function pendingPayrollapproved(Request $request)
     {

      $id = $request->id;

      $approved = $request->is_approved;

      $employee_salary = HrmEmployeeMonthlyEarningDeduction::where('employ_id',$id)->update(['is_approved' => $approved]);

      $employee_salary = HrmEmployeeBenevolentFound::where('employ_id',$id)->update(['is_approved' => $approved]);
      
      $employee_salary = HrmEmployeeLoanAdjusment::where('employ_id',$id)->update(['is_approved' => $approved]);

      activity('Approved')->log('Pending Payroll Approved');

      return redirect()->route('employee.salary.approve')->with('success' , 'Pending Payroll Approved Successfully!');

    }


    // public function getPendingPayroll()
    // {
      
    //   //$total_pending_payrolls = HrmEmployee::where('is_approved', 0)->count('name');

    //   $pending_payrolls = HrmEmployeeMonthlyEarningDeduction::where('is_approved' , 0)->groupBy(['month' , 'year','employ_id'])->get();

    //   $total_pending_payrolls = $pending_payrolls->count();

    //   //print_r($total_pending_payrolls);

    //   return view('layouts.app',compact('total_pending_payrolls'));

      

    // }


}

