<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\InstallmentPlan;
use App\InstallmentPlanAttribute;

use App\UnitSize;
use App\ProductType;

class InstallmentPlanController extends Controller
{
    protected $plan;

    public function __construct() {
        $this->plan = new InstallmentPlan();
    }

    public function getInstallmentPlan() {
        $installmentPlan = InstallmentPlan::orderBy('created_at','desc')->get();

        return view('Setting/installment.index',compact('installmentPlan'));
    }

    public function addInstallmentPlanForm() {

        $types = ProductType::all();
        $sizes = UnitSize::all();

        return view('Setting/installment.add-plan',compact('types','sizes'));
    }

    public function insertInstallmentPlan(Request $request) {

        $validator = Validator::make($request->all(), [
                    'plot_type' => 'required',
                    'plot_size' => 'required',
                    'cost_amount'=>'required|numeric|min:1',
                    'down_payment'=>'required|numeric|min:1',
                    'confirmation_fee'=>'required|numeric|min:1',
                    'plot_belting_fee'=>'nullable|numeric',
                    'six_installment' => 'nullable|numeric',
                    'possession_fee'=>'required|numeric|min:1',
                    'installment'=>'required|numeric|min:1',
                    'total_months'=>'required|numeric|min:12',
                    'status'=>'required'
        ]);

        if ($validator->fails()) {
            return redirect('/installment-plan/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        $plan = $this->plan->createInstallmentPlan($request);


        return redirect()
                        ->route('installment.detail',['id'=>$plan->id])
                        ->with([
                            'message' => 'Installment Plan created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    public function detailInstallmentPlan($id) {

        $installment = InstallmentPlan::where('id',$id)->with('plotType','plotSize')->first();

        return view('Setting/installment.detail-plan',compact('installment'));
    }


    //show the edit Installment form
    public function editInstallmentPlanForm($id) {

        $types = ProductType::all();
        $sizes = UnitSize::all();

        $ins = InstallmentPlan::where('id', $id)->first();

        return view('Setting/installment.edit-plan', compact('ins','types','sizes'));
    }

    //update the Installment plan record
    public function updateInstallmentPlan(Request $request) {

         $validator = Validator::make($request->all(), [
                    'plot_type' => 'required',
                    'plot_size' => 'required',
                    'cost_amount'=>'required|numeric|min:1',
                    'down_payment'=>'required|numeric|min:1',
                    'confirmation_fee'=>'required|numeric|min:1',
                    'plot_belting_fee'=>'nullable|numeric',
                    'six_installment' => 'nullable|numeric',
                    'possession_fee'=>'required|numeric|min:1',
                    'installment'=>'required|numeric|min:1',
                    'total_months'=>'required|numeric|min:12',
                    'status'=>'required'
        ]);

        if ($validator->fails()) {
            return redirect('/installment-plan/edit/'.$request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        $this->plan->updateInstallmentPlan($request);


        return redirect()
                        ->route('installment.detail',['id'=>$request->id])
                        ->with([
                            'message' => 'Installment Plan updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    public function deleteInstallmentPlan($id){
        InstallmentPlan::where('id', $id)->delete();

        return redirect()->route('installment.all')->with([
                    'message' => 'Installment Plan deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }
}
