<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Item;
use App\Category;
use DB;
use Session;
use Carbon\Carbon;
use Illuminate\Validation\Rule;
use App\ItemPurchaseOrder;
use App\Department;
use App\Project;
use App\ItemRelease;
use App\PurchaseRequest;
use App\ItemReleaseData;
use App\ItemPurchaseRequest;
use App\ReceiptItem;
use App\ItemManufacture;
use App\Task;
use App\PurchaseRequestBoqItem;
use App\ItemUnit;
use App\FixedAssetType;
use App\FixedAsset;
use App\HrmEmployee;
use App\AssetRelease;
use App\AssetLocation;
use App\MaterialIssueRequest;
use App\AssetMaintainance;
use DateTime;
use App\FixedAssetForSale;
use App\FixedAssetAccount;
use App\MaterialIssueRequestData;
use App\MaterialRequestApproval;
class ItemController extends Controller
{
    
public function __construct()
{
           
}

function index()
{

    $approvalCount = array();
    $cancelCount = array();

    $mirs = MaterialIssueRequest::where('status' , 'pending')->get();
    $itemList = Item::orderBy('id', 'DESC')->get();
    $departments = Department::orderBy('department_name')->get();
    $purchase_requests = PurchaseRequest::where('status'  , 7)->orderBy('id')->get();

    foreach($mirs as $list)
    {
        $approvalCount[$list->id] = MaterialRequestApproval::where('mir_id' , $list->id)->where('is_approve' , MaterialRequestApproval::upapprove) ->count();
        $cancelCount[$list->id] = MaterialRequestApproval::where('mir_id' , $list->id)->where('is_approve' ,  MaterialRequestApproval::cancel) ->count();
    }

    return view('procurement/items.index' ,compact('itemList' , 'mirs' , 'departments' , 'purchase_requests','approvalCount','cancelCount'));
}

function fixedAssetItems()
{
   
    $fixed_asset_types = FixedAsset::with(['item' , 'asset_type'])
    ->orderBy('name' , 'ASC')
    ->get();

    $fixed_asset_types = json_decode(json_encode( $fixed_asset_types));

    return view('procurement/items.fixed-items.index' ,compact( 'fixed_asset_types'));
}


public function viewFixedAsset($id = null)
{
     $fixed_asset = FixedAsset::with(['item' , 'asset_type'])
    ->where('id' , $id)
    ->first();
     $fixed_asset = json_decode(json_encode( $fixed_asset));

     $assignees  = AssetRelease::where('asset_id' , $id)->get();

     return view('procurement/items.fixed-items.view' ,compact( 'fixed_asset' , 'assignees'));
}

function create()
{
    $parent_category = Category::orderBy('category_name', 'ASC')->get();
    $manufacture_list = ItemManufacture::orderBy('id', 'DESC')->get();
    $item_units = ItemUnit::orderBy('id', 'DESC')->get();
     
    return view('procurement/items.addItem' ,compact('parent_category','manufacture_list' , 'item_units'));
}

function createFixedAsset()
{
    $items = Item::where('type' , 'tools')->orderBy('item_name', 'ASC')->get();
    $fixed_asset_types = FixedAssetType::orderBy('name' , 'ASC')->get();
    $asset_locations = AssetLocation::orderBy('id', 'DESC')->get();
     
    return view('procurement/items.fixed-items.create' ,compact('items' , 'asset_locations' , 'fixed_asset_types'));
}


function store(Request $request)
{

       $validator = Validator::make($request->all(), [
                    'itemcode' => 'required|unique:items,item_code',
                    'name' => 'required|unique:items,item_name',
                    'name' => 'required',
                    'brand' => 'required',
                    'type' => 'required',
                    'unit' => 'required',
                    'storage_type' => 'required',
                    'category' => 'required|integer',
                    'minqty' => 'required|between:0,99999.99|min:1',
                    'maxqty' => 'required|between:0,99999.99|min:1',
                    'quantity' => 'required|between:0,99999.99|min:0'
        ]);


            if ($validator->fails()) {
            return redirect('/items/add-item')
            ->withErrors($validator)
            ->withInput();
            }

            if($request->quantity > $request->maxqty)
            {
            return redirect('/items/add-item')
            ->withInput()
            ->with('quantity', 'Quantity Not be greater than maximum quantity.');;
            }


            if($request->minqty > $request->maxqty)
            {
            return redirect('/items/add-item')
            ->withInput()
            ->with('minquantity', 'Quantity Not be greater than maximum quantity.');;
            }

         Item::create([

                    'item_code' => $request->itemcode,
                    'item_name' => $request->name,
                    'manufacture_id' => $request->brand,
                    'category_id' => $request->category,
                    'unit' => $request->unit,
                    'minqty' => $request->minqty,
                    'maxqty' => $request->maxqty,
                    'description' => $request->description,
                    'quantity' => $request->quantity,
                    'type' => $request->type,
                    'size' => $request->size,
                    'risk_type' => $request->storage_type,
          ]);
        
        return redirect()->route('item.list')->with('success' , 'Item Added Successfully!');
}



function storeFixedAsset(Request $request)
{


       $validator = Validator::make($request->all(), [
                    'asset_tag' => 'required|unique:fixed_assets,asset_tag',
                    'name' => 'required',
                    'items' => 'required',
                    'warranty' => 'required',
                    'purchase_date' => 'required',
                    'asset_location' => 'required',
                    'serial' => 'required',
                    'cost' => 'required',
                    'asset_type' => 'required',
                  
        ]);


            if ($validator->fails())
             {
                return redirect('/items/add-fixed-asset')
                ->withErrors($validator)
                ->withInput();
            }



            $total_items = FixedAsset::where('item_id' , $request->items)->count();

            $item_available_quantity = 0;

            $item_available_quantity = Item::where('id' , $request->items)->first()->quantity;

               if ($item_available_quantity == true) 
               {
                   $item_available_quantity = $item_available_quantity;
               }
            


            if(( $item_available_quantity - $total_items ) <= 0 )
            {
            return redirect('/items/add-fixed-asset')
            ->withInput()
            ->with('quantity', 'You already added '. $total_items.' items. you have 0 quantity left.');
            }


            DB::beginTransaction();

            try {

               $fixed_asset =   FixedAsset::create([
                    'asset_tag' => $request->asset_tag,
                    'name' => $request->name,
                    'item_id' => $request->items,
                    'asset_location' => $request->asset_location,
                    'warranty' => $request->warranty,
                    'cost' => $request->cost,
                    'purchase_date' => $request->purchase_date,
                    'serial' => $request->serial,
                    'description' => $request->description,
                    'asset_type' => $request->asset_type,
                   
          ]);

          DB::commit();
        
        return redirect()->route('fixed.assets')->with('success' , 'Asset Added Successfully!');

      } 
        catch (\Exception $e) 
      {
        DB::rollback();

        echo json_encode(array('response' => 'invalid' , 'message' => 'Something Went Wrong Data Not Updated.'));
      }
}

public function getEmployeeList()
{
   $employees =  HrmEmployee::orderBy('name' , 'ASC')->get();

   echo json_encode(array('response' => 'yes' , 'output' =>   $employees));
}

public function getAssignEmployeeList(Request $request)
{
    $asset_id = $request->id;

    $fixed_asset = AssetRelease::where('asset_id' , $asset_id)->where('assign_status' , 1)->first();

    $employees =  HrmEmployee::where('id' , '!=' , $fixed_asset->employee_id)->orderBy('name' , 'ASC')->get();

   $employee = HrmEmployee::find($fixed_asset->employee_id);

   echo json_encode(array('response' => 'yes' , 'output' =>  $employees , 'name' => $employee->name , 'employee_id' => $employee->id));
}

public function assignAssetWithEmploye(Request $request)
{
    $asset_id = $request->asset_id;
    $employee_id = $request->employee_id;


 DB::beginTransaction();

   try {

        AssetRelease::create([
        'employee_id' => $employee_id,
        'assign_date' => date('Y-m-d'),
        'asset_id' =>  $asset_id,
        'assign_status' => 1,
        ]);

        $fixed_asset =   FixedAsset::where('id' , $asset_id)->update([
            'status' => 'in_use',
        ]);

         DB::commit();

         echo 'ok';
      } 
        catch (\Exception $e) 
      {
       DB::rollback();
   
      }
}

public function assignReAssetWithEmploye(Request $request)
{
    $asset_id = $request->asset_id;
    $employ_id_to_assign = $request->employ_id_to_assign;
    $employee_id = $request->employee_id;
    $in_storage = $request->in_storage;


    DB::beginTransaction();

   try {

        AssetRelease::where('employee_id' , $employ_id_to_assign)->where('asset_id' , $asset_id)->where('assign_status' , 1)->update([
        'till_date' => date('Y-m-d'),
        'assign_status' => 0,
        ]);

        if ($in_storage == 'false') 
        {
           AssetRelease::create([
            'employee_id' => $employee_id,
            'assign_date' => date('Y-m-d'),
            'asset_id' =>  $asset_id,
            'assign_status' => 1,
            ]);
        }
      
      if ($in_storage == 'true') 
      {
          $data = [
            'status' => 'in_storage',
        ];
      }

      if ($in_storage == 'false') 
      {
          $data = [
            'status' => 'in_use',
        ];
      }

        $fixed_asset =   FixedAsset::where('id' , $asset_id)->update( $data );

         DB::commit();

         echo 'ok';
      } 
        catch (\Exception $e) 
      {
       DB::rollback();
   
      }

}

public function destroyFixedAsset($id = null)
{
    FixedAsset::where('id' , $id)->delete();
     AssetRelease::where('asset_id' , $id)->delete();

    return redirect()->route('fixed.assets')->with('success' , 'Fixed Asset Removed Successfully!');
}



function destroy($id)
{
       if(is_numeric($id))
    {
        DB::beginTransaction();

   try {

       $item = Item::find($id);
       $item->delete();
       $item->vendors()->wherePivot('item_id','=',$id)->detach();
       DB::commit();
      } 
        catch (\Exception $e) 
      {
       DB::rollback();
    
      }
    
    }
 
 return redirect()->route('item.list')->with('success' , 'Item Removed Successfully!');
}


function edit($id)
{
 
   if(is_numeric($id))
    {
        $item = Item::where("id",$id)->first();
        $parent_category = Category::orderBy('category_name', 'ASC')->get();
        $manufacture_list = ItemManufacture::orderBy('id', 'DESC')->get();
        $item_units = ItemUnit::orderBy('id', 'DESC')->get();
        return view('procurement/items.editItem' ,compact('item' , 'parent_category' , 'manufacture_list','item_units') );
    }
}




function editFixedAsset($id)
{
 
   if(is_numeric($id))
    {
         $fixed_asset = FixedAsset::where("id",$id)->first();
         $items = Item::where('type' , 'tools')->orderBy('item_name', 'ASC')->get();
          $asset_locations = AssetLocation::orderBy('id', 'DESC')->get();
         $fixed_asset_types = FixedAssetType::orderBy('name' , 'ASC')->get();
        return view('procurement/items.fixed-items.edit' ,compact('items' , 'fixed_asset' , 'fixed_asset_types' , 'asset_locations') );
    }

}



function updateFixedAsset(Request $request)
{

       $id = $request->input('asset_id');

       $validator = Validator::make($request->all(), [
                    'asset_tag' => 'required|unique:fixed_assets,asset_tag,'.$id,
                    'name' => 'required',
                    'items' => 'required',
                    'warranty' => 'required',
                    'serial' => 'required',
                    'purchase_date' => 'required',
                    'asset_location' => 'required',
                    'cost' => 'required',
                    'asset_type' => 'required',
        
        ]);


            if ($validator->fails())
             {
               
                return redirect('/items/edit-fixed-assets/'. $id)
                ->withErrors($validator)
                ->withInput();
            }


            $total_items = FixedAsset::where('item_id' , $request->items)->count();

            DB::beginTransaction();

            try {


               $fixed_asset =   FixedAsset::where('id' , $id)->update([
                    'asset_tag' => $request->asset_tag,
                    'name' => $request->name,
                    'item_id' => $request->items,
                    'asset_location' => $request->asset_location,
                    'warranty' => $request->warranty,
                    'purchase_date' => $request->purchase_date,
                    'cost' => $request->cost,
                    'serial' => $request->serial,
                    'description' => $request->description,
                    'asset_type' => $request->asset_type,
          ]);

          DB::commit();
        
        return redirect()->route('fixed.assets')->with('success' , 'Asset Added Successfully!');
   
      } 
        catch (\Exception $e) 
      {
        DB::rollback();

        echo json_encode(array('response' => 'invalid' , 'message' => 'Something Went Wrong Data Not Updated.'));
      }
}



function update(Request $request)
{
$id = $request->input('id');
if(is_numeric($id))
{
  $validator = Validator::make($request->all(), [
                    'itemcode' => 'required|unique:items,item_code,'.$id,
                    'name' => 'required|unique:items,item_name,'.$id,
                    'brand' => 'required',
                    'type' => 'required',
                    'storage_type' => 'required',
                    'category' => 'required|integer',
                    'unit' => 'required',
                    'minqty' => 'required|between:0,99999.99|min:1',
                    'maxqty' => 'required|between:0,99999.99|min:1',
        ]);


       if ($validator->fails()) 
       {
            return redirect('/items/edit-item/'.$id)
                            ->withErrors($validator)
                            ->withInput();
        }


            if($request->minqty > $request->maxqty)
            {
             return redirect('/items/edit-item/'.$id)
            ->withInput()
            ->with('minquantity', 'Quantity Not be greater than maximum quantity.');;
            }



            Item::where('id', '=', $id)->update(
                array( 
                'item_code'     => $request->itemcode,
                'item_name'     => $request->name,
                'manufacture_id'         => $request->brand,
                'category_id'   => $request->category,
                'minqty'        => $request->minqty,
                'maxqty'        => $request->maxqty,
                'unit'          => $request->unit,
                'description'   => $request->description,
                'type'          => $request->type,
                'size' => $request->size,
                'risk_type'     => $request->storage_type,
                )
            );

}

  return redirect()->route('item.list')->with('success' , 'Item Updated Successfully!');
}


public function view($itemId = null)
{
   if (is_numeric($itemId)) 
   {
      $item_purchase_order = ItemPurchaseOrder::where('item_id' , $itemId)->orderBy('created_at', 'DESC')->get();
      $item = Item::find($itemId);

      $item_releasings = ItemRelease::with(['project' , 'department' , 'releasingItems'])
    ->orderBy('releasing_date', 'DESC')
     ->groupBy(['purchase_request_id' , 'department_id'])
    ->get();

    $item_releasings = json_decode(json_encode($item_releasings )) ;

        return view('procurement/items.view' ,compact('item_purchase_order', 'item' , 'item_releasings' ) );
   }
}

public static function getCurrentRelease($item_id , $pr_id , $department_id)
{
    $current_releasing = 0;
    if($pr_id == 0)
    {
      $query = ItemRelease::where('department_id', $department_id );
    }
    else
    {
      $query = ItemRelease::where('purchase_request_id', $pr_id );
    }

    $current_release = $query->each(function($p, $k) use (&$current_releasing , &$item_id) 
    {
      $current_releasing += $p->releasingItems()->where('item_id' , $item_id)->sum('item_quantity');
    });

  return $current_releasing ;
}

public function releasing(Request $request)
{
    
    $releaser_name = $request->releaser_name;
    $receiver_name = $request->receiver_name;
    $date =  $request->date;
    $department =  $request->department;
    $items =  $request->items;
    $type =  $request->type;


// print_r($request->all());
//  die;


    $purchase_request_id = 0;

    if ($request->mir_id > 0 ) 
    {
      
        $mir = MaterialIssueRequest::where('id' , $request->mir_id)->first();

        $purchase_request_id = $mir->pr_id;

    }

  
     if( empty($items))
    {
        echo json_encode(array('response' => 'invalid' , 'message' => 'No Items Found For This Purchase Request.'));
        exit();
    }

    if( empty($releaser_name))
    {

        echo json_encode(array('response' => 'invalid' , 'message' => 'Please Enter Valid  Name.'));
        exit();
    }
    
    if( empty($receiver_name))
    {
        echo json_encode(array('response' => 'invalid' , 'message' => 'Please Enter Valid  Name.'));
        exit();
    }


      if(empty($date) && (strtotime($date) < strtotime(date('Y-m-d'))  ))
    {
        echo json_encode(array('response' => 'invalid' , 'message' => 'Please Select Valid Date.'));
        exit();
    }

    if(!is_numeric($purchase_request_id))
    {
        echo json_encode(array('response' => 'invalid' , 'message' =>  $purchase_request_id.'Please Select Valid Purchase Request.'));
        exit();
    }

    if(empty($department) || !is_numeric($department))
    {
    echo json_encode(array('response' => 'invalid' , 'message' => 'Please Enter Valid Department Name.'));
    exit();
    }

    if( in_array("0", array_column($items, 'item_id')) || in_array("0", array_column($items, 'releasing_quantity')) || !array_filter(array_column($items, 'releasing_quantity')) || !array_filter(array_column($items, 'item_id'))  )
    {
    echo json_encode(array('response' => 'invalid' , 'message' => 'Please Enter Valid Item Quantity. Quantity Not be Empty Or Zero.'));
    exit();
    }

   DB::beginTransaction();

   try {

        $item_releasing_array = [
        'purchase_request_id' => $purchase_request_id,
        'department_id' =>  $department,
        'mir_id' => $request->mir_id,
        ];

        if ( $type == 'false') 
        {
            $item_releasing_array['releaser_name'] = $releaser_name;
            $item_releasing_array['receiver_name'] = $receiver_name;
            $item_releasing_array['releasing_date'] = date('Y-m-d H:i:s' , strtotime($date));
        }

         if ( $type == 'true') 
        {
            $item_releasing_array['returning_name'] = $releaser_name;
            $item_releasing_array['receiver_name'] = $receiver_name;
            $item_releasing_array['return_date'] = date('Y-m-d H:i:s' , strtotime($date));
        }

        $item_release = ItemRelease::create($item_releasing_array );


        for ($i= 0; $i < sizeof($items); $i++) 
       {
           $itemId =  $items[$i]['item_id'];
           $releasing_quantity =  $items[$i]['releasing_quantity'];

           $item_data = Item::where('id' , $itemId);
           $item =  $item_data->first();

        if ($type == 'false' && ($item->quantity < $releasing_quantity)) 
        {
            DB::rollback();
            echo json_encode(array('response' => 'invalid' , 'message' => 'You have only <b>'.$item->quantity.'</b> quantity left for item <b>'.$item->item_name.'</b> and you enter <b>'.$releasing_quantity.'</b>. '));
            exit();
        }

        if ($purchase_request_id > 0)
        {

        $demand_item_quantity = ItemPurchaseRequest::where('purchase_request_id', '=', $purchase_request_id)
        ->where( 'item_id', $itemId)
        ->first()->quantity;

        $total_receive_items = ReceiptItem::where('purchase_request_id' , $purchase_request_id)
            ->where('approval_status' , 'approve')
            ->where('pass_quantity' , '>' , 0)
            ->where('item_id' ,  $itemId)
            ->sum('pass_quantity');

        $current_releasing = 0;
        $current_returning = 0;
        $cureent_reles = 0;

        $current_release = ItemRelease::where('purchase_request_id', $purchase_request_id)
        ->each(function($p, $k) use (&$cureent_reles,&$current_returning , &$itemId) 
        {
            $current_returning += $p->releasingItems()->where('item_id' , $itemId)->sum('return_quantity');
        });


    
        $current_release = MaterialIssueRequest::where('pr_id', $purchase_request_id )->where('status' , 'pending')

        ->each(function($p, $k) use (&$current_releasing , &$itemId) 
        {
            $current_releasing += $p->requestingItems()->where('item_id' , $itemId)->sum('item_requesting_quantity');
        });


        $current_release = MaterialIssueRequest::where('id', $mir->id)

        ->each(function($p, $k) use (&$cureent_reles , &$itemId) 
        {
            $cureent_reles += $p->requestingItems()->where('item_id' , $itemId)->sum('item_requesting_quantity');
        });




        if ($releasing_quantity > $demand_item_quantity ) 
        {
            DB::rollback();
            echo json_encode(array('response' => 'invalid' , 'message' => 'Request Quantity of  item <b>'.$item->item_name.'</b> is '.$demand_item_quantity.' and you enter invalid quantity  <b>'.$releasing_quantity.'</b>. '));
            exit();
        }

        

        if ($type == 'false' && ($releasing_quantity >  $current_releasing) )
        {
            DB::rollback();
            echo json_encode(array('response' => 'invalid' , 'message' => 'The item '.$item->item_name.' has requested quantity is '.$current_releasing.' and you enter '.$releasing_quantity.'. you cant release amount greater than requested amount.'));
            exit();
        }

            if ($type == 'true') 
            {
                if ($cureent_reles == 0) 
                {
                    DB::rollback();
                    echo json_encode(array('response' => 'invalid' , 'message' => 'You are release <b>'.$cureent_reles.'</b> Quantity of  item <b>'.$item->item_name.'</b>. So you are not able to return anything.'));
                        exit();
                }
                else if($releasing_quantity > $cureent_reles )
                {
                    DB::rollback();
                    echo json_encode(array('response' => 'invalid' , 'message' => 'Your current releasing for item '.$item->item_name.' is '.$cureent_reles.' and your are return quantity is '.$releasing_quantity.' that is Invalid.'));
                        exit();
                }

                     echo $cureent_reles;
            }

        }



        $item_release_data_array = [
            'item_releasing_id' =>  $item_release->id,
            'item_id' => $itemId,
            ];

        if( !empty($releasing_quantity) )
        {

            if ($type == 'false')  
            {
             $item_release_data_array['item_quantity'] =  $releasing_quantity;
             $qty = $item->quantity - $releasing_quantity ;


             MaterialIssueRequestData::where('mir_id' , $mir->id)->where('item_id' , $itemId)->update(['item_requesting_quantity' => $releasing_quantity ]);
            }

            if ($type == 'true') 
            {
              $item_release_data_array['return_quantity'] =  $releasing_quantity;
               $qty = $item->quantity + $releasing_quantity ;
            }

            ItemReleaseData::create($item_release_data_array ); 

            $item_data->update([
              'quantity' => ( $qty ),
            ]);

        }
    }

    MaterialIssueRequest::where('id' , $request->mir_id)->update([
     'status' => 'release',
    ]);

      DB::commit();

      echo json_encode(array('result' => 'valid' , 'message' => 'Item Release Successfully.'));
   
      } 
        catch (\Exception $e) 
      {
        DB::rollback();
        echo json_encode(array('response' => 'invalid' , 'message' => 'Something Went Wrong Data Not Updated.'));
      }
             
}


function releasingItemView()
{
    $item_releasings = ItemRelease::with([ 'department' , 'releasingItems'])
    ->whereNotNull('releasing_date')
    ->whereNotNull('releaser_name')
    ->orderBy('id', 'DESC')
    // ->groupBy(['purchase_request_id' , 'department_id'])
    ->get();
    $item_releasings = json_decode(json_encode($item_releasings )) ;
    return view('procurement/items.item-releasing-list' ,compact( 'item_releasings' ) );
}

function returningItemView()
{
   
    $item_releasings = ItemRelease::with([ 'department' , 'releasingItems'])
    ->whereNotNull('returning_name')
    ->whereNotNull('return_date')
    ->orderBy('id', 'DESC')
    //->groupBy(['purchase_request_id' , 'department_id'])
    ->get();
    $item_releasings = json_decode(json_encode($item_releasings )) ;


    return view('procurement/items.item-returning-list' ,compact( 'item_releasings' ) );
}



public function releasingDetail($id = null)
{
$item_releasings = ItemRelease::with([ 'department' , 'releasingItems' ])
->where('id', $id)
->first();
 $purchase_request_id = $item_releasings->purchase_request_id;

 $item_releasings = json_decode(json_encode($item_releasings )) ;

return view('procurement/items.item-releasing-view' ,compact( 'item_releasings' , 'purchase_request_id' ) );
}

public function returningDetail($id = null)
{
$item_releasings = ItemRelease::with([ 'department' , 'releasingItems' ])
->where('id', $id)
->first();
 $purchase_request_id = $item_releasings->purchase_request_id;

 $item_releasings = json_decode(json_encode($item_releasings )) ;

return view('procurement/items.item-returning-view' ,compact( 'item_releasings' , 'purchase_request_id' ) );
}



public function itemForReleasing(Request $request)
{
    $itemList = Item::with(['category' , 'manufacture'])
    ->where('quantity' , '>' ,0)->where('type' , '!=' , 'tools')->orderBy('id', 'DESC')->get();

    if ( $itemList->count() > 0 ) 
    {
         echo json_encode(array('response' => 'yes' , 'output' => $itemList));
    }
    else
    {
         echo json_encode(array('response' => 'empty' , 'output' => 0));
    }
}



public function itemForRelease(Request $request)
{
    $items = array();

if ( !empty($request->item_id) ) 
    {
    $itemList = Item::with(['category' , 'manufacture'])->where('type' , '!=' , 'tools');


       for ($i=0; $i < count($request->item_id); $i++) 
        { 
            $items[] = $request->item_id[$i];
        }

      
    $itemList = $itemList->whereIn('id' ,  $items)->orderBy('item_name', 'ASC')->get();

    
         echo json_encode(array('response' => 'yes' , 'output' => $itemList));
    }
    else
    {
         echo json_encode(array('response' => 'empty' , 'output' => 0));
    }
}


function aging_report()
{
    $items = Item::orderBy('id', 'desc')->get();
    return view('procurement/items.aging-report' ,compact('items') );
}


function varianceReport()
{
     $tasks = Task::where('node_name' , 'leaf')->orderBy('id', 'ASC')->get();
     return view('procurement/items.variance-report' ,compact('tasks') );
}

public function varianceReportItem(Request $request)
{
   $task_id = $request->task_id;

          $task = Task::find($task_id);
          $boq_array = array();
          $current_item_consume = array(); 
          $boqs = $task->boq;
          $total_ammount = 0;
         

          if ($task == true)
           {
                foreach ($boqs as $key => $boq) 
                {
                   $total_ammount += $boq->total_cost;

                  //.......................total Item boq estimate.......................//

                   $boq_array[] = array('item_id'=> $boq->item->id, 'item_code' => $boq->item->item_code ,'item_name' => $boq->item->item_name , 'item_unit' => $boq->item->unit , 'quantity' => $boq->quantity , 'rate_per_unit' => $boq->rate_per_unit , 'total_cost' => $boq->total_cost  , 'date' => date('d-F-Y' , strtotime($boq->created_at)) );

                //.......................total Item Cunsumtion.......................//

                   if ($boq->item->id > 0 && $task_id > 0) 
                   {

                        $pr_boq_items = PurchaseRequestBoqItem::where('task_id' , $task_id)
                        ->where('item_id' , $boq->item->id)->get();

                        foreach ($pr_boq_items as $key => $pr_boq_item) 
                        {
                        $current_item_consume[] = array('item_id'=> $pr_boq_item->item->id, 'item_code' => $pr_boq_item->item->item_code ,'item_name' => $pr_boq_item->item->item_name , 'item_unit' => $pr_boq_item->item->unit , 'quantity' => $pr_boq_item->quantity , 'rate_per_unit' => $pr_boq_item->rate_per_unit  , 'total_cost' => $pr_boq_item->total_cost  , 'date' => date('d-F-Y' , strtotime($pr_boq_item->created_at)) );
                        }

                   }

                }

                echo json_encode(array('response' =>'found' ,'task' => $task, 'boq' => $boq_array , 'current_item_consume' => $current_item_consume ,'total_ammount' => number_format($total_ammount , 2)));
          }

}

public static function  getItemAgingReport($item_id = null)
{
   $first_receiving = ReceiptItem::where('item_id' , $item_id)->oldest()->first();
   $last_receiving = ReceiptItem::where('item_id' , $item_id)->latest()->first();
   $first_month = 0;
   $second_month = 0;
   $three_month_plus = 0;
   $third_month = 0;
    if ($first_receiving == true && $last_receiving == true) 
    {
        $zero = date('Y-m-d' , strtotime($first_receiving->created_at));
  
        $thirty = date('Y-m-d' , strtotime($first_receiving->created_at->addDays(30)));

        $sixty =  date('Y-m-d' , strtotime($first_receiving->created_at->addDays(30)->addDays(30)));

        $ninty =  date('Y-m-d' , strtotime($first_receiving->created_at->addDays(30)->addDays(30)->addDays(30) ));

        $latest = date('Y-m-d' , strtotime($last_receiving->created_at));

        //....................Calculate quantity..........................??

        $first_month = ReceiptItem::where('item_id' , $item_id)->where('approval_status' , 'approve')->whereBetween('created_at', [$zero, $thirty])->sum('pass_quantity');

        $second_month = ReceiptItem::where('item_id' , $item_id)->where('approval_status' , 'approve')->whereBetween('created_at', [$thirty, $sixty])->sum('pass_quantity');

        $third_month = ReceiptItem::where('item_id' , $item_id)->where('approval_status' , 'approve')->whereBetween('created_at', [$sixty, $ninty])->sum('pass_quantity');

        $three_month_plus = ReceiptItem::where('item_id' , $item_id)->where('approval_status' , 'approve')->whereBetween('created_at', [$ninty, $latest])->sum('pass_quantity');

    }

  return [$first_month , $second_month , $third_month , $three_month_plus ] ;
}

public function Dashboard()
{
    $chartArray = array();
    $total_fixed_assets = FixedAsset::count();
    $total_fixed_asset_maintainces = AssetMaintainance::count();
    $total_fixed_asset_types = FixedAssetType::count();

    $in_use = FixedAsset::where('status' , 'in_use')->count();
    $in_storage = FixedAsset::where('status' , 'in_storage')->count();

    $chartArray  = [
    ['id' => 1, 'label' => 'In Use', 'value' =>$in_use ] ,
    ['id' => 2, 'label' => 'In Storage', 'value' =>$in_storage]
    ];
  
    $chartList =  json_encode($chartArray);

    $fixed_asset_assignee = AssetRelease::orderBy('id' , 'DESC')->get()->take(10);
   

     return view('procurement/items.fixed-items.dashboard' , compact('total_fixed_assets' , 'total_fixed_asset_maintainces' , 'total_fixed_asset_types' , 'chartList' , 'fixed_asset_assignee')  );
}

    public function fixedAssetLegder()
    {
        $fixed_asset = FixedAsset::with(['item' , 'asset_type'])
        ->orderBy('name' , 'ASC')
        ->get();

        $fixed_asset = json_decode(json_encode( $fixed_asset));

         $fixed_asset_types = FixedAssetType::orderBy('name' , 'ASC')->get();

        return view('procurement/items.fixed-items.asset-ledger' ,compact('fixed_asset' , 'fixed_asset_types'));
    }

    public function fixedAssetDepreciationReport()
    {
         $fixed_asset = FixedAsset::with(['item' , 'asset_type'])
        ->orderBy('name' , 'ASC')
        ->get();

        $fixed_asset = json_decode(json_encode( $fixed_asset));

         $fixed_asset_types = FixedAssetType::orderBy('name' , 'ASC')->get();

        return view('procurement/items.fixed-items.depreciation-report' ,compact('fixed_asset' , 'fixed_asset_types'));
    }

    public function filterAssetLegder(Request $request)
    {


        $category = $request->category;
        $from = $request->from;
        $to = $request->to;

        if ($request->tab_type == 'sold') 
        {
            $fetch_type = 'sold';
        }

         if ($request->tab_type == 'depreciation') 
        {
            $fetch_type = 'in_use';
        }


         if (empty($from)) 
         {
             echo json_encode(array('response' => 'from_error'));
             exit();
         }

            if ((!empty($from) && !empty($to)) && strtotime($to) < strtotime($from)) 
         {
             echo json_encode(array('response' => 'greater_error'));
             exit();
         }

         $fixed_assets = FixedAsset::where('physical_status' ,  $fetch_type)->with(['item' , 'asset_type']);

         if (!empty($category)) 
         {
            $fixed_assets = $fixed_assets->where('asset_type' , $category);
         }
        
         $fixed_assets = $fixed_assets->orderBy('asset_type' , 'ASC')->get();
 
         $fixed_assets = json_decode(json_encode( $fixed_assets));


         $dataArray = array();


         $to_date = null;
         $from_date = null;


        if (!empty($to)) 
        {
            $to_date = $to.'-'.$this->calLastDayOfMonth($to."-1");
        }
        else
        {
            $to_date= $from .'-'. $this->calLastDayOfMonth($from);
        }

        $from_date =  $from.'-1';

        $for_the_period_diff =  $this->calMonDiff($from_date, $to_date);



        foreach($fixed_assets as $data)
        {
    
            $opening_diff =  $this->calMonDiff($data->purchase_date , $from.'-1');

            $opening = ($data->cost * ($data->asset_type->depreciation_rate/100) * $opening_diff) / 12;

            $for_the_period = ($data->cost * ($data->asset_type->depreciation_rate/100) *   ($for_the_period_diff + 1)) / 12;

            $opening = round($opening);

            $for_the_period = round($for_the_period);

            $method = 'RBM';

            if($data->asset_type->depreciation_policy == 'straight_line_method')
            {
               $method = 'SLM';
            }

              $bv = ($data->cost - $opening);
              $wdv = $bv - ($opening + $for_the_period);

              if($data->asset_type->depreciation_policy == 'reducing_balance_method')
            {
                $opening = ( $bv * ($data->asset_type->depreciation_rate/100) *  $opening_diff) / 12;

                $for_the_period = (  $bv * ($data->asset_type->depreciation_rate/100) *   ($for_the_period_diff + 1)) / 12;

                $opening = round($opening);

                $for_the_period = round($for_the_period);

                $bv = ( $data->cost -  $opening  );
                $wdv = $bv - ($opening + $for_the_period);
            }

            if ($opening >= 0  && $bv >= 0 ) 
            {  
                $sum_asset_maintainces = AssetMaintainance::where('asset_id' , $data->id)->sum('cost');

              $dataArray [] = array('asset_id' => $data->id , 'asset_tag' => $data->asset_tag , 'name' => $data->name .' -- '. $data->item->manufacture->name , 'purchase_date' => date('M-d-Y' ,  strtotime($data->purchase_date) ) , 'total_month' => round(number_format(100/$data->asset_type->depreciation_rate  , 2) * 12) , 'maintainance' => $sum_asset_maintainces , 'rate' => $data->asset_type->depreciation_rate.'%' , 'cost' => $data->cost,'asset_type' => $data->asset_type->name ,'policy' =>  $method  ,  'total_opening_month' => $opening , 'for_the_period' => $for_the_period  , 'closing' =>   ($opening + $for_the_period ) , 'wdv' => $wdv , 'bv' => $bv );
           }
         
        }

            if ($request->type == 'depreciation') 
            {

               $sumOfValueArray = [];

                foreach($fixed_assets as $data)
                {
                    $cost = 0;
                    $opening = 0;
                    $bv = 0;
                    $for_the_period = 0;
                    $maiantainance_cost = 0;
                    $closing = 0;
                    $wdv = 0;
                    $assetIds = '';

                   foreach($dataArray as $key => $list)
                   {
                     if ($data->asset_type->name == $list['asset_type']) 
                     {
                        
                        $cost += $list['cost'];
                        $opening += $list['total_opening_month'];
                        $bv += $list['bv'];
                        $for_the_period += $list['for_the_period'];
                        $maiantainance_cost += $list['maintainance'];
                        $closing += $list['closing'];
                        $wdv += $list['wdv'];

                        $assetIds .= $list['asset_id'].',';
                     }
                   }

                  $method = 'RBM';

                if($data->asset_type->depreciation_policy == 'straight_line_method')
                {
                  $method = 'SLM';
                }

                   $sumOfValueArray[] = array('asset_type_id'=>$data->asset_type->id, 'asset_type' => $data->asset_type->name , 'policy' => $method , 'cost' =>   $cost , 'total_opening_month' => $opening , 'for_the_period' => $for_the_period ,'maintainance' => $maiantainance_cost , 'closing' =>   $closing , 'wdv' => $wdv , 'bv' => $bv , 'asset_ids' , $assetIds);

                  
                }


                 $result = array_map("unserialize", array_unique(array_map("serialize", $sumOfValueArray)));


                foreach ( $result as $k=>$v )
                {
                    $result[$k] ['asset_ids'] = $result[$k] ['1'];
                    unset($result[$k]['1']);
                     unset($result[$k]['0']);
                }


                echo json_encode(array('response' => 'ok' , 'output' =>  $result));
                exit();
            }

        echo json_encode(array('response' => 'ok' , 'output' =>  $dataArray));

    }

    public function getAssetData(Request $request)
    {
        
         $data = FixedAsset::where('id' ,$request->id)->with(['item' , 'asset_type'])->first();
         $data = json_decode(json_encode( $data));

       
         $to_date = date('Y-m').'-1';
         $from_date = date('Y-m').'-1';


           $for_the_period_diff =  $this->calMonDiff($from_date, $to_date);

        if ($data == true) 
        {

            $opening_diff =  $this->calMonDiff($data->purchase_date , $from_date);

            $opening = ($data->cost * ($data->asset_type->depreciation_rate/100) *  $opening_diff) / 12;

            $for_the_period = ($data->cost * ($data->asset_type->depreciation_rate/100) *   ($for_the_period_diff + 1)) / 12;

            $opening = round($opening);

            $for_the_period = round($for_the_period);

            $method = 'RBM';

            if($data->asset_type->depreciation_policy == 'straight_line_method')
            {
               $method = 'SLM';
            }

              $bv = ($data->cost - $opening  );
              $wdv = $bv - ($opening + $for_the_period );

              if($data->asset_type->depreciation_policy == 'reducing_balance_method')
            {
                $opening = ( $bv * ($data->asset_type->depreciation_rate/100) *  $opening_diff) / 12;

                $for_the_period = (  $bv * ($data->asset_type->depreciation_rate/100) *   ($for_the_period_diff + 1)) / 12;

                $opening = round($opening);

                $for_the_period = round($for_the_period);

                $bv = ( $data->cost -  $opening  );
                $wdv = $bv - ($opening + $for_the_period );
            }

            if ($opening >= 0  && $bv >= 0 ) 
            {  
                $sum_asset_maintainces = AssetMaintainance::where('asset_id' , $data->id)->sum('cost');

              $dataArray = array('maintainance' => $sum_asset_maintainces  , 'wdv' => $wdv  );
           }
         
             echo json_encode(array('response' => 'true' , 'output' => $dataArray));
             exit();
         }
            echo json_encode(array('response' => 'false'));
    }


    public function fixedAssetForSale()
    {
        $fixed_asset_solds = FixedAssetForSale::with(['asset'])->get();

        $fixed_asset_solds = json_decode(json_encode( $fixed_asset_solds));

        return view('procurement/items.fixed-items.for-sale.index' ,compact('fixed_asset_solds'));
    }

    public function createFixedAssetSale()
    {
      $fixed_asset = FixedAsset::where('physical_status' , 'in_use')->orderBy('name' , 'ASC')->get();
      return view('procurement/items.fixed-items.for-sale.create' ,compact('fixed_asset'));
    }

    public function fixedAssetSalaInsert(Request $request)
    {


        $validator = Validator::make($request->all(), [
        'asset' => 'required|unique:fixed_asset_for_sales,asset_id',
        'maiantainance_cost' => 'required',
        'wdv' => 'required',
        'sale_date' => 'required',
        ]);


        if ($validator->fails())
         {
            return redirect('/fixed-assets/add-sale')
            ->withErrors($validator)
            ->withInput();
        }

    $is_valid =  FixedAsset::where('id' , $request->asset )->first();


    if (strtotime($request->sale_date) < strtotime($is_valid->purchase_date)) 
    {
        return redirect()->back()->with('error' , 'You Enter Incorrect Sold Date. Asset Purchase on '.$is_valid->purchase_date.'.');
    }


    if ($is_valid->status == 'in_use') 
    {
        return redirect()->back()->with('error' , 'This asset is currently assign to employee.');
    }


     DB::beginTransaction();

      try {

        FixedAssetForSale::create([
            'maintainance_cost' => $request->maiantainance_cost,
            'writen_down_value' => $request->wdv,
            'asset_id' => $request->asset,
            'sold_date' => $request->sale_date,
        ]);
       

        FixedAsset::where('id' , $request->asset )->update([
            'physical_status' => 'sold',
        ]);
        
      
        DB::commit();
        
         return redirect()->route('fixed.assets.sold')->with('success' , 'Asset Sold Successfully!');


      } 
        catch (\Exception $e) 
      {
        DB::rollback();

        return redirect()->route('fixed.assets.sold')->with('success' , 'Error!');

      }

    }

    public function fixedAssetSaleRevert($id = null)
    {
        DB::beginTransaction();

            try {
            $fixed_asset_sale = FixedAssetForSale::where('id' , $id)->first();


            FixedAsset::where('id' , $fixed_asset_sale->asset_id )->update([
            'physical_status' => 'in_use',
            ]);

            $fixed_asset_sale->delete();

            DB::commit();
        
         return redirect()->route('fixed.assets.sold')->with('success' , 'Asset Revert Successfully!');


      } 
        catch (\Exception $e) 
      {
        DB::rollback();

        return redirect()->route('fixed.assets.sold')->with('success' , 'Error!');

      }

    }

    public function sentToAccounts(Request $request)
    {

        $from = $request->from;
        $to = $request->to;

        $to_date = null;
        $from_date = null;


        if (!empty($to)) 
        {
            $to_date = $to.'-'.$this->calLastDayOfMonth($to."-1");
        }
        else
        {
             $to_date = $from .'-'. $this->calLastDayOfMonth($from);
        }

             $from_date =  $from.'-1';

             $assetIds = '';


        DB::beginTransaction();

      try {

            foreach($request->assets as $list)
            {
            $is_check = FixedAssetAccount::where('asset_type_id' , $list['asset_type_id'])->get();


                if ($is_check->count() > 0 ) 
                {
                    foreach ($is_check as $key => $value) 
                    {

                       $fixed_asset_type =  FixedAssetType::find($value->id)->name;
                        
                        $fromDate = date('Y-m-d', strtotime($from_date));
                        $toDate = date('Y-m-d', strtotime($to_date));

                        $dateBegin = date('Y-m-d', strtotime($value->from_date));
                        $dateEnd = date('Y-m-d', strtotime($value->to_date));

                        if (($fromDate >= $dateBegin) && ($fromDate <= $dateEnd))
                        {
                               DB::rollback();
                             echo json_encode(array('response' => 'error' , 'output' => 'You already generate statement for  <strong> '.$fixed_asset_type.'</strong> <b>from</b> '. $dateBegin.' <b>to</b> '.$dateEnd.' and your from date exist between these dates, So you cant generate statement with this dates.'));
                             exit();
                        }


                         if (($toDate >= $dateBegin) && ($toDate <= $dateEnd))
                        {
                               DB::rollback();
                             echo json_encode(array('response' => 'error' , 'output' => 'You already generate statement for  <strong> '.$fixed_asset_type.'</strong> <b>from</b> '. $dateBegin.' <b>to</b> '.$dateEnd.' and your to date exist between these dates, So you cant generate statement with this dates.'));
                             exit();
                        }


                    }
                }

               $data =  [
                    'asset_type_id' => $list['asset_type_id'],
                    'maint' => str_replace(',', '',  $list['asset_maintainance_cost']),
                    'type' => $request->type,
                    'from_date' => $from_date,
                    'to_date' => $to_date,
                ];

                if ($request->type == 'depreciation') 
                {
                   $data['ftp'] = str_replace(',', '',  $list['cost']);
                }

                if ($request->type == 'sold') 
                {
                   $data['wdv'] = str_replace(',', '',  $list['cost']);
                }


                FixedAssetAccount::create( $data );


            }   
    
            DB::commit();
            echo json_encode(array('response' => 'yes'));

          } 
            catch (\Exception $e) 
          {
            DB::rollback();
            // dd($e);
            echo json_encode(array('response' => 'no'));
          }
    }

    public function calLastDayOfMonth($to)
    {
            $a_date = $to;
            $date = new DateTime($a_date);
            $date->modify('last day of this month');
            return $date->format('d');
    }

    public function calMonDiff($date1 , $date2)
    {
       

                $ts1 = strtotime($date1);
                $ts2 = strtotime($date2);

                $year1 = date('Y', $ts1);
                $year2 = date('Y', $ts2);

                $month1 = date('m', $ts1);
                $month2 = date('m', $ts2);

                $diff = (($year2 - $year1) * 12) + ($month2 - $month1);

                return $diff;
    }


}
