<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ItemManufacture;
use Illuminate\Support\Facades\Validator;
use  DB;
class ItemManufactureController extends Controller
{

     public function __construct()
    {
               
    }

      function index()
    {
       $manufacture_list = ItemManufacture::orderBy('id', 'DESC')->get();
      
      return view('procurement/item-manufactures.index' ,compact('manufacture_list') );
    }

    
    function create()
    {
        return view('procurement/item-manufactures.create' );
    }

    function insert(Request $request)
    {
        $validator = Validator::make($request->all(), [
                        'name' => 'required|unique:item_manufactures,name',
            ]);


           if ($validator->fails()) {
                return redirect('/items/create-manufacture')
                                ->withErrors($validator)
                                ->withInput();
            }

        DB::beginTransaction();

        try {

             $department = ItemManufacture::create([
                        'name' => $request->name
              ]);

             
               DB::commit();
               return redirect()->route('item.manufacture.list')->with('success' , 'Manufacture  Added Successfully!');
          

          } 
            catch (\Exception $e) 
          {
           DB::rollback();
          return redirect()->route('item.manufacture.list')->with('success' , 'Something went wrong.');
          }
    }

    public function destroy($id)
    {
       
        if(is_numeric($id))
        {
          ItemManufacture::where('id',$id)->delete();
        }

        return redirect()->route('item.manufacture.list')->with('success' , 'Manufacture Removed Successfully!');
    }


    function edit($id)
{
   if(is_numeric($id))
    {
          $manufacture = ItemManufacture::where('id', $id)->first();
           return view('procurement/item-manufactures.edit' ,compact('manufacture') );
    }
}

public function update(Request $request) 
{

 $id = $request->input('id');
 if(is_numeric($id))
 {
        $validator = Validator::make($request->all(), [
                    'name' => 'required|unique:item_manufactures,name,'.$id,
        ]);

       if ($validator->fails()) {
            return redirect('/items/edit-manufacture/'.$id)
                            ->withErrors($validator)
                            ->withInput();
        }

       DB::beginTransaction();

        try {

        ItemManufacture::where('id', '=', $id)->update(
        array( 'name' => $request->name ));

        DB::commit();

        return redirect()->route('item.manufacture.list')->with('success' , 'Manufacture Updated Successfully!');
   
      } 
        catch (\Exception $e) 
      {
        DB::rollback();
          return redirect()->route('item.manufacture.list')->with('success' , 'Manufacture Not Updated!');
      }
}

}


}
