<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ItemUnit;
use Illuminate\Support\Facades\Validator;
use  DB;

class ItemUnitController extends Controller
{
     public function __construct()
    {
               
    }

      function index()
    {
       $item_units = ItemUnit::orderBy('id', 'DESC')->get();
      
      return view('procurement/item-units.index' ,compact('item_units') );
    }

    
    function create()
    {
        return view('procurement/item-units.create' );
    }

    function insert(Request $request)
    {
        $validator = Validator::make($request->all(), [
                        'name' => 'required|unique:item_units,name',
            ]);


           if ($validator->fails()) {
                return redirect('/items/create-unit')
                                ->withErrors($validator)
                                ->withInput();
            }

        DB::beginTransaction();

        try {

              ItemUnit::create([
                        'name' => $request->name,
                        'description' => $request->description,
              ]);

             
               DB::commit();
               return redirect()->route('item.unit.list')->with('success' , 'Unit  Added Successfully!');
          

          } 
            catch (\Exception $e) 
          {
              DB::rollback();
              return redirect()->route('item.unit.list')->with('success' , 'Something went wrong.');
          }
    }

    public function destroy($id)
    {
     
        if(is_numeric($id))
        {
          ItemUnit::where('id',$id)->delete();
        }

        return redirect()->route('item.unit.list')->with('success' , 'Item Unit Removed Successfully!');
    }


    function edit($id)
{
   if(is_numeric($id))
    {
          $item_unit = ItemUnit::where('id', $id)->first();
           return view('procurement/item-units.edit' ,compact('item_unit') );
    }
}

public function update(Request $request) 
{

 $id = $request->input('id');
 if(is_numeric($id))
 {
        $validator = Validator::make($request->all(), [
                    'name' => 'required|unique:item_units,name,'.$id,
        ]);

       if ($validator->fails()) {
            return redirect('/items/edit-unit/'.$id)
                            ->withErrors($validator)
                            ->withInput();
        }

       DB::beginTransaction();

        try {

        ItemUnit::where('id', '=', $id)->update(
        array( 'name' => $request->name , 'description' => $request->description ));

        DB::commit();

        return redirect()->route('item.unit.list')->with('success' , 'Item Unit Updated Successfully!');
   
      } 
        catch (\Exception $e) 
      {
        DB::rollback();
          return redirect()->route('item.manufacture.list')->with('success' , 'Item Unit  Not Updated!');
      }
}

}
}
