<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Country;
use App\City;
use App\MergingProperty;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\Dealer;

class MergingPropertyController extends Controller
{
    public function __construct() 
    {
        
    }
    
    function  index ()
    {
        $merging_properties = MergingProperty::where('is_approve' , 1)->orderBy('id' , 'ASC')->get();
        return view('merging-properties.index',compact('merging_properties'));
    }
    
    function indexMergingProperty()
    {
        $merging_properties = MergingProperty::where('is_approve' , 1)->orderBy('id' , 'ASC')->get();
        return view('merging-properties.index-merging-property',compact('merging_properties'));
    }
    
    
    function getRequitionData(Request $request)
    {
         $merging_properties = MergingProperty::where('is_approve' , 1)->where('id' , $request->id)->orderBy('id' , 'ASC')->first();
         $city = City::find($merging_properties->city);
         echo json_encode(array('output' => $merging_properties,'city' => $city ));
    }
    
    function add()
    {
       $countries = Country::all();
       $merging_properties = MergingProperty::where('is_approve' , 1)->orderBy('id' , 'ASC')->get(['mrf_no', 'id']);
       return view('merging-properties.add',compact('countries','merging_properties'));
    }
    
    function insert(Request $request)
    {
         $validator = Validator::make($request->all(), [
                'mrf_no' => 'required|unique:merging_properties,mrf_no,'.$request->mrf_no_id,
                'maf_no'=>'required|unique:merging_properties,maf_no',
                'property_code'=>'required|unique:merging_properties,property_code',
                'requested_by' => 'required',
                'contact_no'=>'required',
                'country_id'=>'required',
                'sale_agent_name'=>'required',
                'city'=>'required',
                'address'=>'required',
                'phase' => 'required',
                'street'=>'required',
                'area'=>'required',
                'demand_for_property'=>'required',
                'merging_value'=>'required',
                'merging_assessed_value'=>'required',
                'appraised_by'=>'required',
                'assessment_amount' => 'required',
                'appraised_by_sale_agent'=>'required',
                'assessment_adjusted_against'=>'required',
        ]);



        if ($validator->fails()) 
        {
            return redirect('/merging-properties/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }
        
        
         DB::beginTransaction();
        try 
        {
            $merging_property = MergingProperty::where('id' , $request->mrf_no_id)->update($request->except('_token','mrf_no_id','country_id'));
            DB::commit();
            return redirect('/merging-properties/add')
                            ->with([
                                'message' => 'Merging Property Added Successfully',
                                'alert-type' => 'info',
            ]);
        }
        catch (\Exception $e) 
        {
           //dd($e);
            DB::rollback();
             return redirect('/merging-properties/add')
                            ->withInput()
                            ->with([
                                'message' => 'Merging Property Not Added ',
                                'alert-type' => 'error',
            ]);
        }
        
        
        
    }
    
    
    function form($id)
    {
       $merging_property =  MergingProperty::where('id' , $id)->first();
        
        return view('merging-properties.form' , compact('merging_property'));
    }
    
    
    //////////////Merging property requisition form Section///////////////////////////////
    
    
      function  indexRequisition()
    {
        $merging_properties = MergingProperty::orderBy('id' , 'ASC')->get();
        return view('merging-properties.requisition_index',compact('merging_properties'));
    }
    
      function  pendingApproval()
    {
        $merging_properties = MergingProperty::where('is_approve' , 0)->orderBy('id' , 'ASC')->get();
        return view('merging-properties.pending_approval',compact('merging_properties'));
    }

    
    function addRequisition()
    {
       $countries = Country::all();
       $dealers = Dealer::get();
       return view('merging-properties.requisition_add',compact('countries','dealers'));
    }
    
    function insertRequisition(Request $request)
    {
         $validator = Validator::make($request->all(), [
                'mrf_no' => 'required|unique:merging_properties,mrf_no',
                'requested_by' => 'required',
                'contact_no'=>'required',
                'country_id'=>'required',
                'sale_agent_name'=>'required',
                'city'=>'required',
                'address'=>'required',
                'phase' => 'required',
                'street'=>'required',
                'area'=>'required',
                'demand_for_property'=>'required',
                'employee_id'=>'required',
                'visit_time'=>'required',
                'contact_person_at_location' => 'required',
                'contact_person_no'=>'required',
                'requestor_accompanied'=>'required',
        ]);



        if ($validator->fails()) 
        {
            return redirect('/merging-properties/add-requisition')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }
        
        
         DB::beginTransaction();
        try 
        {
            //$merging_property = MergingProperty::create(Input::all());
            $input=$request->all();
            $merging_property = MergingProperty::create($input);

            DB::commit();
            return redirect('/merging-properties/add-requisition')
                            ->with([
                                'message' => 'Merging Requisition Property Added Successfully',
                                'alert-type' => 'info',
            ]);
        }
        catch (\Exception $e) 
        {
            //dd($e);
            DB::rollback();
             return redirect('/merging-properties/add-requisition')
                            ->withInput()
                            ->with([
                                'message' => 'Merging Requisition Property Not Added ',
                                'alert-type' => 'error',
            ]);
        }
        
        
        
    }
    public function pendingApprovalStatus($id ,  Request $request)
    {
       MergingProperty::where('id' , $id)->update(['is_approve' => $request->status]);
       
       if($request->status == 1)
       {
           return back()->with([
            'message' => 'Merging Requisition Property Approved',
            'alert-type' => 'success',
            ]);
       }
       else
           {
               return back()->with([
            'message' => 'Merging Requisition Property Cancel',
            'alert-type' => 'error',
            ]);
           } 
    }
    
    function formRequisition($id)
    {
        $merging_property =  MergingProperty::where('id' , $id)->first();
        
        return view('merging-properties.requisition_form' , compact('merging_property'));
    }


    
}
