<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\MultiProject;
use App\ProjectType;

class MultiProjectController extends Controller
{
    //
    public function index(){
    
       $multiprojects= MultiProject::where('name','!=','Super Admin')->get();
        return view('multiproject.index',compact('multiprojects'));
    }
    public function create(){
    
       
         return view('multiproject.create');
     }
     public function store(Request $request ){
 
    $this->validate($request,[
        'project_name'=>['required', 'string', 'max:255','unique:multi_projects,name'],
      
        'image'=>['required'],
        'address'=>['nullable', 'string', 'max:255'],
        'description'=>['nullable', 'string', 'max:1055'],
        
     ]);

  $projecttype=   ProjectType::where('status', true)->first();

   $multiproject= new MultiProject;
   $multiproject->name = $request->project_name;
   $multiproject->address = $request->address;
   $multiproject->project_type_id=$projecttype->id;
   if($request->file('image')){
    $file= $request->file('image');
    $filename= date('YmdHi').$file->getClientOriginalName();
    $file->move(public_path('images'), $filename);
    $multiproject->image= $filename;
}
   
   $multiproject->description = $request->description;
   $multiproject->save();

       
        return redirect()->route('multi.index')->with('message', 'Your Project Created Sucessfully');
    }


    public function edit($id){
try{
    
   $pro_id=   decrypt($id);
      $multiprojects= MultiProject::where('id', $pro_id)->first();
   
      return view('multiproject.edit',compact('multiprojects','id'));
}
catch(\Exception $e){

    return redirect()

    ->route('multi.index')
            ->with([
                'message' => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
}


    }
    public function update(Request $request){
        $this->validate($request,[
            'project_name'=>['required', 'string', 'max:255'],
          'id' =>['required'],
            // 'image'=>['required'],
            'address'=>['nullable', 'string', 'max:255'],
            'description'=>['nullable', 'string', 'max:1055'],
            
         ]);
         try{
    
            $pro_id=   decrypt($request->id);
               $multiproject= MultiProject::where('id', $pro_id)->first();
               
               if( $multiproject->name != $request->project_name){
                $this->validate($request,[
                    'project_name'=>['unique:multi_projects,name'],
                ]);
               }


               $multiproject->name = $request->project_name;
               $multiproject->address = $request->address;
              
               if($request->file('image')){
                $file= $request->file('image');
                $filename= date('YmdHi').$file->getClientOriginalName();
                $file->move(public_path('images'), $filename);
                $multiproject->image= $filename;
            }
               
               $multiproject->description = $request->description;
               $multiproject->save();
               return redirect()->route('multi.index')->with('message', 'Your Project Updated Sucessfully');
         }
         catch(\Exception $e){
         
             return redirect()
         
             ->back()
                     ->with([
                         'message' => 'Invalid Inputs!',
                         'alert-type' => 'error',
                     ]);
         }
    
    }

}
