<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Inventory;
use App\Dealer;
use App\DealerType;
use App\OpenFileDealerInfo;
use Carbon\Carbon;
use App\DealerTransaction;
use App\OpenFilePackage;
use App\OpenFilePackageDetail;
use App\DealerPackage;
use App\DealerPackagePaidAmount;
use Illuminate\Support\Str;
use DB;
use Illuminate\Support\Facades\Validator;
use App\CancelOpenFile;
use App\UnitSize;
use App\SchedulePlan;
use App\PriceList;
use App\OpenFileRefundHistory;
use App\OpenFileDealerEndUserInfo;
use App\Customer;
use App\DealerPaidRebate;
use App\PurchaseRequest;
use App\TokenReceipt;
use App\MergingProperty;
use App\CancelProperty;
use App\DepositorBank;
use App\CompanyBank;
use App\Receipt;
use App\ChartOfAccount;
use App\CustomerProperty;
use App\DealerPackageReceipt;
use App\EmailSms;
use App\EmailSmsType;
use App\MultiProject;
use App\PriceListDetail;
use App\UnitBlock;
use Illuminate\Support\Facades\Auth;
// use App\Traits\MultiProjectCookie;

class OpenFileController extends Controller
{

    // use MultiProjectCookie;
    protected $dealer_package_receipt;
     

    public function __construct()
    {
        
        $this->dealer_package_receipt = new DealerPackageReceipt();

    }
    public function index()
    {
        $data = array();
        $data=  $this->getCookieInfoAndMultiPro();
        if($data['status'] == 'error'){
            return redirect()

            ->back()
            ->with([
                'message' => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }
        $multi_projects = $data['multi_projects'];
        $ids=[];
        if(is_array($data['project_ids'])){
            $ids=    $data['project_ids'];
           }
           else
           {
            $ids[]=    $data['project_ids'];
           }
      

        $dealer_openfile_package = DealerPackage::where([['is_deleted',false]])
        
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
                            })
        ->orderBy('id', 'desc')
        
        ->get();
        
        
         

        $dealers = Dealer::where([['is_deleted', false]])->select('id', 'name', 'code')->orderBy('name', 'asc')->get();

        $openfile_package = OpenFilePackage::where([['is_deleted', false]])
        
        ->orderBy('name', 'asc')->get();
        
        activity('View')->log('Viewed Open File Package Index');

        return view('openfile.index', compact('multi_projects','dealer_openfile_package','dealers','openfile_package'));
    }

    public function create()
    {
        $unitNumbers = Inventory::where([['status', '!=', Inventory::sold], ['is_deleted', false],['inventory_type',1]])->orderby('unit_number', 'asc')->get();
        $dealers = Dealer::where([['status', true], ['is_deleted', false]])->with('dealerType')->orderby('name', 'asc')->select('dealer_type_id', 'id', 'name', 'percentage')->get()->groupBy('dealer_type_id');
        $dealertypes = DealerType::pluck('name', 'id');
        activity('Create')->log('Created Open File Package ');

        return view('openfile.create',compact('unitNumbers','dealers','dealertypes'));
    }
    public function store(Request $request,DealerPackage $dealerpackage){

// dd($request->all());
         
      
        $this->validate($request,[
                
                'date'=>'required',
                'dealer'=>'required|integer',
                'package_id'=>'required|integer',
                // 'multipro_id'=>'required'
             ]);
             
             $data=  $this->getCookieInfoAndMultiPro();
             if($data['status'] == 'error'){
                return response()->json(['error' => 'Something went wrong'], 400);
            }
            $ids=[];
            if(is_array($data['project_ids'])){
                $ids=    $data['project_ids'];
               }
               else
               {
                $ids[]=    $data['project_ids'];
               }
                

        $value =   $dealerpackage->insertData($request,$ids);
        
        return $value;
     
     
       
//     return redirect()
//     ->route('openfile.view')
//     ->with([
//         'message' => 'Data Added Successfully!',
//         'alert-type' => 'success'
// ]);
        // $this->validate($request,[
          
        //     'of_no'=>'required|unique:open_file_dealer_infos,of_no',
        //     'unit_number'=>'required',
        //     'dealer_id'=>'required',
        //     'issue_date'=>'required',
        //     'rebate_amount'=>'required',
            
        //  ]);

        
        // // for ($i = 0; $i < sizeof($request->unit_number);$i++ ){
        //     $openfiledealerinfo = new OpenFileDealerInfo;
        //     // if ($i == 0) {
        //         $openfiledealerinfo->of_no = $request->of_no;   
        //     // }
        //     // else {
        //         // $no='OF-000'.OpenFileDealerInfo::count() + 1;
        //         // $openfiledealerinfo->of_no = $no; 
        //     // }
        //     $openfiledealerinfo->dealer_id = $request->dealer_id;
        //     $openfiledealerinfo->invertory_id =$request->unit_number;
        //     $openfiledealerinfo->issue_date = $request->issue_date;
        //     $date = Carbon::createFromFormat('m/d/Y', $request->issue_date)->addMonth();

        //     $openfiledealerinfo->valid_until_date  = $date;

            
        //     $openfiledealerinfo->save();
        // // }

        // // if ($request->dealer_id != 0) {

        //     // for ($i = 0; $i < count($request->dealer_id); $i++) {



        //         // $dealer = Dealer::where('id', $request->dealer_id)->first();
        //         // $rebate = $request->rebate_amount;
        //         // Dealer::where('id', $request->dealer_id)->update(['total_sale' =>
        //         // $dealer->total_sale + $net_amount, 'total_rebate' =>
        //         // $dealer->total_rebate + $rebate]);
        //         // //make transation
        //         // DealerTransaction::create([
        //         //     'product_id' => $property->id, 'dealer_id' => $dealer->id,
        //         //     'amount' => $rebate, 'status' => DealerTransaction::unpaid
        //         // ]);




        //         //update the product account
        //         // CustomerProperty::where('id', $property->id)->update(['dealer_id' => $dealer->id]);
        //     // }
        // // }
       
        // // $openfiledealerinfo->valid_until_date 
        

        // dd($request->all());
    }


    public function getOpenFilePackage()
    {
        $data = array();
        $data=  $this->getCookieInfoAndMultiPro();
        if($data['status'] == 'error'){
            return redirect()

            ->back()
            ->with([
                'message' => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }
        $multi_projects = $data['multi_projects'];
        
        $packages=  OpenFilePackage::orderby('id', 'desc')->get();;
        // $dealers = Dealer::where([['status', true], ['is_deleted', false]])->with('dealerType')->orderby('name', 'asc')->select('dealer_type_id', 'id', 'name', 'percentage')->get()->groupBy('dealer_type_id');
        $dealers = Dealer::where([['status', true], ['is_deleted', false]])->with('dealerType')->orderby('name', 'asc')->select('dealer_type_id', 'id', 'name', 'percentage')->get();
        // $banks = DepositorBank::all();
        $dealertypes = DealerType::pluck('name', 'id');
        // $cBanks = CompanyBank::all();
       
        return view('openfile.openfilepackage',compact('multi_projects','packages','dealers','dealertypes'));
    }
    public function addReceiptForm($id)
    {
        $packages=  OpenFilePackage::orderby('id', $id)->first();

        $dealers = Dealer::where([['status', true], ['is_deleted', false]])->with('dealerType')->orderby('name', 'asc')->select('dealer_type_id', 'id', 'name', 'percentage')->get();
        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();
        $result = Receipt::where([['receipt_no', '!=', null]])
            ->orderby('receipt_no', 'desc')->first();

        if ($result)
            $receipt_no = ++$result->receipt_no;
        else
            $receipt_no = '50000';

        $accounts = ChartOfAccount::orderBy('number', 'ASC')->get();

        //get dealers payable records 

        $dealers = Dealer::where([['is_deleted', false]])->get();

        $dealersRecord = array();
        //rebate history
        foreach ($dealers as $d) {
            $dealersRecord[$d->id]['info'] = $d;
            $transactions = DealerTransaction::where('dealer_id', $d->id)->with('property')->get();
            $availableRebate = array();
            foreach ($transactions as $t) {

                if ($t->property) {
                    $rebate = $t->amount - DealerPaidRebate::where([['dealer_id', $d->id], ['property_id', $t->property->id], ['is_deleted', false]])->sum('amount');
                    if ($rebate > 0)
                        $availableRebate[$t->id] = $t->property->inventory ? $t->property->inventory->unit_number : '' . ' - ' . $rebate;
                }
            }
            $dealersRecord[$d->id]['rebate'] = $availableRebate;
        }

        $vendor_pos = PurchaseRequest::WithAndWhereHas('receipts', function ($query) {
            $query->where('is_book', '=', false);
            $query->where('receipt_type', '=', true);
        })
            ->get();

        $vendor_pos = json_decode(json_encode($vendor_pos));

        $unitNumbers = TokenReceipt::where([['is_approved', true], ['is_book', false]])->with('inventory')->select('id', 'unit_id', 'token_amount')->get();


        $merging_properties = MergingProperty::orderBy('id', 'ASC')->get(['id', 'mrf_no']);
      


        $adjusted_properties = CancelProperty::join('receipts', 'cancel_properties.id', '=', 'receipts.cancel_property_id')
            ->join('unit_adjusts', 'cancel_properties.id', '=', 'unit_adjusts.cancel_property_id')
            ->havingRaw('sum(receipts.amount) > ?', ['unit_adjusts.total_received_amount'])
            ->get(['cancel_properties.*']);

        return view('openfile.receipt.add', compact('packages','dealers','adjusted_properties',  'banks', 'merging_properties', 'cBanks', 'receipt_no', 'accounts', 'dealersRecord', 'vendor_pos', 'unitNumbers'));
    }




    public function detailReceipt($id)
    {

        // dd($id);
       $dealerpaid= DealerPackageReceipt::where('id', $id)->first();
       $digit = new \NumberFormatter("en", \NumberFormatter::SPELLOUT);
    $words=    $digit->format($dealerpaid->amount);
        return view('openfile.receipt.detail',compact('dealerpaid','words'));
        $data = array();

        $banks = DepositorBank::orderBy('name', 'ASC')->get();
        $cBanks = CompanyBank::all();

        $data['banks'] = $banks;
        $data['cBanks'] = $cBanks;

        $data['receipt'] = Receipt::where('id', $id)->first();

        $data['property'] = CustomerProperty::where('id', $data['receipt']->customer_property_id)
            ->with('inventory', 'customer')
            ->first();

        $result = Receipt::where('customer_property_id', $data['property']->id)
            ->sum('amount');

        $data['balance'] = $data['property']->net_pay - $result;

        $digit = new \NumberFormatter("en", \NumberFormatter::SPELLOUT);

        if ($data['receipt']->tax_paid_by == \App\Receipt::company)
            $data['words'] = $digit->format($data['receipt']->amount + $data['receipt']->tax_amount);
        else
            $data['words'] = $digit->format($data['receipt']->amount);


        activity('View')
            ->log('View Receipt record ' . $data['receipt']->receipt_no);

        return view('openfile.receipt.detail', $data);
    }




    public function registrationForm($id)
    {
        $openfile_enduser=  OpenFileDealerEndUserInfo::where('id', $id)->first();
        $openfiledealerinfo=  OpenFileDealerInfo::where('id', $openfile_enduser->openfile_dealer_info_id)->first();
       

        // $pricelist = PriceList::where('id', $request->price_value_id)->first();
        
      
       
     
        $price =PriceListDetail::where('unit_size_id',$openfiledealerinfo->inventory->size->id)->where('unit_type_id',$openfiledealerinfo->inventory->type->id)->where('pricelist_id', $openfiledealerinfo->dealerPackage->package->pricelist->id)->first();
        $downpayment = 0;
        if (!empty($price)) {
           

        $scheduleplane=SchedulePlan::first();
        $per=$scheduleplane->down_payment;


        $downpayment = $price->total_price * $per / 100;

      


        }
       
        activity('Detail')->log('Detailed Open File Package');

        return view('openfile.registration-form',compact('downpayment','openfile_enduser','openfiledealerinfo'));
        // , compact('detail_dealer_openfile'));
    }

    public function detailOpenFilePackage($dealer_package_id)
    {
       
        $detail_dealer_openfile =  DealerPackage::where('id', $dealer_package_id)->first();

    
        activity('Detail')->log('Detailed Open File Package');

        return view('openfile.detail', compact('detail_dealer_openfile'));
    }

    public function createEndUser($id)
    {
      $openfiledealer_info=  OpenFileDealerInfo::where('id',$id)->first();
       
         
        $customers = Customer::get();
        // UnitBlock::

       
        return view('openfile.enduserdetails', compact('customers','openfiledealer_info'));

    }


    public function endUserStore(Request $request)
    {
       
        $messages = ['app_form_no.required_if' => 'App Form No is required', 
                        'currency_number.required_if' => 'Currency No is required.'];

        $validator = Validator::make($request->all() , [
            'app_form_no' => 'required',
            'currency_number' => 'required',
            'openfiledealer_info_id'=>'required|integer'
            ],
        $messages);


        if ($validator->fails())
        {
        return redirect()->back() 
        ->withErrors($validator)->withInput()
        ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error', ]);
        }

        // dd($request->all());
        $openfile_enduser=   OpenFileDealerEndUserInfo::where('openfile_dealer_info_id',$request->openfiledealer_info_id)->first();
        if (!empty($openfile_enduser)) {
            $openfile_enduser->app_form_no = $request->app_form_no;
            $openfile_enduser->openfile_dealer_info_id = $request->openfiledealer_info_id;
            $openfile_enduser->currency_number = $request->currency_number;
            
            $openfile_enduser->save();
        } else {
            $openfile_enduser=    new OpenFileDealerEndUserInfo;
            $openfile_enduser->app_form_no = $request->app_form_no;
            $openfile_enduser->openfile_dealer_info_id = $request->openfiledealer_info_id;
            $openfile_enduser->currency_number = $request->currency_number;  
            $openfile_enduser->save();
        }
            // $openfiledealerinfo =  OpenFileDealerInfo::where('id',$request->openfiledealer_info_id)->first();
            // $customer = Customer::where('id',$request->customer_id)->first();
        if ($openfile_enduser)
        {
            // return redirect()->route('openfile.detail', ['id' => $request->dealer_package_id])
            return redirect()->route('openfile.detail', $openfile_enduser->openfileDealerInfo->dealerPackage->id)
            ->with(['message' => ' Open File Dealer End User Info Created Successfully!', 'alert-type' => 'success', ]);
        }
        else {
            return redirect()->back()
            ->withInput()
            ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error', ]);
        }
    }

    public function endUserForm($id)
    {
  
        $openfile_enduser=  OpenFileDealerEndUserInfo::where('id', $id)->first();
        $openfiledealerinfo=  OpenFileDealerInfo::where('id', $openfile_enduser->openfile_dealer_info_id)->first();
        $customer = Customer::where('id', $openfile_enduser->customer_id)->first();
        // dd($openfiledealerinfo->inventory->floor);
        return view('openfile.registration-letter-end_user',compact('openfile_enduser','openfiledealerinfo','customer'));
    
    }
    public function storeRegistrationLetterCount(Request $request){

        $openfile_enduser=  OpenFileDealerEndUserInfo::where('id', $request->id)->first();
        $openfile_enduser->registration_letter_count =   $openfile_enduser->registration_letter_count + 1;
        $openfile_enduser->save();
        
        return response()->json(true);
    } 
    public function storeRegistrationFormCount(Request $request){

        $openfile_enduser=  OpenFileDealerEndUserInfo::where('id', $request->id)->first();
        $openfile_enduser->registration_form_count =   $openfile_enduser->registration_form_count + 1;
        $openfile_enduser->save();
        
        return response()->json(true);
    } 

    public function destroy($id)
    {
        if(is_numeric($id))
        {
            DealerPackage::where('id', $id)->update(['is_deleted'=>true]);

            //for permant delete
            // use $user->forceDelete()
        }
        activity('Delete')->log('Delete Open File Package ');

        return redirect()->route('openfile.view')->with(['message' => ' Package Deleted Successfully!', 'alert-type' =>
        'success', ]);
    }

    public function approveOpenFilePackages(){
        // $pending_packages =  DealerPackage::where('is', DealerPackage::pending)->get();
     
        $data = array();
    
    $data=  $this->getCookieInfoAndMultiPro();
      
    if($data['status'] == 'error'){
        return redirect()

        ->back()
        ->with([
            'message' => 'Invalid Inputs!',
            'alert-type' => 'error',
        ]);
    }
    $ids=[];
    if(is_array($data['project_ids'])){
        $ids=    $data['project_ids'];
       }
       else
       {
        $ids[]=    $data['project_ids'];
       }
        $pending_packages=  DealerPackage::where([['is_approved',0],['is_deleted',0]])
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
                            })
        ->orderBy('id','desc')->get();
      $approved_packages=  DealerPackage::where([['is_approved',1],['is_deleted',0]])
      ->when($ids[0] !== 'all', function ($query) use ($ids) {
        $query->whereIn('multi_project_id', $ids);
                        })
      
      ->orderBy('id','desc')->get();
        return view('openfile.approvePackage', compact('pending_packages','approved_packages'));
    
    }

    public function viewOpenFilePackages($id)
    {
         
        $pending_packages=  DealerPackage::where('id',$id)->first();
        // dd($pending_packages);
    //    $paid_amount =   $pending_packages->where('dealer_package_id',$pending_packages->dealer_package_id)->where('is_approved',1)->sum('amount');
    $paid_amount = $pending_packages->dealerPackagePaymentReceipt->where('dealerpackage_id',$pending_packages->dealer_package_id)->where('is_approved',1)->sum('amount');
   
       return view('openfile.aprrovedetail',compact('pending_packages','paid_amount'));
    }

    public function storeOpenFilePackagesDecisionApproved(Request $request, DealerPackage $dealerPackage)
    {
        $dealer_package=  DealerPackage::where('id', $request->dealer_package_id)->first();
       
                 $dealer_package->is_approved = 1;
                 $dealer_package->save();
        
     
              
     
             return redirect()->route('openfile.pending.package')->with(['message' => 'Package Approved Successfully!', 'alert-type' => 'success', ]);;
         
    }

    public function createOpenFilePackagesInventory($id)
    {
        $data=  $this->getCookieInfoAndMultiPro();
      
        if($data['status'] == 'error'){
            return redirect()
    
            ->back()
            ->with([
                'message' => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }
        $ids=[];
        if(is_array($data['project_ids'])){
            $ids=    $data['project_ids'];
           }
           else
           {
            $ids[]=    $data['project_ids'];
           }
         

       $pending_packages=  DealerPackage::where('id',$id)
       
->when($ids[0] !== 'all', function ($query) use ($ids) {
    $query->whereIn('multi_project_id', $ids);
                    })
       ->first();

        // dd($pending_packages->package->packageDetail->sum('unit_quantity'));
       $paid_amount = $pending_packages->dealerPackagePaymentReceipt->where('dealerpackage_id',$pending_packages->dealer_package_id)->where('is_approved',1)->sum('amount');
       return view('openfile.inventory.create',compact('pending_packages','paid_amount'));
    }



    public function storeOpenFilePackageInventory(Request $request,DealerPackage $dealerPackage){

        // dd($request->all());
        // "dealer_package_id" => "39"
        // "package_detail_id" => "32"
        // "inventory_quantity" => "1"
        $array_value = [
           "dealer_package_id" => $request->dealer_package_id,
        "package_detail_id" => $request->package_detail_id,
        "inventory_quantity" => $request->inventory_quantity
        ];

     $value =   $dealerPackage->createSpecificInventory($array_value);

        if ($value) {
            return response()->json([
                'success' => true,
                'message' => 'The Inventory Created Successfully.'
              ]);
        } else {
            return response()->json([
                'success' => false,
                'message' => 'Something Went Wrong.'
              ]);
        }
    }

    public function storeOpenFilePackagesDecision(Request $request,DealerPackage $dealerPackage)
    {
    
    //  dd($request->all());

      $dealer_package=  DealerPackage::where('id', $request->dealer_package_id)->first();
   if($request->status == 1){
            $dealer_package->is_approved = 1;
            $dealer_package->save();
   }
      if($request->inventory_created){

            $array_value = [
                'openfilepackage_id' => $dealer_package->package->id,
                'dealerpackage_id' => $dealer_package->id
            ];

        $value =   $dealerPackage->createInventory($array_value);

            if ($value) {
                return redirect()->route('openfile.pending.package')->with(['message' => 'Package Inventory Created Successfully!', 'alert-type' => 'success', ]);
            } else {
                return redirect()->route('openfile.pending.package')->with(['message' => 'SomeThing went wrong!', 'alert-type' => 'error', ]);
            }
             
      }

        return redirect()->route('openfile.pending.package')->with(['message' => 'Package Inventory Created Successfully!', 'alert-type' => 'success', ]);
    
    }

    public function viewPendingAmount($id)
    {
        
     
     $dealer_package=   DealerPackage::where('id',$id)->first();
     $dealer_payment=      DealerPackageReceipt::where('dealerpackage_id', $id)->get();
     $paid_amount =   $dealer_payment->where('is_approved',1)->where('payment_head',Receipt::package_payment)->sum('amount');
   
     $banks = DepositorBank::all();
     $dealertypes = DealerType::pluck('name', 'id');
     $cBanks = CompanyBank::all();
        return view('openfile.pendingpayments',compact('cBanks','dealertypes','banks','dealer_payment','dealer_package','paid_amount'));
    }

    
    public function storePendingAmount(Request $request)
    {
     
        // dd($request->all());
        DB::beginTransaction();
        try {
            $dealerpackage =  DealerPackage::where('id',$request->dealerpackage_id)->first();
            $openfilepackage = OpenFilePackage::where('id', $request->package_id)->first();

            if (!empty($openfilepackage)) {
                $dealerpackage->package_id = $request->package_id;
                $dealerpackage->dealer_id = $request->dealer_id;
                $dealerpackage->issue_date = $request->date;

                if ($openfilepackage->total_price > $request->Amount) {
                    $dealerpackage->payment_status = DealerPackage::pending;
                } elseif ($openfilepackage->total_price >= $request->Amount) {
                    $dealerpackage->payment_status = DealerPackage::completed;
                } else {
                    $dealerpackage->payment_status = DealerPackage::pending;
                }
                $dealerpackage->save();

                $dealer_package_paid_amount =   new DealerPackagePaidAmount;
                $dealer_package_paid_amount->dealer_package_id  = $dealerpackage->id;
                $dealer_package_paid_amount->amount = $request->Amount;
                $dealer_package_paid_amount->payment_method = $request->payment_method;
                $dealer_package_paid_amount->save();
            }
           
        }
        catch (\Exception $e) {
            DB::rollback();
            return false;
        }
        DB::commit();
        return true;
       
    }

    public function cancelNewOpenFile(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'openfiledealerinfo_no' => 'required',
            'openfile_status' => 'required',
            // 'openfile_cancelfee' 
        ]);

        if ($validator->fails()) {
            return redirect('/cancel-statements/new')
                ->withErrors($validator)
                ->withInput()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        // dd( $request->all());


        foreach ($request->openfiledealerinfo_no as $openfile) {
            CancelOpenFile::create(['openfile_dealer_info_id' => $openfile, 'fee' => $request->openfile_cancelfee]);
        }
        $pro = implode(" ", $request->openfiledealerinfo_no);
        activity('Cancel Property Request')->log($pro . ' Open File registered for Cancel.');
        return redirect()
            ->route('statement.cancel')
            ->with([
                'message' => 'Request cancel added successfully!',
                'alert-type' => 'info'
            ]);
    }

    public function editCancelOpenFileForm($id)
    {

        
        $data['allopenfile']=    OpenFileDealerInfo::has('cancelOpenFile')->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->where('id',$id)->first();

        return view('openfile.cancel.edit', $data);
    }
  public function updateCancelOpenfileForm(Request $request)
    {
         
      
        $dealer_openfile =  CancelOpenFile::where('openfile_dealer_info_id', $request->openfiledealerinfo_no)->first();

        $dealer_openfile->status = $request->property_status;
        $dealer_openfile->fee = $request->openfile_cancelfee;

        $dealer_openfile->after_cancellation_status = $request->after_cancellation_status;
        $dealer_openfile->save();
        
        if ($dealer_openfile->status == 1) {
            $val=OpenFileDealerInfo::where('id', $dealer_openfile->openfile_dealer_info_id)->first();
            Inventory::where('id', $val->invertory_id)->update(['status' => Inventory::hold_company]);
        } else {
            $val=OpenFileDealerInfo::where('id', $dealer_openfile->openfile_dealer_info_id)->first();
            Inventory::where('id', $val->invertory_id)->update(['status' => Inventory::package_open_file]);
        }



        activity('Update Cancel OpenFile Request')->log($dealer_openfile->customer_property_id . ' Open File registered for Cancel.');
        return redirect()
            ->route('statement.cancel')
            ->with([
                'message' => 'Request update successfully!',
                'alert-type' => 'info'
            ]);
    }


    public function editOpenFileRefund($id) {
    
        $data['openfilerefund'] = OpenFileDealerInfo::with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')
        ->where([['id','=',$id]])->first();
        
        $pricelist = PriceList::where('id', $data['openfilerefund']->dealerPackage->package->pricelist->id)->first();
        
      
        $size = UnitSize::where('id',$data['openfilerefund']->inventory->size->id)->first();
        
        $price = $pricelist->pricedetail->where('unit_size_id', $size->id)->where('unit_type_id', $data['openfilerefund']->inventory->type->id)->first();
        if (!empty($price)) {


            $scheduleplane = SchedulePlan::first();
            $per = $scheduleplane->down_payment;


            $result = $price->total_price * $per / 100;
        }
        $data['result'] = $result;
        return view('openfile.refund.edit', $data);
       
    }

    public function updateOpenFileRefund(Request $request) {

        // 0 => pending
        // 1 => approve
        // 2 => decline
        $this->validate($request,[
            'id'=>'required',
            'refund_deduction_type'=>'required',
            'refund_amount_deducted'=>'required',
            'status'=>'required',
         ]);
        // dd($request->all());

        // OpenFileRefundHistory;
        $cancel_property_id = $request->id;
        $cancel_openfile= CancelOpenFile::where('id',$request->id)->first();   
        $val=OpenFileDealerInfo::where('id', $cancel_openfile->openfile_dealer_info_id)->first();
        if($request->status == OpenFileRefundHistory::REFUND_DECISION_DECLINE){
            $inventory=   Inventory::where('id', $val->invertory_id)->update(['status' => Inventory::package_open_file]);
            $cancel_openfile->after_cancellation_status = 'decline';
            $cancel_openfile->save();
             activity('Decline')->log($inventory->unit_number . ' Open File Cancel Request.');
             return redirect()->route('property.refund')
             ->with([
                 'message' => 'Refund Openfile updated Successfully!',
                 'alert-type' => 'success',
                    ]);
            }
        $openfilerefund =  OpenFileRefundHistory::where('dealer_id',$cancel_openfile->openFileDealerInfo->dealer_id)->where('inventory_id',  $cancel_openfile->openFileDealerInfo->invertory_id)->first();
        if (empty($openfilerefund)) {
            $openfilerefund = new OpenFileRefundHistory();
        }
        $receivedAmt=   $val->dealerPackage->dealerPackagePayment->where('dealer_package_id',$val->dealerPackage->id)->where('is_approved',1)->sum('amount');    
        $openfilerefund->dealer_id = $cancel_openfile->openFileDealerInfo->dealer_id;
        $openfilerefund->inventory_id = $cancel_openfile->openFileDealerInfo->invertory_id;
        $openfilerefund->total_amount = $receivedAmt;
        $openfilerefund->cancel_openfile_id = $cancel_openfile->id;
        if ($request->refund_deduction_type == OpenFileRefundHistory::REFUND_DEDUCTUION_IN_PKR) {
            $openfilerefund->total_deduct =  $request->refund_amount_deducted;
           $refund= $request->refund_amount_deducted;
           if( $refund > 0){
                $openfilerefund->total_refund = $refund;
            } else {
                $openfilerefund->total_refund = 0;
            }
          

            if ($receivedAmt != 0) {
                $openfilerefund->total_deduct_percentage = ($request->refund_amount_deducted / $receivedAmt) * 100;
            }
        }
        elseif ($request->refund_deduction_type == OpenFileRefundHistory::REFUND_DEDUCTUION_IN_PERCENTAGE) {
            $val= ($request->refund_amount_deducted / 100) *  $receivedAmt;
            $openfilerefund->total_deduct = $val;
            $refund= $val;
            if($refund > 0){
                $openfilerefund->total_refund = $refund;
            } else {
                $openfilerefund->total_refund = 0;
            }
           
            $openfilerefund->total_deduct_percentage = $request->refund_amount_deducted;
        }
        $openfilerefund->save();
        //make statement history
        if ($request->status == OpenFileRefundHistory::REFUND_DECISION_APPROVED) {
            $update_cancel_property= CancelOpenFile::where('id',$request->id)->first();
            $update_cancel_property->after_cancellation_status = 'refunded';
            $update_cancel_property->save();
           
            $inventory =   Inventory::where('id', $val->invertory_id)->update(['status' => Inventory::package_open_file_refunded]);
            activity('update OpenFile Refund Request')->log($cancel_openfile->openFileDealerInfo->invertory_id. ' Refund Approval Request.');
        }
        return redirect()->route('property.refund')
        ->with([
            'message' => 'Refund Unit updated Successfully!',
            'alert-type' => 'success',
               ]);
        //end statement history  
    }




    public function getPendingReceipts()
    {
        $data = array();
        $data=  $this->getCookieInfoAndMultiPro();
        if($data['status'] == 'error'){
            return redirect()

            ->back()
            ->with([
                'message' => 'Invalid Inputs!',
                'alert-type' => 'error',
            ]);
        }
        $ids=[];
        if(is_array($data['project_ids'])){
            $ids=    $data['project_ids'];
           }
           else
           {
            $ids[]=    $data['project_ids'];
           }
        $data['receipts'] = DealerPackageReceipt::where([['is_approved', 0], ['is_deleted', 0]])
        ->when($ids[0] !== 'all', function ($query) use ($ids) {
            $query->whereIn('multi_project_id', $ids);
                            })
        ->orderBy('receipt_date', 'asc')->paginate(25);

       
        // $data['totalAmount'] = Receipt::where([['is_approved', false], ['is_deleted', false], ['cheaque_status', Receipt::pending]])->count();

        activity('View')->log('Pending Receipt List');

        return view('openfile.receipt.pending-receipts', $data);
    }
    public function approvedReceipt(Request $request)
    {
       
        $current_receipt = DealerPackageReceipt::find($request->dealerreceipt_id);
      
        $isLessDateReceipt = DealerPackageReceipt::where('receipt_date', '<', $current_receipt->receipt_date)->where('dealerpackage_id', $current_receipt->dealerpackage_id)->where('is_approved', false)->where('is_deleted', false)->first();
        if ($isLessDateReceipt > 0) {
            return redirect('/receipt/pendings')
                ->withInput()
                ->with([
                    'message' => 'Error ! First approve lower date receipt.',
                    'alert-type' => 'error',
                ]);
        }

   DB::beginTransaction();
        try {
       $d_Id=     $current_receipt->dealerpackage_id;
            $dealer_payment =      DealerPackageReceipt::where('dealerpackage_id',$d_Id)->where('is_approved',1)->where('payment_head',Receipt::package_payment)->get();
            $paid_amount =   $dealer_payment->sum('amount');
            
            //    dd($current_receipt);
            $current_receipt->is_approved = 1;
            $current_receipt->save();
           $pid=   $current_receipt->dealerPackage->package->id;
            $dealerpackage = DealerPackage::where('id', $current_receipt->dealerpackage_id)->first();
            $openfilepackage = OpenFilePackage::where('id', $pid)->first();
           
            if (!empty($openfilepackage)) {

              
              
              
                 $amount=   $current_receipt->amount + $paid_amount;
               
                 
                if ($openfilepackage->total_price > $amount) {
                  
                    $dealerpackage->payment_status = DealerPackage::pending;
                } elseif ($openfilepackage->total_price >=  $amount) {
                   
                    $dealerpackage->payment_status = DealerPackage::completed;
                    if ($dealerpackage->package->rebate_type == 'cash') {
                        $net_amount =   $dealerpackage->package;

                        $rebate = $dealerpackage->package->rebate_amount;
                        $dealer = Dealer::where('id', $dealerpackage->dealer_id)->first();
                        Dealer::where('id', $dealerpackage->dealer_id)->update([
                            'total_rebate' =>
                            $dealer->total_rebate + $rebate
                        ]);
                          //recently commented
                        //make transation
                        // DealerTransaction::create([
                        //     'dealer_package_id' => $dealerpackage->id,
                        //     'dealer_id' => $dealer->id,
                        //     'amount' => $rebate,
                        //     'status' => DealerTransaction::unpaid
                        // ]);
                          //recently commented end
                    }
                      //recently commented
                //     $result2 = DealerPackageReceipt::where([['receipt_no', '!=', null]])
                //     ->orderby('receipt_no', 'desc')->first();
        
                // if ($result2)
                //     $delaer_package_receipt_no = ++$result2->receipt_no;
                // else
                //     $delaer_package_receipt_no = '100000';
  //recently commented end
                    // if ($dealerpackage->package->rebate_type == 'cash') {

                    //     $receipt =new DealerPackageReceipt;
                    //     $receipt->dealer_id=$dealerpackage->dealer_id;
                    //     $receipt->dealerpackage_id=$dealerpackage->id;
                    //     $receipt->payment_head=Receipt::package_rebate;
                    //     $receipt->payment_mode = Receipt::cash;
                    //     $receipt->amount = $openfilepackage->rebate_amount;
                    //     $receipt->receipt_no=$delaer_package_receipt_no;
                    //     $receipt->receipt_date=date('Y-m-d');
                    //     $receipt->save();

                    // } else
                    
                    //recently commented
                    // if ($dealerpackage->package->rebate_type == 'openfile') {

                    //     if ($openfilepackage->remaining_rebate > 0) {
                    //         $receipt = new DealerPackageReceipt;
                    //         $receipt->dealer_id = $dealerpackage->dealer_id;
                    //         $receipt->dealerpackage_id = $dealerpackage->id;
                    //         $receipt->payment_method = Receipt::cash;
                    //         $receipt->payment_head = Receipt::package_rebate;
                    //         $receipt->payment_mode = Receipt::cash;
                    //         $receipt->amount = $openfilepackage->remaining_rebate;
                    //         $receipt->receipt_no = $delaer_package_receipt_no;
                    //         $receipt->receipt_date = date('Y-m-d');
                    //         $receipt->is_approved = 1;
                    //         $receipt->save();
                    //     }
                    // }
                     //recently commented end



                } else {
                    $dealerpackage->payment_status = DealerPackage::pending;
                 
                }
                $dealerpackage->save();
                // $type =   EmailSmsType::where('name', 'like', 'Paid Installement')->first();
                // if (!empty($type)) {
                //     $detail =   $type->detail->where('content_type', EmailSms::content_type_sms)->first();
                //     if (!empty($detail)) {
                //         if ($detail->status == EmailSms::status_on) {
                //             $msg =  $detail->content;
                //             $message = __($msg, [
                //                 'dealername' =>  $dealerpackage->dealer->name,
                //                 'receivedamount' => $receipt->amount,
                //                 'packagename' => $dealerpackage->package->name,
                              
                                

                //             ]);
                //             if ( $dealerpackage->dealer->phone_number && $receipt->notify_sms == 1) {
                //                 SmsController::sendSMS("92" . substr($dealerpackage->dealer->phone_number, 1), $message);
                //             }
                //             if ( $dealerpackage->dealer->email && $receipt->notify_email == 1) {

                //              $dealeremail=   $dealerpackage->dealer->email ;
                                
                //                 $smtp = SmtpSetting::where('status', 1)->first();
                //                 $transport = (new \Swift_SmtpTransport($smtp->smtp_host, $smtp->smtp_port))
                //                     ->setUsername($smtp->smtp_username)
                //                     ->setPassword($smtp->smtp_password);
                //                 $mailer = new \Swift_Mailer($transport);
                //                 $email = (new InstallmentConfirmation($message))
                //                     ->subject('Add Payment')
                //                     ->from($smtp->from_email, $smtp->from_name)
                //                     ->to($dealeremail)
                //                     ->view('emails.installment-confirmation');
                //                 $email_message = $email->render();
                //                 $swiftMessage = (new \Swift_Message())
                //                     ->setSubject('Add Payment')
                //                     ->setFrom($smtp->from_email, $smtp->from_name)
                //                     ->setTo($dealeremail)
                //                     ->setBody($email_message, 'text/html');
                //                 $response = $mailer->send($swiftMessage);
                //                 $email_log =  new EmailLog;
                //                 $email_log->smpt_setting_id = $smtp->id;
                //                 $email_log->receiver_email = $dealeremail;
                //                 $email_log->content = $message;
                //                 $email_log->title = 'Property Approved';
                //                 $email_log->mailable_class = 'new Membership';
                //                 $email_log->mail_view = 'emails.membership';

                //                 if ($response) {

                //                     $email_log->status = 1;
                //                 } else {
                //                     $email_log->status = 1;
                //                 }
                //                 $email_log->save();
                //             }
                //         }
                //     }

                    
                // }
            }
            DB::commit();
            
        }
        catch (\Exception $e) 
        {
            //dd($e);
            DB::rollback();
           
                return redirect('/receipt/pendings')
                    ->withInput()
                    ->with([
                        'message' => 'Something went wrong!',
                        'alert-type' => 'error',
                    ]);
            
        }

        

        

        activity('Approved')->log('Receipt Approved ' . $current_receipt->receipt_no);

        return redirect()
            ->route('receipt.package-approved.get')
            ->with([
                'message' => 'Receipt Approved successfully!',
                'alert-type' => 'info'
            ]);
    }


    

    public function viewPendingReceipt($id)
 {
       $dealerreceipt= DealerPackageReceipt::where('id', $id)->first();
        
        $pending_packages=  DealerPackage::where('id', $dealerreceipt->dealerpackage_id)->first();
        
       $paid_amount = $pending_packages->dealerPackagePaymentReceipt->where('dealerpackage_id',$pending_packages->dealer_package_id)->where('is_approved',1)->sum('amount');
        
       return view('openfile.receipt.apply-approve-receipt',compact('dealerreceipt','pending_packages','paid_amount'));
    }
    public function approveAllReceipt()
    {
        $data=  $this->getCookieInfoAndMultiPro();
      
    if($data['status'] == 'error'){
        return redirect()

        ->back()
        ->with([
            'message' => 'Invalid Inputs!',
            'alert-type' => 'error',
        ]);
    }
    $ids=[];
    if(is_array($data['project_ids'])){
        $ids=    $data['project_ids'];
       }
       else
       {
        $ids[]=    $data['project_ids'];
       }

        $receipt = $this->dealer_package_receipt->approvedAllReceipt($ids);

        if ($receipt == false ) {
            return redirect()->back()
                ->withInput()
                ->with([
                    'message' => 'Something went wrong!',
                    'alert-type' => 'error',
                ]);
        }

        activity('Approved')->log('All Receipt Approved ');

        return redirect()->back()
            ->with([
                'message' => 'Receipt Approved successfully!',
                'alert-type' => 'info'
            ]);
    }

//  
public function getCookieInfoAndMultiPro(){
    $data =  array();
    try{
        $request = app(Request::class);
       
                if($request->has('multipro_id')){
            
            if($request->multipro_id == 'all'){
                $data['multipro_id'] =$request->multipro_id;
            }else if(!empty($request->multipro_id)){
            $data['multipro_id'] =  decrypt($request->multipro_id);
            }
        }
        
        
        $project_id = request()->cookie('current_project_id');
       
        $user = Auth::user();
        $data['multi_projects'] = [];
        if (!empty($project_id)) {
            $p_id = decrypt($project_id);
            $multi = MultiProject::where('id', $p_id)->first();
            $multiProjectId = $multi->id;
            if ($multi->name == "Super Admin") {
                $roles = $user
                    ->roles()
                    ->where('name', 'like', 'admin')
                    ->whereHas('projects', function ($query) use ($multiProjectId) {
                        $query->where('multi_project_id', $multiProjectId);
                    })
                    ->first();
                if (!empty($roles)) {
                    $data['multi_projects']  = MultiProject::where('name', 'NOT like', 'Super Admin')->get();
                    $data['project'] = $multi->name;
                    $data['role'] = 'admin';
                    $data['project_ids'] =  'all';
                    if(isset( $data['multipro_id'])){
                        $data['project_ids'] = $data['multipro_id'];
                        
                    }
                    $data['status'] = 'success';
                    return  $data;
                    

                } else {
                    // $request = app(Request::class);
           
                $permission=decrypt($request->permission);
                
                $project_ids=       $user->roles()
               ->whereHas('projects', function ($query)   {
               $query->where('name', 'NOT like', 'Super Admin');
               })
               ->get()
               ->filter(function ($r) use ($permission) {
               return $r->hasPermission($permission);
               })
               ->pluck('projects.*.id') // Pluck the 'id' column from the remaining 'projects' models
               ->flatten() // Flatten the collection of IDs into a single array
               ->unique()
               ->toArray()
               ;
               
               if(sizeof($project_ids) == 0)
               {
                   $data['status'] = 'error';
                   return  $data; 
               }
                     
                    $data['multi_projects'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get();
                    $data['project'] = $multi->name;
                    $data['role'] = 'other';
                    $data['project_ids'] =  $project_ids;
                    if(isset( $data['multipro_id'])){
                        if($data['multipro_id'] != 'all'){
                        $data['project_ids'] = $data['multipro_id'];
                        }
                     
                    }
                    $data['status'] = 'success';
                    return $data;
                }
            }
            else{
                $roles = $user
                    ->roles()
                    
                    ->whereHas('projects', function ($query) use ($multiProjectId) {
                        $query->where('multi_project_id', $multiProjectId);
                    })
                    ->first(); 
                
                    if (!empty($roles)) {
                        $data['multi_projects']  = [];
                        $data['project'] = $multi->name;
                        $data['role'] = 'other';
                        $data['project_ids'] =  $multi->id ;
                        if(isset( $data['multipro_id'])){
                            if($data['multipro_id'] != 'all'){
                                $data['project_ids'] = $data['multipro_id'];
                                }
                        }
                        $data['status'] = 'success';
                        return  $data;
                        
    
                    }
            }
        }
        else
        {
            $data['status'] = 'error';
            return  $data; 
        }
    }
    catch(\Exception $e){
        $data['status'] = 'error';
        return  $data;

    }
}    
public function viewApprovedReceipt()
{  

    $data = array();
    
    $data=  $this->getCookieInfoAndMultiPro();
      
    if($data['status'] == 'error'){
        return redirect()

        ->back()
        ->with([
            'message' => 'Invalid Inputs!',
            'alert-type' => 'error',
        ]);
    }
    $ids=[];
    if(is_array($data['project_ids'])){
        $ids=    $data['project_ids'];
       }
       else
       {
        $ids[]=    $data['project_ids'];
       }
    // multi_project_id
 
    $dealer_payment= DealerPackageReceipt::where([['is_approved', 1],['is_deleted','!=',1]])
    ->when($ids[0] !== 'all', function ($query) use ($ids) {
        $query->whereIn('multi_project_id', $ids);
                        })
    ->orderBy('id', 'desc')->paginate(25);  
    $data['dealers'] = Dealer::where('is_deleted', false)->select('id', 'name', 'code')->orderBy('name', 'asc')->get();
    // $data['totalAmount'] = Receipt::where([['is_approved', 1], ['is_deleted', false]])
    // ->count();
    // $data['receiptNo'] = Receipt::where('is_deleted', false)->where('is_approved', true)->select('id', 'receipt_no')->get();
    
    return view('openfile.receipt.all-approved-receipts', compact('dealer_payment'));
}

public function destroyDealerReceipt($id)
    {
        if(is_numeric($id))
        {
            DealerPackageReceipt::where('id', $id)->update(['is_deleted'=>true]);

            // for permant delete
            // use $user->forceDelete()
        }
        activity('Delete')->log('Delete Dealer Package Receipt  ');

        return redirect()->route('receipt.package.pending')->with(['message' => ' Dealer Package Receipt Deleted
        Successfully!',
        'alert-type' =>
        'success', ]);
    }

  //update the statment table
  public function updateTable(Request $request)
  {
       
      $filters = array();
      

      if ($request->dealer != 0)
          $filters['dealer'] = $request->dealer;
      if ($request->status != 0)
          $filters['status'] = $request->status;
      if ($request->openfilepackage != 0)
          $filters['openfilepackage'] = $request->openfilepackage;
      if ($request->date != 0)
          $filters['date'] = $request->date;
      if ($request->package_inventory != 0)
          $filters['package_inventory'] = $request->package_inventory;
          if ($request->multipro != 0)
          $filters['multipro'] = $request->multipro;
          $data = array();
    
    $data=  $this->getCookieInfoAndMultiPro();
      
    if($data['status'] == 'error'){
        return redirect()

        ->back()
        ->with([
            'message' => 'Invalid Inputs!',
            'alert-type' => 'error',
        ]);
    }
    $ids=[];
    if(is_array($data['project_ids'])){
        $ids=    $data['project_ids'];
       }
       else
       {
        $ids[]=    $data['project_ids'];
       }

     $openfile_package=  new OpenFilePackage;

        $data = $openfile_package->updateTable($filters,$ids);


     return view('openfile.update_table', $data);
  }

}
