<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\ChartOfAccount;
use App\ControlAccount;
use App\AccountClass;
use App\UnitType;
use App\UnitSize;
use App\OpenFilePackage;
use App\OpenFilePackageDetail;
use App\ProjectType;
use App\PriceList;
use App\SchedulePlan;
class PackageController extends Controller
{
    //
    public function index()
    {
        $allpackagelist = OpenFilePackage::where([['is_deleted',false]])->orderBy('created_at', 'desc')->get();

        activity('View')->log('View Package index');

        return view('package.index', compact('allpackagelist'));
    }
    public function create()
    {
        $data['types'] = UnitType::where([['is_deleted',false],['status',1],['projecttype_id',ProjectType::society]])->get();
        $data['sizes']= UnitSize::where([['is_deleted',false]])->orderBy('name','asc')->get();
        $data['pricelist']= PriceList::where([['project_type_id',ProjectType::society]])->orderBy('id','asc')->get();
        activity('Create')->log('Create Package ');
        
        return view('package.create',$data);
    }
    public function store(Request $request,OpenFilePackage $openfilepackage)
    {
        // return true;

       
         
        $this->validate($request,[
            'package_name'=>'required',
'package_price'=>'required',
'rebate_amount'=>'required',
'rebatetype'=>'required'
           
            
         ]);
        // "unit_quantity" => array:1 [
        //     0 => "10"
        //   ]
        //   "unit_size" => array:1 [
        //     0 => "3"
        //   ]
        //   "unit_type" => array:1 [
        //     0 => "1"
        //   ]
        //   "package_name" => "test"
      $return_value=  $openfilepackage->insertData($request);

        if ($return_value) {
            return redirect()->back()->with(['message' => 'Package  Added Succesfully!', 'alert-type' => 'success',]);
        }
        else{

            return redirect()->back()->with(['message' => 'SomeThing went wrong!', 'alert-type' => 'error',]);
        }

        // OpenFilePackage;
        // OpenFilePackageDetail
    }

    public function show($id) {
        
        $package = OpenFilePackage::where('id',$id)->first();
        // $pricelistdetail = PriceListDetail :: where('id',$id)->first();
        // dd($pricelistdetail);
        return view('package.detail', compact('package'));

    }    

    public function destroy($id)
    {
        if(is_numeric($id))
        {
            OpenFilePackage::where('id', $id)->update(['is_deleted'=>true]);
            $p = UnitType::where('id',$id)->first();

            //for permant delete
            // use $user->forceDelete()
        }
            activity('Delete')->log('Delete Package ');
        
        return redirect()->route('packge.index')->with(['message' => ' Package Deleted Successfully!', 'alert-type' =>
        'success', ]);
    }


    public function getDownPayment(Request $request)
    {
        // unit_size_id
        //unit_type_id
        //price_value_id
        $this->validate($request,[
            'unit_size_id'=>'required|integer',
            'unit_type_id'=>'required|integer',
            'price_value_id'=>'required|integer',  
         ]);
        

        $pricelist = PriceList::where('id', $request->price_value_id)->first();

      
            $size = UnitSize::where('id',$request->unit_size_id)->first();
            $price = $pricelist->pricedetail->where('unit_size_id', $size->id)->where('unit_type_id',$request->unit_type_id)->first();
            if (!empty($price)) {
                // return $price->total_price;

            $scheduleplane=SchedulePlan::first();
           $per=    $scheduleplane->down_payment;


            $result = $price->total_price * $per / 100;

            return $result;


            }
            return 0;
       
    }

   
}
