<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Payment;
use App\CustomerProperty;
use App\Customer;
use App\DepositorBank;
use App\CompanyBank;
use App\CustomerPropertyFullPaymentStatement;
use Illuminate\Support\Facades\Validator;
use App\CustomerPropertyFullPayment;
use DB;

class PaymentController extends Controller
{

    protected $payment;

    public function __construct() {
        $this->payment = new Payment();
    }

    public function getAllPayments() {

        $payments = Payment::with('property')->orderBy('created_at','desc')->get();
        $totalAmount = Payment::sum('amount');

        return view('payment.index',compact('payments','totalAmount'));
    }

    public function addPaymentForm() {

        $customers = Customer::all();
        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();

        return view('payment.add-payment',compact('customers','banks','cBanks'));
    }

    public function updatePropertyForm(Request $request) {

        $properties = CustomerProperty::where([['customer_id',$request->customer_id],['booking_type','!=',CustomerProperty::normal]])->with('inventory')->get();

        $receivedAmount = array();
        $lastDate = array();
        $remainingAmount = array();
        $discountAmount = array();

        foreach($properties as $property) {
            $data = CustomerPropertyFullPayment::where('customer_property_id',$property->id)->first();
            if($data)
                $discountAmount[$property->id] = $data->discount_amount;
            else
                $discountAmount[$property->id] = 0;
            $receivedAmount[$property->id] = Payment::where('property_id',$property->id)->sum('amount');
            $lastDate[$property->id] = Payment::where('property_id',$property->id)->orderBy('receipt_date','desc')->first();
            $balance = CustomerPropertyFullPaymentStatement::where('property_id',$property->id)->value(DB::raw("SUM(balance)"));
            $remainingAmount[$property->id] = $balance;

        }

        return view('payment.update-property',compact('properties','receivedAmount','lastDate','remainingAmount','discountAmount'));
    }

    public function insertPayment(Request $request) {

        $validator = Validator::make($request->all(), [
                    'amount' => 'required|regex:/^[0-9]+$/u',
                    'customer_id'=>'required',
                    'property_id'=>'required',
                    'payment_mode' => 'required',
                    'receipt_date' => 'required',
                    'cheque_number'=>'nullable|regex:/^[a-zA-Z\s0-9]+$/u',
                    'receipt_no' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect('/add/customer-payment')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        $payment = $this->payment->insertPayment($request);

        return redirect()
                        ->route('statement.detail',['id'=>$request->property_id])
                        ->with([
                            'message' => 'Payment added successfully!',
                            'alert-type' => 'info'
        ]);

    }

    public function detailPayment($id) {

        $payment = Payment::where('id',$id)->with('customer','property')->first();

        return view('payment.detail-payment',compact('payment'));
    }

    

    public function deletePayment($id){

        $payment = Payment::where('id',$id)->first();

        //delete previous record
        $cBank = CompanyBank::where('id',$payment->company_account)->first();
        if($cBank) {

                CompanyBank::where('id',$receipt->company_account)->update(['amount'=>$cBank->amount - $payment->amount ]);
       //make transation
            CompanyBankTransaction::where('receipt_id', $payment->id)->delete();

                }

        $payment = $this->payment->deletePayment($id);

        return redirect()
                        ->route('statement.detail',['id'=>$payment->property_id])
                        ->with([
                            'message' => 'Payment deleted successfully!',
                            'alert-type' => 'info'
        ]);
    }
}
