<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\PaymentHead;

class PaymentHeadController extends Controller {

    protected $paymentHead;

    public function __construct() {
        $this->paymentHead = new PaymentHead();
    }

    //Get All the Payment Head
    public function allPaymentHeads() {

        $allPaymentHeads = PaymentHead::orderBy('created_at', 'desc')->get();

        return view('Setting/paymentHead.index', compact('allPaymentHeads'));
    }

    //show the add new PaymentHead  form
    public function addPaymentHeadForm() {

        return view('Setting/paymentHead.add-payment-head');
    }

    //insert new PaymentHead record
    public function insertPaymentHead(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u'
        ]);

        if ($validator->fails()) {
            return redirect('/payment-head/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new PaymentHead
        //PaymentHead::create(Input::all());
        $input=$request->all();
        PaymentHead::create($input);
        
        return redirect()
                        ->route('paymentHead.all')
                        ->with([
                            'message' => 'PaymentHead created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the edit PaymentHead form
    public function editPaymentHeadForm($id) {

        $paymentHead = PaymentHead::where('id', $id)->first();

        return view('Setting/paymentHead.edit-payment-head', compact('paymentHead'));
    }

    //update the PaymentHead record
    public function updatePaymentHead(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u'
                    
        ]);

        if ($validator->fails()) {
            return redirect('/payment-head/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update PaymentHead
        PaymentHead::where('id',$request->id)->update(['name'=>$request->name]);

        return redirect()
                        ->route('paymentHead.all')
                        ->with([
                            'message' => 'PaymentHead updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific PaymentHead
    public function deletePaymentHead($id) {

        PaymentHead::where('id', $id)->delete();

        return redirect()->route('paymentHead.all')->with([
                    'message' => 'paymentHead deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
