<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\Policy;

class PolicyController extends Controller {

    protected $policy;

    public function __construct() {
        $this->policy = new Policy();
    }

    //Get All the Policies
    public function allPolicies() {

        $allPolicies = Policy::orderBy('created_at', 'desc')->get();

        return view('payroll/policy.index', compact('allPolicies'));
    }

    //show the add new Policy  form
    public function addPolicyForm() {

        return view('payroll/policy.add-policy');
    }

    //insert new Policy record
    public function insertPolicy(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'amount' => 'required|numeric|min:0',
                    'type'=>'required'
        ]);

        if ($validator->fails()) {
            return redirect('/policy/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new Policy
        //$policy = Policy::create(Input::all());
        $input=$request->all();
        $policy = Policy::create($input);

        return redirect()
                        ->route('policy.all')
                        ->with([
                            'message' => 'Policy created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the edit Policy form
    public function editPolicyForm($id) {

        $policy = Policy::where('id', $id)->first();

        return view('payroll/policy.edit-policy', compact('policy'));
    }

    //update the Policy record
    public function updatePolicy(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'amount' => 'required|numeric|min:0',
                    'type'=>'required'
                    
        ]);

        if ($validator->fails()) {
            return redirect('/policy/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Policy
        Policy::where('id',$request->id)->update(['name'=>$request->name,'type'=>$request->type,'amount'=>$request->amount]);

        return redirect()
                       ->route('policy.all')
                        ->with([
                            'message' => 'Policy updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific Policy
    public function deletePolicy($id) {

        Policy::where('id', $id)->delete();

        return redirect()->route('policy.all')->with([
                    'message' => 'Policy deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
