<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\UnitCategory;
use App\UnitSize;
use App\UnitType;
use App\UnitFloor;
use App\UnitBlock;
use App\ProjectType;
use App\PriceList;
use App\PriceListDetail;

class PriceListController extends Controller
{
    //
    public function index(){
       
        $data['projecttype'] =   ProjectType::where('status', true)->first();
        if ($data['projecttype']->id == ProjectType::high_rise) {
            $allpricelist = PriceList::where([['is_deleted',false]])->where('project_type_id',ProjectType::high_rise)->orderBy('created_at', 'desc')->get();
      
        }
        else if ($data['projecttype']->id == ProjectType::society) {
            $allpricelist = PriceList::where([['is_deleted',false]])->where('project_type_id',ProjectType::society)->orderBy('created_at', 'desc')->get();
      
        }
        
        return view('pricelist.index', compact('allpricelist'));
    }

    public function create(){

        $data['projecttype'] =   ProjectType::where('status', true)->first();

        if( $data['projecttype']->id == ProjectType::high_rise){
            $data['h_r_types'] = UnitType::where([['is_deleted',false],['status',1],['projecttype_id',$data['projecttype']->id]])->get();
            $data['h_r_floor'] = UnitFloor::where([['is_deleted',false]])->get();
        }
        if( $data['projecttype']->id == ProjectType::society){
            $data['types'] = UnitType::where([['is_deleted',false],['status',1],['projecttype_id',$data['projecttype']->id]])->get();
        }
       
        $data['sizes']= UnitSize::where([['is_deleted',false]])->orderBy('name','asc')->get();
        return view('pricelist.create',$data);
    }

    public function show($id) {
        
        $pricelist = PriceList::where('id',$id)->first();
        // $pricelistdetail = PriceListDetail :: where('id',$id)->first();
        // dd($pricelistdetail);
        return view('pricelist.detail', compact('pricelist'));
    }

    public function edit($id)
    {
        $data['price'] = PriceList::where('id', $id)->first();
        $data['projecttype'] =   ProjectType::where('status', true)->first();
        if( $data['projecttype']->id == ProjectType::high_rise){
            $data['h_r_types'] = UnitType::where([['is_deleted',false],['status',1],['projecttype_id',$data['projecttype']->id]])->get();
            $data['h_r_floor'] = UnitFloor::where([['is_deleted',false]])->get();
        }

        if( $data['projecttype']->id == ProjectType::society){
            $data['types'] = UnitType::where([['is_deleted',false],['status',1],['projecttype_id',$data['projecttype']->id]])->get();
        }

       
        $data['sizes']= UnitSize::where([['is_deleted',false]])->orderBy('name','asc')->get();

        return view('/pricelist.edit',$data);
    }

    public function update(Request $request)
    {
    //    dd($request->all());
         $this->validate($request,[
            'project_type'=>'required',
            'list_number'=>'required',
            'pricelist_id' => 'required'
            
         ]);
       $pricelist= PriceList::where('id', $request->pricelist_id)->first();
       if( $pricelist->l_no  != $request->list_number){
        $this->validate($request,[   
            'list_number'=>'required|unique:price_lists,l_no', 
         ]);
            $pricelist->l_no = $request->list_number;
            $pricelist->save();
       }
        //update unitType
        $return_value=     $pricelist->updateDetail($request,$pricelist->id);
        if ($return_value == true) {
            activity('Update')->log('Edit Price List added ');

            return redirect()
                ->route('pricelist.index', $pricelist->id)
                ->with([
                    'message' => 'Price List updated successfully!',
                    'alert-type' => 'info'
                ]);
        } else {
            return redirect()
            ->route('pricelist.edit',$pricelist->id)
            ->with([
                'message' => 'Error Something went wrong!',
                'alert-type' => 'error'
            ]);
        }
    }

    public function store(Request $request,PriceList $pricelist){
 
        $this->validate($request,[
            'project_type'=>'required',
            'list_number'=>'required|unique:price_lists,l_no',
            
         ]);
       
    //      if ($request->project_type == ProjectType::high_rise) {
    //         $this->validate($request,[
    //             'high_rise_price'=>'required|integer',
    //          ]);
    // }

        // if ($request->project_type == ProjectType::high_rise) {
        //     $return_value = $pricelist->insertDetail($request);
        //     if ($return_value) {
        //         return redirect()->route('pricelist.index')->with(['message' => 'Price List Added Succesfully!', 'alert-type' => 'success',]);
        //     } else {
        //         return redirect()->route('pricelist.index')->with(['message' => 'SomeThing Went Wrong!', 'alert-type' => 'error',]);
        //     }
        // }
        //  elseif ($request->project_type == ProjectType::society) {
            $return_value = $pricelist->insertDetail($request);
            if ($return_value) {
                return redirect()->route('pricelist.index')->with(['message' => 'Price List Added Succesfully!', 'alert-type' => 'success',]);
            } else {
                return redirect()->route('pricelist.index')->with(['message' => 'SomeThing Went Wrong!', 'alert-type' => 'error',]);
            }
        // }
    }
    
    public function destroy($id){
       

        if(is_numeric($id))
        {
            PriceList::where('id', $id)->update(['is_deleted'=>true]);
            $p = UnitType::where('id',$id)->first();      

            //for permant delete
            // use $user->forceDelete() 
        }
        activity('Delete')->log('Delete Price List ');
        
        return redirect()->route('pricelist.index')->with(['message' => ' Pricelist Deleted Successfully!', 'alert-type' =>
        'success', ]);
    }
    
}