<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\ProductType;

class ProductTypeController extends Controller {

    protected $productType;

    public function __construct() {
        $this->productType = new ProductType();
    }

    //Get All the Product Type
    public function allProductTypes() {

        $allProductTypes = ProductType::orderBy('created_at', 'desc')->get();

        return view('Setting/productType.index', compact('allProductTypes'));
    }

    //show the add new Product Type  form
    public function addProductTypeForm() {

        return view('Setting/productType.add-type');
    }

    //insert new Product Type record
    public function insertProductType(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'start_from' => 'required|numeric|min:1'
        ]);

        if ($validator->fails()) {
            return redirect('/product-type/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new Product Type
         //ProductType::create(Input::all());
         $input=$request->all();
         ProductType::create($input);

        return redirect()
                        ->route('product.type.all')
                        ->with([
                            'message' => 'Product type created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the Product Type
    public function detailProductType($id) {

        $type = ProductType::where('id', $id)->first();

        return view('Setting/productType.detail-type', compact('type'));
    }

    //show the edit Product Type form
    public function editProductTypeForm($id) {

        $type = ProductType::where('id', $id)->first();

        return view('Setting/productType.edit-type', compact('type'));
    }

    //update the Product Type record
    public function updateProductType(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'start_from' => 'required|numeric|min:1',

        ]);

        if ($validator->fails()) {
            return redirect('/product-type/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Product Type
        ProductType::where('id',$request->id)->update(['name'=>$request->name,'start_from'=>$request->start_from]);

        return redirect()
                        ->route('product.type.all')
                        ->with([
                            'message' => 'Product type updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific Product Type
    public function deleteProductType($id) {

        ProductType::where('id', $id)->delete();

        return redirect()->route('product.type.all')->with([
                    'message' => 'Product type deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
