<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\ProjectAccount;
use App\Inventory;
use App\DepositorBank;

class ProjectAccountController extends Controller
{
    protected $amount;

    public function __construct() {

        $this->amount = new ProjectAccount();
    }

    public function getAllAccounts()
    {
        $amounts = ProjectAccount::with('inventory')->orderby('date','desc')->get();
        $totalAmount = ProjectAccount::sum('amount');

        return view('projectAccount.index',compact('amounts','totalAmount'));
    }

    public function addAccountForm()
    {
        $inventories = Inventory::where('status',Inventory::sold)->get();

        $banks = DepositorBank::all();

        return view('projectAccount.add-amount',compact('inventories','banks'));
    }

    public function insertAccount(Request $request) {

        $validator = Validator::make($request->all(), [
                    'amount' => 'required|regex:/^[0-9]+$/u',
                    'inventory_id'=>'required',
                    'depositor_name'=>'required',
                    'payment_type' => 'required',
                    'payment_head' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/project-account/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        $amount = $this->amount->insertAmount($request);

        return redirect()
                        ->route('account.detail',['id'=>$amount->id])
                        ->with([
                            'message' => 'Payment added successfully!',
                            'alert-type' => 'info'
        ]);
    }

    public function editAccountForm($id) {

        $amount = ProjectAccount::where('id',$id)->first();

        $inventories = Inventory::where('status',Inventory::sold)->get();

        $banks = DepositorBank::all();

        return view('projectAccount.edit-amount',compact('amount','inventories','banks'));
    }

    public function updateAccount(Request $request) {

        $validator = Validator::make($request->all(), [
                    'amount' => 'required|regex:/^[0-9]+$/u',
                    'date' => 'required',
                    'inventory_id'=>'required',
                    'depositor_name'=>'required',
                    'payment_type' => 'required',
                    'payment_head' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/project-account/edit/'.$request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        $this->amount->updateAmount($request);

        return redirect()
                        ->route('account.detail',['id'=>$request->id])
                        ->with([
                            'message' => 'Payment updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    public function detailAccount($id) {

        $amount = ProjectAccount::where('id',$id)->with('inventory','bank','files')->first();

        return view('projectAccount.detail-amount',compact('amount'));

    }

    public function deleteAccount($id) {

        ProjectAccount::where('id',$id)->delete();

        return redirect()
                        ->route('account.all')
                        ->with([
                            'message' => 'Payment deleted successfully!',
                            'alert-type' => 'info'
        ]);
    }
}
