<?php

namespace App\Http\Controllers;


use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Project;
use DB;
use Session;
use Illuminate\Validation\Rule;

class ProjectController extends Controller
{
    

    public function __construct()
{
           
}

function index()
{
      $projectList = Project::orderBy('id', 'DESC')->get();
      return view('procurement/project.index' ,compact('projectList') );
}


function create()
{
      return view('procurement/project.addProject');
}



function store(Request $request)
{

$validator = Validator::make($request->all(), [
                    'name' => 'required|unique:projects,project_name',
                    'contact' => 'required|numeric|min:11',
                    'address' => 'required',
        ]);


       if ($validator->fails()) {
            return redirect('/projects/add-project')
                            ->withErrors($validator)
                            ->withInput();
        }


         $createProject = Project::create([
                    'project_name' => $request->name,
                    'description' => $request->description,
                    'contact' => $request->contact,
                    'address' => $request->address
          ]);
        
        return redirect()->route('project.list')->with('success' , 'Project Added Successfully!');
}

function destroy($id)
{
    if(is_numeric($id))
    {
         Project::where('id',$id)->delete();
    }
 
  return redirect()->route('project.list')->with('success' , 'Project Removed Successfully!');
}

function edit($id)
{
 
   if(is_numeric($id))
    {
          $findProject = Project::where('id', $id)->first();
           return view('procurement/project.editProject' ,compact('findProject') );
    }

}

function update(Request $request)
{
$id = $request->input('id');
if(is_numeric($id))
{
  $validator = Validator::make($request->all(), [
                    'name' => 'required|unique:projects,project_name,'.$id,
                    'contact' => 'required|numeric|min:11',
                    'address' => 'required',

        ]);


       if ($validator->fails()) {
            return redirect('/projects/edit-project/'.$id)
                            ->withErrors($validator)
                            ->withInput();
        }

    Project::where('id', '=', $id)->update(array( 'project_name' => $request->name, 'description' => $request->description , 'contact' => $request->contact, 'address' => $request->address));
}

  return redirect()->route('project.list')->with('success' , 'Project Updated Successfully!');
}


}
