<?php

namespace App\Http\Controllers;

use App\MultiProject;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Http\Response;


class ProjectSwitchController extends Controller
{
    //
    public  function index()
    {

        $user = Auth::user();
        $projects = $user->roles()->with('projects')->get()->pluck('projects')->flatten()->unique('id');
        $projectId = request()->cookie('current_project_id');

        $pro_id = 0;

        if (!empty($projectId)) {

            $pro_id =   decrypt($projectId);
        } else {

            $mproject =  MultiProject::where('name', 'like', 'Super Admin')->first();
           
            if (empty($mproject)) {
                return view('switchproject.index', compact('projects', 'pro_id'));
            }

            $projectId =  $mproject->id;

            $user = Auth::user();
            $role = $user->roles()->whereHas('projects', function ($query) use ($projectId) {
                $query->where('multi_project_id', $projectId);
            })
                ->first();
            //    dd($pro_id,$projects);

            if (!empty($role)) {
                // $pro_id = $projectId;
                return view('switchproject.index', compact('projects', 'pro_id'));
            }
        }

        return view('switchproject.index', compact('projects', 'pro_id'));
    }
    public function switchProject(Request $request)
    {


        $validator = Validator::make($request->all(), [

            'project' => 'required',

        ]);
        if ($validator->fails()) {
            return response()->json([
                'errors' => $validator->errors(),
            ], 422);
        }
        try {
            $id = decrypt($request->project);
            $project = MultiProject::where('id', $id)->first();


            if ($project) {
                // if($project->name == 'Super Admin'){

                //  return response()->json([
                //     'message' => 'Success!',

                // ])->withCookie(cookie()->forget('current_project_id'));
                //     }
                // else{
                $cookie = encrypt($project->id);
                return response()->json([
                    'message' => 'Success!',

                ])->withCookie(cookie('current_project_id', $cookie));
                // }

            } else {
                return response()->json([
                    'errors' => 'Project Not Exists',
                ], 422);
            }
        } catch (\Exception $e) {
            return response()->json([
                'errors' => 'SomeThing went wrong',
            ], 422);
        }
    }
}
