<?php

namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\Purchase;

class PurchaseController extends Controller {

    protected $purchase;

    public function __construct() {
        $this->purchase = new Purchase();
    }

    //Get All the purchase
    public function allPurchases() {

        $allPurchases = Purchase::orderBy('created_at', 'desc')->get();

        return view('transaction/purchase.index', compact('allPurchases'));
    }

    //show the add new purchase  form
    public function addPurchaseForm() {

        return view('transaction/purchase.add-purchase');
    }

    //insert new purchase record
    public function insertPurchase(Request $request) {

        $validator = Validator::make($request->all(), [
                    'product' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'supplier' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'date'=>'required',
                    'rate'=>'required|numeric|min:1',
                    'tax'=>'numeric|min:1|nullable',
                    'qty'=>'required|numeric|min:1',
            'payment_mode'=>'required'
        ]);

        if ($validator->fails()) {
            return redirect('/purchase/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //create new Purchase
        //$purchase = Purchase::create(Input::all());
        $input=$request->all();
        $purchase = Purchase::create($input);
        
        //update total and net amount
        Purchase::where('id',$purchase->id)->update(['total'=>$request->rate * $request->qty,'net'=>($request->rate * $request->qty) - (($request->tax / 100) * ($request->rate * $request->qty))]);

        return redirect()
                        ->route('purchase.detail',['id'=>$purchase->id])
                        ->with([
                            'message' => 'Purchase created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the detail of the Purchase
    public function detailPurchase($id) {

        $purchase = Purchase::where('id', $id)->first();

        return view('transaction/purchase.detail-purchase', compact('purchase'));
    }

    //show the edit purchase form
    public function editPurchaseForm($id) {

        $purchase = Purchase::where('id', $id)->first();

        return view('transaction/purchase.edit-purchase', compact('purchase'));
    }

    //update the Purchase record
    public function updatePurchase(Request $request) {

        $validator = Validator::make($request->all(), [
                    'product' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'supplier' => 'required|regex:/^[a-zA-Z\s]+$/u',
                    'date'=>'required',
                    'rate'=>'numeric|min:1|nullable',
                    'tax'=>'numeric|min:1|nullable',
                    'qty'=>'numeric|min:1|nullable',
            'payment_mode'=>'required'
                    
        ]);

        if ($validator->fails()) {
            return redirect('/purchase/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Purchase
        Purchase::where('id',$request->id)->update(Input::except('_token'));
        Purchase::where('id',$request->id)->update(['total'=>$request->rate * $request->qty,'net'=>($request->rate * $request->qty) - (($request->tax / 100) * ($request->rate * $request->qty))]);


        return redirect()
                        ->route('purchase.detail',['id'=>$request->id])
                        ->with([
                            'message' => 'Purchase updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific purchase
    public function deletePurchase($id) {

        Purchase::where('id', $id)->delete();

        return redirect()->route('purchase.all')->with([
                    'message' => 'Purchase deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

}
