<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\PurchaseOrderReceipt;
use Illuminate\Support\Facades\Validator;
use App\PurchaseRequestVendor;
use Illuminate\Support\Facades\Crypt;
use App\PurchaseRequest;
use App\PurchaseOrder;
use DB;
use App\Project;
use App\ComparativeStatement;
class PurchaseOrderReceiptController extends Controller
{
     public function __construct()
   
    {
               
    }

    public function index()
{
       $purchase_requests = PurchaseRequest::orderBy('id', 'DESC')->where([['status' ,'>', 6]])->get();

  
    return view('procurement/purchase-order-receipt.view' ,compact('purchase_requests' ) );
}


        public function view($pr_id)
        {
        if(is_numeric($pr_id))
        {

        $po_receipt_vendors = PurchaseOrderReceipt::where('purchase_request_id' , $pr_id)->where('status', '!=' , 3)->pluck('vendor_id')->toArray();

        $vendors = PurchaseRequestVendor::withAndWhereHas('receipts', function($query) use ($pr_id)
        {
        $query->where('purchase_request_id', $pr_id);
        })
        ->whereIn('id' , $po_receipt_vendors)
        ->get();

  
        return view('procurement/purchase-order-receipt.po-receipt' , compact('vendors' , 'pr_id'  ) );
        }
        }


    public function detail( Request $request)
    {

        $vendor_id = Crypt::decryptString($request->input('vendor'));
        $purchase_order_id = Crypt::decryptString($request->input('purchase_order'));
        $purchase_request_id=Crypt::decryptString($request->input('purchase_request'));
        $receipt_id = Crypt::decryptString($request->input('receipt_id'));
        $purchase_request = PurchaseRequest::find($purchase_request_id);
        $receipt = PurchaseOrderReceipt::find($receipt_id);
        $cs = ComparativeStatement::where('purchase_request_id' , $purchase_request_id)->where('vendor_id' , $vendor_id);
        $vendor = PurchaseRequestVendor::find( $vendor_id );
        $purchase_order = PurchaseOrder::where('vendor_id' ,  $vendor_id ) ->where('purchase_request_id' , $purchase_request_id)->first();

        $project = Project::withTrashed()->find($purchase_request->project_id);
        return view('procurement/purchase-order-receipt.index' , compact( 'vendor' , 'purchase_request_id' , 'purchase_request' , 'purchase_order_id','purchase_order', 'cs' , 'receipt' , 'project' ) );
    }

    public function payReceipt(Request $request)

    {
        $pr_id = $request->pr_id;
        $receipt_id = $request->receipt_id;
        $amount_to_pay = $request->amount_to_pay;
        $status = $request->status;
        $vendor_id = $request->vendor_id;
        $remaining_amount = 0;
        $receipt_status = 1;

///................to check if aount isnumericor not.................................
       
            if(!is_numeric($amount_to_pay))
            {
                 echo json_encode(array('response' => 'invalid_value' , 'message' => 'Price is only in number.'));
             exit();
            }


      $purchase_order = PurchaseOrder::where('purchase_request_id' , $pr_id )
        ->where('vendor_id' , $vendor_id)
        ->first();



      $purchase_order_recipt = PurchaseOrderReceipt::find($receipt_id);



///.............Check if receipt in status partially paid then paid remaining amount.........
$total_price  = $purchase_order_recipt->total_amount;


        if($purchase_order_recipt->status == 2)
        {
            $amount_to_pay = $purchase_order_recipt->total_pay_amount + $amount_to_pay;
        }



        $remaining_amount = $total_price - $amount_to_pay;

         
///..........to check total_pay_amount is greater than total ammount................

      if($amount_to_pay > $total_price)
        {
              echo json_encode(array('response' => 'invalid_value' , 'message' => 'Error! You enter price greater than original price.'));
             exit();
        }




///..........change receipt status to if amount remaning................



        if( $remaining_amount > 0)
        {
            $receipt_status = 2; 
        }


        DB::beginTransaction();

        try {

        PurchaseOrderReceipt::where('id', '=' , $receipt_id)
        ->update([
        'status' => $receipt_status,
        'receipt_pay_date' => date('Y-m-d H:i:s'),
        'total_amount' => $total_price,
        'total_pay_amount' => $amount_to_pay,
        'remaining_amount' => $remaining_amount,
        ]);

          DB::commit();

          echo json_encode(array('response' => 'yes'));
        } 

        catch (\Exception $e) 
        {
          DB::rollback();
        }
    }

public function vendorReceipt(Request $request)
{
     $vendorId = $request->input('vendor');
     $status = $request->input('status');


        if($status  == 'paid')
        {
          $status = 1;  
        }
        else if($status  == 'partial-paid')
        {
          $status = 2;  
        }
        else
        {
            $status = 0;  
        }

      

    $vendor_po_receipt = PurchaseOrderReceipt::where('vendor_id' , $vendorId)->where('status' , $status)->get();

    $vendor = PurchaseRequestVendor::find($vendorId);
    return view('procurement/purchase-order-receipt.vendor-po-receipt' , compact('vendor_po_receipt' , 'vendor'));
}

public function listReceipt(Request $request)
{
     $status = $request->input('status');


        if($status  == 'paid')
        {
          $status = 1;  
        }
        else if($status  == 'partial-paid')
        {
          $status = 2;  
        }
        else
        {
            $status = 0;  
        }


     $total_receipts = PurchaseRequest::withAndWhereHas('receipts', function($query) use ($status)
    {
    $query->where('status',  $status);
    })
    ->where('department_id' , $request->department )
    ->get();
    $total_receipts = json_decode(json_encode($total_receipts));
    
    return view('procurement/purchase-order-receipt.all' , compact('total_receipts' ));

}

public function add_account_officer(Request $request)
{
    $receipt_id = $request->receipt_id;
    $name_account_officer = $request->name_account_officer;

   
        if ( empty($name_account_officer)) 
    {
         echo json_encode(array('response' => 'invalid' , 'message' => "Please Enter Name!" ));
         exit;
    }
     try 
    {
        PurchaseOrderReceipt::where('id' ,  $receipt_id )->update( 
            ['account_officer_name' => $name_account_officer , 'account_officer_name_date' => date('Y-m-d H:i:s') ] ); 
        DB::commit();
        echo json_encode(array('response' => 'yes'));
    } 
    catch (\Exception $e) 
    {
        DB::rollback();
    }

}

}