<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Validator;
use App\Department;
use App\Project;
use App\Item;
use App\Role;
use App\PurchaseRequest;
use DB;
use App\ItemPurchaseRequest;
use App\ApprovelStatus;
use App\ItemVendor;
use Illuminate\Http\Request;
use Response;
use App\ComparativeStatement;
use App\RequestForQuotation;
use App\PurchaseOrder;
use App\PurchaseOrderReceipt;
use Carbon\Carbon;
use App\PurchaseRequestVendor;
use Illuminate\Support\Facades\Auth;
use App\User;
use App\ReceiptItem;
use App\ItemRelease;
use App\ItemPurchaseOrder;
use App\ItemReleaseData;
use App\CsApproval;
use App\Task;
use App\billOfQuantity;
use App\PurchaseRequestBoqItem;
use App\PurchaseOrderRemark;
use App\MaterialIssueRequest;
use App\MaterialIssueRequestData;
use App\MaterialRequestApproval;
class PurchaseRequestController extends Controller
{
     public function __construct()
   
    {
               
    }

    function index()
    {
        $user = User::with('role')->find(Auth::user()->id);



        if(!$user->can('manage-procurement-dashboard') && !$user->hasRole('admin')) 
        { 
            $purchase_requests = PurchaseRequest::whereHas('department',function($query) use($user)
            {
            $query->where('role_id','>', 0);
            })
            ->where('created_by' , Auth::user()->id)
            ->orderBy('id', 'DESC')->get();
        }
        else
        {
            $purchase_requests = PurchaseRequest::whereHas('department',function($query) use($user)
            {
                $query->where('role_id','>', 0);
            })
                ->orderBy('id', 'DESC')->get();
        }      


        return view('procurement/purchase-request.index' ,compact('purchase_requests') );
    }

    function create()
    {
        $user = User::with('role')->find(Auth::user()->id);

         $where = ['role_id','>',0];

          if(!$user->can('manage-procurement-dashboard') && !$user->hasRole('admin')) 
        { 
            $where = ['role_id',$user->role->role_id];
        }

         $departments = Department::where([$where])->orderBy('id', 'DESC')->get(['id','department_name']);
        
        $items = Item::orderBy('id', 'DESC')->get(['id','item_name','unit']);
        $approvel_roles = Role::orderBy('id', 'DESC')->get(['id','name']);

        $tasks = task::where('node_name' , 'leaf')->orderBy('id', 'ASC')->get();

        return view('procurement/purchase-request.add' ,compact('departments'  , 'items' , 'approvel_roles','tasks')  );
    }

        function createCashPr()
    {
        $user = User::with('role')->find(Auth::user()->id);

         $where = ['role_id','>',0];

          if(!$user->can('manage-procurement-dashboard') && !$user->hasRole('admin')) 
        { 
            $where = ['role_id',$user->role->role_id];
        }

         $departments = Department::where([$where])->orderBy('id', 'DESC')->get(['id','department_name']);
        
        $items = Item::orderBy('id', 'DESC')->get(['id','item_name','unit']);
        $approvel_roles = Role::orderBy('id', 'DESC')->get(['id','name']);

        $vendors = PurchaseRequestVendor::orderBy('name', 'ASC')->get();

        return view('procurement/purchase-request.cash_pr' ,compact('departments'  , 'items' , 'approvel_roles','vendors')  );
    }

    function store(Request $request)
    {


       $request->role_orders = $request->role_name;

       $validator = Validator::make($request->all(), [
                    'project' => 'required',
                    'department' => 'required',
                    'items.*'=> 'required',
                    'quantity.*'=> 'required|numeric',
                    'price.*'=> 'numeric'
                   
        ] , [
                    'items.*.required' => 'All Items Field Must Required.',
                    'quantity.*.required' => 'All Quantity Field Must Required.',
                    'quantity.*.numeric' => 'Quantity Field Must Number.',
                    'price.*.numeric' => 'Price Field Must Number.',
                    
        ]);


///....................Custom validation .....................................
        
         if ($request->workOrderType == 'true' && $request->work_order_type == '0' )
        {
             echo json_encode(array('project' => 'invalid_value' , 'message' => 'Please select a valid task name.'));
            exit();
        }

        if ($request->workOrderType == 'true' && $request->work_order_type != '0' )
        {
           $work_order_id = $request->work_order_type;
        }

        if ($request->workOrderType == 'false' )
        {
           $work_order_id = 0;
        }


         if($request->pr_type == 'direct_pr' && (in_array(0, $request->vendor) || in_array(null, $request->vendor)) )
        {
            echo json_encode(array('project' => 'invalid_value' , 'message' => 'One of your item is selected without Vendor. Please recheck and select again.'));
            exit();
        }


         if(in_array(0, $request->items) || in_array(null, $request->items) )
        {
            echo json_encode(array('project' => 'invalid_value' , 'message' => 'One of your item is not selected. Please recheck and select again.'));
            exit();
        }


        if(count(array_unique($request->items)) < count($request->items))
        {
             echo json_encode(array('project' => 'invalid_value' , 'message' => 'One of your item is Repeated. Please recheck and select again.'));
            exit();
        }

        if(empty($request->project) )
        {
            echo json_encode(array('project' => 'invalid_value' , 'message' => 'Please select project.'));
            exit();
        }

        if(empty($request->department) )
        {
            echo json_encode(array('department' => 'invalid_value' , 'message' => 'Please select project.'));
            exit();
        }

        if(in_array("", $request->items) )
        {
            echo json_encode(array('items' => 'invalid_value' , 'message' => 'Please check all items not be empty.'));
            exit();
        }


        if(in_array("", $request->quantity) || in_array("0", $request->quantity) )
        {
            echo json_encode(array('quantity' => 'invalid_value' , 'message' => 'Please check all quantity not be empty or zero.'));
            exit();
        }

        if(in_array("", $request->price) || in_array("0", $request->price) )
        {
            echo json_encode(array('price' => 'invalid_value' , 'message' => 'Please check all Prices not be empty or zero.'));
            exit();
        }


        if(empty($request->role_orders))
        {
            echo json_encode(array('role_orders' => 'invalid_value' , 'message' => 'You have to select atleast one role for approval'));
            exit();
        }

         //.......................Validation End ............................//

         DB::beginTransaction();

        try {

            $purchase_request  =  PurchaseRequest::create([
            'department_id' => $request->department,
            'task_id' => $work_order_id,
            'created_by' => Auth::user()->id,
            'pr_type' => $request->pr_type,
            ]);

          if( $purchase_request->id > 0 && !empty($request->items))
          {

          for ($item = 0; $item < sizeof( $request->items); $item++) 
          { 

            $current_item = Item::find($request->items[$item]);

            if(($current_item->quantity + $request->quantity[$item]) > $current_item->maxqty)
            {
            $validOrderQty = $current_item->maxqty - $current_item->quantity;

            if($validOrderQty <= 0 )
            {
            $validOrderQty = 0;
            }

            echo json_encode(array('max_quantity_error' => 'invalid_value' , 'message' => 'Item <b>'.$current_item->item_name.' </b> has max order Quantity is '.$current_item->maxqty.'. you  have already '.$current_item->quantity.' . you can only order now '. ( $validOrderQty ).' .'));
            DB::rollback();
            exit();
            }

            $pr_Boq_item_array = [
            'item_id' => $request->items[$item],
            'quantity' => $request->quantity[$item],
            'rate_per_unit' => $request->price[$item],
            'total_cost' => $request->price[$item] * $request->quantity[$item],
            'purchase_request_id' => $purchase_request->id,
            ];

         if ($request->workOrderType == 'true')
         {

            $valid_boq_quantity = billOfQuantity::where('task_id' , $work_order_id)
            ->where('item_id' , $request->items[$item])
            ->first();


            if ($valid_boq_quantity == false)
            {
                 echo json_encode(array('max_quantity_error' => 'invalid_value' , 'message' => 'Item <b>'.$current_item->item_name.'</b> is not added in BOQ.'));
                 DB::rollback();
                 exit();
            }

            if ($valid_boq_quantity == true) 
            {
                 $pr_Boq_item_array['task_id'] = $work_order_id;
                 $pr_Boq_item_array['boq_id'] = $valid_boq_quantity->id;
               
            }

          }

            if ($request->workOrderType == 'false')
            {
               $pr_Boq_item_array['task_id'] = 0;
               $pr_Boq_item_array['boq_id'] = 0;
            }
          
               PurchaseRequestBoqItem::create($pr_Boq_item_array);

                ItemPurchaseRequest::create([
                    'purchase_request_id' => $purchase_request->id,
                    'item_id' => $request->items[$item],
                    'quantity' => $request->quantity[$item],
                    'price' => $request->price[$item],
                    'description' => $request->description[$item],
                    'remaining_quantity' => $request->quantity[$item]
                ]);

            }

           }

       
          if( $purchase_request->id > 0 && !empty($request->role_name))
          {

            $order = 1;
            $roleStatus = $request->role_orders;

          for($approval_role = 0; $approval_role < sizeof($roleStatus); $approval_role ++) 
           { 
            ApprovelStatus::create([
            'purchase_request_id' =>  $purchase_request->id,
            'role_id' => $roleStatus[$approval_role],
            'approvel_order' => $order,
            ]);

             $order ++;
            }

           $approval =  ApprovelStatus::where('purchase_request_id', $purchase_request->id)->where('approvel_status', '0')->orderBy('approvel_order', 'ASC')->first();

           if($approval)
           {
            $approval_status = new ApprovelStatus();
            $approval_status->pusherNotification($approval->role_id , $purchase_request->id );
           }

           }



           if( $purchase_request->id > 0 && $request->pr_type == 'direct_pr')
           {

                $pr_id = $purchase_request->id;
                


                for ($i=0; $i < count($request->vendor); $i++) 
                { 
                    
                        $price = ItemPurchaseRequest::where('purchase_request_id', $pr_id)
                        ->where('item_id' , $request->items[$i])
                        ->first()
                        ->price; 

                        ComparativeStatement::create([
                            'purchase_request_id' => $pr_id,
                            'item_id' => $request->items[$i],
                            'vendor_id' => $request->vendor[$i],
                            'price' => $price,
                        ]);

                    $po = PurchaseOrder::where('purchase_request_id', '=', $pr_id)
                    ->where( 'vendor_id'  , $request->vendor[$i]);

                    $is_po_exist = $po->first();

                     if ($is_po_exist == true) 
                    {
                        $purchase_order_id = $is_po_exist->id;
                    }
                    

                    if ($is_po_exist == false) 
                    {
                        $purchase_order =  PurchaseOrder::create([
                        'purchase_request_id' => $pr_id,
                        'vendor_id' => $request->vendor[$i],
                        'status' => 1,
                        'delivery_date' => date('Y-m-d H:i:s'),
                        ]);

                        $purchase_order_id = $purchase_order->id;
                    }
                    


                  
                        $get_vendor_price = ComparativeStatement::where('purchase_request_id', '=', $pr_id)
                        ->where( 'vendor_id' , $request->vendor[$i])
                        ->where( 'item_id' , $request->items[$i] )
                        ->first()
                        ->price;

                        $item_purchase_request = ItemPurchaseRequest::where('purchase_request_id', '=', $pr_id)
                        ->where( 'item_id' , $request->items[$i] );

                        $get_requested_items =  $item_purchase_request->first();
                         $remainingItemsQuantity = $get_requested_items->quantity;



                        $remainingItemsQuantity  = ($get_requested_items->remaining_quantity - $request->quantity[$i]);


                        if ($remainingItemsQuantity < 0 ) 
                        {
                             $remainingItemsQuantity  = 0;
                        }

                        ItemPurchaseOrder::create([
                        'purchase_order_id' => $purchase_order_id,
                        'purchase_request_id' => $pr_id,
                        'item_id' => $request->items[$i],
                        'price' =>  $get_vendor_price,
                        'total_quantity' => $get_requested_items->quantity,
                        'demand_quantity' =>  $request->quantity[$i]
                        ]);

                        $item_purchase_request->update([
                        'remaining_quantity' => $remainingItemsQuantity ,
                        ]);

    
                }


                $rfqs_vendors = json_encode(array_unique($request->vendor));

// print_r( $rfqs_vendors);
// DB::rollback();
// die;
                PurchaseRequest::where('id', '=', $pr_id)->update([
                'quotation_valid_date' => date('Y-m-d'),
                'quotation_created_date' => date('Y-m-d'),
                'rfq_vendors' => $rfqs_vendors,
                ]);
           




            }

           DB::commit();
          echo json_encode(array('success' => 'ok' , 'message' => 'Purchase Request created successfully.'));
      } 
        
        catch (\Exception $e) 
      {
        DB::rollback();

      //  dd($e);
      }

    }


    public function search(Request $request)
    {
    $qty = $request->qty;
    $item_id = $request->item_id;
    $task_id = $request->task_id;

    if (!empty($qty) && $qty > 0) 
    {
   
    $valid_boq_quantity = billOfQuantity::where('task_id' , $task_id)
    ->where('item_id' , $item_id)
    
    ->first();

    if ( $valid_boq_quantity == true ) 
    {
        $pr_boq_item = PurchaseRequestBoqItem::where([['task_id' , $task_id] , ['boq_id' , $valid_boq_quantity->id] , ['item_id' ,  $item_id]])->sum('quantity');

        $qty += $pr_boq_item;

        if ($valid_boq_quantity->quantity <  $qty)
        {
            echo json_encode(array('response' => 'limit_exceed' , 'max' => $valid_boq_quantity->quantity));
        }
        else
        {
            echo json_encode(array('response' => 'limit_not_exceed'));
        }
    }
     else
        {
            echo json_encode(array('response' => 'limit_not_exceed'));
        }
    }

    }

    function destroy($id)
{
 
    if(is_numeric($id))
    {
         PurchaseRequest::where('id',$id)->delete();
         PurchaseRequestBoqItem::where('purchase_request_id' , $id)->delete();
    }
 
  return redirect()->route('purchase-requests.list')->with('success' , 'Purchase Request Removed Successfully!');
}



    function edit($id)
{
 
   if(is_numeric($id))
    {
        $purchase_request = PurchaseRequest::where('id', $id)->first();
        $departments = Department::orderBy('id', 'DESC')->get(['id' , 'department_name']);
        $projects = Project::get(['id' , 'project_name']);
        $items = Item::orderBy('id', 'DESC')->get(['id','item_name' , 'unit']);
        $approvel_roles = Role::orderBy('id', 'DESC')->get(['id','name']);
        $approval_status = PurchaseRequest::find($purchase_request->id)->approvalStatus;

        $assignRoles = '';
        $count = 1;
        
        foreach( $approval_status as $roles)
        {
            if($roles->approvel_status != 1)
            {
              $assignRoles .= $roles->role_id;
                if($count != sizeof($approval_status))
                {
                  $assignRoles  .= ',';
                }
              $count ++;
            }
        }

        $tasks = task::where('node_name' , 'leaf')->orderBy('id', 'ASC')->get();

        return view('procurement/purchase-request.edit',compact('purchase_request' , 'departments' , 'projects' , 'items' , 'approvel_roles' , 'assignRoles' , 'tasks' ) );
    }

}

function update(Request $request)
{
    $id = $request->purchase_request_id;

    $request->role_orders = $request->role_name;
  
    $validator = Validator::make($request->all(), [
                    'project' => 'required',
                    'department' => 'required',
                    'items.*'=> 'required',
                    'quantity.*'=> 'required|numeric',
                    'price.*'=> 'numeric'
         ] , [
                    'items.*.required' => 'All Items Field Must Required.',
                    'quantity.*.required' => 'All Quantity Field Must Required.',
                    'quantity.*.numeric' => 'Quantity Field Must Number.',
                    'price.*.numeric' => 'Price Field Must Number.',
                    
        ]);


        if(in_array(0, $request->items) || in_array(null, $request->items) )
        {
            return redirect('/purchase-requests/edit-purchase-request/'.$id)
            ->with('item_errors' ,'One of your item is not selected. Please recheck and select again.'); 
        }

        if(count(array_unique($request->items)) < count($request->items))
        {
            return redirect('/purchase-requests/edit-purchase-request/'.$id)
            ->with('item_errors' ,'One of your item is Repeated. Please recheck and select again.');        
        }

    if(empty($request->role_orders))
      {
         return redirect('/purchase-requests/edit-purchase-request/'.$id)
         ->with('role_orders' ,'You have to select atleast one role for approval');
      }


       if ($validator->fails())
        {
            return redirect('/purchase-requests/edit-purchase-request/'.$id)
            ->withErrors($validator)
            ->withInput();
        }
      $purchase_request = PurchaseRequest::find($id);

         DB::beginTransaction();

    try {

         PurchaseRequest::where('id', '=', $id)->update([
            'department_id' => $request->department,
          ]);


          if( $id > 0 && !empty($request->items))
          {

            $Itemids = implode(",", $request->items);
             
             ItemPurchaseRequest::where('purchase_request_id' , $id )
             ->whereNotIn('item_id', [$Itemids] )
             ->delete();

             PurchaseRequestBoqItem::where('purchase_request_id' , $id)
             ->whereNotIn('item_id', [$Itemids] )
             ->delete();

             for ($item=0; $item < sizeof( $request->items); $item++) { 


             $current_item = Item::find($request->items[$item]);


             if(($current_item->quantity + $request->quantity[$item]) > $current_item->maxqty)
             {
               $validOrderQty = $current_item->maxqty - $current_item->quantity;

               if($validOrderQty <= 0 )
               {
                 $validOrderQty = 0;
               }
             
               DB::rollback();
               return redirect('/purchase-requests/edit-purchase-request/'.$id)
               ->with('role_orders' ,'Item '.$current_item->item_name.'  has max order Quantity is '.$current_item->maxqty.'. you  have already '.$current_item->quantity.' . you can only order now '. ( $validOrderQty ).' .');
    
            }


            $boq_array = [
                    'purchase_request_id' => $purchase_request->id,
                    'item_id' => $request->items[$item],
                    'quantity' => $request->quantity[$item],
                    'rate_per_unit' => $request->price[$item],
                    'total_cost' => $request->price[$item] * $request->quantity[$item],
                   ];


            if ( $purchase_request->task_id > 0)
         {

            $valid_boq_quantity = billOfQuantity::where('task_id' , $purchase_request->task_id)
            ->where('item_id' , $request->items[$item])
            ->first();


            if ($valid_boq_quantity == false)
            {
                DB::rollback();
               return redirect('/purchase-requests/edit-purchase-request/'.$id)
               ->with('role_orders' , 'Item '.$current_item->item_name.' is not added in BOQ.');
            }

            if ($valid_boq_quantity == true) 
            {

                $pr_Boq_item_array = [['purchase_request_id' , $purchase_request->id] , ['task_id' , $purchase_request->task_id] , ['boq_id' , $valid_boq_quantity->id] , ['item_id' ,  $request->items[$item]]];

                $boq_array['task_id'] = $purchase_request->task_id;
                $boq_array['boq_id'] = $valid_boq_quantity->id; 
            }

          }

          if ($purchase_request->task_id == 0) 
          {
               $pr_Boq_item_array = [['purchase_request_id' , $purchase_request->id] , ['task_id' , $purchase_request->task_id] , ['boq_id' , 0] , ['item_id' ,  $request->items[$item]]];

                $boq_array['task_id'] = 0;
                $boq_array['boq_id'] = 0; 
          }


               $pr_boq_item = PurchaseRequestBoqItem::where($pr_Boq_item_array);

                if ($pr_boq_item->first() == true)
                {
                     $pr_boq_item->update( $boq_array );
                }

                 if ($pr_boq_item->first() == false)
                {
                     PurchaseRequestBoqItem::create( $boq_array );
                }



             
            $insert_new_items = ItemPurchaseRequest::where('purchase_request_id', '=', $id)
            ->where( 'item_id', $request->items[$item])
            ->first();

            if($insert_new_items == true)
            {
                ItemPurchaseRequest::where('purchase_request_id', '=', $id)
                ->where( 'item_id', $request->items[$item])
                ->update([
                'quantity' => $request->quantity[$item],
                'price' => $request->price[$item],
                'description' => $request->description[$item],
                'remaining_quantity' => $request->quantity[$item]
                ]);
            }

            if($insert_new_items == false)
            {
                ItemPurchaseRequest::create([
                'purchase_request_id' => $id,
                'item_id' => $request->items[$item],
                'quantity' => $request->quantity[$item],
                'price' => $request->price[$item],
                'description' => $request->description[$item],
                'remaining_quantity' => $request->quantity[$item]
              ]);
            }
          }

         }

          
          if( $id > 0 &&  (!empty($request->role_orders) && $request->role_orders != 0))
          {

            $order = 1;
            $roleStatus = $request->role_orders;

            ApprovelStatus::where('purchase_request_id' , $id )
             ->whereNotIn('role_id', [$request->role_orders] )
             ->where( 'approvel_status' , 0)
             ->delete();

         for ($approval_role = 0; $approval_role < sizeof($roleStatus); $approval_role ++) 
          { 

            $insert_new_approval_role = ApprovelStatus::where('purchase_request_id', '=', $id)->where( 'role_id' , $roleStatus[$approval_role])->where( 'approvel_status' , 0)->first();

            if($insert_new_approval_role == true)
            {
                ApprovelStatus::where('purchase_request_id', '=', $id)
                ->where('role_id' , $roleStatus[$approval_role])
                ->update([
                'approvel_order' => $order,
                ]);
            }


            if($insert_new_approval_role == false)
            {
                ApprovelStatus::create([
                'purchase_request_id' =>  $id,
                'role_id' => $roleStatus[$approval_role],
                'approvel_order' => $order,
                ]);
            }

            $order ++;
            }


             $approval =  ApprovelStatus::where('purchase_request_id', $id)->where('approvel_status', '0')->orderBy('approvel_order', 'ASC')->first();

           if($approval == true)
           {
            $approval_status = new ApprovelStatus();
            $approval_status->pusherNotification($approval->role_id , $id);
           }


          }

           DB::commit();
           return redirect()->route('purchase-requests.list')->with('success' , 'Your Purchase Request Updated Successfully!');
      } 
        
        catch (\Exception $e) 
      {
        DB::rollback();
   
        return redirect()->route('purchase-requests.list')->with('success' , 'Error Something went wrong.');
      }
}


    function fetchNewItems()
    {
        $items = Item::orderBy('id', 'DESC')->get(['id','item_name','unit']);
        $output = '';
        $unique = rand(100000, 999999);
        if($items->count() > 0 )
        {
          echo json_encode(array('response' => 'yes' ,'id' => $unique ,'items' => $items));
        }
    }

    public function view($id)
    {
        if(is_numeric($id))
        {
            $total_cs = 0;
            $total_rfq = 0;
            $total_po = 0;
            $total_recipt = 0;
              $approval = 0;
              
            $purchase_request = PurchaseRequest::where('id', $id)->first();
            $approval_status =  ApprovelStatus::where('purchase_request_id', '=', $id)
            ->where( 'approvel_status' , 0)
            ->count();
            $pending_recipt = PurchaseOrderReceipt::where('purchase_request_id' , $purchase_request->id)->where('status' , '!=' , 1)->count();

            $pending_po = PurchaseOrder::where('purchase_request_id' , $purchase_request->id)->where('status' , '!=' , 2)->count();

            if($purchase_request->status > 3)
            {
                $total_rfq = sizeof(json_decode($purchase_request->rfq_vendors));
            }

            if($purchase_request->status > 4)
            {
                $total_cs = ComparativeStatement::getVendorIds($purchase_request->id);
                $total_cs = sizeof($total_cs);
            }

            if($purchase_request->status > 5)
            {
                $total_po = PurchaseOrder::getVendorIds($purchase_request->id);
                $total_po = sizeof($total_po);
            }

            if($purchase_request->status > 6)
            {
                $total_recipt = PurchaseOrderReceipt::where('purchase_request_id' , $purchase_request->id)->where('status', '!=' , 3)->count();
            }

            $total_cancel_po = PurchaseOrderRemark::with(['vendor'])->where('pr_id' , $purchase_request->id )->groupBy('po_id')->get();

           $approval_check = ApprovelStatus::where('purchase_request_id', $purchase_request->id)->where('approvel_status', '0')->where('role_id', auth::user()->role->role_id)->count();

            if ($approval_check > 0 )
            {
              $approval = 1;  
            }
                

            return view('procurement/purchase-request.view', compact('purchase_request', 'approval_status', 'total_cs', 'total_rfq', 'total_po', 'total_recipt', 'pending_recipt', 'pending_po', 'total_cancel_po' , 'approval'));
        }
    }


      public function print($id , $role)
    {
        if(is_numeric($id))
        {
            $total_cs = 0;
            $total_rfq = 0;
            $total_po = 0;
            $total_recipt = 0;
            $purchase_request  = PurchaseRequest::withAndWhereHas('approvalStatus', function($query) use ($role)
            {
            $query->where('role_id',  $role);
            })->with(['user' , 'project' , 'department'])           
            ->where('id', $id)
            ->first();  



            $purchase_request = json_decode(json_encode(  $purchase_request));

            $approval_status =  ApprovelStatus::where('purchase_request_id', '=', $id)
            ->where( 'approvel_status' , 0)
            ->count();
            $pending_recipt = PurchaseOrderReceipt::where('purchase_request_id' , $purchase_request->id)->where('status' , '!=' , 1)->count();

            $pending_po = PurchaseOrder::where('purchase_request_id' , $purchase_request->id)->where('status' , '!=' , 2)->count();

            if($purchase_request->status > 3)
            {
                $total_rfq = sizeof(json_decode($purchase_request->rfq_vendors));
            }

            if($purchase_request->status > 4)
            {
                $total_cs = ComparativeStatement::getVendorIds($purchase_request->id);
                $total_cs = sizeof($total_cs);
            }

            if($purchase_request->status > 5)
            {
                $total_po = PurchaseOrder::getVendorIds($purchase_request->id);
                $total_po = sizeof($total_po);
            }

            if($purchase_request->status > 6)
            {
                $total_recipt = PurchaseOrderReceipt::where('purchase_request_id' , $purchase_request->id)->where('status', '!=' , 3)->count();
            }

            return view('procurement/purchase-request.print' , compact('purchase_request' , 'approval_status' , 'total_cs' , 'total_rfq' , 'total_po' , 'total_recipt' , 'pending_recipt' , 'pending_po' , 'role'));
        }
    }

   
        function notify($role_id)
        {

       $approvalCount = array();
        //........................Sum of Total Purchase........................

        $data['total_purchase'] = PurchaseOrderReceipt::sum('total_amount');
        $data['total_pay_purchase'] = PurchaseOrderReceipt::sum('total_pay_amount');
        $data['total_monthly_purchase']= PurchaseOrderReceipt::whereYear('receipt_date', Carbon::now()->year)->whereMonth('receipt_date', Carbon::now()->month)
                    ->sum('total_amount');
 
        //........................GET  PRs.................................

        $purchase_requests = PurchaseRequest::withAndWhereHas('approvalStatus', function($query) use ($role_id)
        {
        $query->where('role_id',$role_id);
        $query->where('approvel_status', 0);

        })
        ->orderBy('id', 'DESC')->get();


         //........................GET  Cs's.................................

        $approval_pending_cs = PurchaseRequest::withAndWhereHas('csApprovalStatus', function($query) use ($role_id)
        {
        $query->where('role_id',$role_id);
        $query->where('approvel_status', 0);
        })
        ->with('user')
      
        ->orderBy('id', 'DESC')->get();
         $approval_pending_cs = json_decode(json_encode( $approval_pending_cs));

        //........................GET  Latest Five Pr's.........................

        $data['purchase_request_latest'] = PurchaseRequest::take(5)
     
        ->orderBy('id', 'DESC')
        ->get();

        $data['total_purchase_orders'] = PurchaseOrder::where('status' , '!=' , 0)->take(5)
     
        ->orderBy('id', 'DESC')
        ->get();

     //........................GET Departments.................................
        $data['departments'] = Department::orderBy('id', 'DESC')->get(['id','department_name']);

     //........................Material Issue Request Approvals.................................

            

        $material_issue_requests = MaterialIssueRequest::where('mir_type' , MaterialIssueRequest::without_purchase_request)->with(['requestingItems' , 'department'])->orderBy('id', 'DESC')->get();

        foreach($material_issue_requests as $list)
        {
            $approvalCount[$list->id] = MaterialRequestApproval::where('mir_id' , $list->id)->where('is_approve' , 0) ->count();
        }



        return view('procurement/welcome' ,compact('role_id' , 'purchase_requests' , 'approval_pending_cs' , 'data','material_issue_requests' , 'approvalCount') );
        }



        function getLatestPrForApproval(Request $request)
        {
            $role_id = $request->role_id;
            $total = 0;
            $purchase_requests = PurchaseRequest::withAndWhereHas('approvalStatus', function($query) use ($role_id)
            {
            $query->where('role_id',$role_id);
            $query->where('approvel_status', 0);

            })
       
        ->orderBy('id', 'DESC')->get();

        if($purchase_requests->count() > 0)
        {
            $total = $purchase_requests->count();
             $data_array =array();

              foreach( $purchase_requests as $list )
              {
                $data_array[] = array('id' => $list->id , 'department' => $list->department->department_name , 'created_by' =>  $list->user->name , 'action' =>  
                    '<a href="'. route('purchase-requests.view',[$list->id] ) .'" target="_blank" class="btn btn-warning btn-xs" >view</a>
                    
                    <form method="POST" style="display: inline;" action="'.route('purchase-request-approvals.changeStatus') .'"  id="pr_approval_form_'.$list->id.'">
                    '.csrf_field().'
                    <input type="hidden" name="role_id" id="role_id" value="'.$role_id.'">
                    <input type="hidden" name="pr_id" id="pr_id" value="'.$list->id.'">
                    <button type="submit" name="status" class="btn btn-success btn-xs" value="approve">Approve</button>
                    <button type="button" name="status" onclick="return addRemarks(this , pr_approval_form_'.$list->id.' )" class="btn btn-danger btn-xs" value="unapprove">Cancel</button>
                    </form>' );
              }
               echo json_encode(array('total' => $total , 'response' =>  $data_array));
        }
        else
        {
            $total = 0;
             echo json_encode(array('total' => $total ));
        }
       
        }


                function getLatestCSForApproval(Request $request)
        {
            $role_id = $request->role_id;
            $total = 0;
            $approval_pending_cs = PurchaseRequest::withAndWhereHas('csApprovalStatus', function($query) use ($role_id)
        {
        $query->where('role_id',$role_id);
        $query->where('approvel_status', 0);
        })
        ->with('user')
       
        ->orderBy('id', 'DESC')->get();
if($approval_pending_cs->count() > 0)
        {
            $total = $approval_pending_cs->count();
            
         $approval_pending_cs = json_decode(json_encode( $approval_pending_cs));

       
             $data_array =array();

              foreach( $approval_pending_cs as $list )
              {

                foreach($list->cs_approval_status as $po_id)
                {
                   $poid = $po_id->purchase_order_id;
                   $po = \App\PurchaseOrder::find($poid );
                   $advanceAmount = ( $po->total_amount*$po->advance) / 100;

                $data_array[] = array('id' => $list->id , 'advance' => number_format($advanceAmount) . ' (' .$po->advance  .'%)'  ,'total_amount' => number_format($po->total_amount) , 'po' => $po->id , 'department' => Department::withTrashed()->find($list->department_id)->department_name  , 'created_by' =>  $list->user->name , 'action' =>  
                    '<a href="'. route('comparative-statements-view-approval-pending',
                        ['view' => $list->id ,'user'=> $role_id , 'po' => $poid ] ) .'" target="_blank" class="btn btn-warning btn-xs" >view</a>
                    
                    <form method="POST" style="display: inline;" action="'.route('purchase-order-approvals.change-cs-status') .'"  id="pr_approval_form_'.$list->id.'">
                    '.csrf_field().'
                     <input type="hidden" name="role_id" id="role_id" value="'.$role_id.'">
                    <input type="hidden" name="purchase_request_id" id="purchase_request_id" value="'.$list->id.'">
                    <input type="hidden" name="purchase_order_id" id="purchase_order_id" value="'.$poid.'">
                    <button type="submit" name="status" class="btn btn-success btn-xs" value="approve">Approved</button>
                    </form> <a href="javascript:void(0);" onclick="return cancelPo(this , '.$list->id.' , '.$poid.' )" class="btn btn-danger btn-xs" >Cancel</a> ' );
              }
          }
               echo json_encode(array('total' => $total , 'response' =>  $data_array));
           }
        else
        {
            $total = 0;
             echo json_encode(array('total' => $total ));
        }
       
        }



    public function detail(Request $request)
    {
        if($request->status == 'complete')
        {
          $purchase_requests= PurchaseRequest::getPrWithStatus('complete' , $request->department)[1] ;
        }
        elseif($request->status == 'pending')
        {
          $purchase_requests = PurchaseRequest::getPrWithStatus('pending' , $request->department)[1] ;
        }
        elseif($request->status == 'cancel')
        {
          $purchase_requests = PurchaseRequest::getPrWithStatus('cancel' , $request->department)[1];
        }
        else
        {
          return redirect()->back();
        }

          return view('procurement/purchase-request.index' ,compact('purchase_requests') );
    }
public function changeCsStatus(Request $request)
{
        $purchase_request_id = $request->purchase_request_id;
        $purchase_order_id = $request->purchase_order_id;
        $role_id = $request->role_id;


        
          DB::beginTransaction();
    try {


        $purchase_order = PurchaseOrder::find($purchase_order_id);

        if ($purchase_order->total_amount > 0 && $purchase_order->advance > 0 ) 
        {

        $total_already_advance = PurchaseOrderReceipt::where([['purchase_order_id' , $purchase_order_id] , ['vendor_id' , $purchase_order->vendor_id] , ['purchase_request_id' , $purchase_request_id] , ['receipt_type' , 2]])->sum('total_amount');

         $advanceAmount = ( $purchase_order->total_amount*$purchase_order->advance) / 100;
         $advanceAmount = $advanceAmount - $total_already_advance;

         PurchaseOrderReceipt::create([
          'purchase_order_id' => $purchase_order_id,
          'vendor_id' => $purchase_order->vendor_id,
          'purchase_request_id' => $purchase_request_id,
          'total_amount' => $advanceAmount,
          'remaining_amount' => $advanceAmount,
          'receipt_type' => 2,
          'receipt_date' => date('Y-m-d'),
         ]);

        }

        CsApproval::where('purchase_request_id', '=', $purchase_request_id)
        ->where('purchase_order_id' , $purchase_order_id)
        ->where('role_id' , $role_id)
        ->update([
        'approvel_status' => 1,
        ]);
          
          $is_more_approval = CsApproval::where('purchase_request_id', '=', $purchase_request_id)
        ->where('purchase_order_id' , $purchase_order_id)
        ->where('approvel_status' , 0)->count();


            if($is_more_approval ==  0)
            {

            PurchaseRequest::where('id', '=', $purchase_request_id)->update([
            'status' => 6,
            ]);

            PurchaseOrder::where('id', '=', $purchase_order_id)->update([
            'status' => 1,
            ]);

            }

          DB::commit();
          return redirect()->back()->with('success-po' , 'status changed successfully');
      } 
        
        catch (\Exception $e) 
      {
        DB::rollback();
   
       return redirect()->back()->with('success-po' , 'Error Something went wrong.');

      }


}

    function changeStatus(Request $request)
    {

        $purchase_request_id = $request->pr_id;
        $role_id = $request->role_id;
        $remarks = $request->remarks;
        $status = 0;
        $pr_status = 0;

        if($request->status == 'approve')
        {
           $status = 1;
        }

         if($request->status != 'approve')
        {
           $status = 2;
           $pr_status = 2;
           PurchaseRequestBoqItem::where('purchase_request_id' , $purchase_request_id)->delete();
        }

           DB::beginTransaction();
    try {

        ApprovelStatus::where('purchase_request_id', '=', $purchase_request_id)
        ->where('role_id' , $role_id)
        ->update([
        'approvel_status' => $status,
        ]);


         if($request->status == 'approve')
         {

            $approval =  ApprovelStatus::where('purchase_request_id', $purchase_request_id)->where('approvel_status', '0')->orderBy('approvel_order', 'ASC')->first();

            if( $approval == true)
            {

            $pr_status = 1;

            $approval_status = new ApprovelStatus();
            $approval_status->pusherNotification($approval->role_id , $purchase_request_id);

            }
            else
            {
            $pr_status = 3;
            }

       }


            $purchase_request = PurchaseRequest::where('id', '=', $purchase_request_id);
            $pr = $purchase_request->first();

            if ($pr == true && $pr->pr_type == 'direct_pr') 
            {
             $pr_status = 6;
            }

           $purchase_request->update([
            'status' => $pr_status,
            'cancellation_remarks' =>  $remarks,
            ]);

              DB::commit();
          return redirect()->back()->with('success' , 'Status changed successfully');
      } 
        
        catch (\Exception $e) 
      {
        DB::rollback();
  
       return redirect()->back()->with('success' , 'Error Something went wrong.');
      }
    }


    public function getRelseasOrReturnMir(Request $request)
    {
        $type = $request->type;

        if ($type == 'return') 
        {
            $mirs = MaterialIssueRequest::orderBy('id', 'DESC')->get();
        }

        if ($type == 'release') 
        {
            $mirs =  MaterialIssueRequest::where('status' , 'pending')->get();
        }

        echo json_encode(array('output' => $mirs));
    }


     function getPr(Request $request)
{
    if ( !empty($request->pr_id)) {
        // code...
   
  $pr_department =  PurchaseRequest::find($request->pr_id)->department;
  $receive_items = ReceiptItem::where('purchase_request_id' , $request->pr_id)
  ->where('approval_status' , 'approve')
  ->where('pass_quantity' , '>' , 0)
  ->groupBy('item_id')
  ->get();

  $items =array();

    if($receive_items->count() > 0)
    {
        foreach($receive_items as $item_list)
        {

            $item_id = $item_list->item_id;

            $item = Item::find($item_id);

            $total_receive_items = ReceiptItem::where('purchase_request_id' , $request->pr_id)
            ->where('approval_status' , 'approve')
            ->where('pass_quantity' , '>' , 0)
            ->where('item_id' ,  $item_id)
            ->sum('pass_quantity');

            $demand_item_quantity = ItemPurchaseRequest::where('purchase_request_id', '=', $request->pr_id)
            ->where( 'item_id', $item_id)
            ->first()->quantity;

            $current_releasing = 0;
            $current_returning = 0;
            
            $current_release = ItemRelease::where('purchase_request_id', $request->pr_id )
             ->each(function($p, $k) use (&$current_releasing ,&$current_returning , &$item_id) 
            {
              $current_releasing+=$p->releasingItems()->where('item_id',$item_id)->sum('item_quantity');
              $current_returning += $p->releasingItems()->where('item_id' , $item_id)->sum('return_quantity');
            });

             $current_releasing = $current_releasing - $current_returning ;

            $items[] = array('id' => $item->id , 'item_code' => $item->item_code , 'item_name' => $item->item_name  , 'brand' => $item->manufacture->name , 'category' => $item->category->category_name  , 'quantity' => number_format( $total_receive_items - $current_releasing, 2) , 'demand_quantity' => number_format($demand_item_quantity , 2) , 'current_releasing' =>  number_format($current_releasing , 2) , 'total_receive_items' => number_format($total_receive_items , 2 ) );
        }
    }

    echo json_encode(array('department_name' => $pr_department->department_name , 'department_id' => $pr_department->id , 'items' =>  $items));

   }
   else
   {
      echo json_encode(array('department_name' => '' , 'department_id' => '' , 'items' => ''));
   }
}


    function getDepartment(Request $request)
{
    if ( !empty($request->mir_id)) {
    
    $mir = MaterialIssueRequest::where('id' , $request->mir_id)->with('department')->first();

    $pr_id = $mir->pr_id;

    $item_ids = json_decode(json_encode($mir->requestingItems->pluck('item_id')));


    // $pr_department =  PurchaseRequest::find($pr_id)->department;
    $receive_items = ReceiptItem::where('purchase_request_id' , $pr_id)
    ->where('approval_status' , 'approve')
    ->where('pass_quantity' , '>' , 0)
    ->whereIn('item_id' , $item_ids)
    ->groupBy('item_id')
    ->get();

     $items =array();


    if($receive_items->count() > 0)
    {

        $type =  'with_pr';

        foreach($receive_items as $item_list)
        {

            $item_id = $item_list->item_id;

            $item = Item::find($item_id);

             $current_releasing = 0;
            $current_returning = 0;

            $requesting_quantity = MaterialIssueRequestData::where([['mir_id' , $request->mir_id] , ['item_id' , $item_id]])->first()->item_requesting_quantity;


            
            // code...

                $total_receive_items = ReceiptItem::where('purchase_request_id' , $pr_id)
                ->where('approval_status' , 'approve')
                ->where('pass_quantity' , '>' , 0)
                ->where('item_id' ,  $item_id)
                ->sum('pass_quantity');

                $demand_item_quantity = ItemPurchaseRequest::where('purchase_request_id', '=', $pr_id)
                ->where( 'item_id', $item_id)
                ->first()->quantity;

               
                
                $current_release = ItemRelease::where('purchase_request_id',$pr_id )
                 ->each(function($p, $k) use (&$current_releasing ,&$current_returning , &$item_id) 
                {
                  $current_releasing+=$p->releasingItems()->where('item_id',$item_id)->sum('item_quantity');
                  $current_returning += $p->releasingItems()->where('item_id' , $item_id)->sum('return_quantity');
                });
            
            $current_releasing = $current_releasing - $current_returning ;

            $items[] = array('id' => $item->id , 'item_code' => $item->item_code , 'item_name' => $item->item_name  , 'brand' => $item->manufacture->name , 'category' => $item->category->category_name  , 'quantity' => number_format( $item->quantity, 2) , 'demand_quantity' => number_format($demand_item_quantity , 2) , 'current_releasing' =>  number_format($current_releasing , 2) , 'total_receive_items' => number_format($total_receive_items , 2 ) , 'requesting_quantity' => $requesting_quantity  );
        }
    }
    else
    {

        $type =  'without_pr';

         foreach($item_ids as $item_id)
        {

            $item = Item::find($item_id);

            $current_releasing = 0;
            $current_returning = 0;
            $total_receive_items = 0;
           

            $requesting_quantity = MaterialIssueRequestData::where([['mir_id' , $request->mir_id] , ['item_id' , $item_id]])->first()->item_requesting_quantity;
             $demand_item_quantity = $requesting_quantity;

            $items[] = array('id' => $item->id , 'item_code' => $item->item_code , 'item_name' => $item->item_name  , 'brand' => $item->manufacture->name , 'category' => $item->category->category_name  , 'quantity' => number_format( $item->quantity, 2) , 'demand_quantity' => number_format($demand_item_quantity , 2) , 'current_releasing' =>  number_format($current_releasing , 2) , 'total_receive_items' => number_format($total_receive_items , 2 ) , 'requesting_quantity' => $requesting_quantity );
        }
    }

    echo json_encode(array('department_name' => $mir->department->department_name , 'department_id' => $mir->department->id , 'items' =>  $items , 'response_type' => $type));

   }
   else
   {
      echo json_encode(array('department_name' => '' , 'department_id' => '' , 'items' => '' , 'response_type' => '' ));
   }
}
public function addPerson(Request  $request)
{
    $pr_id = $request->pr_id;
    $status = $request->status;
    $auth_person = $request->auth_person;
    $remarks = $request->remarks;
    date_default_timezone_set("Asia/Karachi");
    
    if($status  == 'auth_person')
    {
        if ( empty($auth_person)) 
    {
         echo json_encode(array('response' => 'invalid' , 'message' => "Please Enter Name!" ));
         exit;
    }

      $data = ['auth_person' =>  $auth_person , 'auth_person_date' =>  date('Y-m-d H:i:s')];
    }

    if($status  == 'remarks')
    {
         if ( empty($remarks)) 
    {
         echo json_encode(array('response' => 'invalid' , 'message' => "Please Enter Name!" ));
         exit;
    }

      $data = ['remarks' =>  $remarks ];
    }

    DB::beginTransaction();

    try 
    {
        PurchaseRequest::where('id' ,  $pr_id )->update( $data ); 
        DB::commit();
        echo json_encode(array('response' => 'yes'));
    } 
    catch (\Exception $e) 
    {
        DB::rollback();
    }

}

public function getItemLatestPrice(Request $request)
{
   $item_id = $request->item_id;
   $price = null;
   $quantity = Item::find($item_id)->quantity;

   $item = ItemPurchaseOrder::where('item_id' , $item_id)->latest('id')->first();
   if ($item == true)
   {
        $price = $item->price;
        echo json_encode(array('response' => 'yes' , 'quantity' => $quantity , 'price' =>  $price));
   }
   else
   {
        echo json_encode(array('response' => 'null'  , 'quantity' => $quantity  ));
   }
}

public function prApprovalPending($role_id = null)
{
    //........................GET Aproval's PR's.................................

    $purchase_requests = PurchaseRequest::withAndWhereHas('approvalStatus', function($query) use ($role_id)
    {
    $query->where('role_id',$role_id);
    $query->where('approvel_status', 0);
    })
   
    ->orderBy('id', 'DESC')->get();

    //........................End.................................

    return view('procurement/approval-pending/pr-approval-pending' ,compact('role_id' , 'purchase_requests') );
}
public function csApprovalPending($role_id = null)
{           
    $approval_pending_cs = PurchaseRequest::withAndWhereHas('csApprovalStatus', function($query) use ($role_id)   
     {       
     $query->where('role_id',$role_id);       
     $query->where('approvel_status', 0);     
     })    
     ->with('user')  
     ->orderBy('id', 'DESC')->get();   
     $approval_pending_cs = json_decode(json_encode( $approval_pending_cs)); 
     return view('procurement/approval-pending/cs-approval-pending' ,compact('role_id' , 'approval_pending_cs') );
}


public function getVendorItems(Request $request)
{
   
    $vendor_id = $request->vendor_id;
      $vendor = PurchaseRequestVendor::with('items')->find($vendor_id);

      if ($vendor == true) 
      {
         echo json_encode(array('response' => 'yes' , 'output' => $vendor));
      }

}


}