<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Reconciliation;
use App\CompanyBank;
use App\Receipt;
use App\ChartOfAccount;
use App\ExpensePayment;
use App\GeneralJournalEntry;

class ReconciliationController extends Controller
{
    //

    public function allReconciliations() {

    	$data['allReconciliations'] = Reconciliation::orderBy('created_at','desc')->get();

    	return view('transaction/reconcile.index',$data);
    }

    public function reconcileForm() {

    	$data['accounts'] = ChartOfAccount::whereHas('type',function($query){
            $query->where('name','Bank');
        })->get();

    	return view('transaction/reconcile.new-reconcile',$data);
    }

    public function showReconciliations(Request $request) {

    	$validator = Validator::make($request->all(), [
                    'start_date' => 'required',
                    'end_date' => 'required',
                    'account' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/reconciliations/new')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

    	// $data['receipts'] = Receipt::where('company_account',$request->account)->whereBetween('receipt_date',[$request->start_date,$request->end_date])->get();

     //    $data['payments'] = ExpensePayment::where([['account_id',$request->account],['payment_method','!=',ExpensePayment::CASH]])->whereBetween('date',[$request->start_date,$request->end_date])->get();

        $data['entries'] = GeneralJournalEntry::where([['account_id',$request->account],['is_post',true]])->orderBy('date','ASC')->get();

        $previousBalance = GeneralJournalEntry::where([['account_id',$request->account],['date','<',$request->start_date]])->sum('amount');

    	$data['account'] = $request->account;
    	$data['start_date'] = $request->start_date;
    	$data['end_date'] = $request->end_date;
    	
    	return view('transaction/reconcile.show-reconcile',$data);

    }

    public function addReconciliations(Request $request) {


    	if($request->e_ids ) {

    		foreach ($request->e_ids as $key => $value) {
    			GeneralJournalEntry::where('id',$value)->update(['is_cleared' =>true]);


    		}

            Reconciliation::create(['account_id'=>$request->account,'started_at'=>$request->start_date,'ended_at'=>$request->end_date]);


    	}

      


    	return redirect()
                        ->route('reconcile.all')
                        ->with([
                            'message' => 'Reconciliation perform successfully!',
                            'alert-type' => 'info'
        ]);
    }

}
