<?php

namespace App\Http\Controllers;

use App\DealerRefundOpenFileUnitReceipt;
use Illuminate\Http\Request;
use App\Customerproperty;
use App\CustomerStatement;
use App\UnitRefundHistory;
use App\StatementHistory;
use App\CancelProperty;
use App\Inventory;
use App\DealerTransaction;
use App\PaymentHeadPriority;
use App\Receipt;
use App\DepositorBank;
use App\CompanyBank;
use App\SurchargeReceipt;
use App\CustomerPropertyTax;
use App\OpenFileDealerInfo;
use Illuminate\Support\Facades\Auth;
use App\MultiProject;
use App\ProjectType;
use App\Customer;
use App\ChartOfAccount;
use App\CustomerRefundUnitReceipt;
use App\Dealer;
use App\RefundReceiptDocument;
use App\Traits\MultiProjectCookie;
use Illuminate\Support\Facades\Validator;
use DB;

class RefundPropertyController extends Controller
{
    //
    use MultiProjectCookie;
    public function index(Request $request)
    {
        $data = array();

        $project_ids =   $this->getCookieInfoAndMultiPro($request);

        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];

        // dd($ids);


        $data['allStatements'] = CustomerProperty::whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refund-pending');
        })->with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundReceipt')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            // ->whereIn('multi_project_id', $ids)
            ->orderBy('created_at', 'desc')->paginate(25);

        $receivedAmt = array();
        foreach ($data['allStatements'] as $statement) {
            $receivedAmt[$statement->id] = CustomerStatement::where([['customer_property_id', $statement->id], ['is_deleted', false]])->sum('received');
        }
        $data['receivedAmt'] = $receivedAmt;


        $data['statementCount'] = CustomerProperty::whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refund-pending');
        })
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();


        $data['statement_count_pending_refund'] = CustomerProperty::whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refund-pending');
        })
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();

        //refunded
        $data['allStatementsRefunded'] = CustomerProperty::whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })->with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundHistory')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->orderBy('created_at', 'desc')->paginate(25);

        $data['statement_count_refunded'] = CustomerProperty::whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();


        //decline

        $data['allStatementsdecline'] = CustomerProperty::whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'decline');
        })->with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundHistory')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->orderBy('created_at', 'desc')->paginate(25);

        $data['statement_count_decline'] = CustomerProperty::whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'decline');
        })
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();
        //pending openfile refund

        $data['OpenFileDealerInfo_pending_refund'] = OpenFileDealerInfo::whereHas('cancelOpenFile', function ($q) {
            $q->where('after_cancellation_status', 'refund-pending');
        })
            ->whereHas('inventory', function ($query) use ($ids) {
                $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                    $query->whereIn('multi_project_id', $ids);
                });
            })

            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')

            ->orderBy('created_at', 'desc')->paginate(25);

        $data['OpenFileDealerInfocount'] = OpenFileDealerInfo::whereHas('cancelOpenFile', function ($q) {
            $q->where('after_cancellation_status', 'refund-pending');
        })
            ->whereHas('inventory', function ($query) use ($ids) {
                $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                    $query->whereIn('multi_project_id', $ids);
                });
            })
            ->count();

        //approved openfile refund
        $data['OpenFileDealerInfo_approved_refund'] = OpenFileDealerInfo::whereHas('cancelOpenFile', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
            ->whereHas('inventory', function ($query) use ($ids) {
                $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                    $query->whereIn('multi_project_id', $ids);
                });
            })
            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->paginate(25);

        $data['refundedapprovedcount'] = OpenFileDealerInfo::whereHas('cancelOpenFile', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
            ->whereHas('inventory', function ($query) use ($ids) {
                $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                    $query->whereIn('multi_project_id', $ids);
                });
            })
            ->count();
        $data['multi_projects'] = $project_ids['multi_projects'];

        activity('View')->log('Cancel Statements list.');

        if (isset($project_ids['multipro_id'])) {

            return view('statement.refund.index-update', $data);
        } else {

            return view('statement.refund.index', $data);
        }
    }


    public function edit($id)
    {

        $data['allStatements'] = CustomerProperty::with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundHistory')
            ->orderBy('created_at', 'desc')->where([['is_deleted', false], ['id', '=', $id]])->first();

        $data['received_amount'] =   CustomerStatement::where([['customer_property_id', $data['allStatements']->id], ['is_deleted', false]])->sum('received');

        return view('statement.refund.edit', $data);
    }

    public function update(Request $request)
    {

        // 0 => pending
        // 1 => approve
        // 2 => decline
        $this->validate($request, [
            'id' => 'required',
            'refund_deduction_type' => 'required',
            'refund_amount_deducted' => 'required',
            'status' => 'required',
        ]);

        $cancel_property_id = $request->id;
        $cancel_property = CancelProperty::where('id', $request->id)->first();
        $receivedAmt = CustomerStatement::where([['customer_property_id', $cancel_property->customer_property_id], ['is_deleted', false]])->sum('received');
        if ($request->status == UnitRefundHistory::REFUND_DECISION_DECLINE) {



            CustomerProperty::where('id', $cancel_property->customer_property_id)->update(['status' => Customerproperty::approved,  'cancel_date'  => null]);

            $customer_property =  CancelProperty::where('customer_property_id', $cancel_property->customer_property_id)->first();

            $customer_property->status = 0;

            $customer_property->save();
            $property = CustomerProperty::find($cancel_property->customer_property_id);

            Inventory::where('id', $property->inventory_id)->update(['status' => Inventory::sold]);
            $cancel_property->after_cancellation_status = 'decline';
            $cancel_property->save();
            activity('Decline')->log($property->inventory->unit_number . ' Property Cancel Request.');
            return redirect()->route('property.refund')
                ->with([
                    'message' => 'Refund Unit updated Successfully!',
                    'alert-type' => 'success',
                ]);
        }








        $unitrefund =  UnitRefundHistory::where('customer_id', $cancel_property->customerProperty->customer_id)->where('customer_property_id', $cancel_property->customer_property_id)->first();
        if (empty($unitrefund)) {
            $unitrefund = new UnitRefundHistory();
        }

        $unitrefund->customer_id = $cancel_property->customerProperty->customer->id;
        $unitrefund->customer_property_id =  $cancel_property->customer_property_id;
        $unitrefund->total_amount = $receivedAmt;
        $unitrefund->cancel_property_id = $cancel_property->id;
        if ($request->refund_deduction_type == UnitRefundHistory::REFUND_DEDUCTUION_IN_PKR) {
            $unitrefund->total_deduct =  $request->refund_amount_deducted;
            $refund = $receivedAmt - $request->refund_amount_deducted;
            if ($refund > 0) {
                $unitrefund->total_refund = $refund;
            } else {
                $unitrefund->total_refund = 0;
            }


            if ($receivedAmt != 0) {
                $unitrefund->total_deduct_percentage = ($request->refund_amount_deducted / $receivedAmt) * 100;
            }
        } elseif ($request->refund_deduction_type == UnitRefundHistory::REFUND_DEDUCTUION_IN_PERCENTAGE) {
            $val = ($request->refund_amount_deducted / 100) *  $receivedAmt;
            $unitrefund->total_deduct = $val;
            $refund = $receivedAmt - $val;
            if ($refund > 0) {
                $unitrefund->total_refund = $refund;
            } else {
                $unitrefund->total_refund = 0;
            }

            $unitrefund->total_deduct_percentage = $request->refund_amount_deducted;
        }



        $owner = CustomerProperty::where('id',  $cancel_property->customer_property_id)->first();

        $unitrefund->save();
        //make statement history
        if ($request->status == UnitRefundHistory::REFUND_DECISION_APPROVED) {
            // $cancel_property->$cancel_property = 'refunded';       
            // $cancel_property->save();

            $data = $this->getUnitDetail($owner);
            $unitrefund->unit_detail = $data;
            $unitrefund->save();
            $update_cancel_property = CancelProperty::where('id', $request->id)->first();
            $update_cancel_property->after_cancellation_status = 'refunded';
            $update_cancel_property->save();

            Inventory::where('id', $update_cancel_property->customerProperty->inventory_id)->update(['status' => Inventory::open]);
            $customer_statements =  CustomerStatement::where('customer_property_id', $cancel_property->customer_property_id)->get();
            foreach ($customer_statements as $cs) {
                StatementHistory::create(['unit_refund_history_id' => $unitrefund->id, "payment_head" => $cs->payment_head, "inst_no" => $cs->inst_no, "inst_track" => $cs->inst_track, "due_date" => $cs->due_date, "due" => $cs->due, "received" => $cs->received, "balance" => $cs->balance, "rcpt_no" => $cs->rcpt_no, "ref_no" => $cs->ref_no, "rcpt_date" => $cs->rcpt_date, "rcpt_amount" => $cs->rcpt_amount, "late_days" => $cs->late_days, "surcharge" => $cs->surcharge]);
            }



            activity('update')->log($cancel_property->customerProperty->inventory->unit_number . ' Refund Approval Request.');
        }
        return redirect()->route('property.refund')
            ->with([
                'message' => 'Refund Unit updated Successfully!',
                'alert-type' => 'success',
            ]);
        //end statement history  
    }



    public function getUnitDetail(CustomerProperty $owner)
    {

        $floor_street = '';
        if ($owner->inventory->floor) {
            $floor_street = $owner->inventory->floor->name;
        }
        $block = $owner->inventory->floor->unitBlock ? $owner->inventory->floor->unitBlock->name : '';
        $category = '';
        foreach ($owner->inventory->categories as $c) {
            $category =  $category . ' ' . $c->category->name . '' . $c->category->percent;
        }
        $size = $owner->inventory->size ? $owner->inventory->size->name : '';
        $total_price =  $owner->inventory->total_price;
        $net_pay = $owner->net_pay;
        $unit_plot_no = $owner->inventory ? $owner->inventory->unit_number : '';
        $unit_type = $owner->inventory->type->name;
        $area =    $owner->inventory->area;
        $discount = number_format($owner->discount);
        $category_cost = number_format($owner->inventory->extra_amount);
        $booking_type = '';
        if ($owner->booking_type == \App\CustomerProperty::normal) {
            $booking_type = 'Installment';
        } elseif ($owner->booking_type == \App\CustomerProperty::full_payment) {
            $booking_type = 'Full Payment';
        }
        $booking_date = date('d-m-Y', strtotime($owner->original_boooking_date));
        $schedule_start_date = '';
        if ($owner->schedule_start_date) {
            $schedule_start_date = date('d-m-Y', strtotime($owner->schedule_start_date));
        }
        $unit_array = array(
            'floor_street' => $floor_street,
            'unit_plot_no' => $unit_plot_no,
            'block' => $block,
            'unit_type' => $unit_type,
            'category' => $category,
            'area' => $area,
            'size' => $size,
            'discount' => $discount,
            'total_price' => $total_price,
            'category_cost' => $category_cost,
            'net_amt' => $net_pay,
            'booking_type' => $booking_type,
            'booking_date' => $booking_date,
            'schedule_start_date' => $schedule_start_date
        );
        // $out = array_values($unit_array);
        // return json_encode($unit_array);
        return serialize($unit_array);
        // unserialize($data);
    }
    public function detailRefundStatementHistory($id)
    {




        $unit_refund = UnitRefundHistory::where('customer_property_id', $id)->first();
        //     dd($transferproperty->transferhistory);
        $property = CustomerProperty::where('id', $unit_refund->customer_property_id)->with('inventory', 'customer', 'statement', 'propertyTax')->first();
        $amount = StatementHistory::where('unit_refund_history_id', $unit_refund->id)->sum('received');
        $data = unserialize($unit_refund->unit_detail);

        $receivedAmtPer = $amount * 100 /  $data['net_amt'];
        $outstandingAmt = ($data['net_amt'] - $amount);
        $outstandingAmtPer = $outstandingAmt * 100 / $data['net_amt'];

        $dealers = DealerTransaction::where('product_id', $id)->get();
        $periorities = PaymentHeadPriority::orderby('priority', 'ASC')->get(['payment_head', 'priority']);
        $pdc_receipt = Receipt::where('customer_property_id', $unit_refund->customer_property_id)->where('payment_method', Receipt::cheque)->where('cheaque_status', Receipt::pending)->sum('amount');

        $pdcReceiptPer = $pdc_receipt * 100 /  $data['net_amt'];
        $allotment = false;
        $provisional = false;

        if ($receivedAmtPer >= 10) {
            $allotment = true;
        }
        if ($receivedAmtPer >= 25) {
            $provisional = true;
        }
        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();
        $waiveOff = SurchargeReceipt::where('customer_property_id', $unit_refund->customer_property_id)->where('customer_id', $unit_refund->customer_id)->where('amount', 0)->sum('total_surcharge');
        $paidSurcharge = SurchargeReceipt::where('customer_property_id', $unit_refund->customer_property_id)->where('customer_id', $unit_refund->customer_id)->sum('amount');
        $taxs = CustomerPropertyTax::where('customer_id', $unit_refund->owner_id)->where('property_id', $unit_refund->customer_property_id)->get();



        activity('View')->log('View the Refund Statement history detail ' . $unit_refund->customerProperty->inventory->unit_number . $unit_refund->customerProperty->customer->name);


        return view('statement.refund.refundhistory', compact('taxs', 'data', 'unit_refund', 'paidSurcharge', 'waiveOff', 'property', 'allotment', 'provisional', 'amount', 'receivedAmtPer', 'outstandingAmtPer', 'outstandingAmt', 'dealers', 'banks', 'cBanks', 'periorities', 'pdc_receipt', 'pdcReceiptPer'));
        // return view('customer.transfer-history',compact('taxs','data','transferproperty','paidSurcharge','waiveOff','property','allotment','provisional','amount','receivedAmtPer','outstandingAmtPer','outstandingAmt','dealers','banks','cBanks','periorities','pdc_receipt','pdcReceiptPer'));

    }
    // public  function getCookieInfomation(){
    //     $data = array();
    //     $project_id = request()->cookie('current_project_id');
    //     $user = Auth::user();
    //     if (!empty($project_id)) {
    //         $p_id = decrypt($project_id);
    //         $multi = MultiProject::where('id', $p_id)->first();
    //         $multiProjectId = $multi->id;
    //         if ($multi->name == "Super Admin") {
    //             $roles = $user
    //                 ->roles()
    //                 ->where('name', 'like', 'admin')
    //                 ->whereHas('projects', function ($query) use ($multiProjectId) {
    //                     $query->where('multi_project_id', $multiProjectId);
    //                 })
    //                 ->first();
    //             if (!empty($roles)) {
    //                 $data['multi_projects']  = MultiProject::where('name', 'NOT like', 'Super Admin')->get()->pluck('id')->toArray() // Flatten the collection of IDs into a single array
    //                 ;
    //                 return   $data;
    //             } else {
    //                 $project_ids = $user->roles()
    //                     ->with('projects') // Eager load the related 'projects' models
    //                     ->get()
    //                     ->pluck('projects.*.id') // Pluck the 'id' column from the related 'projects' models
    //                     ->flatten() // Flatten the collection of IDs into a single array
    //                     ->unique() // Filter out duplicates
    //                     ->values(); // Reset the array keys

    //                 ;
    //                 $data['multi_projects'] = MultiProject::whereIn('id',  $project_ids)->where('name', 'NOT like', 'Super Admin')->get()->pluck('id')
    //                 ->toArray();

    //                  return   $data;
    //             }
    //         }
    //         else{
    //             $roles = $user
    //                 ->roles()

    //                 ->whereHas('projects', function ($query) use ($multiProjectId) {
    //                     $query->where('multi_project_id', $multiProjectId);
    //                 })
    //                 ->first(); 

    //                 if (!empty($roles)) {
    //                     $data['multi_projects']  = $multi->id;

    //                     return   $data;


    //                 }
    //         }
    //     }
    // }

    public function createCustomerRefundUnitReceipt()
    {

       

        $customers = Customer::where('is_deleted', false)->get();
        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();
        $result = CustomerRefundUnitReceipt::where([['receipt_no', '!=', null]])
            ->orderby('receipt_no', 'desc')->first();

        if ($result) {

            $parts = explode("-", $result->receipt_no);
            $num = intval($parts[1]);
            $num++;
            $receipt_no = $parts[0] . "-" . strval($num);
        } else
            $receipt_no = 'RU-50000';





        $accounts = ChartOfAccount::orderBy('number', 'ASC')->get();







        return view('receipt.refund-unit-receipt', compact('customers', 'banks',  'cBanks', 'receipt_no'));
    }
    public function createDealerRefundOpenFileReceipt()
    {

      

        // $customers = Customer::where('is_deleted', false)->get();
        $dealers = Dealer::where('is_deleted', false)->get();
        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();
        $result = DealerRefundOpenFileUnitReceipt::where([['receipt_no', '!=', null]])
            ->orderby('receipt_no', 'desc')->first();

        if ($result) {

            $parts = explode("-", $result->receipt_no);
            $num = intval($parts[1]);
            $num++;
            $receipt_no = $parts[0] . "-" . strval($num);
        } else
            $receipt_no = 'ROF-50000';





        $accounts = ChartOfAccount::orderBy('number', 'ASC')->get();







        return view('receipt.refund-open-file-receipt', compact('dealers', 'banks',  'cBanks', 'receipt_no'));
    }

    public function updatePropertyForm(Request $request)
    {


        $project_ids =   $this->getCookieInfoAndMultiPro($request);
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];


        //refunded
        $data['allStatementsRefunded'] = CustomerProperty::where('customer_id', $request->customer_id)->whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
        ->doesntHave('unitRefundReceipt')
        ->with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundHistory')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->orderBy('created_at', 'desc')->get();

        $data['statement_count_refunded'] = CustomerProperty::where('customer_id', $request->customer_id)->whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
        ->doesntHave('unitRefundReceipt')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();


        //decline





        return view('receipt.update-refund-unit', $data);
    }
    public function updateOpenFileForm(Request $request)
    {


        $project_ids =   $this->getCookieInfoAndMultiPro($request);
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];


       

        $data['OpenFileDealerInfo_approved_refund'] = OpenFileDealerInfo::where('dealer_id', $request->dealer_id)
        ->whereHas('cancelOpenFile', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
        ->doesntHave('dealerRefundOpenFileUnitReceipts')
            ->whereHas('inventory', function ($query) use ($ids) {
                $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                    $query->whereIn('multi_project_id', $ids);
                });
            })

            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->get();

       


        //decline





        return view('receipt.update-refund-openfile', $data);
    }

    public function getRefundedUnitData(Request $request)
    {


        $allStatementsRefunded = CustomerProperty::where('id', $request->property_id)->whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })->with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundHistory')
            ->orderBy('created_at', 'desc')->first();
        $total_amount = 0;
        $total_refund = 0;
        $total_deduct = 0;
        if (!empty($allStatementsRefunded->unitRefundHistory)) {
            $total_amount = $allStatementsRefunded->unitRefundHistory->total_amount;
            $total_refund = $allStatementsRefunded->unitRefundHistory->total_refund;
            $total_deduct = $allStatementsRefunded->unitRefundHistory->total_deduct;
        }

        $arr = [
            'total_amount' => $total_amount,
            'total_refund' => $total_refund,
            'total_deduct' => $total_deduct,
        ];

        return response()->json(['data' => $arr]);
    }

    public function getRefundedOpenFileData(Request $request)
    {

        
        $openfile_refund = OpenFileDealerInfo::where('id', $request->openfile_dealer_info_id)->whereHas('cancelOpenFile', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
             
            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->first();
       
            $total_amount = 0;
        $total_refund = 0;
        $total_deduct = 0;
        if (!empty($openfile_refund->cancelOpenFile)) {
            $total_amount = $openfile_refund->cancelOpenFile->openFileRefunded->total_amount ;
            $total_refund =  $openfile_refund->cancelOpenFile->openFileRefunded->total_refund  ;
            $total_deduct =  $openfile_refund->cancelOpenFile->openFileRefunded->total_deduct ;
        }

        $arr = [
            'total_amount' => $total_amount,
            'total_refund' => $total_refund,
            'total_deduct' => $total_deduct,
        ];

        return response()->json(['data' => $arr]);
    }

    public function insertReceipt(Request $request)
    {





        $messages = [
            'bank_name.required_if' => 'Depositor Bank Name is required',
            'company_account.required_if' => 'Company Account is required',
            'cheque_number.required_if' => 'Cheque Number is required.',
            'drawn_date' => 'Drawn Date is required',
            'dealer_adjustment_unit_id' => 'Dealer Payable Rebates is required',
            'vendor_purchase_order_id' => 'Vendor Bill is required',
        ];

        $validator = Validator::make(
            $request->all(),
            [
                'amount' => 'required|regex:/^[0-9]+$/u',
                'customer_id' => 'required',
                'customer_property_id' => 'required',
                'payment_method' => 'required',

                'receipt_date' => 'required',
                'bank_name' => 'nullable|required_if:payment_method,2,3',
                'company_account' => 'nullable|required_if:payment_method,2,3',
                'drawn_date' => 'nullable|required_if:payment_method,3',
                'cheque_number' => 'nullable|required_if:payment_method,3|regex:/^[a-zA-Z\s0-9]+$/u',

                'receipt_no' => 'required|unique:customer_refund_unit_receipts,receipt_no',
                'roll_back_properties' => 'nullable|required_if:adjustment_type,7|regex:/^[0-9]+$/u'
            ],
            $messages
        );



        if ($validator->fails()) {
            return redirect()->route('property.refund.receipt')
                ->withErrors($validator)->withInput()
                ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error',]);
        }

        // dd($request->all());
        // amount

        $allStatementsRefunded = CustomerProperty::where('id', $request->customer_property_id)->whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })->with('unitRefundHistory', 'inventory')
            ->orderBy('created_at', 'desc')->first();

        $total_deduct = 0;
        if (!empty($allStatementsRefunded->unitRefundHistory)) {
            $total_deduct = $allStatementsRefunded->unitRefundHistory->total_deduct;
        }

        $remainingAmount =  $total_deduct;
        if ($request->amount > $remainingAmount) {
            return redirect()->route('property.refund.receipt')
                ->with(['message' => 'entered amount is more then remaining amount!', 'alert-type' => 'error',]);
        }



        $multiproject_id = $allStatementsRefunded->inventory ? $allStatementsRefunded->inventory->multiproject->id : null;
        $request->merge(['multi_project_id' => $multiproject_id]);


        $input = $request->all();
        $receipt = CustomerRefundUnitReceipt::create($input);
        if (!$receipt) {
            return redirect()->route('property.refund.receipt')->withInput()
                ->with(['message' => 'Something went wrong!', 'alert-type' => 'error',]);
        } else {

            return redirect()
                ->back()
                ->with(['message' => 'Receipt send for approval!', 'alert-type' => 'info']);
        }
    }
    public function insertOpenFileRefundReceipt(Request $request)
    {





    
        $messages = [
            'bank_name.required_if' => 'Depositor Bank Name is required',
            'company_account.required_if' => 'Company Account is required',
            'cheque_number.required_if' => 'Cheque Number is required.',
            'drawn_date' => 'Drawn Date is required',
            'dealer_adjustment_unit_id' => 'Dealer Payable Rebates is required',
            'vendor_purchase_order_id' => 'Vendor Bill is required',
        ];

        $validator = Validator::make(
            $request->all(),
            [
                'amount' => 'required|regex:/^[0-9]+$/u',
                'dealer_id' => 'required',
                'openfile_dealer_info_id' => 'required',
                'payment_method' => 'required',

                'receipt_date' => 'required',
                'bank_name' => 'nullable|required_if:payment_method,2,3',
                'company_account' => 'nullable|required_if:payment_method,2,3',
                'drawn_date' => 'nullable|required_if:payment_method,3',
                'cheque_number' => 'nullable|required_if:payment_method,3|regex:/^[a-zA-Z\s0-9]+$/u',

                'receipt_no' => 'required|unique:dealer_refund_open_file_unit_receipts,receipt_no',
                'roll_back_properties' => 'nullable|required_if:adjustment_type,7|regex:/^[0-9]+$/u'
            ],
            $messages
        );



        if ($validator->fails()) {
            return redirect()->route('property.refund-openfile.receipt')
                ->withErrors($validator)->withInput()
                ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error',]);
        }

        // dd($request->all());
        // amount

        
       
        $openfile_refund = OpenFileDealerInfo::where('id', $request->openfile_dealer_info_id)->whereHas('cancelOpenFile', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
             
            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->first();
       
        $total_deduct = 0;
        if (!empty($openfile_refund->cancelOpenFile)) {
            $total_deduct = $openfile_refund->cancelOpenFile->openFileRefunded->total_deduct;
        }

        $remainingAmount =   $total_deduct;
        if ($request->amount > $remainingAmount) {
            return redirect()->route('property.refund-openfile.receipt')
                ->with(['message' => 'entered amount is more then total deduction amount!', 'alert-type' => 'error',]);
        }



        $multiproject_id = $openfile_refund->inventory ? $openfile_refund->inventory->multiproject->id : null;
        $request->merge(['multi_project_id' => $multiproject_id]);


        $input = $request->all();
        $receipt = DealerRefundOpenFileUnitReceipt::create($input);
        if (!$receipt) {
            return redirect()->route('property.refund-openfile.receipt')->withInput()
                ->with(['message' => 'Something went wrong!', 'alert-type' => 'error',]);
        } else {

            return redirect()
                ->back()
                ->with(['message' => 'Receipt send for approval!', 'alert-type' => 'info']);
        }
    }
    public function getPendingReceipts(Request $request)
    {
        
        $data = array();
        $project_ids =   $this->getCookieInfoAndMultiPro($request);
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];

        $data['receipts'] = CustomerRefundUnitReceipt::with('property')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->where([['is_approved', false], ['is_deleted', false]])
            ->orderBy('receipt_date', 'asc')->get();



        $data['totalAmount'] = CustomerRefundUnitReceipt::where([['is_approved', false], ['is_deleted', false]])
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();


            $data['openfile_receipts'] = DealerRefundOpenFileUnitReceipt::
            when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->where([['is_approved', false], ['is_deleted', false]])
            ->orderBy('receipt_date', 'asc')->get();



        $data['openfile_count'] = DealerRefundOpenFileUnitReceipt::where([['is_approved', false], ['is_deleted', false]])
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();

 
            activity('View')->log('Refund Unit Pending Receipt List');

        return view('receipt.refund-recipt-pending', $data);
    }
    public function detailReceipt($id)
    {

        $data = array();

        $banks = DepositorBank::orderBy('name', 'ASC')->get();
        $cBanks = CompanyBank::all();

        $data['banks'] = $banks;
        $data['cBanks'] = $cBanks;

        $data['receipt'] = CustomerRefundUnitReceipt::where('id', $id)->first();

        $data['property'] = CustomerProperty::where('id', $data['receipt']->customer_property_id)
            ->whereHas('cancelProperty', function ($q) {
                $q->where('after_cancellation_status', 'refunded');
            })
            ->with('inventory', 'customer', 'unitRefundHistory')
            ->first();

        $result = CustomerRefundUnitReceipt::where('customer_property_id', $data['property']->id)
            ->sum('amount');

        // $data['property']->unitRefundHistory->total_refund
        // $data['property']->unitRefundHistory->total_deduct; 
        $data['balance'] =   $data['property']->unitRefundHistory->total_deduct;

        $digit = new \NumberFormatter("en", \NumberFormatter::SPELLOUT);

        if ($data['receipt']->tax_paid_by == \App\CustomerRefundUnitReceipt::company)
            $data['words'] = $digit->format($data['receipt']->amount + $data['receipt']->tax_amount);
        else
            $data['words'] = $digit->format($data['receipt']->amount);

        $data['refund_words'] =   $digit->format($data['property']->unitRefundHistory->total_refund);

        activity('View')
            ->log('View Unit Refund  Receipt record ' . $data['receipt']->receipt_no);

        return view('receipt.detail-unit-refund-receipt', $data);
    }
    public function detailOpenFileReceipt($id)
    {

        $data = array();

        $banks = DepositorBank::orderBy('name', 'ASC')->get();
        $cBanks = CompanyBank::all();

        $data['banks'] = $banks;
        $data['cBanks'] = $cBanks;

        $data['receipt'] = DealerRefundOpenFileUnitReceipt::where('id', $id)->first();
        $data['openfile_refund'] = OpenFileDealerInfo::where('id',  $data['receipt']->openfile_dealer_info_id)->whereHas('cancelOpenFile', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
             
            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->first();
       

        $result = DealerRefundOpenFileUnitReceipt::where('openfile_dealer_info_id', $data['openfile_refund']->id)
            ->sum('amount');

         
        $data['balance'] =   $data['openfile_refund']->cancelOpenFile->openFileRefunded->total_deduct;

        $digit = new \NumberFormatter("en", \NumberFormatter::SPELLOUT);

        if ($data['receipt']->tax_paid_by == DealerRefundOpenFileUnitReceipt::company)
            $data['words'] = $digit->format($data['receipt']->amount + $data['receipt']->tax_amount);
        else
            $data['words'] = $digit->format($data['receipt']->amount);

        $data['refund_words'] =   $digit->format($data['openfile_refund']->cancelOpenFile->openFileRefunded->total_refund);

        activity('View')
            ->log('View Open File Refund  Receipt record ' . $data['receipt']->receipt_no);

        return view('receipt.detail-openfile-refund-receipt', $data);
    }
    function uploadReceiptDocument(Request $request)
    {

        $receipt_id = $request->input('receipt_id');

        $supported_image = array(
            'gif',
            'jpg',
            'JPG',
            'jpeg',
            'png',
            'PNG',
            'docx',
            'pdf',
        );

        DB::beginTransaction();

        try {

            if ($request->file('files')) {
                foreach ($request->file('files') as $file) {

                    $imagePath = $file;
                    $imageExtension = $imagePath->getClientOriginalExtension();

                    if (!in_array($imageExtension, $supported_image)) {
                        echo json_encode(array('response' => 'invalid_document', 'message' => 'Only jpg|png|JPG|PNG|jpeg|gif|pdf|docx  Aceptable.'));

                        DB::rollback();
                        exit();
                    }

                    if (in_array($imageExtension, array('docx', 'pdf'))) {
                        $imageName = time() . '.' . $imagePath->getClientOriginalName();
                    } else {
                        $imageName = md5(time() . '.' . $imagePath->getClientOriginalName());
                    }

                    $path = $imagePath->storeAs('receipt_documents', $imageName, 'public');

                    $unit_type = $request->input('unit_type');
                    if($unit_type == RefundReceiptDocument::open_file){
                    RefundReceiptDocument::create([
                        'refund_receipt_id' => $receipt_id,
                        'document_path' => $imageName,
                        'openfile' => 1
                        
                    ]);
                }
                elseif($unit_type == RefundReceiptDocument::close_unit){
                    RefundReceiptDocument::create([
                        'refund_receipt_id' => $receipt_id,
                        'document_path' => $imageName,
                        'close_unit' => 1
                        
                    ]);
                }
            }

                DB::commit();

                echo json_encode(array('response' => 'yes'));
            } else {
                echo json_encode(array('response' => 'invalid_document', 'message' => 'Please Select files to upload.'));
                DB::rollback();
                exit();
            }
        } catch (\Exception $e) {

            DB::rollback();
            echo json_encode(array('response' => 'invalid_document', 'message' => 'Something went wrong. Please Refresh the page.'));
        }
    }
   

    public function deleteDocument($id = null)
    {

        $receipt_document = RefundReceiptDocument::where('id',$id)->where('close_unit',1)->first();

        if (\File::exists(public_path('storage/receipt_documents/' . $receipt_document->document_path))) {
            \File::delete(public_path('storage/receipt_documents/' . $receipt_document->document_path));
        }

        $receipt_document->delete();

        return redirect()->back();
    }

    public function deleteOpenfileDocument($id = null)
    {

        $receipt_document = RefundReceiptDocument::where('id',$id)->where('openfile',1)->first();

        if (\File::exists(public_path('storage/receipt_documents/' . $receipt_document->document_path))) {
            \File::delete(public_path('storage/receipt_documents/' . $receipt_document->document_path));
        }

        $receipt_document->delete();

        return redirect()->back();
    }

    public function editReceiptForm($id)
    {


        $project_ids =   $this->getCookieInfoAndMultiPro();
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];


        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();

        $receipt = CustomerRefundUnitReceipt::where('id', $id)->with('customer', 'property')->first();

        $properties = CustomerProperty::where('customer_id', $receipt->customer_id)->whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })->with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundHistory')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->orderBy('created_at', 'desc')->get();






        $customers = Customer::where('is_deleted', false)->get();


        //rebate history








        return view('receipt.edit-refund-receipt', compact('receipt', 'banks', 'cBanks', 'customers', 'properties'));
    }
    public function editOpenfileReceiptForm($id)
    {


        $project_ids =   $this->getCookieInfoAndMultiPro();
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];


        $banks = DepositorBank::all();
        $cBanks = CompanyBank::all();

        $receipt = DealerRefundOpenFileUnitReceipt::where('id', $id)->first();

        $OpenFileDealerInfo_approved_refund = OpenFileDealerInfo::where('dealer_id', $receipt->dealer_id)
        ->whereHas('cancelOpenFile', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
            ->whereHas('inventory', function ($query) use ($ids) {
                $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                    $query->whereIn('multi_project_id', $ids);
                });
            })

            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->get();

       
        
            $dealers = Dealer::where('is_deleted', false)->get();




      


        return view('receipt.edit-refund-openfile-receipt', compact('receipt', 'banks', 'cBanks', 'dealers', 'OpenFileDealerInfo_approved_refund'));
    }
    public function editUpdatePropertyForm(Request $request)
    {


        $project_ids =   $this->getCookieInfoAndMultiPro();
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];


        $receipt = CustomerRefundUnitReceipt::where('id', $request->receipt_id)->with('customer', 'property')->first();

        $properties = CustomerProperty::where('customer_id', $receipt->customer_id)->whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })->with('inventory', 'customer', 'dealer', 'cancelProperty', 'unitRefundHistory')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->orderBy('created_at', 'desc')->get();



        return view('receipt.update-refund-edit', compact('receipt', 'properties'));
    }

    public function editUpdateOpenfileForm(Request $request)
    {


        $project_ids =   $this->getCookieInfoAndMultiPro();
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];

 


            $receipt = DealerRefundOpenFileUnitReceipt::where('id', $request->receipt_id)->first();

        $OpenFileDealerInfo_approved_refund = OpenFileDealerInfo::where('dealer_id', $receipt->dealer_id)
        ->whereHas('cancelOpenFile', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
            ->whereHas('inventory', function ($query) use ($ids) {
                $query->when($ids[0] !== 'all', function ($query) use ($ids) {
                    $query->whereIn('multi_project_id', $ids);
                });
            })

            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->get();

       
        



        return view('receipt.update-refund-openfile-edit', compact('receipt', 'OpenFileDealerInfo_approved_refund'));
    }

    public function updateOpenFileReceipt(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'amount' => 'required|regex:/^[0-9]+$/u',
            'receipt_date' => 'required',
            'dealer_id' => 'required',
                'openfile_dealer_info_id' => 'required',
            'payment_method' => 'required',


            'cheque_number' => 'nullable|regex:/^[a-zA-Z\s0-9]+$/u',
            'receipt_no' => 'required',
        ]);


        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)->withInput()
                ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error',]);
        }

       
        $openfile_refund = OpenFileDealerInfo::where('id', $request->openfile_dealer_info_id)->whereHas('cancelOpenFile', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })
             
            ->with('inventory', 'dealerPackage', 'dealer', 'cancelOpenFile')->orderBy('created_at', 'desc')->first();
       
        $total_deduct = 0;
        if (!empty($openfile_refund->cancelOpenFile)) {
            $total_deduct = $openfile_refund->cancelOpenFile->openFileRefunded->total_deduct;
        }

        $remainingAmount =  $total_deduct;
        if ($request->amount > $remainingAmount) {
            return redirect()->back()
                ->with(['message' => 'entered amount is more then remaining amount!', 'alert-type' => 'error',]);
        }


        $multiproject_id = $openfile_refund->inventory ? $openfile_refund->inventory->multiproject->id : null;
        $request->merge(['multi_project_id' => $multiproject_id]);


       


        $result =    DealerRefundOpenFileUnitReceipt::where('id', $request->id)->update($request->except(['_token', 'permission', 'receipt_id', 'type', 'total_deduction']));





        if (!$result) {
            return redirect()
                ->back()
                ->withInput()
                ->with([
                    'message' => 'Something went wrong!',
                    'alert-type' => 'error',
                ]);
        }

        activity('Update')->log('Edit Open File Refund Unit Receipt info ' . $request->receipt_no);



        return   redirect()
            ->route('receipt.refund.pending')
            ->with([
                'message' => 'Receipt updated successfully!',
                'alert-type' => 'info'
            ]);
    }
    public function updateReceipt(Request $request)
    {


        $validator = Validator::make($request->all(), [
            'amount' => 'required|regex:/^[0-9]+$/u',
            'receipt_date' => 'required',
            'customer_id' => 'required',
            'customer_property_id' => 'required',
            'payment_method' => 'required',


            'cheque_number' => 'nullable|regex:/^[a-zA-Z\s0-9]+$/u',
            'receipt_no' => 'required',
        ]);


        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)->withInput()
                ->with(['message' => 'Invalid Inputs!', 'alert-type' => 'error',]);
        }

        $allStatementsRefunded = CustomerProperty::where('id', $request->customer_property_id)->whereHas('cancelProperty', function ($q) {
            $q->where('after_cancellation_status', 'refunded');
        })->with('unitRefundHistory', 'inventory')
            ->orderBy('created_at', 'desc')->first();

        $total_deduct = 0;
        if (!empty($allStatementsRefunded->unitRefundHistory)) {
            $total_deduct = $allStatementsRefunded->unitRefundHistory->total_deduct;
        }

        $remainingAmount =  $total_deduct;
        if ($request->amount > $remainingAmount) {
            return redirect()->back()
                ->with(['message' => 'entered amount is more then remaining amount!', 'alert-type' => 'error',]);
        }




        $multiproject_id = $allStatementsRefunded->inventory ? $allStatementsRefunded->inventory->multiproject->id : null;
        $request->merge(['multi_project_id' => $multiproject_id]);




        $result =    CustomerRefundUnitReceipt::where('id', $request->id)->update($request->except(['_token', 'permission', 'receipt_id', 'type', 'total_deduction']));





        if (!$result) {
            return redirect()
                ->back()
                ->withInput()
                ->with([
                    'message' => 'Something went wrong!',
                    'alert-type' => 'error',
                ]);
        }

        activity('Update')->log('Edit Refund Unit Receipt info ' . $request->receipt_no);



        return   redirect()
            ->route('receipt.refund.pending')
            ->with([
                'message' => 'Receipt updated successfully!',
                'alert-type' => 'info'
            ]);
    }

    public function deleteReceipt($id)
    {

        $receipt = CustomerRefundUnitReceipt::where('id', $id)->first();

        CustomerRefundUnitReceipt::where('id', $id)->update(['is_deleted' => true]);

        $amount = CustomerRefundUnitReceipt::where([['customer_id', $receipt->customer_id], ['is_deleted', false]])->sum('amount');

        // Customer::where('id', $receipt->customer_id)->update(['total_paid_amount' => $amount]);

        activity('Delete')->log('Delete Refund Unit Receipt info ' . $receipt->receipt_no);

        return redirect()
            ->back()
            ->with([
                'message' => 'Payment deleted successfully!',
                'alert-type' => 'info'
            ]);
    }

    public function deleteOpenFileReceipt($id)
    {
       

        $receipt = DealerRefundOpenFileUnitReceipt::where('id', $id)->first();


        DealerRefundOpenFileUnitReceipt::where('id', $id)->update(['is_deleted' => true]);






        // $amount = CustomerRefundUnitReceipt::where([['customer_id', $receipt->customer_id], ['is_deleted', false]])->sum('amount');

        // Customer::where('id', $receipt->customer_id)->update(['total_paid_amount' => $amount]);




        activity('Delete')->log('Delete Refund Unit Receipt info ' . $receipt->receipt_no);

        return redirect()
            ->back()
            ->with([
                'message' => 'Payment deleted successfully!',
                'alert-type' => 'info'
            ]);
    }
    
    public function approvedReceipt($id)
    {

        $current_receipt = CustomerRefundUnitReceipt::find($id);

        $isLessDateReceipt = CustomerRefundUnitReceipt::where('receipt_date', '<', $current_receipt->receipt_date)->where('customer_property_id', $current_receipt->customer_property_id)->where('is_approved', false)->where('is_deleted', false)->first();


        // customer_property_id
        // $properties = CustomerProperty
        if (!empty($isLessDateReceipt)) {
            return redirect()
                ->route('receipt.refund.pending')
                ->withInput()
                ->with([
                    'message' => 'Error ! First approve lower date receipt.',
                    'alert-type' => 'error',
                ]);
        }

        $receipt_n = CustomerRefundUnitReceipt::where('id', $id)->first();





        $receipt =     CustomerRefundUnitReceipt::where('id', $id)->update(['is_approved' => true]);




        if (!$receipt) {
            return redirect()
                ->route('receipt.refund.pending')
                ->withInput()
                ->with([
                    'message' => 'Something went wrong!',
                    'alert-type' => 'error',
                ]);
        }


        activity('Approved')->log('REfund Unit Receipt Approved ' . $receipt_n->receipt_no);

        return redirect()
            ->back()
            ->with([
                'message' => 'Receipt Approved successfully!',
                'alert-type' => 'info'
            ]);
    }
    public function approvedOpenfileReceipt($id)
    {

        $current_receipt = DealerRefundOpenFileUnitReceipt::find($id);

        $isLessDateReceipt = DealerRefundOpenFileUnitReceipt::where('receipt_date', '<', $current_receipt->receipt_date)->where('openfile_dealer_info_id', $current_receipt->openfile_dealer_info_id)->where('is_approved', false)->where('is_deleted', false)->first();


        // customer_property_id
        // $properties = CustomerProperty
        if (!empty($isLessDateReceipt)) {
            return redirect()
                ->route('receipt.refund.pending')
                ->withInput()
                ->with([
                    'message' => 'Error ! First approve lower date receipt.',
                    'alert-type' => 'error',
                ]);
        }

        $receipt_n = DealerRefundOpenFileUnitReceipt::where('id', $id)->first();





        $receipt =     DealerRefundOpenFileUnitReceipt::where('id', $id)->update(['is_approved' => true]);




        if (!$receipt) {
            return redirect()
                ->route('receipt.refund.pending')
                ->withInput()
                ->with([
                    'message' => 'Something went wrong!',
                    'alert-type' => 'error',
                ]);
        }


        activity('Approved')->log('Open Unit Refund Unit Receipt Approved ' . $receipt_n->receipt_no);

        return redirect()
            ->back()
            ->with([
                'message' => 'Receipt Approved successfully!',
                'alert-type' => 'info'
            ]);
    }

    public function receiptList(){

        
        
        $data = array();
        $project_ids =   $this->getCookieInfoAndMultiPro();
        if ($project_ids['status'] == 'error') {
            return redirect()

                ->back()
                ->with([
                    'message' => 'Invalid Inputs!',
                    'alert-type' => 'error',
                ]);
        }
        $ids = [];
        if (is_array($project_ids['project_ids'])) {
            $ids = $project_ids['project_ids'];
        } else
            $ids[] = $project_ids['project_ids'];

        $data['receipts'] = CustomerRefundUnitReceipt::with('property')
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->where('is_deleted', false)
            ->orderBy('receipt_date', 'asc')->get();



        $data['totalAmount'] = CustomerRefundUnitReceipt::where('is_deleted', false)
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();


            $data['openfile_receipts'] = DealerRefundOpenFileUnitReceipt::
            when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->where('is_deleted', false)
            ->orderBy('receipt_date', 'asc')->get();



        $data['openfile_count'] = DealerRefundOpenFileUnitReceipt::where(
         'is_deleted', false)
            ->when($ids[0] !== 'all', function ($query) use ($ids) {
                $query->whereIn('multi_project_id', $ids);
            })
            ->count();

 
            activity('View')->log('Refund Unit Pending Receipt List');
        return view('receipt.refund-receipt-list',$data);
        
    }
}
