<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use App\CustomerProperty;
use App\CustomerStatement;
use DB;
use App\Expense;
use App\Purchase;
use App\DealerPaidRebate;
use App\Receipt;
use App\ProjectAccount;
use App\Inventory;
use App\DealerTransaction;
use App\ExpenseCategory;
use App\Vendor;
use App\CompanyBank;
use App\ExpensePayment;
use App\PropertyChatHistory;
use App\ChartOfAccount;
use App\GeneralJournalEntry;
use Illuminate\Support\Facades\Auth;
use App\Item;
use App\ReceiptItem;
use App\ItemRelease;
use App\ItemReleaseData;
use App\PurchaseOrderReceipt;
use App\ItemPurchaseOrder;
use App\ControlAccount;
use App\MultiProject;
use DateTime;
use DateInterval;
use DatePeriod;
use App\UnitBlock;
use App\UnitFloor;
use App\UnitSize;
use App\TransferProperty;

class ReportController extends Controller
{

    //form to get the date range
    public function getProjectAccountStatementForm()
    {

        return view('report.project-account-statement-range');
    }

    public function getProjectAccountStatement(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'date_range' => 'required'

        ]);

        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();

        $amounts = ProjectAccount::whereBetween('date', [$from, $to])->with('inventory')
            ->get();

        //range
        $from_date = $date[0];
        $to_date = $date[1];

        return view('report.project-account-statement', compact('amounts', 'from_date', 'to_date'));
    }

    //form to get the date range
    public function getAccountStatementForm()
    {

       $multi_projects= MultiProject::all();
        return view('report.account-statement-range',compact('multi_projects'));
    }
    public function getAccountStatement(Request $request)
    {

        dd($request->all());

        $validator = Validator::make($request->all(),
         [
            'date_range' => 'required', 
         'period' => 'required',
         'multipro_id' =>'required'
        ]);

        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }

        $block = '0';
        $filter_type = 'all';
        if (!empty($request->block) && ($request->block != 'summary' && $request->block != 'combined')) {
            $block = $request->block;
            $filter_type = 'filter';
        }

       
        // $dueAmt = array();
        // $percent = array();
        // $dueMonth = array();
        // $outStandingAmount = array();
        // $overDueAmt = array();
        if ($request->period == 1) {

            $date = explode('-', $request->date_range);
            $from = Carbon::parse($date[0])->startOfDay();
            $to = Carbon::parse($date[1])->endOfDay();

            $properties = CustomerProperty::where([['status', '!=', CustomerProperty::cancel], ['is_deleted', false]])
                ->whereBetween('booking_date', [$from, $to])
                ->with('inventory', 'customer', 'size', 'dealer')
                ->get();

            $properties = json_decode(json_encode($properties), true);

            usort($properties, function ($item1, $item2) {
                return preg_replace("/[^0-9.]/", "", $item1['inventory']['unit_number']) <=> preg_replace("/[^0-9.]/", "", $item2['inventory']['unit_number']);
            });

            $properties = json_decode(json_encode($properties));

            // echo '<pre>';
            // print_r($properties);
            // die;
            $receivedAmt = array();

            foreach ($properties as $statement) {

                $receivedAmt[$statement
                    ->id] = Receipt::where('is_deleted', false)

                    ->whereBetween('receipt_date', [$from, $to])
                    ->whereIn('customer_property_id', [$statement
                        ->id])
                    ->where('is_approved', 1)
                    ->sum('amount');
            }

            $dueAmt = array();
            $percent = array();
            $dueMonth = array();
            $outStandingAmount = array();
            $overDueAmt = array();

            foreach ($properties as $statement) {

                //$surcharge = CustomerStatement::where('customer_property_id',$statement->id)->whereBetween('due_date',[$from,$to])->value(DB::raw("SUM(surcharge)"));;
                $balance = CustomerStatement::where('customer_property_id', $statement->id)
                    ->whereBetween('due_date', [$from, $to])->value(DB::raw("SUM(balance)"));

                $dueAmt[$statement->id] = $balance;

                $amount = CustomerStatement::where('customer_property_id', $statement->id)
                    ->sum('received');

                $outStandingAmount[$statement->id] = $amount;

                /*Previous Query commented by MI*/
                /*$overDue = CustomerStatement::where('customer_property_id',$statement->id)
                    ->whereDate('due_date','<', \Carbon\Carbon::today())
                    ->sum('balance');*/

                $overDue = CustomerStatement::where('customer_property_id', $statement->id)
                    ->whereBetween('due_date', [$from, $to])->sum('balance');

                $overDueAmt[$statement->id] = $overDue;

                $percent[$statement->id] = (float)(($dueAmt[$statement
                    ->id] / $statement->cost) * 100);

                $dueMonth[$statement
                    ->id] = CustomerStatement::whereBetween('due_date', [$from, $to])->where([['customer_property_id', $statement->id], ['balance', '>', 0]])
                    ->get(['customer_property_id', 'due', 'due_date']);
            }

            //range
            $from_date = $date[0];
            $to_date = $date[1];
        } else {

            $properties = CustomerProperty::where([['status', '!=', CustomerProperty::cancel], ['is_deleted', false]])
                ->whereDate('booking_date', '<=', $request->date_range)

                ->with('inventory', 'customer', 'size')
                ->get();
              

            $receivedAmt = array();

            foreach ($properties as $statement) {

                $receivedAmt[$statement
                    ->id] = Receipt::where('is_deleted', false)

                    ->whereDate('receipt_date', '<', $request->date_range)

                    ->whereIn('customer_property_id', [$statement
                        ->id])
                    ->where('is_approved', 1)
                    ->sum('amount');
            }
            $dueAmt = array();
            $percent = array();
            $dueMonth = array();
            foreach ($properties as $statement) {

                $balance = CustomerStatement::where('customer_property_id', $statement->id)
                    ->where('due_date', '<=', $request->date_range)
                    ->value(DB::raw("SUM(balance)"));

                $dueAmt[$statement->id] = $balance;

                $amount = CustomerStatement::where('customer_property_id', $statement->id)
                    ->sum('received');

                $outStandingAmount[$statement->id] = $amount;

                /*Previous Query */
                /*$overDue = CustomerStatement::where('customer_property_id',$statement->id)
                    ->whereDate('due_date','<',  \Carbon\Carbon::today())
                    ->sum('balance');*/

                $overDue = CustomerStatement::where('customer_property_id', $statement->id)
                    ->whereDate('due_date', '<', $request->date_range)
                    ->sum('balance');

                $overDueAmt[$statement->id] = $overDue;

                $percent[$statement->id] = (float)(($dueAmt[$statement
                    ->id] / $statement->cost) * 100);

                $dueMonth[$statement
                    ->id] = CustomerStatement::where('due_date', '<=', $request->date_range)
                    ->where([['customer_property_id', $statement->id], ['balance', '>', 0]])
                    ->get(['customer_property_id', 'due', 'due_date']);
            }

            //range
            $from_date = CustomerStatement::oldest('due_date')->first()->due_date;
            if ($request->period == 1) {
                $date = explode('-', $request->date_range);

                $to_date = $date[1];
            } else if ($request->period == 2) {
                $to_date = $request->date_range;
            }

        }

        $dueMonth = json_decode(json_encode($dueMonth), true);
        $start = new DateTime($from_date);
        $start->modify('first day of this month');
        $end = new DateTime($to_date);
        $end->modify('first day of next month');
        $interval = DateInterval::createFromDateString('1 month');
        $period = new DatePeriod($start, $interval, $end);
        $unit_blocks = UnitBlock::orderBy('name', 'ASC')->get();
        $selected_date_range = $request->date_range;
        $selected_period = $request->period;
        /////..................For Block Summary display....................//
        $allFloors = UnitFloor::all();
    
        $floor_data = array();
        foreach ($allFloors as $f) {
            $temp['name'] = $f->name;

            $temp['block'] =$f
            ->unitBlock? $f
                ->unitBlock->name:'';

            $temp['total_units'] = Inventory::where([['is_deleted', false], ['unit_floor_id', $f
                ->id]])
                ->count();

            $temp['booked_units'] = Inventory::where([['is_deleted', false], ['unit_floor_id', $f->id], ['status', Inventory::sold]])
                ->count();

                // dd($temp['booked_units']);

            $temp['un_booked_units'] = $temp['total_units'] - $temp['booked_units'];

            $result = Inventory::where([['is_deleted', false], ['unit_floor_id', $f
                ->id]])
                ->pluck('unit_size_id')
                ->toArray();

            $temp['total_units_area'] = 0;

            foreach ($result as $r) $temp['total_units_area'] += UnitSize::where('id', $r)->first()?UnitSize::where('id', $r)->first()->name:0;

            $result = Inventory::where([['is_deleted', false], ['status', '!=', Inventory::sold], ['unit_floor_id', $f
                ->id]])
                ->pluck('unit_size_id')
                ->toArray();

            $temp['un_booked_units_area'] = 0;

            foreach ($result as $r) $temp['un_booked_units_area'] +=  UnitSize::where('id', $r)->first()?UnitSize::where('id', $r)->first()->name:0;

            $temp['booked_units_area'] = $temp['total_units_area'] - $temp['un_booked_units_area'];

            $floor_id = $f->id;

            $temp['total_units_amount'] = Inventory::where([['is_deleted', false], ['unit_floor_id', $f->id], ['status', '=', Inventory::sold]])
                ->sum('total_price');

            $temp['booked_units_amount'] = CustomerProperty::where('is_deleted', false)->where('status', '!=', CustomerProperty::cancel)->whereHas('inventory', function ($query) use ($floor_id) {
                $query->where('unit_floor_id', $floor_id);
                $query->where('status', Inventory::sold);
            })
                ->sum('net_pay');

            // Inventory::where([['is_deleted',false],['unit_floor_id',$f->id],['status',Inventory::sold]])->sum('total_price');
            // $temp['un_booked_units_amount'] = $temp['total_units_amount'] - $temp['booked_units_amount'];
            $temp['un_booked_units_amount'] = Inventory::where([['is_deleted', false], ['unit_floor_id', $f->id], ['status', '!=', Inventory::sold]])
                ->sum('total_price');;

            $allProperties = CustomerProperty::where('is_deleted', false)->where('status', '!=', CustomerProperty::cancel)->whereHas('inventory', function ($query) use ($floor_id) {
                $query->where('unit_floor_id', $floor_id);
            })->pluck('id')
                ->toArray();

            $temp['recovery'] = 0;

            $temp['discount'] = 0;

            $temp['receivable'] = 0;
            $temp['overdue'] = 0;
            $temp['future'] = 0;

            if (count($allProperties) > 0) {

                $temp['recovery'] = Receipt::where('is_deleted', false)->whereIn('customer_property_id', $allProperties)->where('is_approved', 1)
                    ->sum('amount');

                $discount = ($temp['total_units_amount'] - $temp['booked_units_amount']);

                $temp['discount'] = $discount > 0 ? $discount : 0;

                $temp['receivable'] = Customerproperty::whereIn('id', $allProperties)->sum('net_pay') - $temp['recovery'];

                $temp['overdue'] = CustomerStatement::whereIn('customer_property_id', $allProperties)->where('due_date', '<', Carbon::now())
                    ->sum('balance');

                $transfer = TransferProperty::whereIn('property_id', $allProperties)->sum('transfer_charges');

                $temp['future'] = CustomerStatement::whereIn('customer_property_id', $allProperties)->where('due_date', '>=', Carbon::now())
                    ->sum('balance') - $transfer;
            }

            array_push($floor_data, $temp);
        }
        // dd( $floor_data,$unit_blocks);
        ////////////End///////////////////////////////////////////////////////////////////////////////
        if (!empty($request->block) && ($request->block == 'summary' || $request->block == 'combined')) {
            $block = $request->block;
        }
 
        return view('report.account-statement', compact('properties', 'from_date', 'to_date', 'overDueAmt', 'receivedAmt', 'dueAmt', 'outStandingAmount', 'percent', 'dueMonth', 'period', 'selected_period', 'selected_date_range', 'unit_blocks', 'block', 'filter_type', 'floor_data'));
    }
    // public function getAccountStatement(Request $request)
    // {

    //     $validator = Validator::make($request->all() , ['date_range' => 'required', 'period' => 'required']);

    //     if ($validator->fails())
    //     {
    //         return redirect()
    //             ->back()
    //             ->withErrors($validator)->withInput();
    //     }

    //     $block = '0';

    //     $filter_type = 'all';

    //     if (!empty($request->block) && ($request->block != 'summary' && $request->block != 'combined'))
    //     {
    //         $block = $request->block;
    //         $filter_type = 'filter';
    //     }

    //     if ($request->period == 1)
    //     {

    //         $date = explode('-', $request->date_range);
    //         $from = Carbon::parse($date[0])->startOfDay();
    //         $to = Carbon::parse($date[1])->endOfDay();

    //         $properties = CustomerProperty::where([['status', '!=', CustomerProperty::cancel], ['is_deleted', false]])
    //           ->whereBetween('booking_date', [$from, $to])
    //           ->with('inventory', 'customer', 'size', 'dealer')
    //             ->get();

    //         $properties = json_decode(json_encode($properties) , true);

    //         usort($properties, function ($item1, $item2)
    //         {
    //             return preg_replace("/[^0-9.]/", "", $item1['inventory']['unit_number']) <=> preg_replace("/[^0-9.]/", "", $item2['inventory']['unit_number']);
    //         });

    //         $properties = json_decode(json_encode($properties));

    //         // echo '<pre>';
    //         // print_r($properties);
    //         // die;
    //         $receivedAmt = array();

    //         foreach ($properties as $statement)
    //         {

    //             $receivedAmt[$statement
    //                 ->id] = Receipt::where('is_deleted', false)

    //                 ->whereBetween('receipt_date', [$from, $to])
    //                     ->whereIn('customer_property_id', [$statement
    //                 ->id])
    //                 ->where('is_approved', 1)
    //                 ->sum('amount');
    //         }

    //         $dueAmt = array();
    //         $percent = array();
    //         $dueMonth = array();
    //         $outStandingAmount = array();
    //         $overDueAmt = array();

    //         foreach ($properties as $statement)
    //         {

    //             //$surcharge = CustomerStatement::where('customer_property_id',$statement->id)->whereBetween('due_date',[$from,$to])->value(DB::raw("SUM(surcharge)"));;
    //             $balance = CustomerStatement::where('customer_property_id', $statement->id)
    //                 ->whereBetween('due_date', [$from, $to])->value(DB::raw("SUM(balance)"));

    //             $dueAmt[$statement->id] = $balance;

    //             $amount = CustomerStatement::where('customer_property_id', $statement->id)
    //                 ->sum('received');

    //             $outStandingAmount[$statement->id] = $amount;

    //             /*Previous Query commented by MI*/
    //             /*$overDue = CustomerStatement::where('customer_property_id',$statement->id)
    //                 ->whereDate('due_date','<', \Carbon\Carbon::today())
    //                 ->sum('balance');*/

    //             $overDue = CustomerStatement::where('customer_property_id', $statement->id)
    //                 ->whereBetween('due_date', [$from, $to])->sum('balance');

    //             $overDueAmt[$statement->id] = $overDue;

    //             $percent[$statement->id] = (float)(($dueAmt[$statement
    //                 ->id] / $statement->cost) * 100);

    //             $dueMonth[$statement
    //                 ->id] = CustomerStatement::whereBetween('due_date', [$from, $to])->where([['customer_property_id', $statement->id], ['balance', '>', 0]])
    //                 ->get(['customer_property_id', 'due', 'due_date']);

    //         }

    //         //range
    //         $from_date = $date[0];
    //         $to_date = $date[1];
    //     }
    //     else
    //     {

    //         $properties = CustomerProperty::where([['status', '!=', CustomerProperty::cancel], ['is_deleted', false]])
    //          ->whereDate('booking_date', '<', $request->date_range)

    //             ->with('inventory', 'customer', 'size')
    //             ->get();

    //         $receivedAmt = array();

    //         foreach ($properties as $statement)
    //         {

    //             $receivedAmt[$statement
    //                 ->id] = Receipt::where('is_deleted', false)

    //                 ->whereDate('receipt_date', '<', $request->date_range)

    //                 ->whereIn('customer_property_id', [$statement
    //                 ->id])
    //                 ->where('is_approved', 1)
    //                 ->sum('amount');

    //         }

    //         $dueAmt = array();
    //         $percent = array();
    //         $dueMonth = array();

    //         foreach ($properties as $statement)
    //         {

    //             $balance = CustomerStatement::where('customer_property_id', $statement->id)
    //                 ->where('due_date', '<=', $request->date_range)
    //                 ->value(DB::raw("SUM(balance)"));

    //             $dueAmt[$statement->id] = $balance;

    //             $amount = CustomerStatement::where('customer_property_id', $statement->id)
    //                 ->sum('received');

    //             $outStandingAmount[$statement->id] = $amount;

    //             /*Previous Query */
    //             /*$overDue = CustomerStatement::where('customer_property_id',$statement->id)
    //                 ->whereDate('due_date','<',  \Carbon\Carbon::today())
    //                 ->sum('balance');*/

    //             $overDue = CustomerStatement::where('customer_property_id', $statement->id)
    //                 ->whereDate('due_date', '<', $request->date_range)
    //                 ->sum('balance');

    //             $overDueAmt[$statement->id] = $overDue;

    //             $percent[$statement->id] = (float)(($dueAmt[$statement
    //                 ->id] / $statement->cost) * 100);

    //             $dueMonth[$statement
    //                 ->id] = CustomerStatement::where('due_date', '<=', $request->date_range)
    //                 ->where([['customer_property_id', $statement->id], ['balance', '>', 0]])
    //                 ->get(['customer_property_id', 'due', 'due_date']);

    //         }

    //         //range
    //         $from_date = CustomerStatement::oldest('due_date')->first()->due_date;
    //         $to_date = $request->date_range;
    //     }

    //     $dueMonth = json_decode(json_encode($dueMonth) , true);

    //     $start = new DateTime($from_date);
    //     $start->modify('first day of this month');

    //     $end = new DateTime($to_date);
    //     $end->modify('first day of next month');

    //     $interval = DateInterval::createFromDateString('1 month');

    //     $period = new DatePeriod($start, $interval, $end);

    //     $unit_blocks = UnitBlock::orderBy('name', 'ASC')->get();
    //     $selected_date_range = $request->date_range;
    //     $selected_period = $request->period;

    //     /////..................For Block Summary display....................//
    //     $allFloors = UnitFloor::all();

    //     $floor_data = array();

    //     foreach ($allFloors as $f)
    //     {
    //         $temp['name'] = $f->name;

    //         $temp['block'] = $f
    //             ->unitBlock->name;

    //         $temp['total_units'] = Inventory::where([['is_deleted', false], ['unit_floor_id', $f
    //             ->id]])
    //             ->count();

    //         $temp['booked_units'] = Inventory::where([['is_deleted', false], ['unit_floor_id', $f->id], ['status', Inventory::sold]])
    //             ->count();

    //         $temp['un_booked_units'] = $temp['total_units'] - $temp['booked_units'];

    //         $result = Inventory::where([['is_deleted', false], ['unit_floor_id', $f
    //             ->id]])
    //             ->pluck('unit_size_id')
    //             ->toArray();

    //         $temp['total_units_area'] = 0;

    //         foreach ($result as $r) $temp['total_units_area'] += UnitSize::where('id', $r)->first()->name;

    //         $result = Inventory::where([['is_deleted', false], ['status', '!=', Inventory::sold], ['unit_floor_id', $f
    //             ->id]])
    //             ->pluck('unit_size_id')
    //             ->toArray();

    //         $temp['un_booked_units_area'] = 0;

    //         foreach ($result as $r) $temp['un_booked_units_area'] += UnitSize::where('id', $r)->first()->name;

    //         $temp['booked_units_area'] = $temp['total_units_area'] - $temp['un_booked_units_area'];

    //         $floor_id = $f->id;

    //         $temp['total_units_amount'] = Inventory::where([['is_deleted', false], ['unit_floor_id', $f->id], ['status', '=', Inventory::sold]])
    //             ->sum('total_price');

    //         $temp['booked_units_amount'] = CustomerProperty::where('is_deleted', false)->where('status', '!=', CustomerProperty::cancel)->whereHas('inventory', function ($query) use ($floor_id)
    //         {
    //             $query->where('unit_floor_id', $floor_id);
    //             $query->where('status', Inventory::sold);
    //         })
    //             ->sum('net_pay');

    //         // Inventory::where([['is_deleted',false],['unit_floor_id',$f->id],['status',Inventory::sold]])->sum('total_price');
    //         // $temp['un_booked_units_amount'] = $temp['total_units_amount'] - $temp['booked_units_amount'];
    //         $temp['un_booked_units_amount'] = Inventory::where([['is_deleted', false], ['unit_floor_id', $f->id], ['status', '!=', Inventory::sold]])
    //             ->sum('total_price');;

    //         $allProperties = CustomerProperty::where('is_deleted', false)->where('status', '!=', CustomerProperty::cancel)->whereHas('inventory', function ($query) use ($floor_id)
    //         {
    //             $query->where('unit_floor_id', $floor_id);
    //         })->pluck('id')
    //             ->toArray();

    //         $temp['recovery'] = 0;

    //         $temp['discount'] = 0;

    //         $temp['receivable'] = 0;
    //         $temp['overdue'] = 0;
    //         $temp['future'] = 0;

    //         if (count($allProperties) > 0)
    //         {

    //             $temp['recovery'] = Receipt::where('is_deleted', false)->whereIn('customer_property_id', $allProperties)->where('is_approved', 1)
    //                 ->sum('amount');

    //             $discount = ($temp['total_units_amount'] - $temp['booked_units_amount']);

    //             $temp['discount'] = $discount > 0 ? $discount : 0;

    //             $temp['receivable'] = Customerproperty::whereIn('id', $allProperties)->sum('net_pay') - $temp['recovery'];

    //             $temp['overdue'] = CustomerStatement::whereIn('customer_property_id', $allProperties)->where('due_date', '<', Carbon::now())
    //                 ->sum('balance');

    //             $transfer = TransferProperty::whereIn('property_id', $allProperties)->sum('transfer_charges');

    //             $temp['future'] = CustomerStatement::whereIn('customer_property_id', $allProperties)->where('due_date', '>=', Carbon::now())
    //                 ->sum('balance') - $transfer;

    //         }

    //         array_push($floor_data, $temp);
    //     }

    //     ////////////End///////////////////////////////////////////////////////////////////////////////
    //     if (!empty($request->block) && ($request->block == 'summary' || $request->block == 'combined'))
    //     {
    //         $block = $request->block;
    //     }

    //     return view('report.account-statement', compact('properties', 'from_date', 'to_date', 'overDueAmt', 'receivedAmt', 'dueAmt', 'outStandingAmount', 'percent', 'dueMonth', 'period', 'selected_period', 'selected_date_range', 'unit_blocks', 'block', 'filter_type', 'floor_data'));

    // }

    //form to get the date range
    public function getProfitLossStatementForm()
    {

        return view('report.profit-loss-statement-range');
    }

    public function getProfitLossStatement(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'date_range' => 'required'

        ]);

        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();

        //Income
        $data['income'] = $this->getAccountChildsRange('Income', $from, $to, $request->level);

        //Expenses
        $data['expense'] = $this->getAccountChildsRange('Expense', $from, $to, $request->level);

        //CGS
        $data['cgs'] = $this->getAccountChildsRange('Direct Cost', $from, $to, $request->level);

        //range
        $data['from_date'] = $date[0];
        $data['to_date'] = $date[1];

        return view('report.profit-loss-statement', $data);
    }

    public function getAllProfitLossStatement(Request $request)
    {

        $from = date('Y-m-d');

        $from = GeneralJournalEntry::oldest('date')->first();

        if ($from == true) {
            $from = $from->date;
        }

        //Income
        $data['income'] = $this->getAccountChildsRange('Income', $from, date('Y-m-d'));

        //Expenses
        $data['expense'] = $this->getAccountChildsRange('Expense', $from, date('Y-m-d'));

        //CGS
        $data['cgs'] = $this->getAccountChildsRange('Direct Cost', $from, date('Y-m-d'));

        //range
        $data['from_date'] = $from;
        $data['to_date'] = Carbon::today();

        return view('report.profit-loss-statement', $data);
    }

    //form to get the date range
    public function getBalanceSheetForm()
    {

        return view('report.balance-sheet-range');
    }

    public function getBalanceSheet(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'date' => 'required', 'level' => 'required'

        ]);
        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }

        //Get All Current Assets Details
        $data['currentAsset'] = $this->getAccountChilds('Current Asset', $request->date, $request->level);
        $data['bank'] = $this->getAccountChilds('Bank', $request->date, $request->level);
        $data['accountReceivable'] = $this->getAccountChilds('Accounts Receivable', $request->date, $request->level);
        $data['otherCurrentAsset'] = $this->getAccountChilds('Other CurrentAsset', $request->date, $request->level);
        //Get All Fixed Assets Details
        $data['fixedAsset'] = $this->getAccountChilds('Non-Current Asset', $request->date, $request->level);
        // $data['otherAsset'] = $this->getAccountChilds('Other Asset',$request->date);
        //GET ALL Liabilites
        $data['accountPayable'] = $this->getAccountChilds('Accounts Payable', $request->date, $request->level);
        $data['otherCurrentLiability'] = $this->getAccountChilds('Other Current Liability', $request->date, $request->level);

        $data['longTermLiability'] = $this->getAccountChilds('Long Term Liability', $request->date, $request->level);

        //GET All Equites
        $data['equity'] = $this->getAccountChilds('Equity', $request->date, $request->level);

        //GET Net INCOME
        //get total Revenue
        $revenue = $this->getAccountChildSum('Income', $request->date) * -1;

        //get total CGS
        $cgs = $this->getAccountChildSum('Direct Cost', $request->date);

        //get Total Expense
        $expense = $this->getAccountChildSum('Expense', $request->date);

        $data['netIncome'] = $revenue - $cgs - $expense;

        //date
        $data['date'] = $request->date;

        return view('report.balance-sheet', $data);
    }

    //get all the accounts of specific type and their sum
    public function getAccountChilds($accountName, $date, $level = 3)
    {

        if ($level == 1) {

            $accounts = array();
            $result = ChartOfAccount::where([['sub_account_id', null]])->whereHas('type', function ($query) use ($accountName) {
                $query->where('name', $accountName);
            })->get();
            foreach ($result as $r) {

                $subParentIds = ChartOfAccount::where('sub_account_id', $r->id)
                    ->pluck('id');

                $childAccountIds = ChartOfAccount::whereIn('sub_account_id', $subParentIds)->pluck('id');

                if (!$childAccountIds->isEmpty()) $sum = GeneralJournalEntry::where([['is_post', true], ['date', '<=', $date]])->whereIn('account_id', $childAccountIds)->sum('amount');
                else $sum = 0;

                $arr = ['account' => $r, 'sum' => $sum];

                array_push($accounts, $arr);
            }
        } elseif ($level == 2) {

            $accounts = array();
            $parentIds = ChartOfAccount::where([['sub_account_id', null]])->whereHas('type', function ($query) use ($accountName) {
                $query->where('name', $accountName);
            })->pluck('id');

            $result = ChartOfAccount::whereIn('sub_account_id', $parentIds)->get();
            foreach ($result as $r) {

                $id = $r->number;
                $childAccountIds = ChartOfAccount::where('sub_account_id', $r->id)
                    ->pluck('id');

                if (!$childAccountIds->isEmpty()) $sum = GeneralJournalEntry::where([['is_post', true], ['date', '<=', $date]])->whereIn('account_id', $childAccountIds)->sum('amount');
                else $sum = 0;

                $arr = ['account' => $r, 'sum' => $sum];

                array_push($accounts, $arr);
            }
        } else {

            $accounts = array();
            $result = ChartOfAccount::whereHas('type', function ($query) use ($accountName) {
                $query->where('name', $accountName);
            })->get();
            foreach ($result as $r) {
                $sum = GeneralJournalEntry::where([['is_post', true], ['date', '<=', $date], ['account_id', $r
                    ->id]])
                    ->sum('amount');
                $arr = ['account' => $r, 'sum' => $sum];

                array_push($accounts, $arr);
            }
        }

        return $accounts;
    }

    //get all the accounts of specific type and their sum
    public function getAccountChildsRange($accountName, $from, $to, $level = 3)
    {

        if ($level == 1) {

            $accounts = array();
            $result = ChartOfAccount::where([['sub_account_id', null]])->whereHas('type', function ($query) use ($accountName) {
                $query->where('name', $accountName);
            })->get();
            foreach ($result as $r) {

                $subParentIds = ChartOfAccount::where('sub_account_id', $r->id)
                    ->pluck('id');

                $childAccountIds = ChartOfAccount::whereIn('sub_account_id', $subParentIds)->pluck('id');

                if (!$childAccountIds->isEmpty()) $sum = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true]])
                    ->whereIn('account_id', $childAccountIds)->sum('amount');
                else $sum = 0;

                $arr = ['account' => $r, 'sum' => $sum];

                array_push($accounts, $arr);
            }
        } elseif ($level == 2) {

            $accounts = array();
            $parentIds = ChartOfAccount::where([['sub_account_id', null]])->whereHas('type', function ($query) use ($accountName) {
                $query->where('name', $accountName);
            })->pluck('id');

            $result = ChartOfAccount::whereIn('sub_account_id', $parentIds)->get();
            foreach ($result as $r) {

                $id = $r->number;
                $childAccountIds = ChartOfAccount::where('sub_account_id', $r->id)
                    ->pluck('id');

                if (!$childAccountIds->isEmpty()) $sum = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true]])
                    ->whereIn('account_id', $childAccountIds)->sum('amount');
                else $sum = 0;

                $arr = ['account' => $r, 'sum' => $sum];

                array_push($accounts, $arr);
            }
        } else {

            $accounts = array();
            $result = ChartOfAccount::whereHas('type', function ($query) use ($accountName) {
                $query->where('name', $accountName);
            })->get();
            foreach ($result as $r) {
                $sum = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true], ['account_id', $r
                    ->id]])
                    ->sum('amount');
                $arr = ['account' => $r, 'sum' => $sum];

                array_push($accounts, $arr);
            }
        }

        return $accounts;
    }

    //get  the sum of accounts of specific type
    public static function getAccountChildSum($accountName, $date,$ids=null)
    {
        if($ids == null){
            $ids[0] = 'all';
        }
        $sum = 0;
        $result = ChartOfAccount::whereHas('type', function ($query) use ($accountName) {
            $query->where('name', $accountName);
        })->get();
        foreach ($result as $r) {
            $result = GeneralJournalEntry::where([['is_post', true], ['date', '<=', $date], ['account_id', $r
                ->id]])
                ->when($ids[0] !== 'all', function ($query) use ($ids) {
                    $query->whereIn('multi_project_id', $ids);
                                    })
                ->sum('amount');
            $sum += $result;
        }

        return $sum;
    }

    //get  the sum of accounts of specific type Date Range
    public function getAccountChildSumDateRange($accountName, $from, $to)
    {

        $sum = 0;
        $result = ChartOfAccount::whereHas('type', function ($query) use ($accountName) {
            $query->where('name', $accountName);
        })->get();
        foreach ($result as $r) {
            $result = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['account_id', $r->id], ['is_post', true]])
                ->sum('amount');
            $sum += $result;
        }

        return $sum;
    }

    //form to get the date range
    public function getSoldInventoryForm()
    {

        return view('report.sold-inventory-range');
    }

    public function getSoldInventory(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'date_range' => 'required'

        ]);

        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }

        $block = 0;

        $filter_type = 'all';

        if (!empty($request->block)) {
            $block = $request->block;
            $filter_type = 'filter';
        }

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();

        $inventories = Inventory::where('status', Inventory::sold)->whereHas('customer_property', function ($query) use ($from, $to) {
            $query->whereBetween('booking_date', [$from, $to]);
        })->with('customer_property', 'floor', 'size', 'categories')
            ->orderBy('unit_number', 'ASC')
            ->get();

        $totalAmt = 0;
        $receivedAmt = 0;

        foreach ($inventories as $i) {

            if (($filter_type == 'filter' && $block > 0 && $block == $i
                ->floor
                ->unitBlock
                ->id) || $filter_type == 'all') {

                $property = CustomerProperty::where('inventory_id', $i->id)
                    ->where('is_deleted', false)
                    ->where('status', '!=', CustomerProperty::cancel)
                    ->first();

                $totalAmt += CustomerProperty::where('inventory_id', $i->id)
                    ->sum('net_pay');

                $receivedAmt += Receipt::where('customer_property_id', $property->id)

                    ->whereBetween('receipt_date', [$from, $to])
                    ->where('is_approved', 1)
                    ->where('is_deleted', false)
                    ->sum('amount');
            }
        }

        $due = json_decode(json_encode($inventories), true);

        usort($due, function ($item1, $item2) {
            return preg_replace("/[^0-9.]/", "", $item1['unit_number']) <=> preg_replace("/[^0-9.]/", "", $item2['unit_number']);
        });
        $due = json_decode(json_encode($due));
        $inventories = $due;
        // echo '<pre>';
        // print_r($data['due']);
        // die;
        //range
        $from_date = $date[0];
        $to_date = $date[1];

        $unit_blocks = UnitBlock::orderBy('name', 'ASC')->get();
        $selected_date_range = $request->date_range;
        $type = 'with_filter';

        return view('report.sold-inventory', compact('inventories', 'from_date', 'to_date', 'totalAmt', 'receivedAmt', 'filter_type', 'block', 'unit_blocks', 'selected_date_range', 'type'));
    }

    public function getAllSoldInventory(Request $request)
    {

        $inventories = Inventory::where('status', Inventory::sold)->whereHas('property', function ($query) {
            $query->where('booking_date', '<=', Carbon::today());
        })
            ->with('property')
            ->get();
        $totalAmt = 0;
        $receivedAmt = 0;
        foreach ($inventories as $i) {
            $property = CustomerProperty::where('inventory_id', $i->id)
                ->where('is_deleted', false)
                ->where('status', '!=', CustomerProperty::cancel)
                ->first();
            $totalAmt += CustomerProperty::where('inventory_id', $i->id)
                ->sum('net_pay');
            if ($property) {
                $receivedAmt += Receipt::where('customer_property_id', $property->id)
                    ->where('is_approved', 1)
                    ->where('is_deleted', false)
                    ->sum('amount');
            }
        }
        //range
        $from_date = 'Starting';
        $to_date = Carbon::today();
        $type = 'default';
        $block = 0;
        $filter_type = 'all';
         
        return view('report.sold-inventory', compact('inventories', 'from_date', 'to_date', 'totalAmt', 'receivedAmt', 'type', 'block', 'filter_type'));
    }

    //form to get the date range
    public function getReceivedAmountForm()
    {

        return view('report.received-amount-range');
    }

    public function getReceivedAmount(Request $request)
    {

        $validator = Validator::make($request->all(), ['date_range' => 'required']);

        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }

        $block = 0;
        $filter_type = 'all';

        if (!empty($request->block)) {
            $block = $request->block;
            $filter_type = 'filter';
        }

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();

        $receipts = Receipt::whereBetween('receipt_date', [$from, $to])->where('is_approved', 1)
            ->where('is_deleted', false)->whereHas('property', function ($query) {

                $query->where('status', '!=', CustomerProperty::cancel);
            })
            ->with('property', 'customer')
            ->get();

        //range
        $from_date = $date[0];
        $to_date = $date[1];

        $unit_blocks = UnitBlock::orderBy('name', 'ASC')->get();

        $selected_date_range = $request->date_range;

        $type = null;

        return view('report.received-amount', compact('receipts', 'from_date', 'to_date', 'block', 'filter_type', 'unit_blocks', 'selected_date_range', 'type'));
    }

    //form to get the date range
    public function getMonthWiseRecoveryForm()
    {
        return view('report.monthly-recovery-range');
    }

    public function getMonthWiseRecoveryStatement(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'date_range' => 'required',

        ]);

        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();

        $properties = CustomerProperty::where([['status', '!=', CustomerProperty::cancel], ['is_deleted', false]])->with('inventory', 'customer', 'size')
            ->get();

        $receivedAmt = array();

        foreach ($properties as $statement) {
            $receivedAmt[$statement
                ->id] = Receipt::where('is_deleted', false)
                ->whereIn('customer_property_id', [$statement
                    ->id])
                ->where('is_approved', 1)
                ->sum('amount');
        }

        //range
        $from_date = $date[0];
        $to_date = $date[1];

        $start = new DateTime($from_date);
        $start->modify('first day of this month');
        $end = new DateTime($to_date);
        $end->modify('first day of next month');
        $interval = DateInterval::createFromDateString('1 month');
        $period = new DatePeriod($start, $interval, $end);

        return view('report.monthly-recovery', compact('properties', 'from_date', 'to_date', 'receivedAmt', 'period'));
    }

    public function getAllReceivedAmount(Request $request)
    {

        $cancel_properties = CustomerProperty::where('status', CustomerProperty::cancel)->pluck('id');

        $receipts = Receipt::where('receipt_date', '<=', Carbon::today())->whereNotIn('customer_property_id', $cancel_properties)->where('is_approved', 1)
            ->where('is_deleted', false)
            ->with('property', 'customer')
            ->get();

        $block = 0;
        $filter_type = 'all';
        //range
        $from_date = Carbon::today();
        $to_date = Carbon::today();

        $type = 'all';

        return view('report.received-amount', compact('receipts', 'from_date', 'to_date', 'block', 'filter_type', 'type'));
    }

    //form to get the date range
    public function getCommissionAmountForm()
    {

        return view('report.commission-amount-range');
    }

    public function getCommissionAmount(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'date_range' => 'required'

        ]);

        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }

        $block = 0;
        $filter_type = 'all';

        if (!empty($request->block)) {
            $block = $request->block;
            $filter_type = 'filter';
        }
        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();
        $transactions = DealerTransaction::whereBetween('created_at', [$from, $to])->with('property', 'dealer')
            ->get();
        $paid_amount = 0;
        foreach ($transactions as $t) {
            $paid_amount += DealerPaidRebate::where('property_id', $t->product_id)
                ->sum('amount');
        }
        //range
        $from_date = $date[0];
        $to_date = $date[1];
        $unit_blocks = UnitBlock::orderBy('name', 'ASC')->get();
        $selected_date_range = $request->date_range;
        return view('report.commission-amount', compact('transactions', 'from_date', 'to_date', 'paid_amount', 'selected_date_range', 'unit_blocks', 'block', 'filter_type'));
    }

    //form to get the date range
    public function getPaidRebateForm()
    {
        return view('report.paid-rebate-range');
    }

    public function getPaidRebate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'date_range' => 'required'

        ]);
        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }
        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();
        $rebates = DealerPaidRebate::whereBetween('date', [$from, $to])->with('dealer', 'property')
            ->get();
        //range
        $from_date = $date[0];
        $to_date = $date[1];
        return view('report.paid-rebate', compact('rebates', 'from_date', 'to_date'));
    }

    public function generateAgingReport(Request $request)
    {

        $data['allDueStatements'] = CustomerProperty::whereHas('statement', function ($query) {
            $query->where('due_date', '<=', Carbon::today());
            $query->where('balance', '>', 0);
        })
            ->where('status', '!=', CustomerProperty::cancel)
            ->get();

        $block = 0;
        $filter_type = 'all';

        if (!empty($request->block)) {
            $block = $request->block;
            $filter_type = 'filter';
        }

        $first_tenure = array(); // 1-30 dys
        $second_tenure = array(); // 31-60 days
        $third_tenure = array(); // 61-90 days
        $fourth_tenure = array(); // +91 days
        foreach ($data['allDueStatements'] as $statement) {
            $first_tenure[$statement
                ->id] = CustomerStatement::where([['customer_property_id', $statement->id], ['balance', '>', 0]])
                ->whereBetween('due_date', [Carbon::today()
                    ->subDay(30), Carbon::today()])
                ->sum('balance');

            $second_tenure[$statement
                ->id] = CustomerStatement::whereBetween('due_date', [Carbon::today()
                ->subDay(60), Carbon::today()
                ->subDay(31)])
                ->where([['customer_property_id', $statement->id], ['balance', '>', 0]])
                ->sum('balance');

            $third_tenure[$statement
                ->id] = CustomerStatement::where([['customer_property_id', $statement->id], ['balance', '>', 0]])
                ->whereBetween('due_date', [Carbon::today()
                    ->subDay(90), Carbon::today()
                    ->subDay(61)])
                ->sum('balance');

            $fourth_tenure[$statement
                ->id] = CustomerStatement::where([['customer_property_id', $statement->id], ['balance', '>', 0], ['due_date', '<', Carbon::today()
                ->subDay(91)]])
                ->sum('balance');
        }

        $data['first_tenure'] = $first_tenure;
        $data['second_tenure'] = $second_tenure;
        $data['third_tenure'] = $third_tenure;
        $data['fourth_tenure'] = $fourth_tenure;
        $data['unit_blocks'] = UnitBlock::orderBy('name', 'ASC')->get();
        $data['block'] = $block;
        $data['filter_type'] = $filter_type;
        return view('report.aging', $data);
    }

    //form to get the date range
    public function getVendorExpenseForm()
    {

        $data['vendors'] = ControlAccount::where([['type', ControlAccount::VENDOR]])->get();
        $data['categories'] = ChartOfAccount::where([['account_type_id', 2]])->get();
        $data['accounts'] = ChartOfAccount::where([['account_type_id', 4]])->get();
        return view('report.vendor-expense-range', $data);
    }

    public function getVendorExpense(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'date_range' => 'required'

        ]);
        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }
        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();
        $filters = array();
        if ($request->vendor != 0) $filters['vendor'] = $request->vendor;
        if ($request->category != 0) $filters['category'] = $request->category;
        if ($request->account != 0) $filters['account'] = $request->account;
        //range
        $from_date = $date[0];
        $to_date = $date[1];

        return view('report.vendor-expense', compact('payments', 'from_date', 'to_date', 'complete_report'));
    }

    public function chatHistoryForm(Request $request)
    {
        $data = array();
        $data['property'] = CustomerProperty::with('chatHistory')->where('id', $request->property_id)
            ->first();
        return view('report.chat-history-modal', $data);
    }

    public function updateChatHistory(Request $request)
    {

        PropertyChatHistory::create(['remarks' => $request->remarks, 'property_id' => $request->property_id, 'next_follow_up' => $request->next_follow_up, 'user_id' => Auth::user()->id]);

        activity('Chat History')
            ->log('Chat history  added ' . $request->property);
    }

    public function getTrialBalanceForm()
    {

        return view('report.trial-balance-range');
    }

    public function getTrialBalanceReport(Request $request)
    {

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();

        $accountRecord = array();
        $openingBalance = array();
        $totalDebit = array();
        $totalCredit = array();
        $subChild = array();
        $child = array();
        $accountBalance = array();
        $subAccountBalance = array();
        $childAccountBalance = array();
 
        if ($request->level == 0 || $request->level == 4) {

            $data['accounts'] = ChartOfAccount::where([['sub_account_id', null]])

                ->select('id', 'name', 'number', 'sub_account_id')
                ->orderBy('number', 'ASC')
                ->get();

            $subChild = array();
            $child = array();

            foreach ($data['accounts'] as $sA) {

                $subChild[$sA->id] = ChartOfAccount::where('sub_account_id', $sA->id)
                    ->select('id', 'name', 'number', 'sub_account_id')
                    ->orderBy('number', 'ASC')
                    ->get();

                $accountBalance[$sA->id] = false;

                foreach ($subChild[$sA->id] as $sC) {

                    $child[$sC->id] = ChartofAccount::where('sub_account_id', $sC->id)
                        ->select('id', 'name', 'number', 'sub_account_id')
                        ->orderBy('number', 'ASC')
                        ->get();

                    $subAccountBalance[$sC->id] = false;

                    foreach ($child[$sC->id] as $c) {

                        $childAccountBalance[$c->id] = false;

                        $accountRecord[$c->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true]])
                            ->where('account_id', $c->id)
                            ->sum('amount');

                        $openingBalance[$c->id] = GeneralJournalEntry::whereDate('date', '<', $from)->where([['is_post', true]])
                            ->where('account_id', $c->id)
                            ->sum('amount');

                        $totalDebit[$c->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true], ['amount', '>', 0]])
                            ->where('account_id', $c->id)
                            ->sum('amount');

                        $totalCredit[$c->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true], ['amount', '<', 0]])
                            ->where('account_id', $c->id)
                            ->sum('amount');

                        if ($totalCredit[$c->id] != 0 || $totalDebit[$c->id] || $openingBalance[$c->id]) {
                            $accountBalance[$sA->id] = true;
                            $subAccountBalance[$sC->id] = true;
                            $childAccountBalance[$c->id] = true;
                        }
                    }
                }
            }
        } elseif ($request->level == 1) {

            $accounts = array();
            $data['accounts'] = ChartOfAccount::where([['sub_account_id', null]])->orderBy('number', 'ASC')
                ->get();
 
             
            foreach ($data['accounts'] as $r) {

                $subParentIds = ChartOfAccount::where('sub_account_id', $r->id)
                    ->pluck('id');

                $childAccountIds = ChartOfAccount::whereIn('sub_account_id', $subParentIds)->pluck('id');

                $accountRecord[$r
                    ->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true]])
                    ->whereIn('account_id', $childAccountIds)->sum('amount');
                $openingBalance[$r
                    ->id] = GeneralJournalEntry::where('date', '<', $from)->where([['is_post', true]])
                    ->whereIn('account_id', $childAccountIds)->sum('amount');

                $totalDebit[$r
                    ->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true], ['amount', '>', 0]])
                    ->whereIn('account_id', $childAccountIds)->sum('amount');
                $totalCredit[$r
                    ->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true], ['amount', '<', 0]])
                    ->whereIn('account_id', $childAccountIds)->sum('amount');
            }
        } elseif ($request->level == 2) {

            $accounts = array();
            $parentIds = ChartOfAccount::where([['sub_account_id', null]])->pluck('id');

            $data['accounts'] = ChartOfAccount::whereIn('sub_account_id', $parentIds)->orderBy('number', 'ASC')
                ->get();
            foreach ($data['accounts'] as $r) {

                $id = $r->number;
                $childAccountIds = ChartOfAccount::where('sub_account_id', $r->id)
                    ->pluck('id');

                $accountRecord[$r
                    ->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true]])
                    ->whereIn('account_id', $childAccountIds)->sum('amount');
                $openingBalance[$r
                    ->id] = GeneralJournalEntry::where('date', '<', $from)->where([['is_post', true]])
                    ->whereIn('account_id', $childAccountIds)->sum('amount');

                $totalDebit[$r
                    ->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true], ['amount', '>', 0]])
                    ->whereIn('account_id', $childAccountIds)->sum('amount');
                $totalCredit[$r
                    ->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true], ['amount', '<', 0]])
                    ->whereIn('account_id', $childAccountIds)->sum('amount');
            }
        } else {

            $accounts = array();
            $data['accounts'] = ChartOfAccount::orderBy('number', 'ASC')->get();
            foreach ($data['accounts'] as $r) {
                $accountRecord[$r
                    ->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true], ['account_id', $r
                    ->id]])
                    ->sum('amount');
                $openingBalance[$r
                    ->id] = GeneralJournalEntry::where('date', '<', $from)->where([['is_post', true]])
                    ->where('account_id', $r->id)
                    ->sum('amount');

                $totalDebit[$r
                    ->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true], ['amount', '>', 0]])
                    ->where('account_id', $r->id)
                    ->sum('amount');
                $totalCredit[$r
                    ->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['is_post', true], ['amount', '<', 0]])
                    ->where('account_id', $r->id)
                    ->sum('amount');
            }
        }

        $data['accountRecord'] = $accountRecord;
        $data['openingBalance'] = $openingBalance;
        $data['totalDebit'] = $totalDebit;
        $data['totalCredit'] = $totalCredit;
        $data['subChild'] = $subChild;
        $data['child'] = $child;
        $data['level'] = $request->level;
        $data['accountBalance'] = $accountBalance;
        $data['subAccountBalance'] = $subAccountBalance;
        $data['childBalance'] = $childAccountBalance;

        $data['to'] = $to;
        $data['from'] = $from;

        /*echo "<pre>";
        print_r($data);
        exit;*/

    
        return view('report.trial-balance', $data);
    }

    public function updateTrialBalanceReport(Request $request)
    {

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();

        $data['accounts'] = ChartOfAccount::orderBy('number', 'ASC')->get();

        $accountRecord = array();

        foreach ($data['accounts'] as $acc) {
            $accountRecord[$acc
                ->id] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['account_id', $acc->id], ['is_post', true]])
                ->sum('amount');
        }

        $data['accountRecord'] = $accountRecord;

        $data['to'] = $to;

        return view('report.update-trial-balance', $data);
    }

    public function getTrialBalanceDetailReport($accountId)
    {

        $parentIds = ChartOfAccount::where('id', $accountId)->pluck('id');

        $subParentIds = ChartOfAccount::whereIn('sub_account_id', $parentIds)->pluck('id');

        $childIds = ChartOfAccount::whereIn('sub_account_id', $subParentIds)->pluck('id');

        if (!$childIds->isEmpty()) $data['transactions'] = GeneralJournalEntry::where([['is_post', true]])->whereHas('account', function ($query) use ($childIds, $accountId) {
            $query->whereIn('account_id', [$childIds]);
            $query->orwhere('account_id', $accountId);
        })->get();
        else $data['transactions'] = GeneralJournalEntry::where([['is_post', true], ['account_id', $accountId]])->get();

        $data['account'] = ChartOfAccount::find($accountId);

        $data['pre_balance'] = 0;

        return view('report.trial-balance-detail', $data);
    }

    public function updateTrialBalanceDetailReport(Request $request)
    {

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();

        $accountId = $request->account_id;

        $data['transactions'] = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['account_id', $accountId], ['is_post', true]])->get();

        $entryNos = GeneralJournalEntry::whereBetween('date', [$from, $to])->where([['account_id', $accountId], ['is_post', true]])->pluck('entry_no');

        $entryData = array();
        foreach ($entryNos as $entry) {
            $entryData[$entry] = GeneralJournalEntry::where([['is_post', true], ['entry_no', $entry], ['account_id', '!=', $accountId]])->get();
        }
        $data['accountHit'] = $entryData;

        $data['account'] = ChartOfAccount::find($accountId);

        $data['pre_balance'] = GeneralJournalEntry::where([['account_id', $accountId], ['is_post', true]])->where('date', '<', $from)->sum('amount');

        $data['to'] = $to;

        return view('report.update-trial-balance-detail', $data);
    }

    public function getCashFlowStatementForm()
    {

        return view('report.cash-flow-statement-range');
    }

    public function getCashFlowStatementReport(Request $request)
    {

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();

        //Get the operating Activities
        //Get the operating Activities
        //GET Net INCOME
        $data['netIncome'] = ($this->getAccountChildSumDateRange('Income', $from, $to) * -1) - $this->getAccountChildSumDateRange('Direct Cost', $from, $to) - $this->getAccountChildSumDateRange('Expense', $from, $to);

        $data['accountPayable'] = $this->getAccountChildsRange('Accounts Payable', $from, $to);

        $data['accountReceivable'] = $this->getAccountChildsRange('Accounts Receivable', $from, $to);
        $data['otherCurrentAsset'] = $this->getAccountChildsRange('Other CurrentAsset', $from, $to);

        $data['otherCurrentLiability'] = $this->getAccountChildsRange('Other Current Liability', $from, $to);

        //Get the investing Activites
        $data['fixedAsset'] = $this->getAccountChildsRange('Non-Current Asset', $from, $to);
        $data['otherAsset'] = $this->getAccountChildsRange('Other Asset', $from, $to);

        //GET ALL Financial Activities
        $data['equity'] = $this->getAccountChildsRange('Equity', $from, $to);
        $data['longTermLiability'] = $this->getAccountChildsRange('Long Term Liability', $from, $to);

        $data['to'] = $to;
        $data['from'] = $from;

        return view('report.cash-flow-statement', $data);
    }

    public function updateCashFlowStatementReport(Request $request)
    {

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();

        //Get the operating Activities
        //GET Net INCOME
        $data['netIncome'] = ($this->getAccountChildSumDateRange('Income', $from, $to) * -1) - $this->getAccountChildSumDateRange('Direct Cost', $from, $to) - $this->getAccountChildSumDateRange('Expense', $from, $to);

        $data['accountPayable'] = $this->getAccountChildsRange('Accounts Payable', $from, $to, $request->level);

        $data['accountReceivable'] = $this->getAccountChildsRange('Accounts Receivable', $from, $to, $request->level);
        $data['otherCurrentAsset'] = $this->getAccountChildsRange('Other CurrentAsset', $from, $to, $request->level);

        $data['otherCurrentLiability'] = $this->getAccountChildsRange('Other Current Liability', $from, $to, $request->level);

        //Get the investing Activites
        $data['fixedAsset'] = $this->getAccountChildsRange('Non-Current Asset', $from, $to, $request->level);

        //GET ALL Financial Activities
        $data['equity'] = $this->getAccountChildsRange('Equity', $from, $to, $request->level);
        $data['longTermLiability'] = $this->getAccountChildsRange('Long Term Liability', $from, $to, $request->level);

        $data['to'] = $to;
        $data['from'] = $from;

        return view('report.update-cash-flow-statement', $data);
    }

    public function getItemInOutReport()
    {

        $data['items'] = Item::get();

        $in = array();
        $out = array();
        $remaining = array();
        $result = ItemRelease::where('releasing_date', Carbon::today())->get();

        foreach ($data['items'] as $item) {

            $receipts = PurchaseOrderReceipt::where('receipt_date', Carbon::today())->pluck('id');

            $in[$item
                ->id] = ReceiptItem::whereIn('purchase_order_receipt_id', $receipts)->where('item_id', $item->id)
                ->sum('quantity');

            $out[$item->id] = 0;

            foreach ($result as $r) {
                $out[$item
                    ->id] = ItemReleaseData::where([['item_releasing_id', $r->id], ['item_id', $item
                    ->id]])
                    ->sum('item_quantity');
            }

            $remaining[$item
                ->id] = Item::find($item->id)->quantity;
        }

        $data['in'] = $in;
        $data['out'] = $out;
        $data['remaining'] = $remaining;

        $data['to_date'] = date('d-m-Y');
        $data['from_date'] = date('d-m-Y');

        return view('report/item-in-out', $data);
    }

    public function updateItemInOutReport(Request $request)
    {

        if ($request->item_list) $data['items'] = Item::whereIn('id', $request->item_list)
            ->get();
        else $data['items'] = Item::get();

        $in = array();
        $out = array();
        $remaining = array();

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();
        $result = ItemRelease::whereBetween('releasing_date', [$from, $to])->get();

        $item_array = array();

        foreach ($data['items'] as $item) {
            $receipts = PurchaseOrderReceipt::whereBetween('receipt_date', [$from, $to])->pluck('id');

            $in_item = ReceiptItem::whereIn('purchase_order_receipt_id', $receipts)->where('item_id', $item->id)
                ->sum('quantity');

            $outArray = array();

            foreach ($result as $r) {
                $outArray[] = array(
                    'item_id' => $item->id,
                    'quantity' => ItemReleaseData::where([['item_releasing_id', $r->id], ['item_id', $item
                        ->id]])
                        ->sum('item_quantity')
                );
            }

            $sumOfItemOutQuantity = array_reduce($outArray, function ($a, $b) {
                isset($a[$b['item_id']]) ? $a[$b['item_id']]['quantity'] += $b['quantity'] : $a[$b['item_id']] = $b;
                return $a;
            });

            $out_item = $sumOfItemOutQuantity[$item->id]['quantity'];

            $remaining_item = Item::find($item->id)->quantity;

            if ($out_item > 0 || $in_item > 0) {
                $out[$item->id] = $out_item > 0 ? $out_item : 0;

                $in[$item->id] = $in_item > 0 ? $in_item : 0;

                $item_array[] = $item;

                $remaining[$item->id] = $remaining_item > 0 ? $remaining_item : 0;
            }
        }

        $data['items'] = $item_array;
        $data['in'] = $in;
        $data['out'] = $out;
        $data['remaining'] = $remaining;

        if (!empty($from) && !empty($to)) {
            $data['to_date'] = $to;
            $data['from_date'] = $from;
        } else {
            $data['to_date'] = date('d-m-Y');
            $data['from_date'] = date('d-m-Y');
        }

        return view('report/update-item-in-out', $data);
    }

    public function getInventoryReport()
    {

        $data['items'] = Item::get();

        $in = array();
        $out = array();
        $remaining = array();
        $result = ItemRelease::where('releasing_date', Carbon::today())->get();

        foreach ($data['items'] as $item) {
            $receipts = PurchaseOrderReceipt::where('receipt_date', Carbon::today())->pluck('id');

            $in[$item
                ->id] = ReceiptItem::whereIn('purchase_order_receipt_id', $receipts)->where('item_id', $item->id)
                ->sum('quantity');

            $out[$item->id] = 0;

            foreach ($result as $r) {
                $out[$item
                    ->id] = ItemReleaseData::where([['item_releasing_id', $r->id], ['item_id', $item
                    ->id]])
                    ->sum('item_quantity');
            }

            $remaining[$item
                ->id] = Item::find($item->id)->quantity;
        }

        $data['in'] = $in;
        $data['out'] = $out;
        $data['remaining'] = $remaining;

        $data['to_date'] = date('d-m-Y');
        $data['from_date'] = date('d-m-Y');

        return view('report/inventory', $data);
    }

    public function updateInventoryReport(Request $request)
    {

        if ($request->item_list) $data['items'] = Item::whereIn('id', $request->item_list)
            ->get();
        else $data['items'] = Item::get();

        $in = array();
        $out = array();
        $remaining = array();

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();
        $result = ItemRelease::whereBetween('releasing_date', [$from, $to])->get();

        $item_array = array();

        foreach ($data['items'] as $item) {
            $receipts = PurchaseOrderReceipt::whereBetween('receipt_date', [$from, $to])->pluck('id');

            $in_item = ReceiptItem::whereIn('purchase_order_receipt_id', $receipts)->where('item_id', $item->id)
                ->sum('quantity');

            $outArray = array();

            foreach ($result as $r) {
                $outArray[] = array(
                    'item_id' => $item->id,
                    'quantity' => ItemReleaseData::where([['item_releasing_id', $r->id], ['item_id', $item
                        ->id]])
                        ->sum('item_quantity')
                );
            }

            $sumOfItemOutQuantity = array_reduce($outArray, function ($a, $b) {
                isset($a[$b['item_id']]) ? $a[$b['item_id']]['quantity'] += $b['quantity'] : $a[$b['item_id']] = $b;
                return $a;
            });

            $out_item = $sumOfItemOutQuantity[$item->id]['quantity'];

            $remaining_item = Item::find($item->id)->quantity;

            if ($out_item > 0 || $in_item > 0) {
                $out[$item->id] = $out_item > 0 ? $out_item : 0;

                $in[$item->id] = $in_item > 0 ? $in_item : 0;

                $item_array[] = $item;

                $remaining[$item->id] = $remaining_item > 0 ? $remaining_item : 0;
            }
        }

        $data['items'] = $item_array;
        $data['in'] = $in;
        $data['out'] = $out;
        $data['remaining'] = $remaining;

        if (!empty($from) && !empty($to)) {
            $data['to_date'] = $to;
            $data['from_date'] = $from;
        } else {
            $data['to_date'] = date('d-m-Y');
            $data['from_date'] = date('d-m-Y');
        }

        return view('report/update-inventory', $data);
    }

    public function getItemValuationReport()
    {

        $data['items'] = Item::get();

        $lastPrice = array();
        $remaining = array();

        foreach ($data['items'] as $item) {

            $price = 0;

            $item_purchase_order = ItemPurchaseOrder::where('item_id', $item->id)
                ->orderBy('created_at', 'DESC')
                ->first();
            if ($item_purchase_order == true) {
                $price = $item_purchase_order->price;
            }

            $lastPrice[$item->id] = $price;

            $remaining[$item
                ->id] = ReceiptItem::where('item_id', $item->id)
                ->sum('quantity') - ItemReleaseData::where([['item_id', $item
                    ->id]])
                ->sum('item_quantity');;
        }

        $data['lastPrice'] = $lastPrice;
        $data['remaining'] = $remaining;

        return view('report/item-valuation', $data);
    }

    public function getGeneralLedgerForm()
    {

        return view('report.general-ledger-range');
    }

    public function getGeneralLedger(Request $request)
    {

        $validator = Validator::make($request->all(), ['date_range' => 'required']);

        if ($validator->fails()) {
            return redirect()
                ->back()
                ->withErrors($validator)->withInput();
        }

        $date = explode('-', $request->date_range);
        $from = Carbon::parse($date[0])->startOfDay();
        $to = Carbon::parse($date[1])->endOfDay();

        $accounts = ChartOfAccount::orderBy('number', 'asc')->get();

        $info = array();
        $ledger = array();
        $formated_to = date('Y-m-d', strtotime($to));
        foreach ($accounts as $acc) {

            $info['info'] = $acc;

            $info['transactions'] = GeneralJournalEntry::whereBetween('date', [$from, $to])
                ->where([
                    ['account_id', $acc->id],
                    ['is_post', true]
                ])
                ->get();

            $info['openingBalance'] = GeneralJournalEntry::where([
                ['account_id', $acc->id],
                ['is_post', true]
            ])
                ->where('date', '<', $from)
                ->sum('amount');

            $info['leafAccount'] = ChartOfAccount::where('sub_account_id', $acc->id)->count() == 0 ? true : false;

            $id = $acc->number;

            // $info['sum'] = GeneralJournalEntry::where('is_post',true)->whereHas('account',function($query) use($id) {
            //     $query->where('sub_account_id',$id);
            // })->sum('amount');

            // $info['sum'] = GeneralJournalEntry::where('is_post', true)
            //     ->whereHas('account', function ($query) use ($id) {
            //         $query->where('number', 'LIKE', '%' . $id . '%');
            //     })->sum('amount');

            // $ledger[$acc->id] = $info;
            $array = explode('-', $id);
            if (sizeof($array) > 2) {
                $info['sum'] = GeneralJournalEntry::where('is_post', true)->whereHas('account', function ($query) use ($id) {
                    $query->where('number', 'LIKE',  '%' . $id . '%');
                })->where('date', '<=',  $formated_to)->sum('amount');
                $ledger[$acc->id] = $info;
            } else {
                $info['sum'] = GeneralJournalEntry::where('is_post', true)->whereHas('account', function ($query) use ($array) {
                    $query->where('number', 'LIKE',  $array[0] . '-%');
                })->where('date', '<=',  $formated_to)->sum('amount');
                $ledger[$acc->id] = $info;
            }
        }

        $data['ledger'] = $ledger;

        $data['to'] = $to;
        $data['from'] = $from;

        /*echo "<pre>";
        print_r($data);
        exit;*/

        return view('report.general-ledger', $data);
    }
}
