<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\PurchaseRequest;
use App\ItemVendor;
use App\RequestForQuotation;
use App\Item;
use Illuminate\Support\Facades\Crypt;
use App\Mail\RequestForQuotationMail;
use Mail;
use DB;
use App\PurchaseRequestVendor;
use App\Project;
use App\ComparativeStatement;
use App\ComparativeStatementDocument;
class RequestForQuotationController extends Controller
{

     public function __construct()
    {
               
    }

    function index()
    {

    $purchase_requests = PurchaseRequest::orderBy('id', 'DESC')
    ->where('status' ,'>', 3)->get();
    // dd($purchase_requests);
    return view('procurement/request-for-quotation.purchase-request-rfq' ,compact('purchase_requests') );
    }

    function getVendorForRfq(Request $request)
    {
    $pr_id = $request->pr_id;

    $vendors = array();

    $vendor_lists =  RequestForQuotation::getVendorIds($pr_id );

    foreach (array_unique($vendor_lists) as $key => $value) 
    {
        $vendor = PurchaseRequestVendor::find($value);
        if($vendor == true)
        {
            $vendors[] = $vendor;
        }
    }

    if(!empty($vendors))
    {
        echo json_encode(array('response' => 'yes' , 'vendor_keys' => $vendor_lists , 'vendor' => $vendors));
        exit;
    }

    echo json_encode(array('response' => 'no_vendor_assign'));

    }

     function sendRfq(Request $request)
    {

      $pr_id = $request->purchase_request_id;
      $quatation_date = $request->quatation_date;
      $message = $request->message;
      $project_name = $request->project_name;
      $vendors = $request->vendors;
      
      $validator = Validator::make($request->all(), [
                    'quatation_date' => 'required',
                    'purchase_request_id' => 'required|integer',       
         ]);

        if ($validator->fails())
        {
            return response()->json($validator->messages(), 200);
        }

        if(empty($vendors) || in_array('0', $vendors) || in_array('', $vendors))
        {
            echo  json_encode(array('empty' => 'vendor' ));
            exit;
        }

         DB::beginTransaction();

       try {

           PurchaseRequest::where('id', '=', $pr_id)->update([
            'status' => 4,
            'quotation_valid_date' => $quatation_date,
            'quotation_created_date' => date('Y-m-d'),
            'note' => $message,
            'rfq_vendors' => json_encode($vendors)
          ]);

           for ($i=0; $i < sizeof($vendors); $i++)
       {
            $vendor = PurchaseRequestVendor::find($vendors[$i]);
            if($vendor == true)
            {
                $vendor_data = array('name' =>  $vendor->name , 'link' => url('request-for-quotations/rfq?vendor='.Crypt::encryptString($vendor->id).'&purchase_request='.Crypt::encryptString($pr_id).'')  , 'project_name' => $project_name);
               // Mail::to($vendor->email)->send(new RequestForQuotationMail($vendor_data));
            }
       }

          DB::commit();
          echo  json_encode(array('response' => 'send'));
      
      } 
        
        catch (\Exception $e) 
      {
        DB::rollback();
  
      }
       
    }



    public function view( $pr_id)
    {
       if (is_numeric($pr_id)) 
       {
           $purchase_request = PurchaseRequest::where('id', $pr_id)->first();
           $vendors = PurchaseRequestVendor::whereIn('id' , json_decode($purchase_request->rfq_vendors))->get();
          
           return view('procurement/request-for-quotation.view' , compact('vendors' , 'pr_id' , 'purchase_request') );
       }
    }

    function all( Request $request)
    {
         $status = $request->input('status');

        if (!empty($status) && ( $status == 'rfq-sent' || $status == 'cs-pending' || $status == 'cs-receive'))
        {
            $purchase_request_rfq = PurchaseRequest::select('rfq_vendors','id' , 'status')
            ->whereIn('status' , [4 , 5])
            ->where('department_id' , $request->input('department'))
            ->get();

            return view('procurement/request-for-quotation.all' , compact('purchase_request_rfq' , 'status') );
        }
        else
        {
            return redirect()->back();
        }

    }

    public function changeDate( Request $request)
    {
       $pr_id = $request->pr_id;
        $quotation_valid_date = $request->quotation_valid_date;


       $validator = Validator::make($request->all(), [
                    'quotation_valid_date' => 'required',       
         ]);

       if ($validator->fails())
        {
            return response()->json($validator->messages(), 200);
        }

          DB::beginTransaction();

       try {

           PurchaseRequest::where('id', '=', $pr_id)->update([
            'quotation_valid_date' => $quotation_valid_date,
          ]);

          DB::commit();
          echo  json_encode(array('response' => 'save' , 'date' => date('d-F-Y' , strtotime($quotation_valid_date))));
      } 

       catch (\Exception $e) 
      {
        DB::rollback();

      }


    }


     public function detail( Request $request)
    {
     
       $vendor_id = Crypt::decryptString($request->input('vendor'));
        $purchase_request_id = Crypt::decryptString($request->input('purchase_request'));

        $purchase_request = PurchaseRequest::where('id', $purchase_request_id)
        ->first();
        $rfq_items = ItemVendor::getVendorItems( $vendor_id , $purchase_request_id);
        $project = Project::withTrashed()->find($purchase_request->project_id);

        $total_cs = ComparativeStatement::countCs($purchase_request_id , $vendor_id );


        $docs =  ComparativeStatementDocument::where([['pr_id' , $purchase_request_id] , ['vendor_id' , $vendor_id]])->get();

        return view('procurement/request-for-quotation.index' , compact('purchase_request' , 'rfq_items' , 'vendor_id' , 'project' , 'total_cs' , 'docs') );
    }

    function deleteCsDocument($id=null)
    {
        ComparativeStatementDocument::where('id' , $id)->delete();
         return redirect()->back()->with('success' , ' Removed Successfully!');
    }


}
