<?php

namespace App\Http\Controllers;

use App\MultiProject;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Validator;
use App\Role;
use App\Permission;
use App\PermissionRole;
use Illuminate\Validation\Rule;
use DB;

class RoleController extends Controller {



    //Get All the Role
    public function getRoles() {

        $allRoles = Role::orderBy('created_at', 'desc')->get();

        activity('View')->log('Roles List.');

        return view('Setting/role.index', compact('allRoles'));
    }

    //show the add new Role  form
    public function addRole() {

        $data['multi_projects'] = MultiProject::all();
        return view('Setting/role.add-role',$data);
    }

    //insert new Role record
    public function createRole(Request $request) {

        
        $validator = Validator::make($request->all(), [
                    // 'name' => 'required|unique:roles,name',

                    'name' => [
                        'required',
                        Rule::unique('roles', 'name')->where(function ($query) use ($request) {
                            return $query->whereExists(function ($subquery) use ($request) {
                                $subquery->select(DB::raw(1))
                                         ->from('multiproject_role')
                                         ->whereRaw('multiproject_role.role_id = roles.id')
                                         ->whereIn('multiproject_role.multi_project_id', $request->input('multipro_id'));
                            });
                        }),
                    ],

                    'multipro_id' => 'required'
        ]);

        if ($validator->fails()) {
            return redirect('/role-management/add')
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }
        // dd($request->all());

        //create new Role
      $role= new Role;
      $role->name=$request->name;
      $role->description=$request->description;
      $role->save();

      foreach($request->multipro_id as $multi){
     
        $project = MultiProject::find($multi);
       
           $project->role()->attach($role);
      }
        // Role::create(['name'=>$request->name,'description'=>$request->description]);

        activity('Create')->log('New role added '. $request->name);

        return redirect()
                        ->route('role.view')
                        ->with([
                            'message' => 'Role created successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //show the edit Role form
    public function editRole($id) {

        $role = Role::where('id', $id)->first();

        return view('Setting/role.edit-role', compact('role'));
    }

    //update the Role
    public function updateRole(Request $request) {

        $validator = Validator::make($request->all(), [
                    'name' => 'required',

        ]);

        if ($validator->fails()) {
            return redirect('/role-management/edit/' . $request->id)
                            ->withErrors($validator)
                            ->withInput()
                            ->with([
                                'message' => 'Invalid Inputs!',
                                'alert-type' => 'error',
            ]);
        }

        //update Role
        Role::where('id',$request->id)->update(['name'=>$request->name,'description'=>$request->description]);

        activity('Update')->log('Edit Role '. $request->name);

        return redirect()
                        ->route('role.view')
                        ->with([
                            'message' => 'Role updated successfully!',
                            'alert-type' => 'info'
        ]);
    }

    //delete the specific Role
    public function deleteRole($id) {

        $role = Role::where('id',$id)->first();

        Role::where('id', $id)->delete();

        activity('Delete')->log('Delete Role ' . $role->name);

        return redirect()->route('role.view')->with([
                    'message' => 'Role deleted Successfully!',
                    'alert-type' => 'info',
        ]);
    }

    // public function getRoleAccess() {

    //     $data = array();

    //     $data['roles'] = Role::get();
    //     $data['permissions'] = Permission::orderBy('department','ASC')->get();
    //     $data['permission_roles'] = PermissionRole::get();

    //     return view('Setting/account.role',$data);
    // }

    // public function updateRoleAccess(Request $request) {

    //     if($request->permission) {
    //         PermissionRole::delete();

    //         foreach($request->permission as $key => $val)  {
    //             foreach($val as $keyr => $valr) {
    //                 PermissionRole::create(['permission_id'=>$keyr,'role_id'=>$key]);
    //             }
    //         }
    //     }

    //     return redirect()->back()->with([
    //                 'message' => 'Permission  updated Successfully!',
    //                 'alert-type' => 'info',]);

    // }

    public function permissionForm($id) {

        $data = array();

        $data['roles'] = Role::where('id',$id)->get();
        // dd($data['roles']);
        $data['permissions'] = Permission::orderBy('department','ASC')->get();
        $data['permission_roles'] = PermissionRole::get();

        return view('Setting/role.permission',$data);

    }

    public function updatePermission(Request $request) {
 
        if($request->permission) {
            PermissionRole::where('role_id',$request->role_id)->delete();
            // cache()->forget('entrust_permissions_for_role_'.$request->role_id);

            foreach($request->permission as $key => $val)  {
                foreach($val as $keyr => $valr) {
                    PermissionRole::create(['permission_id'=>$keyr,'role_id'=>$key]);
                }
            }
        }

        return redirect()->route('role.view')->with([
                    'message' => 'Permission  updated Successfully!',
                    'alert-type' => 'info',]);

    }

    public function updatePermissionForSelect2(Request $request) {

        // dd($request->all());
        // if($request->permission) {
        //     PermissionRole::where('role_id',$request->role_id)->delete();

        //     foreach($request->permission as $key => $val)  {
        //         foreach($val as $keyr => $valr) {
        //             PermissionRole::create(['permission_id'=>$keyr,'role_id'=>$key]);
        //         }
        //     }
        // }
        if($request->permission) {
            PermissionRole::where('role_id',$request->role_id)->delete();

            foreach($request->permission as $key => $val)  {
               
                // foreach($val as $keyr => $valr) {
                    PermissionRole::create(['permission_id'=>$val,'role_id'=>$request->role_id]);
                // }
            }
        }
        return redirect()->route('role.view')->with([
                    'message' => 'Permission  updated Successfully!',
                    'alert-type' => 'info',]);

    }

}
